; PHONE.CTL - sample phone control file - by Stefan Xenos
;
;       This file defines how the callback verifier treats
;       different phone numbers. You should edit it to
;       reflect your local calling area before using the
;       callback verifier. This file controls:
;
;       - Which numbers can be dialed without long distance
;         charges.
;       - Which long distance numbers should and should
;         not be called.
;       - Locked out phone numbers
;       - How many digits should be dialed for different
;         sets of phone numbers.
;
;       This file replaces the files LOCAL.CTL and LOCKOUT.CTL
;       which were required in versions 1.1 and earlier.
;
;       Format of this file:
;
;       - Comments begin with a semicolon (;).
;       - Every non-blank line either contains a keyword
;         or a phone number. Keywords all begin with a
;         number sign (#).
;       - Spaces, tabs, and the characters "()-" are
;         ignored in phone numbers, and may be used
;         for formatting.
;       - Underscores are ignored within keywords.
;         In keywords, upper and lower case letters
;         are treated identically.
;       - Most keywords can be specified more than once.
;         A phone number is always effected by the most recent
;         keyword specified.
;
;       Keywords used to define sections of this file:
;
;       Keyword:        Meaning:
;       --------------------------------------------------------------
;       #lockout        The phone numbers that follow should not
;                       be dialed under any circumstances. This
;                       should include emergency numbers, the numbers
;                       of harassing users, etc.
;
;       #local          The numbers that follow may be dialed without
;                       long distance charges.
;
;       #ld             The numbers that follow are long distance.
;                       The BBS will only dial these numbers if
;                       long distance phone numbers are enabled in
;                       CALLBACK.CTL.
;
;       #ld_lockout     The numbers that follow are long distance.
;                       The BBS will not dial these numbers, no
;                       matter what the settings in CALLBACK.CTL are.
;                       This is useful for preventing the BBS from
;                       dialing numbers in other countries, etc.
;                       I recommend putting the lines
;
;                               #ld_lockout
;                               *
;
;                       near the end of the file. This will cause
;                       all unknown phone numbers to be treated
;                       as being too long distance to dial.
;
;       #ask_local      Use this keyword to define a group of
;                       phone numbers which may or may not be
;                       local calls. If the user's phone number
;                       is found in the list, they will be asked
;                       if their number is a local call. If they
;                       answer yes, this behaves just like #local.
;                       Otherwise, it behaves just like #ld.
;
;       #end            Everything beyond this keyword is ignored
;                       This must appear at the end of the file.
;
;       Miscellaneous keywords:
;
;       Keyword:        Meaning:
;       --------------------------------------------------------------
;       #ld_prefix      Defines a prefix which is added to long
;                       distance numbers before dialing them.
;                       This is usually set to 1.
;
;       #ld_start       Defines the first digit to be dialed of
;                       the following long distance numbers.
;                       For example, specifying a value of 2
;                       will cause the first digit of the phone
;                       number to be skipped (the 2nd digit would
;                       be the first one dialed). Since every
;                       calling area I know of requires the entire
;                       phone number to be dialed for ld numbers,
;                       this should usually be set to 1.
;
;       #ld_len         Sets the number of digits to be dialed
;                       in the following long distance numbers.
;
;
;       #local_prefix   Defines a prefix which is added to local
;                       numbers before dialing them. This is
;                       usually left blank.
;
;       #local_start    Sets the first digit of local phone numbers
;                       to dial. For example: My area has 10 digit
;                       phone numbers. The last 7 digits are dialed
;                       for local calls. In my case, I set this to
;                       4 (the first digit being dialed is the 4th
;                       digit, skipping the 3 digit area code).
;
;       #local_len      Sets the number of digits to dial for local
;                       phone numbers.
;
;       #start_time     Defines the earliest time that callback verifications
;                       may be performed.
;
;       #end_time       Defines the latest time that callback verifications
;                       may be performed.
;
;       #write          The remainder of the line is written to the
;                       user's screen when and if that line is
;                       reached.
;
;       #city           The remainder of the line contains a city name.
;                       The following phone numbers are said to belong
;                       to this city. If the user's phone number matches
;                       any of the phone numbers that belong to this
;                       city, the city name will be displayed to the user.
;                       By default, padlock will also change the user's
;                       city name to the city that their phone number
;                       belongs to (although this behaviour can be
;                       turned on and off with the num_update_city token
;                       in SETTINGS.MH). You can end a city with either
;                       another #city token or an #end_city token.
;
;       #end_city       Defines the end of a city. 
;
;
;       Note: #ld_prefix, #ld_start, and #ld_len must be specified
;             before any long distance phone numbers are. Also,
;             #local_prefix, #local_start, and #local_len must
;             preceed any local phone numbers.
;
;       It is possible to define #local_len, #local_start, and
;       #local_prefix more than once in this file. This is useful
;       for sysops who live in an area where the number of digits
;       to be be dialed depends on the user's phone number. Sysops
;       who use phone extenders or some long distance plan (like
;       UniTel) that requires you to dial another phone number
;       before the user's number can use this to specify which
;       numbers should be dialed using that long distance carrier
;       and what the dialing prefix should be.
;
;       The following wildcards may be used for phone numbers:
;
;               *       Skip 0 or more characters.
;               ?       Skip 1 character
;               []      Match any one of the characters
;                       between the brackets.
;               !       Match anything but the following character
;                       If this is followed by the [] wildcard,
;                       it means match anything but the characters
;                       within the brackets.
;
;       Example:
;
;               If the user's phone number was 6132577636,
;               it would match with all of the following:
;
;               (613) 257-*
;               *
;               613257*
;               *7636
;               61325?-7636
;               61*36
;               (613) 257-7636
;               *257*
;               613*
;               6132577636*
;               61325[67]*
;               613!657*
;
;               it would match with none of the following:
;
;               (613) 257
;               257-7636
;               257*
;               819*
;               6132577636?
;               613257763[012345789]
;               613![123]577636
;
;       A user's phone number is compared with every phone number
;       in this file until a match is found. The first match that
;       is found is used, even if the user's phone number matches
;       with other numbers in the file. For example, if the user's
;       phone number was 6132577636:
;
;       #local
;       613*
;       #ld
;       6132577636
;       #lockout
;       *7636
;
;       The user's phone number would be considered local because
;       the first phone number it matched with is 613*, a local
;       number. If your file looked like:
;
;       #local
;       ???256*
;       #lockout
;       *7636
;       #ld
;       613*
;
;       The user would be locked out since the first number it matched
;       was *7636, a locked out phone number.
;
;       For this reason, it's often a good idea to put your locked out
;       phone numbers first, followed by local numbers and long distance
;       numbers.
;
;       Moving these comments to the end of the file may speed things
;       up a bit... the file access from Mex isn't terribly fast.


; Config ------------------------------------------------------------
;
;       These keywords MUST be specified before any phone numbers!
;       PADLOCK WILL NOT BE ABLE TO OPERATE IF THESE KEYWORDS ARE MISSING!

#local_start    4               ; The first digit to dial for local calls
#local_len      7               ; The number of digits to dial for local calls
#local_prefix                   ; Prefix to be added to all local numbers

#ld_prefix      1               ; Prefix to be added to all long distance numbers
#ld_len         10              ; Number of digits to dial for long distance calls
#ld_start       1               ; First digit to dial for long distance calls

; Optional keywords -------------------------------------------------

; The following two keywords define the earliest and latest times that callback
; verification may be performed for a set of phone numbers. The time format is:
;
;    hh:mm.ss
;
; where hh is the hour, mm is the minute, and ss is the second. mm and ss are
; optional and may be skipped. If these keywords are not specified, then
; callback verifications may be performed at any time of the day or night.
; These keywords are also useful for limiting calls to various long distance
; numbers to when long distance fees are cheapest. 

;#local_start_time       10
;#local_end_time         22:30.00
;#ld_start_time          23:00
;#ld_end_time            23:30

; Locked out phone numbers -----------------------------------------

#lockout                        ; The following phone numbers are locked out
#write Scanning locked out phone numbers...

; Provincial emergency numbers
911*                            ; 911
??? 747-1918                    ; Child abuse hotlines  (ottawa)
??? 776-6060                    ;                       (quebec)
??? 729-1119                    ; Distress centers
??? 238-3311
??? 722-4591
??? 733-6448
??? 741-6433
??? 238-2088
??? 729-8889                    ; Sexual assault victims
??? 234-2266
??? 745-4818                    ; Womens shelters
??? 745-3665
??? 234-5181
??? 747-0020
??? 225-3129
??? 789-8300
??? 563-0363                    ; Substance abuse
??? 737-1100                    ; Poison information center
??? 267-1373
??? 463-5060
??? 267-7270                    ; Marine and air search
??? 267-2677                    ; OPP
??? 267-2671
??? 267-8919
??? 267-8917

; Local emergency numbers

??? 257-2323                    ; Police
??? 257-4163                    ; Tips
??? 256-1234                    ; Fire
??? 257-2222
??? 257-1144
??? 267-2030
??? 259-2115
??? 624-5221
??? 256-2500                    ; Hospitals
??? 257-2200
??? 256-2489
??? 256-4444
??? 623-6561
??? 668-6868
??? 257-5960
??? 253-2034
??? 267-1373
??? 267-7270

; Miscellaneous numbers
*7371111                        ; Pizza pizza
1*                              ; Any long distance number
0*                              ; Operator assistance
??? 555*                        ; Any number starting with 555
800*                            ; Any toll free number
888*                            ; Ditto
900*                            ; Any 900 number
??? 976*                        ; Any 976 number
??? 230-0000                    ; Flat rate long distance number

; Harassing users

; Local calling area --------------------------------------------

#write Scanning local calling area...

; Area 613 ------------------------------------------------------

#local                          ; The following numbers are local
#write Area 613...              ; Display message to user

#city Almonte, Ontario
(613) 256*

#city Carleton Place, Ontario
(613) 25[37]*

#city Ottawa, Ontario
(613) 22[4568]*
(613) 23*
(613) 24![0289]*
(613) 25[367]*
(613) 274*
(613) 350*
(613) 52[1369]*
(613) 55[68]*
(613) 56*
(613) 580*
(613) 59[345689]*
(613) 660*
(613) 72*
(613) 73![25]*
(613) 74![03]*
(613) 75[05]*
(613) 76[12359]*
(613) 77![49]*
(613) 78!4*
(613) 79[014789]*
(613) 82[089]*
(613) 844*
(613) 860*
(613) 920*
(613) 94[134567]*
(613) 95[123467]*
(613) 99!9*
#endcity

; Area 819 ------------------------------------------------------

#local                          ; The following numbers are local
#write Area 819...              ; Display helpful message to user

#city Hull, Quebec
(819) 22[4568]*
(819) 23*
(819) 24![0289]*
(819) 25[367]*
(819) 274*
(819) 350*
(819) 52[1369]*
(819) 55[68]*
(819) 56*
(819) 580*
(819) 59[345689]*
(819) 660*
(819) 72*
(819) 73![25]*
(819) 74![03]*
(819) 75[05]*
(819) 76[12359]*
(819) 77![49]*
(819) 78!4*
(819) 79[014789]*
(819) 82[089]*
(819) 844*
(819) 860*
(819) 920*
(819) 94[134567]*
(819) 95[123467]*
(819) 99!9*
#endcity

; Long distance numbers ----------------------------------------------------

#ld                             ; The numbers that follow are long distance.
#city Stittsville
(613) 258*                      ; Stittsville
#endcity

; Miscellaneous numbers ----------------------------------------------------

#ask_local                      ; 613 numbers not already listed may be new
(613) *                         ; local extensions which have not yet been
                                ; added to the phone book. If this is the
                                ; case, ask the user if his/her number is
                                ; local.

#ld                             ; The same may be true for new 819 numbers,
(819) *                         ; but it's much less likely, so consider
                                ; them long distance.

#end                            ; End of file. REQUIRED.

