@echo off
if %1. == . goto commandLineError
if %2. == . goto noSecondParam

set MEX_INCLUDE=%2
if exist %MEX_INCLUDE%\max.mh goto maxOk
echo Can't find file: %MEX_INCLUDE%\max.mh
goto maxMhError
:noSecondParam
if exist ..\m\max.mh BUILD %1 ..\m
goto maxMhError


:maxOk
if exist %1\mexp.exe goto mexpOk
echo Can't find file: %1\mexp.exe
goto done
:mexpOk
if exist getphone.mex goto getphoneOk
echo Can't find file: getphone.mex
goto done
:getPhoneOk

%1\mexp init
if errorlevel 1 goto compileError
%1\mexp getphone
if errorlevel 1 goto compileError
%1\mexp checknum
if errorlevel 1 goto compileError
%1\mexp verify
if errorlevel 1 goto compileError
%1\meccap *.mec
if errorlevel 1 goto compileError

echo.
echo Compilation completed successfully.
echo.

goto done

:commandLineError

if exist ..\MEXP.EXE goto clefmexp
goto :nodefault
:clefmexp
BUILD ..

:nodefault
echo Compiles all files necessary to run the Padlock call back verifier.
echo.
echo Syntax:
echo.
echo    BUILD [maximus directory] [mex include directories]
echo.
echo Where [maximus directory] is the name of the directory containing MECCAP.EXE
echo and MEXP.EXE, and [mex include directories] includes the directory containing
echo the file MAX.MH.
echo.
goto done

:maxMhError
echo Please pass the directory containing max.mh as the second parameter
echo to this batch file or type:
echo.
echo SET MEX_INCLUDE=[directory name]
echo.
echo before running this batch file, where [directory name] is the name
echo of the directory containing max.mh. Usually, this file is located
echo in a subdirectory of your main max directory called "m".
echo.
goto done

:compileError
echo.
echo Compilation errors were detected. These errors must be corrected
echo before you can use Padlock. Compilation errors are often caused
echo by mistakes in SETTINGS.MH. Double check your changes to this
echo file and then run this batch file again. For more information on
echo compile time errors, see section 14.3 of your Maximus documentation.
echo.
:done

if %2. == . goto end

set MEX_INCLUDE=

:end
