UNIT Tick;
{ͻ}
{ Tick processor                                Last changed: 15.08.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, Dos;

PROCEDURE ProcessTicks;
PROCEDURE Hatch(CONST FName: PathStr; CONST Description: STRING);

IMPLEMENTATION

USES OpString, OpDos, OpDate, OpPick, OpCrt, OpWindow, OpCmd, OpFrame, OpRoot,
     OproUtil, InterCom, StrUtil, LogFile, FileUtil, Send2Utl, MailUtil,
     OutUtil, Input, AreaMisc, NetFile, Util, ArcView, UnixDate, SimpDB,
     Opus_173, Globals, FuncSrvr, PoPTypes;

TYPE
  PTickMsg = ^TTickMsg;
  TTickMsg = RECORD
               NumLines : Byte;
               Line     : Array[1..10] OF S80;
             END;

  PTickFile = ^TTickFile;
  TTickFile = RECORD
    Area     : S20;
    Origin   : S20;
    From     : TFidoAddress;
    FileName : S12;
    Desc     : String;
    CRC      : LongInt;
    Replaces : S12;
    NumPath  : Byte;
    Path     : Array[1..20] Of String;
    NumSeenBy: Byte;
    SeenBy   : SendToTabType;
    Password : S20;
  END;

  TTickAreaPickList = OBJECT(PickList)
    TickFile : PNetFile;

    constructor Init(VAR ATickFile: TNetFile);
    procedure ItemString(Item: Word; Mode: pkMode; var IType: pkItemType; var IString: String); virtual;
  END;

VAR
  TickFileRec    : PTickFile;
  TickAreaRec    : PTickArea;
{
  TickLetterPath : PathStr;
  TickMsgPtr     : Array[1..3] OF PTickMsg;
}


  constructor TTickAreaPickList.Init(VAR ATickFile: TNetFile);
  begin
    TickFile:=@ATickFile;
    InitAbstract(23, 3, 57, ScreenHeight-1, Cfg.Color[3], DefWindowOptions or WBordered,
                 22, TickFile^.FileSize, PickVertical, SingleChoice);
    IF Cfg.Screen.ExplodingWin THEN EnableExplosions(10);
    SetSearchMode(PickStringSearch);
    SetPadSize(1,1);
    Wframe.AddHeader(' Tick Areas ',heTC);
    AddMoreHeader(' More   ',HeBR,#24,#25,'',7,8,0);
  END;

  procedure TTickAreaPickList.ItemString(Item: Word; Mode: pkMode; var IType: pkItemType; var IString: String);
  VAR
    ta: TTickArea;
  BEGIN
    IString:='';
    IF TickFile^.FileSize>=Item-1 THEN
    BEGIN
      TickFile^.GetRec(Ta, Item-1, NoKeep, Wait);
      IF TickFile^.IoResult=0 THEN IString:=Ta.AreaName;
    END;
  end;

  FUNCTION StripDosChars(Area: S20): S20;
  VAR
    i : Byte;
  BEGIN
    i:=1;
    WHILE i<=Length(Area) DO
      IF Area[i] IN ['.',':','\'] THEN Delete(Area, i, 1) ELSE Inc(i);
    StripDosChars:=Area;
  END;


  FUNCTION Adr2Str(CONST Adr: TFidoAddress): S20;
  VAR
    s : S20;
  BEGIN
    s:=Address2Str(Adr);
    IF Adr.Point=0 THEN s:=Copy(s,1,Pos('.',s)-1);
    Adr2Str:=s;
  END;

  FUNCTION FindTickArea(VAR TickFile: TNetFile; CONST AreaName: S20): Boolean;
  VAR
    Found : Boolean;
  BEGIN
    TickFile.Seek(0);
    Found:=False;
    WHILE Not Found And Not TickFile.EoF DO
    BEGIN
      TickFile.Read(TickAreaRec^,NoKeep,Wait);
      Found:=StUpCase(TickAreaRec^.AreaName)=AreaName;
    END;
    FindTickArea:=Found;
  END;

  FUNCTION CheckGetFrom(CONST Adr: TFidoAddress): Byte;
  VAR
    Num,i : Byte;
    Found: Boolean;
    GetFromTab : SendToTabType;
  BEGIN
    ReadSendTo(TickAreaRec^.GetFrom, GetFromTab, Num);
    i:=0; Found:=False;
    WHILE (i<=Num) And Not Found DO
    BEGIN
      Inc(i);
      Found:=CmpAdr(GetFromTab[i],Adr);
    END;
    IF Not Found THEN i:=0;
    CheckGetFrom:=i;
  END;

  FUNCTION Tick2Buffer(CONST TickName: S12; CONST NodeStat: TNodeStat): Boolean;
  VAR
    t : PBufTextFile;
    s, Rest : String;
    ok: Integer;
    isBad : Boolean;

    PROCEDURE BadTic(CONST s: String);
    BEGIN
      AddLog('!','Error in TIC line: "'+s+'"');
      isBad:=True;
    END;

    FUNCTION Token(CONST s: String; VAR Rest: String): Byte;
    VAR
      KeyWord : S10;
    BEGIN
      IF Pos(' ',s)>0 THEN
      BEGIN
        KeyWord:='*'+StUpCase(Copy(s, 1, Pos(' ', s)-1))+'*';
        Rest:=Trim(Copy(s, Pos(' ', s)+1, Length(s)-Pos(' ',s)));
        Token:=Pos(KeyWord, '*AREA*ORIGIN*FROM*FILE*DESC*CRC*REPLACES*PATH*SEENBY*PW*');
      END ELSE
        Token:=0;
    END;

  BEGIN
    AddLog(' ','Reading '+TickName);
    FillChar(TickFileRec^, SizeOf(TickFileRec^), 0);
    New(t, Init(Cfg.Inbound[NodeStat]+TickName, SOpenRead, 2048));
    IF t<>NIL THEN
    BEGIN
      isBad:=False;
      REPEAT
        t^.ReadLn(s);
        CASE Token(s, Rest) OF
           0 : ;
           1 : TickFileRec^.Area:=StUpCase(Rest);
           6 : TickFileRec^.Origin:=Rest;
          13 : IF Not GetAdressFromStr(Rest, TickFileRec^.From) THEN BadTic(s);
          18 : TickFileRec^.FileName:=Rest;
          23 : TickFileRec^.Desc:=Rest;
          28 : BEGIN
                 Val('$'+Rest, TickFileRec^.CRC, Ok);
                 IF Ok<>0 THEN BadTic(s);
               END;
          32 : TickFileRec^.Replaces:=Rest;
          41 : BEGIN
                 Inc(TickFileRec^.NumPath);
                 TickFileRec^.Path[TickFileRec^.NumPath]:=Rest;
               END;
          46 : BEGIN
                 Inc(TickFileRec^.NumSeenBy);
                 IF TickFileRec^.NumSeenBy>50 THEN  { CHANGE THIS SOMETIME.... }
                 BEGIN
                   TickFileRec^.NumSeenBy:=50;
                   Move(TickFileRec^.SeenBy[2],TickFileRec^.SeenBy[1],49*SizeOf(TFidoAddress));
                 END;
                 IF Not GetAdressFromStr(Rest, TickFileRec^.SeenBy[TickFileRec^.NumSeenBy]) THEN
                   Dec(TickFileRec^.NumSeenBy);
               END;
          53 : TickFileRec^.PassWord:=StUpCase(Rest);
        END;
      UNTIL t^.EoF OR isBad;

      Dispose(t, Done);
    END ELSE
    BEGIN
      AddLog('!', 'File: '+TickName+' disappered??');
      isBad:=True;
    END;
    Tick2Buffer:=NOT isBad;
  END;

  PROCEDURE Add2FilesBBS;
  VAR
    FilesBBS, NewFilesBBS: PBufTextFile;
    Added,
    Found : Boolean;
    s, Line: String;
    FName : S12;
    Offset : LongInt;
  BEGIN
    IF (Cfg.BBS.BBSType=btOpus170) AND FindAreaByPath(Cfg.BBS.Path, TickAreaRec^.AreaPath, Offset) THEN
    BEGIN
(*
  FilesBBSType = RECORD
    Area_Number : Word;
    Name        : String[12];
    Dl_Priv     : Byte;
    Size        : LongInt;
    Date        : Word;
    Time        : Word;
    AFlag       : Word;
    DL_Lock     : LongInt;
    Up_Date     : Word;
    Up_Time     : Word;
    Down_Cntr   : Word;
    Descr_Len   : Word;
    AltPath_Len : Byte;
    Upld_by_Len : Byte;
    Nxt_Key     : LongInt;
    Filler      : Array[1..20] of Byte;  { Size = 64 bytes }
    Description : String;
    AltPath     : PathStr;
    Uploaded_By : String[35];
  END;
*)
    END ELSE
    BEGIN
      IF TickAreaRec^.FilesBBS='' THEN FName:='FILES.BBS' ELSE FName:=TickAreaRec^.FilesBBS;

      Line:=CPad(TickFileRec^.FileName,13)+TickFileRec^.Desc;
      IF Cfg.AreaMan.InsDLCnt THEN AddDlC(Line);

      New(FilesBBS, InitCreate(AddBackSlash(TickAreaRec^.AreaPath)+FName, SOpen+ShareDenyNone, 2048));
      IF FilesBBS=NIL THEN
      BEGIN
        AddLog('!', 'Can''t update '+FName+' with description: '+Line);
      END ELSE
      BEGIN
        IF TickFileRec^.Replaces='' THEN
        BEGIN
          FilesBBS^.WriteLn(Line);
          Dispose(FilesBBS, Done);
        END ELSE
        BEGIN
          New(NewFilesBBS, Init(AddBackSlash(TickAreaRec^.AreaPath)+'TICK-TMP.$$$', SCreate, 2048));
          IF NewFilesBBS=NIL THEN
          BEGIN
            AddLog('!', 'Can''t update '+FName+' with description: '+Line);
            FilesBBS^.WriteLn(Line);
            Dispose(FilesBBS, Done);
          END ELSE
          BEGIN
            FilesBBS^.SetPos(0, PosAbs);
            Found:=False; Added:=False;
            WHILE NOT FilesBBS^.EoF AND (NewFilesBBS^.GetStatus=0) DO
            BEGIN
              FilesBBS^.ReadLn(s);
              IF (Pos(' ',s)>0) AND (StUpCase(Copy(s,1,Pos(' ',s)-1))=TickFileRec^.Replaces) THEN
              BEGIN
                Found:=True;
                IF Cfg.AreaMan.InsDLCnt THEN IncDLC(Line, GetDLC(s));
                IF TickFileRec^.Replaces=TickFileRec^.FileName THEN
                BEGIN
                  NewFilesBBS^.WriteLn(Line);
                  Added:=True;
                END;
              END ELSE
                NewFilesBBS^.WriteLn(s);
            END;
            IF (TickFileRec^.Replaces<>TickFileRec^.FileName) OR (NOT Added) THEN NewFilesBBS^.WriteLn(Line);
            IF NewFilesBBS^.GetStatus<>0 THEN
            BEGIN
              AddLog('!', 'Can''t update '+FName+' with description: '+Line);
              Dispose(FilesBBS, Done); Dispose(NewFilesBBS, Done);
              DeleteFile(AddBackSlash(TickAreaRec^.AreaPath)+'TICK-TMP.$$$');
            END ELSE
            BEGIN
              IF Found THEN
              BEGIN
                IF (TickFileRec^.Replaces<>TickFileRec^.FileName) AND
                   (DeleteFile(AddBackSlash(TickAreaRec^.AreaPath)+TickFileRec^.Replaces)) THEN
                  AddLog(':','Erasing '+TickFileRec^.Replaces+' replaced by '+TickFileRec^.FileName);
              END;
              Dispose(FilesBBS, Done); Dispose(NewFilesBBS, Done);
              DeleteFile(AddBackSlash(TickAreaRec^.AreaPath)+FName);
              RenameFile(AddBackSlash(TickAreaRec^.AreaPath)+'TICK-TMP.$$$', AddBackSlash(TickAreaRec^.AreaPath)+FName);
            END;
          END;
        END;
      END;
    END;
  END;

  FUNCTION IsDupe(CONST FName: S12; CONST Area: S20): Boolean;
  VAR
    S : String;
    Dupe : Boolean;
    DupeFile : PBufTextFile;
  BEGIN
    Dupe:=False;
    IF Cfg.Tick.DupeDir<>'' THEN
    BEGIN
      New(DupeFile, Init(Cfg.Tick.DupeDir+StripDosChars(Area)+'.DUP', SOpenRead+ShareDenyNone, 2048));
      IF DupeFile<>NIL THEN
      BEGIN
        WHILE Not DupeFile^.EoF And Not Dupe DO
        BEGIN
          DupeFile^.ReadLn(S);
          IF Pos(' ', S)>0 THEN S:=Copy(S, 1, Pos(' ', S)-1);
          IF StUpCase(FName)=Trim(S) THEN Dupe:=True;
        END;
        Dispose(DupeFile, Done);
      END;
    END;
    IsDupe:=Dupe;
  END;

  PROCEDURE WriteInDupeFile(CONST FName: S12; CONST Area: S20);
  VAR
    DupeFile : TNetFile;
  BEGIN
    IF Cfg.Tick.DupeDir<>'' THEN
    BEGIN
      IF DupeFile.Open(Cfg.Tick.DupeDir+StripDosChars(Area)+'.DUP', 1, True) THEN
      BEGIN
        DupeFile.Seek(DupeFile.FileSize);
        DupeFile.WriteLine(StUpCase(FName));
        DupeFile.Close;
      END;
    END;
  END;

  FUNCTION MoveTick(VAR TickFile: TNetFile; CONST TickName: S12; CONST NodeStat: TNodeStat): Boolean;
  VAR
    TSr : SearchRec;
    s : PathStr;
    OldName : S12;
    Success : Boolean;

(*
    PROCEDURE WriteTickLetter;
    VAR
      tf    : PBufTextFile;
      FName : PathStr;

      PROCEDURE ReadTemplate;
      VAR
        i : Byte;
        Tpl : PBufTextFile;
        S : S80;
      BEGIN
        FOR i:=1 TO 3 DO
        BEGIN
          PoPGetMem(POINTER(TickMsgPtr[i]),SizeOf(TTickMsg));
          FillChar(TickMsgPtr[i]^, SizeOf(TickMsgPtr[i]^), 0);
        END;
        New(Tpl, Init(StartPath+PoPTemplateFileName, SOpenRead+ShareDenyNone, 2048));
        i:=0;
        IF Tpl<>NIL THEN
        BEGIN
          WHILE NOT Tpl^.EoF DO
          BEGIN
            Tpl^.ReadLn(S);
            IF Copy(S,1,1)='/' THEN
            BEGIN
              IF StUpCase(Copy(s,1,9))='/TICKHEAD' THEN i:=1 ELSE
                IF StUpCase(Copy(s,1,9))='/TICKBODY' THEN i:=2 ELSE
                  IF StUpCase(Copy(s,1,9))='/TICKFOOT' THEN i:=3 ELSE
                    i:=0;
            END ELSE
              IF (i>0) And (TickMsgPtr[i]^.NumLines<10) THEN
              BEGIN
                Inc(TickMsgPtr[i]^.NumLines);
                TickMsgPtr[i]^.Line[TickMsgPtr[i]^.NumLines]:=S;
              END;
          END;
        END;
        IF TickMsgPtr[2]^.NumLines=0 THEN
        BEGIN
          TickMsgPtr[2]^.NumLines:=2;
          TickMsgPtr[2]^.Line[1]:='  $FileName ($Size) in $HumanName ';
        END;
        Dispose(Tpl, Done);
      END;

      PROCEDURE WriteHeader;
      VAR
        i : Byte;
        s : String;
      BEGIN
        IF TickMsgPtr[1]^.NumLines>0 THEN
        BEGIN
          FOR i:=1 TO TickMsgPtr[1]^.NumLines DO
          BEGIN
            s:=TickMsgPtr[1]^.Line[i];
            Replace(s, '$today', TodayString('mm/dd/yy'), 0);
            Replace(s, '$groupname', TickAreaRec^.GroupName, 0);
            tf^.WriteLn(s);
          END;
        END;
      END;

      PROCEDURE WriteBody;
      VAR
        i : Byte;
        s : String;
      BEGIN
        IF TickMsgPtr[2]^.NumLines>0 THEN
        BEGIN
          FOR i:=1 TO TickMsgPtr[2]^.NumLines DO
          BEGIN
            s:=TickMsgPtr[2]^.Line[i];
            Replace(s, '$filename', Pad(TSr.Name,12), 0);
            Replace(s, '$filesize', LongIntForm('#.###', TSr.Size div 1024), 0);
            Replace(s, '$desc', TickFileRec^.Desc, 0);
            Replace(s, '$tickarea', TickFileRec^.Area, 0);
            Replace(s, '$humanname', TickAreaRec^.HumanName, 0);
            tf^.WriteLn(s);
          END;
        END;
      END;

    BEGIN
      FName:=TickAreaRec^.GroupName;
      IF Length(FName)>8 THEN Insert('.',FName,9);
      FName:=TickLetterPath+FName;
      IF TickMsgPtr[1]=NIL THEN ReadTemplate;
      New(tf, Init(FName, SOpen, 4096));
      IF tf=NIL THEN
      BEGIN
        AddLog(':','Creating letter for group: '+TickAreaRec^.GroupName);
        New(tf, Init(FName, SCreate, 4096));
        WriteHeader;
      END ELSE
        tf^.SetPos(0, PosEnd);
      WriteBody;
      Dispose(tf, Done);
    END;
*)

    PROCEDURE RemoveFromTit(CONST FName: S12);
    VAR
      TitF : TTitFile;
    BEGIN
      IF TitF.Open(False) THEN
      BEGIN
        TitF.RemoveFile(FName);
        TitF.Close;
      END;
    END;

    PROCEDURE RenameTick;
    BEGIN
      IF RenameFile(Cfg.Inbound[NodeStat]+TickName, ForceExtension(Cfg.Inbound[NodeStat]+TickName, 'BAD')) THEN
        AddLog('*', TickName+' renamed to '+ForceExtension(TickName, 'BAD'));
    END;

  BEGIN
    MoveTick:=False;
    Success:=False;
    IF Tick2Buffer(TickName, NodeStat) THEN
    BEGIN
      AddLog('*','Processing: '+TickFileRec^.FileName+' in area: '+TickFileRec^.Area+' from: '+Address2Str(TickFileRec^.From));
      IF FindTickArea(TickFile, TickFileRec^.Area) THEN
      BEGIN
        IF CheckGetFrom(TickFileRec^.From)<>0 THEN
        BEGIN
          IF FindNodeInfo(NodesRec,TickFileRec^.From) THEN
          BEGIN
            IF (TickFileRec^.Password=NodesRec.TickPassword) OR (TickFileRec^.Password='') THEN
            BEGIN
              FindFirst(Cfg.Inbound[NodeStat]+TickFileRec^.FileName,AnyFile,TSr);
              IF (DosError<>0) AND (TickAreaRec^.CanBeRepacked) THEN
              BEGIN
                s:=TickFileRec^.FileName;
                IF Pos('.',s)>0 THEN s:=Copy(s,1,Pos('.',s)-1);
                s:=s+'.*';
                FindClose(TSr);
                FindFirst(Cfg.Inbound[NodeStat]+s,AnyFile,TSr);
              END;
              IF DosError=0 THEN
              BEGIN
                IF TickFileRec^.FileName<>TSr.Name THEN
                BEGIN
                  TickFileRec^.CRC:=FileCRC(Cfg.Inbound[NodeStat]+TSr.Name);
                  OldName:=TickFileRec^.FileName;
                  TickFileRec^.FileName:=StUpCase(TSr.Name);
                END;
                IF (NOT TickAreaRec^.CheckCRC) OR (FileCrC(Cfg.Inbound[NodeStat]+TickFileRec^.FileName)=TickFileRec^.CRC) THEN
                BEGIN
                  IF (TickFileRec^.Replaces<>'') OR NOT (TickAreaRec^.CheckDupe) OR
                    NOT IsDupe(TSr.Name,TickAreaRec^.AreaName) THEN
                  BEGIN
                    IF ExistFile(AddBackSlash(TickAreaRec^.AreaPath)+TSr.Name) AND (TickFileRec^.Replaces='') THEN
                      TickFileRec^.Replaces:=TSr.Name;
                    AddLog('+','Moving '+TSr.Name+' to '+AddBackSlash(TickAreaRec^.AreaPath));
                    IF CopyFile(Cfg.Inbound[NodeStat]+TSr.Name,
                                AddBackSlash(TickAreaRec^.AreaPath)+TSr.Name,False,True)=0 THEN
                    BEGIN
                      IF TickAreaRec^.CheckDupe THEN WriteInDupeFile(TSr.Name,TickAreaRec^.AreaName);
                      RemoveFromTit(OldName);
                      DeleteFile(Cfg.Inbound[NodeStat]+TickName);
                      Add2FilesBBS;
{---
                      IF TickAreaRec^.WriteLetter AND (TickAreaRec^.AnnouncePath<>'') AND
                         (TickAreaRec^.GroupName<>'') THEN
                        WriteTickLetter;
---}
                      MoveTick:=True;
                      Success:=True;
                    END ELSE
                      AddLog('!','Can''t copy file to destination directory');
                  END ELSE
                    AddLog('!','Dupe: '+TSr.Name+' in area: '+TickFileRec^.Area) ;
                END ELSE
                  AddLog('!','CRC Error: '+TSr.Name+' in area: '+TickFileRec^.Area) ;
              END ELSE
              BEGIN
                IF Cfg.Tick.RequestMissing THEN
                BEGIN
                  IF RequestAFile(TickFileRec^.FileName, TickFileRec^.From, '') THEN
                    AddLog('#', 'File not found: '+TickFileRec^.FileName+' requesting it from: '+
                           Address2Str(TickFileRec^.From))
                  ELSE
                    AddLog('#', 'File not found: '+TickFileRec^.FileName+' HAS been requested from: '+
                           Address2Str(TickFileRec^.From));
                  Success:=True;
                END ELSE
                  AddLog('!','File not found: '+TickFileRec^.FileName);
              END;
              FindClose(TSr);
            END ELSE
              AddLog('!','Password error');
          END ELSE
            AddLog('!',Address2Str(TickFileRec^.From)+' not found in Nodes Setup');
        END ELSE
          AddLog('!',Address2Str(TickFileRec^.From)+' is not allowed to hatch into: '+TickFileRec^.Area);
      END ELSE
        AddLog('!','Unknown tick area: '+TickFileRec^.Area);
    END ELSE
      AddLog('!','Error in tick file: '+TickName);
    IF NOT Success THEN RenameTick;
  END;

  PROCEDURE FindNodesToSendTo(VAR TickToTab: SendToTabType; VAR Num: Word);
  VAR
    TmpTab : SendToTabType;
    i,j,GFNum, STNum : Byte;
  BEGIN
    FillChar(TickToTab, SizeOf(TickToTab), 0);
    ReadSendTo(TickAreaRec^.GetFrom, TickToTab, GFNum);
    i:=CheckGetFrom(TickFileRec^.From);
    IF i>0 THEN
    BEGIN
      FOR j:=i TO GFNum-1 DO
        TickToTab[j]:=TickToTab[j+1];
      Dec(GFNum);
    END;
    ReadSendTo(TickAreaRec^.SendTo, TmpTab, STNum);
    FOR i:=GFNum+1 TO GFNum+1+STNum DO
      TickToTab[i]:=TmpTab[i-GFNum];
    Num:=GFNum+StNum;
  END;

  FUNCTION MakeTickDate: S40;
  VAR
    s : S40;
    Hour, Min, Sec, Sec100,
    Year, Month, Day, DoW : Word;
  BEGIN  { (UnixDate) Sat Jan 11 12:56:57 1992 GMT }
    s:=TodayString('www nnn dd yyyy');
    s:=Copy(s,1,10)+CurrentTimeString(' hh:mm:ss')+Copy(s,11,5){+' GMT'};
    GetDate(Year, Month, Day, DoW);
    GetTime(Hour, Min, Sec, Sec100);
    s:=' '+Long2Str(GetUnixDate(Year,Month,Day,Hour,Min,Sec))+' '+s;
    MakeTickDate:=s;
  END;

  PROCEDURE FindRightAkA(VAR Address: TFidoAddress);
  VAR
    i : Byte;
    Found : Boolean;
  BEGIN
    IF (TickAreaRec^.AKAToUse>0) AND (Cfg.Addresses[TickAreaRec^.AKAToUse].Zone<>0) THEN
    BEGIN
      Address:=Cfg.Addresses[TickAreaRec^.AKAToUse];
    END ELSE
    BEGIN
      i:=1; Found:=False;
      REPEAT
        IF (Cfg.Addresses[i].Zone<>0) And (Cfg.Addresses[i].Zone=Address.Zone) THEN
        BEGIN
          Address:=Cfg.Addresses[i];
          Found:=True;
        END;
        Inc(i);
      UNTIL (i>MaxAddresses) OR (Found);
      IF NOT Found THEN Address:=Cfg.Addresses[Cfg.MainAdrNum];
    END;
  END;

  FUNCTION NodeInSeenBy(CONST Adr: TFidoAddress): Boolean;
  VAR
    i : Byte;
  BEGIN
    NodeInSeenBy:=False;
    FOR i:=1 TO TickFileRec^.NumSeenBy DO
      IF CmpAdr(Adr, TickFileRec^.SeenBy[i]) THEN
      BEGIN
        NodeInSeenBy:=True;
        Break;
      END;
  END;

  PROCEDURE SendTick(CONST UPath: PathStr);
  VAR
    SendTickFile : PBufTextFile;
    Num,i,j: Word;
    Tp,PTName,s : PathStr;
    FL: Char;
    WasThere: Boolean;
    Pk : Byte;
    TmpSendTo : SendToType;
    TickToTab : SendToTabType;
  BEGIN
    FindNodesToSendTo(TickToTab, Num);
    IF Num>0 THEN
    BEGIN
      WriteSendTo(TickToTab,TmpSendTo,Num);
      FOR i:=1 TO 2 DO
      BEGIN
        IF TmpSendTo[i]<>'' THEN AddLog('+','Sending '+JustFileName(TickFileRec^.FileName)+' to '+TmpSendTo[i]);
      END;
      IF Cfg.Tick.HoldDir='' THEN tp:=Cfg.Outbound+'.TIC\' ELSE tp:=Cfg.Tick.HoldDir;
      IF NOT ChkDir(tp) THEN MakeFullDir(tp);
      FindRightAkA(TickFileRec^.From);
      FOR i:=1 TO Num DO
      BEGIN
        IF NOT NodeInSeenBy(TickToTab[i]) THEN
        BEGIN
          FindNodeInfo(NodesRec,TickToTab[i]);
          REPEAT
            s:=tp+'TK'+Copy(InventPktName,3,6)+'.TIC';
          UNTIL Not ExistFile(s);
          New(SendTickFile, Init(s, SCreate, 4096));
          IF SendTickFile<>NIL THEN
          BEGIN
            SendTickFile^.WriteLn('Area '+TickFileRec^.Area);
            SendTickFile^.WriteLn('Origin '+TickFileRec^.Origin);
            SendTickFile^.WriteLn('From '+Adr2Str(TickFileRec^.From));
            SendTickFile^.WriteLn('File '+TickFileRec^.FileName);
            IF TickFileRec^.Replaces<>'' THEN
              SendTickFile^.WriteLn('Replaces '+TickFileRec^.Replaces);
            SendTickFile^.WriteLn('Desc '+TickFileRec^.Desc);
            SendTickFile^.WriteLn('CRC '+HexL(TickFileRec^.CRC));
            SendTickFile^.WriteLn('Created by Portal of Power v'+ver+' (C) Copyright 1989-95 by The Portal Team');
            FOR j:=1 TO TickFileRec^.NumPath DO
              SendTickFile^.WriteLn('Path '+TickFileRec^.Path[j]) ;
            SendTickFile^.WriteLn('Path '+Adr2Str(TickFileRec^.From)+MakeTickDate);
            FOR j:=1 TO TickFileRec^.NumSeenBy DO
              SendTickFile^.WriteLn('Seenby '+Adr2Str(TickFileRec^.SeenBy[j])) ;
            FOR j:=1 TO Num DO
              SendTickFile^.WriteLn('Seenby '+Adr2Str(TickToTab[j])) ;
            SendTickFile^.WriteLn('Seenby '+Adr2Str(TickFileRec^.From)) ;
            IF NodesRec.TickPassword<>'' THEN
              SendTickFile^.WriteLn('PW '+NodesRec.TickPassword);
            Dispose(SendTickFile, Done);
            CASE NodesRec.Flavor OF
              'N' : FL:='F';
              'C',
              'I',
              'D' : FL:=NodesRec.Flavor;
              ELSE FL:='H';
            END;
            WITH TickToTab[i] DO
            BEGIN
              IF UPath='' THEN
                SendAFile(AddBackSlash(TickAreaRec^.AreaPath)+TickFileRec^.FileName, TickToTab[i], FL, STNothing)
              ELSE
                SendAFile(AddBackSlash(UPath)+TickFileRec^.FileName, TickToTab[i], FL, STNothing);
              IF NodesRec.PackTick THEN
              BEGIN
                PTName:=HoldFileName(TickToTab[i],True)+'PTF' ;
                WasThere:=ExistFile(PTName);
                IF NodesRec.PackerType=0 THEN Pk:=1 ELSE Pk:=NodesRec.PackerType;
                IF ArcCommand(Pk,1,PtName,s) THEN
                BEGIN
                  DeleteFile(s);
                  IF Not WasThere THEN SendAFile(PTName,TickToTab[i],FL,STDelete);
                END ELSE
                  SendAFile(s, TickToTab[i], FL,STDelete);
              END ELSE
                SendAFile(s, TickToTab[i], FL, STDelete);
            END;
          END ELSE
            AddLog('!','Not enough memory to create: '+s)
        END ELSE
          AddLog('#','Skipping '+Address2Str(TickToTab[i])+' - is in seenby');
      END;
    END;
  END;

  PROCEDURE UnPackTicks(CONST NodeStat: TNodeStat);
  VAR
    Sr : SearchRec;
    s : PathStr;
  BEGIN
    FindFirst(Cfg.Inbound[NodeStat]+'*.PTF',AnyFile,Sr);
    IF DosError=0 THEN AddLog(' ','Unpacking packed tick files');
    WHILE DosError=0 DO
    BEGIN
      GetDir(0,s); ChangeDir(Cfg.Inbound[NodeStat]);
      IF ArcCommand(ArcType(sr.Name),2,sr.name,'*.TIC') THEN DeleteFile(Sr.Name);
      ChangeDir(s);
      FindNext(Sr);
    END;
    FindClose(Sr);
  END;

  PROCEDURE ProcessTicks;
  VAR
    Sr       : SearchRec;
    NodeStat : TNodeStat;
    TickFile : TNetFile;
    TmpAdr   : TFidoAddress;
  BEGIN
{$IFNDEF PoPLite}
    IF Cfg.TaskType=2 THEN
    BEGIN
      RequestFunction(fsProcessTicks);
      EXIT;
    END;
    FillChar(TmpAdr, SizeOf(TmpAdr), 0);
    IF Not SetInterCom(ICTick, TmpAdr, False) THEN Exit;
    IF TickFile.Open(StartPath+PoPTickFileName, SizeOf(TTickArea),False) THEN
    BEGIN
      AddLog('+','Searching for Tick files');
{
      TickLetterPath:=StartPath+'TICKMSG.'+HexW(Cfg.TaskNumber)+'\';
      MakeFullDir(TickLetterPath);
}
      New(TickFileRec);
      New(TickAreaRec);
      IF (TickFileRec<>NIL) AND (TickAreaRec<>NIL) THEN
      BEGIN
        FOR NodeStat:=nsUnKnown TO nsPassword DO
        BEGIN
          IF (Cfg.InboundToDo[NodeStat] AND itd_Tick)<>0 THEN
          BEGIN
            UnpackTicks(NodeStat);
            FindFirst(Cfg.Inbound[NodeStat]+'*.TIC',AnyFile,Sr);
            IF (DosError=0) AND (Cfg.Tick.BeforeMoving<>'') THEN RunCmd(Cfg.Tick.BeforeMoving, Cfg.Inbound[NodeStat]);
            WHILE DosError=0 DO
            BEGIN
              AddLog(':','Processing: '+Sr.Name);
              IF MoveTick(TickFile, Sr.Name, NodeStat) THEN SendTick('');
              FindNext(Sr);
            END;
            FindClose(Sr);
          END;
        END;
      END ELSE
        AddLog('!','Not enough memory to process tick files');
      IF TickAreaRec<>NIL THEN Dispose(TickAreaRec);
      IF TickFileRec<>NIL THEN Dispose(TickFileRec);
      { Txt2Messages }
{
      RmDir(Copy(TickLetterPath,1,Length(TickLetterPath)-1));
}
      TickFile.Close;
      AddLog('+','Tick processing done');
    END;
{$ENDIF}
  END;

  PROCEDURE Hatch(CONST FName: PathStr; CONST Description: STRING);
  VAR
    TickFile : TNetFile;
    i        : Byte;
    ok       : Boolean;

    FUNCTION FindTickArea: Boolean;
    VAR
      b  : Boolean;
      jp : PathStr;
    BEGIN
      b:=False;
      jp:=StUpCase(AddBackSlash(JustPathName(FName)));
      TickFile.SEEK(0);
      WHILE NOT TickFile.EoF AND (NOT b) DO
      BEGIN
        TickFile.Read(TickAreaRec^,NoKeep,Wait);
        IF jp=AddBackSlash(TickAreaRec^.AreaPath) THEN b:=True;
      END;
      FindTickArea:=b;
    END;

    PROCEDURE PickTicks;
    VAR
      pl : TTickAreaPickList;
      OldTopic : Word;
    BEGIN
      pl.Init(TickFile);
      IF ok THEN
      BEGIN
        pl.SetInitialChoice(TickFile.FILEPOS);
        ok:=False;
      END;
      OldTopic:=Topic;
      Topic:=2002;
      pl.Process;
      pl.Erase;
      Topic:=OldTopic;
      IF pl.GetLastCommand<>ccQuit THEN
      BEGIN
        TickFile.GetRec(TickAreaRec^,pl.GetLastChoice-1,NoKeep,Wait);
        ok:=True;
      END;
      pl.Done;
    END;

  BEGIN
    IF TickFile.Open(StartPath+PoPTickFileName, SizeOf(TTickArea), False) THEN
    BEGIN
      New(TickFileRec);
      New(TickAreaRec);
      IF (TickFileRec<>NIL) AND (TickAreaRec<>NIL) THEN
      BEGIN
        FILLCHAR(TickFileRec^,SizeOf(TickFileRec^),0);
        ok:=FindTickArea;
        PickTicks;
        IF ok THEN
        BEGIN
          WITH TickFileRec^ DO
          BEGIN
            FileName:=StUpCase(JustFileName(FName));
            Replaces:=FileName;
            InputString(21, 7, 12, 12, 2, 'Hatch file', 'Replaces: ', Replaces);
            Area:=TickAreaRec^.AreaName;

            Desc:='A '+Trim(Description);
            DelDlC(Desc);
            Delete(Desc,1,13);

            IF (Cfg.BBS.BBSType=btMax) AND (Length(Desc)>0) AND (Copy(Desc,1,1)='/') THEN
            BEGIN
              i:=Pos(' ', Desc);
              IF i>0 THEN Delete(Desc, 1, i) ELSE Desc:='';
            END;

            Crc:=FileCRC(FName);
            NumSeenBy:=0;
            IF (TickAreaRec^.AkaToUse>0) AND (Cfg.Addresses[TickAreaRec^.AkaToUse].Zone<>0) THEN
            BEGIN
              Origin:=Adr2Str(Cfg.Addresses[TickAreaRec^.AkaToUse]);
              From:=Cfg.Addresses[TickAreaRec^.AkaToUse];
            END ELSE
            BEGIN
              Origin:=Adr2Str(Cfg.Addresses[Cfg.MainAdrNum]);
              From:=Cfg.Addresses[Cfg.MainAdrNum];
            END;
            AddLog(':', 'Hatching '+FileName+': "'+Desc+'" in area '+Area);
          END;
          SendTick(JustPathName(FName));
        END;
      END ELSE
        AddLog('!' ,'Not enough memory to hatch files');
      IF TickAreaRec<>NIL THEN Dispose(TickAreaRec);
      IF TickFileRec<>NIL THEN Dispose(TickFileRec);
      TickFile.Close;
    END;
  END;

END.
