UNIT TextEdit;
{ͻ}
{ Text Editor                                   Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, DOS;

PROCEDURE RunTextEditor(CONST TextFileName:PathStr);

IMPLEMENTATION

USES OpCrt, OpDos, OpString, OpRoot, OpCmd, OpFrame, OpWindow, OpMemo,
     OpEditor, OpEdit, OpPick, OpConst,
     PoPTypes, Input, Keyboard, OproUtil, InterCom, StrUtil,LogFile,
     Globals, Util;

VAR
  PickArray : ^PickListArrayType;
  Editor : TextEditorPtr;
  FSize : LongInt;

  PROCEDURE PickProc(Item: Word; Mode: pkMode; VAR IType: pkItemType;
                     VAR IString: String; PickPtr: PickListPtr); far;
  BEGIN
    IString:=PickArray^[Item-1].FileName;
    IF Mode=pkDisplay THEN IString:=' '+IString;
  END;

  PROCEDURE ReadPickFile;
  VAR
    PickFile : File Of PickListArrayType;
  BEGIN
    Assign(PickFile, StartPath+PoPTextEditorPickFile); FileMode:=ShareRead+ShareDenyW;
    Reset(PickFile);
    IF IOResult=0 THEN
    BEGIN
      Read(PickFile, PickArray^);
      Close(PickFile);
    END ELSE
      FillChar(PickArray^, SizeOf(PickArray^),0);
  END;

  PROCEDURE WritePickFile;
  VAR
    PickFile : File Of PickListArrayType;
  BEGIN
    Assign(PickFile, StartPath+PoPTextEditorPickFile);
    ReWrite(PickFile);
    Write(PickFile, PickArray^);
    Close(PickFile);
  END;

  procedure ErrorProc(UnitCode: Byte; var ErrCode: Word; Msg: string); far;
    {-Error handler}
  var
    CursorSL, CursorXY : Word;
    I : Word;
    Win : WindowPtr;
  begin
    GetCursorState(CursorXY, CursorSL);
    New(Win, InitCustom(1,2,ScreenWidth,2,Cfg.Color[2],wSaveContents+wClear));
    IF Win<>Nil THEN
    BEGIN
      Win^.Draw;
      NormalCursor;
      FastWrite(' '+Msg+'. Press any key...',2,1,ErrorColor);
      I := PopReadKeyWord;
      KillWindow(Win);
      RestoreCursorState(CursorXY, CursorSL);
    END ELSE
      AddLog('!', 'Editor error: '+Msg);
  end;

  PROCEDURE MyStatusProc(MP: MemoPtr); far;
  BEGIN
    with TextEditorPtr(MP)^, Cfg.Color[2] do
    begin
      {get filename if it changed}
      if teOptionsAreOn(teNewFile) then
      begin
        teOptionsOff(teNewFile);
      end;
      FastWrite(CPad(StUpCase(mfFileName),ScreenWidth-37),2,38,HeaderColor);
{     FastWrite('   ',2,78,HeaderColor);}

      FastWrite(' L '+LongIntForm('#####',meCurLine)+'   C '+LongIntForm('#####',meCurCol)+
                '           '+LongIntForm('###',MemAvail Div 1024)+'k    ',2,1,HeaderColor);
      {insert remaining fields}
      if teOptionsAreOn(teInsert) then FastWrite('I',2,22,HeaderColor);
      if teOptionsAreOn(teSmartTabs) then FastWrite('S',2,23,HeaderColor);
      if teOptionsAreOn(teIndent) then FastWrite('D',2,24,HeaderColor);
      if teOptionsAreOn(teWordWrap) then FastWrite('W',2,25,HeaderColor);
      if teOptionsAreOn(teModified) then FastWrite('*',2,37,HeaderColor);
    END;
  END;

  FUNCTION MyYesNo(MsgCode: Word; Prompt: String; Default: Byte;
                   QuitAndAll: Boolean): Byte; far;
  VAR
    LE : LineEditor;
    Ch : Char;
    CharsToTake : CharSet;
    Win : WindowPtr;
  BEGIN
    New(Win, InitCustom(1,2,ScreenWidth,2,Cfg.Color[2],wSaveContents+wClear));
    Win^.Draw;
    LE.Init(Cfg.Color[2]);
    LE.leEditOptionsOn(leAllowEscape+leDefaultAccepted+leForceUpper);
    IF Default=teYes THEN Ch:='Y' ELSE Ch:='N';
    IF QuitAndAll THEN
    BEGIN
      CharsToTake:=['Y','N','A','Q'];
      Prompt:=Prompt+' (Y/N/A/Q)';
    END ELSE
      CharsToTake:=['Y','N'];
    LE.ReadChar(Prompt,2,1,CharsToTake,Ch);
    IF LE.GetLastCommand=ccQuit THEN
      MyYesNo:=teQuit
    ELSE
      CASE Ch OF
        'Y' : MyYesNo:=teYes;
        'N' : MyYesNo:=teNo;
        'A' : MyYesNo:=teAll;
        'Q' : MyYesNo:=teQuit;
      END;
    LE.Done;
    KillWindow(Win);
  END;

  FUNCTION MyEditFunc(MsgCode: Word; Prompt: String; ForceUp, TrimBlanks: Boolean;
                      MaxLen: Byte; VAR s: String): Boolean; far;
  VAR
    LE : LineEditor;
    Win : WindowPtr;
    x1, x2, l : Byte;
  BEGIN
    IF MaxLen<40 THEN l:=MaxLen ELSE l:=40;
    x1:=5; x2:=8+l+Length(Prompt);
    CenterWindow(x1, x2);
    New(Win, InitCustom(x1,5,x2,5,Cfg.Color[3],wBordered+wSaveContents+wClear));
    IF CurrentMode=Mono THEN
      Win^.wFrame.AddShadow(shBR,shOverWrite)
    ELSE
      Win^.wFrame.AddShadow(shBR,shSeeThru);
    Win^.Draw;
    LE.Init(Cfg.Color[3]);
    IF ForceUp THEN LE.leEditOptionsOn(leForceUpper);
    IF Not TrimBlanks THEN LE.leEditOptionsOff(leTrimBlanks);
    LE.ReadString(Prompt,5,x1+2,MaxLen,40,s);
    MyEditFunc:=(LE.GetLastCommand<>ccQuit);
    LE.Done;
    KillWindow(Win);
  END;

  PROCEDURE AddToPickList(CONST FName: PathStr);
  VAR
    i : Byte;
  BEGIN
    i:=0;
    WHILE (i<16) And (PickArray^[i].FileName<>'') And
          (PickArray^[i].FileName<>FullPathName(FName)) DO
      Inc(i);
    IF (i=16) Or (PickArray^[i].FileName='') THEN
    BEGIN
      Move(PickArray^[0], PickArray^[1], SizeOf(TPickList)*15);
    END ELSE
    BEGIN
      IF i>0 THEN Move(PickArray^[0], PickArray^[1], SizeOf(TPickList)*i);
    END;
    PickArray^[0].FileName:=FullPathName(FName);
  END;

  FUNCTION MyGetFileFunc(MsgCode: Word; Prompt: String; ForceUp, TrimBlanks,
                         Writing, MustExist: Boolean; MaxLen: Byte; DefExt: ExtStr;
                         VAR s: String): Boolean; far;
  BEGIN
    if not MyEditFunc(0, Prompt, ForceUp, TrimBlanks, MaxLen, S) then
      MyGetFileFunc := False
    else
      if Writing then
        if ExistFile(S) then
           MyGetFileFunc := MyYesNo(0, 'File exists. Overwrite it?', teNo, False) = teYes
         else
           MyGetFileFunc := True
      else
      BEGIN
        if ExistFile(S) {or not MustExist} then
        BEGIN
          MyGetFileFunc := True;
          IF MsgCode<>39003 THEN AddToPickList(s);
        END ELSE
        begin
          IF (s<>'') And (((Pos('*',s)=0) and (Pos('?',s)=0)) and
             (MyYesNo(0, 'File does not exists. Create it?', teNo, False) = teYes))
             or SelectFile(s) THEN
          BEGIN
            MyGetFileFunc:=True;
            IF MsgCode<>39003 THEN AddToPickList(s);
          END ELSE
            MyGetFileFunc:=False;
        end;
      END;
  END;

PROCEDURE RunTextEditor(CONST TextFileName:PathStr);
VAR
  OldScreen   : POINTER;
  ExitCommand : WORD;
  FName       : PathStr;

  FUNCTION InitEditor: Boolean;
  LABEL
    GetName;
  BEGIN
    InitEditor:=False;
    New(Editor, InitCustom(1,3,ScreenWidth,ScreenHeight,Cfg.Color[2],DefWindowOptions,65521));
    IF Editor=NIL  THEN
    BEGIN
      ErrorProc(0,InitStatus,'Not enough memory to open window');
      Exit;
    END;
    WITH Editor^ DO
    BEGIN
      meOptionsOn(meNoCtrlZ);
      SetStatusProc(MyStatusProc);
      SetErrorProc(ErrorProc);
      SetEditProc(MyEditFunc);
      SetGetFileProc(MyGetFileFunc);
      SetYesNoProc(MyYesNo);
      SetHelpIndex(Topic);
      If TextFileName='' then
      BEGIN
        IF (PickArray^[0].FileName<>'') AND (ExistFile(PickArray^[0].FileName)) THEN
             FName:=PickArray^[0].FileName
        ELSE
        BEGIN
  GetName:
          IF Not MyGetFileFunc(0,'File name: ',True,True,False,False,64,'',FName) THEN
          BEGIN
            Done;
            Exit;
          END;
        END;
      END
      ELSE
        FName := TextFileName;
      IF FName<>'' THEN
      BEGIN
        ReadFile(FName,FSize);
        IF GetLastError=0 THEN
        BEGIN
          If TextFileName='' then AddToPickList(FName);
        END ELSE Goto GetName;
      END ELSE
      BEGIN
        Done;
        Exit;
      END;
    END;
    InitEditor:=True;
  END;

  PROCEDURE AddCommands;
  BEGIN
    WITH EditorCommands DO
    BEGIN
      { ALT-X = Exit all files }
      AddCommand(ccQuit, 1, $2d00, 0);
      Addcommand(ccQuit, 1, $011b, 0);
      { ALT-F3 = Pick List }
      AddCommand(ccUser0, 1, $6a00, 0);
      { ALT-F6 = Swap Files }
      AddCommand(ccUser1, 1, $6d00, 0);
    END;
  END;

  FUNCTION PickFromList(VAR FName: PathStr): Boolean;
  VAR
    NumPick, MaxLen : Byte;
    PL : PickList;
  BEGIN
    NumPick:=0; MaxLen:=0;
    WHILE (NumPick<16) And (PickArray^[NumPick].FileName<>'') DO
    BEGIN
      IF Length(PickArray^[NumPick].FileName)>MaxLen THEN
        MaxLen:=Length(PickArray^[NumPick].FileName);
      Inc(NumPick);
    END;
    WITH PL DO
    BEGIN
      IF Not InitCustom(10,4,50,19,Cfg.Color[3],DefWindowOptions or wBordered,
                        MaxLen+2,NumPick,PickProc,PickVertical,SingleChoice) THEN
      BEGIN
        ErrorProc(0,InitStatus,'Not enough memory to show pickfile');
        Exit;
      END;
      SetSearchMode(PickCharSearch);
      wFrame.AddShadow(shBR, shOverWrite);
      wFrame.AddHeader( ' Pick List ', heTC);
      IF NumPick>1 THEN SetInitialChoice(2);
      OptimizeSize;
      Process;
      IF GetLastCommand=ccSelect THEN
      BEGIN
        FName:=GetLastChoiceString;
        PickFromList:=ExistFile(FName);
      END ELSE
        PickFromList:=False;
      Done;
    END;
  END;


BEGIN
{$IFNDEF PoPLite}
  New(PickArray);
  FillChar(Call,SizeOf(Call),0);
  IF Not SetInterCom(ICTextEdit,Call,False) THEN Exit;
  SaveWindow(1,1,ScreenWidth,ScreenHeight,True,OldScreen);
  AddCommands;
  ReadPickFile;
  FName:='';
  IF InitEditor THEN
  BEGIN
    Topic:=90;
    REPEAT
      Editor^.Process;
      ExitCommand:=Editor^.GetLastCommand;
      case ExitCommand of
        ccQuit,                { quit }
        ccAbandonFile :        { abandon file }
          if not Editor^.teOptionsAreOn(teModified) then
             ExitCommand := ccQuit
          else
          begin
            case MyYesNo(0, emFileModified, teYes, False) of
              teYes :
                begin
                  Editor^.SaveFile;
                  ExitCommand := ccQuit
                end;
              teNo :
                ExitCommand := ccQuit;
              else
                ExitCommand := ccNone;
            end;
          end;
        ccSaveExit : ExitCommand:=ccQuit;
        ccUser0 : BEGIN  { ALT-F3 }
                    if Editor^.teOptionsAreOn(teModified) then
                    begin
                      case MyYesNo(0, emFileModified, teYes, False) of
                        teYes : begin
                                  Editor^.SaveFile;
                                  ExitCommand := ccNone;
                                end;
                        teNo :  ExitCommand := ccNone;
                        else    ExitCommand := ccQuit;
                      end;
                    END;
                    IF (ExitCommand<>ccQuit) And PickFromList(FName) THEN
                    BEGIN
                      Editor^.ReadFile(FName,FSize);
                      IF (Editor^.GetLastError=0) and (TextFileName='') THEN AddToPickList(FName);
                    END;
                    ExitCommand:=ccNone;
                  END;
        ccUser1 : IF PickArray^[1].FileName<>'' THEN
                  BEGIN
                    if Editor^.teOptionsAreOn(teModified) then
                    begin
                      case MyYesNo(0, emFileModified, teYes, False) of
                        teYes : begin
                                  Editor^.SaveFile;
                                  ExitCommand := ccNone;
                                end;
                        teNo :  ExitCommand := ccNone;
                        else    ExitCommand := ccQuit;
                      end;
                    END;
                    IF ExitCommand<>ccQuit THEN
                    BEGIN
                      REPEAT
                        FName:=PickArray^[1].FileName ;
                        Editor^.ReadFile(FName,FSize);
                      UNTIL Editor^.GetLastError=0 ;
                      If TextFileName = '' then AddToPickList(FName);
                    END;
                    ExitCommand:=ccNone;
                  END ;
      end;
    until ExitCommand=ccQuit;
    Dispose(Editor, Done);
  END;
  RestoreWindow(1,1,ScreenWidth,ScreenHeight,True,OldScreen);
  WritePickFile;
  Dispose(PickArray);
{$ELSE}
  AskError(10, 'Not implemented in Portal of Power/Lite', 2);
{$ENDIF}
END;

END.
