UNIT Resource;
{ͻ}
{ Resource mamager                              Last changed: 20.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-95 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, Dos, OpRoot,
     OproUtil;

CONST
  { GetMenu Constants }
  MnuMain          =  1;
  MnuDTDialDir     =  2;
  MnuAMInsertLine  =  3;
  MnuAMMoveFile    =  4;
  MnuAMGlobalFunc  =  5;
  MnuCopyFileError =  6;
  MnuOMSelMailType =  7;
  MnuOMGlobalCmd   =  8;
  MnuOMGetUpdType  =  9;
  MnuOMSelSendAs   = 10;
  MnuDTEmulation   = 11;
{ MnuMacros        = 12;  Udget }
  MnuNLInsNode     = 13;
  MnuEventFlags    = 14;
  MnuNlSearchOpt   = 15;

  MnuUEQBBSFlags   = 100;
  MnuUEOPUS110Flags= 101;
  MnuUEMaxFlags    = 102;

  { GetEsr Constants }
  EsrMiscScreen      =  1;
  EsrGlobalVal       =  2;
  EsrArcSetup        =  3;
  EsrDirAndFiles     =  4;
  EsrMdmOptions      =  5;
  EsrMatrixInfo      =  6;
  EsrDumbTermSetup   =  7;
  EsrDumbTermExt     =  8;
  EsrNLCompSetup     =  9;
  EsrConnectionSetup = 10;
  EsrAreaManSetup    = 11;
  EsrMultiBBSSetup   = 12;
  EsrNetMailSetup    = 13;
  EsrEchoMailSetup   = 14;
  EsrMailScanMisc    = 15;
  EsrFileFwdMisc     = 16;
  EsrNLManager       = 17;
  EsrReqLimits       = 18;
  EsrNodesSetup      = 19;
  EsrFileFwdSetup    = 20;
  EsrOkFileSetup     = 21;
  EsrTickSetup       = 22;
  EsrMiscTickSetup   = 23;
  EsrEventSetup      = 24;
  EsrNodeListSeg     = 25;
  EsrEchoAreas       = 26;
  EsrListFiles       = 27;
  EsrListFiles2      = 28;
  EsrFuncKeys        = 29;
  EsrScheduleSetup   = 30;
  EsrNLTranslatSetup = 31;
  EsrAdvMdmOptions   = 32;
  EsrInboundToDoSetup= 33;
  EsrMailScanParams  = 34;
  EsrMFSSetup        = 35;
  EsrPopEdHeader     = 36;
  EsrMdmConnStat     = 37;

{ ------ User editor ------ }

  EsrUserQBBSCombined = 100;
  EsrUserMAXIMUSMain  = 101;
  EsrUserQBBSMain     = 102;
  EsrUserRAMain       = 103;
  EsrUserOPUS110Main  = 104;
  EsrUserLastRead     = 105;
  EsrUserSBBSMain     = 106;
  EsrUserSBBSExtra    = 107;

VAR
  ResLib : OpLibrary;

PROCEDURE OpenResLib(CONST FName: PathStr);
PROCEDURE CreateResLib(CONST FName: PathStr);
PROCEDURE CloseResLib;
PROCEDURE GetMenu(MNr, ColorLevel: Byte; VAR M: TPoPMenu);
PROCEDURE GetEsr(ENr, ColorLevel: Byte; VAR Esr: TPoPEntryScreen);
FUNCTION  GetString(CONST StrName: DirEntryName): String;
PROCEDURE PutString(CONST StrName: DirEntryName; S: String);
FUNCTION To3(B: Byte): String;

IMPLEMENTATION

USES OpCrt, OpString, OpEntry, OpMenu, OpField, OpSelect,
     Nodelist, Globals, LogFile, Config, MailCfg, PoPHelp, UserEdit;

CONST
  otStrLib = 1100;
  veStrLib = 0;
  ResLibOpen : Boolean = False;

TYPE
  StrTypePtr = ^StrType;
  StrType    = Object(Root)
                 Str : String ;

                 CONSTRUCTOR Init(CONST St: String);
                 CONSTRUCTOR Load(VAR S: IdStream);
                 PROCEDURE Store(VAR S: IdStream);
               END;

  CONSTRUCTOR StrType.Init(CONST St: String);
  BEGIN
    Str:=St;
  END;

  CONSTRUCTOR StrType.Load(VAR S: IdStream);
  BEGIN
    IF Not Root.Init THEN Fail;
    Str:=S.ReadString;
    IF S.PeekStatus<>0 THEN Fail;
  END;

  PROCEDURE StrType.Store(VAR S: IdStream);
  BEGIN
    S.WriteString(Str);
  END;

  PROCEDURE StrLibStream(SPtr: IdStreamPtr); far;
  BEGIN
    SPtr^.RegisterType(otStrLib,veStrLib,TypeOf(StrType),@StrType.Store,@StrType.Load);
  END;

  FUNCTION GetString(CONST StrName: DirEntryName): String;
  VAR
    St: StrType;
  BEGIN
    ResLib.GetEntry(StrName,St);
    GetString:=St.Str;
    St.Done;
  END;

  PROCEDURE PutString(CONST StrName: DirEntryName; S: String);
  VAR
    St : StrType;
  BEGIN
    St.Init(S);
    ResLib.PutEntry(StrName, St);
    St.Done;
  END;

  FUNCTION To3(B: Byte): String;
  BEGIN
    To3:=LongIntForm('@@@',b);
  END;

{=== RESOURCE LIBRARY ===================================================}

  PROCEDURE OpenResLib(CONST FName: PathStr);
  BEGIN
    FileMode:=$20;
    IF Not ResLib.Init(FName, $3D20, 1024,'POP-RES') THEN
    BEGIN
      WriteLn(FName+' not found Portal halted (Error code:',InitStatus,')');
      Halt(255);
    END;
    ResLib.RegisterHier(TPoPMenuStream);
    ResLib.RegisterHier(TPoPEntryScreenStream);
    ResLib.RegisterHier(YesNoFieldStream);
    ResLib.RegisterHier(TBitYesNoFieldStream);
    ResLib.RegisterHier(TimeFieldStream);
    ResLib.RegisterHier(ByteFieldStream);
    ResLib.RegisterHier(ShortIntFieldStream);
    ResLib.RegisterHier(WordFieldStream);
    ResLib.RegisterHier(IntegerFieldStream);
{$IFDEF OS2}
    ResLib.RegisterHier(SmallWordFieldStream);
    ResLib.RegisterHier(SmallIntFieldStream);
{$ENDIF}
    ResLib.RegisterHier(StringFieldStream);
    ResLib.RegisterHier(CharFieldStream);
    ResLib.RegisterHier(ChoiceFieldStream);
    ResLib.RegisterHier(LongIntFieldStream);
    ResLib.RegisterHier(TextFieldStream);
    ResLib.RegisterHier(DateStFieldStream);
    ResLib.RegisterHier(DateFieldStream);
    ResLib.RegisterHier(StringDictStream);
    ResLib.RegisterPointer(1000, @Cfg);
    ResLib.RegisterPointer(1001, @Config.IncBBSType);
    ResLib.RegisterPointer(1002, @Config.IncNodelist);
    ResLib.RegisterPointer(1003, @NodelistEntry);
    ResLib.RegisterPointer(1004, @Str2Bin);
    ResLib.RegisterPointer(1005, @ValidateBin);
    ResLib.RegisterPointer(1006, @BinConv);
    ResLib.RegisterPointer(1007, @NodesRec);
    ResLib.RegisterPointer(1008, @MailCfg.IncNodeStat);
    ResLib.RegisterPointer(1009, @Config.IncModemType);
    ResLib.RegisterPointer(1010, @MailCfg.IncFreeArea);
    ResLib.RegisterPointer(1011, @CurrentEvent);
{   ResLib.RegisterPointer(1012, @NodeListSegRec);}
    ResLib.RegisterPointer(1013, @UserEdit.IncOPUSUserLevel);
    ResLib.RegisterPointer(1014, @UserEdit.IncMaximusUserLevel);
    ResLib.RegisterPointer(1015, @UserEdit.BinConv32);
    ResLib.RegisterPointer(1016, @UserEdit.ValidateBin32);
{   ResLib.RegisterPointer(1017, @UserEdit.Combined);
    ResLib.RegisterPointer(1018, @UserEdit.UserRecord7);
    ResLib.RegisterPointer(1019, @UserEdit.UserRecord1);
    ResLib.RegisterPointer(1020, @UserEdit.UserRecord4);
    ResLib.RegisterPointer(1021, @UserEdit.UserRecord3);}
{    ResLib.RegisterPointer(1022, @AreasRec);}
    ResLib.RegisterPointer(1023, @IncArcType);
    ResLib.RegisterPointer(1024, @MailCfg.IncSCDAction);
    ResLib.RegisterPointer(1025, @UserEdit.IncMaxHelpLevel);
    ResLib.RegisterPointer(1026, @UserEdit.IncMaxVideoLevel);
    ResLib.RegisterPointer(1027, @UserEdit.IncMaxProtocol);
    ResLib.RegisterPointer(1028, @MailCfg.IncAKAUsed);
    ResLib.RegisterPointer(1029, @Config.IncTaskType);
    ResLib.RegisterPointer(1030, @Config.IncReqOnUs);
    ResLib.RegisterHier(StrLibStream);
    ResLibOpen:=True;
  END;

  PROCEDURE CreateResLib(CONST FName: PathStr);
  BEGIN
    IF Not ResLib.Create(FName, 2048,'POP-RES',64) THEN
    BEGIN
      Halt(255);
    END;
    ResLib.RegisterHier(MenuStream);
    ResLib.RegisterHier(EntryScreenStream);
    ResLib.RegisterPointer(1000, @Cfg);
  END;

  PROCEDURE CloseResLib;
  BEGIN
    IF ResLibOpen THEN
    BEGIN
      ResLib.Done;
      ResLibOpen:=False;
    END;
  END;

  PROCEDURE GetMenu(MNr, ColorLevel: Byte; VAR M: TPoPMenu);
  VAR
    Offset : Byte;
  BEGIN
    ResLib.GetEntry('MNU'+To3(MNr),M);
    M.UpdateScreenSize;
    Offset:=(ScreenWidth-80) DIV 2;
    M.MoveWindow(Offset, 0);
    WITH Cfg.Color[ColorLevel] DO
    BEGIN
      M.SetAllFrameAttr(FrameColor,FrameMono);
      M.SetAllHeaderAttr(HeaderColor,HeaderMono);
      M.SetAllHighAttr(HighItemColor,HighItemMono);
      M.SetAllNormAttr(TextColor,TextMono);
      M.SetAllProtectAttr(ProItemColor,ProItemMono);
      M.SetAllSelectAttr(SelItemColor,SelItemMono);
      M.SetAllShadowAttr(ShadowColor,ShadowMono);
    END;
    IF Cfg.Screen.ExplodingWin THEN M.EnableAllExplosions(6) ELSE M.EnableNormalOpen;
  END;

  PROCEDURE GetEsr(ENr, ColorLevel: Byte; VAR Esr: TPoPEntryScreen);

    PROCEDURE ResetEsrColors;
    VAR
      EFP : EntryFieldPtr;
      TFP : TextFieldPtr;
      CA, MA : FlexAttrs;
    BEGIN
      { Br ndres til VisitAll..... metode kald! }
      EFP := EntryFieldPtr(Esr.asFields.Head);
      WHILE EFP <> Nil DO
        WITH EFP^ DO
        BEGIN
          sfCtrlColor := Cfg.Color[ColorLevel].CtrlColor;
          sfCtrlMono := Cfg.Color[ColorLevel].CtrlMono;
          sfProFieldColor := Cfg.Color[ColorLevel].ProFieldColor;
          sfProFieldMono := Cfg.Color[ColorLevel].ProFieldMono;
          sfSelFieldColor := Cfg.Color[ColorLevel].SelFieldColor;
          sfSelFieldMono := Cfg.Color[ColorLevel].SelFieldMono;
          sfFieldColor := Cfg.Color[ColorLevel].FieldColor;
          sfFieldMono := Cfg.Color[ColorLevel].FieldMono;
          sfProPromptColor := Cfg.Color[ColorLevel].ProPromptColor;
          sfProPromptMono := Cfg.Color[ColorLevel].ProPromptMono;
          sfSelPromptColor := Cfg.Color[ColorLevel].SelPromptColor;
          sfSelPromptMono := Cfg.Color[ColorLevel].SelPromptMono;
          sfPromptColor := Cfg.Color[ColorLevel].PromptColor;
          sfPromptMono := Cfg.Color[ColorLevel].PromptMono;
          EFP := EntryFieldPtr(dlNext);
        END;
      { ndre tekst felter.... }
      FillChar(CA, SizeOf(CA), Cfg.Color[ColorLevel].TextColor);
      FillChar(MA, SizeOf(MA), Cfg.Color[ColorLevel].TextMono);
      TFP := Pointer(ESR.asTextFields.Head);
      while TFP <> nil do
        with TFP^ do
        begin
          tfColorAttrs:=CA;
          tfMonoAttrs :=MA;

          {follow link}
          TFP := Pointer(TFP^.slNext);
        end;

    END;

  VAR
    i : LongInt;
    Offset : Byte;
  BEGIN
    ResLib.GetEntry('ESR'+To3(ENr),Esr);
    i:=ResLib.GetStatus;
    IF i<>0 THEN
    BEGIN
      AddLog('!','GetESR: Error '+Long2Str(i)+' in '+Long2Str(Enr));
      Halt(255);
    END;
    WITH Cfg.Color[ColorLevel],ESR DO
    BEGIN
      ResetHeaderColor(HeaderColor, HeaderMono);
      ResetShadowColor(ShadowColor, ShadowMono);
      wFrame.frFrameColor := FrameColor;
      wFrame.frFrameMono := FrameMono;
      SetTextAttr(TextColor,TextMono);
      esFieldOptionsOn(efClearFirstChar);
      SetWrapMode(WrapAtEdges);
    END;
    ResetEsrColors ;
    IF Cfg.Screen.ExplodingWin THEN Esr.EnableExplosions(10) ELSE Esr.EnableNormalOpen;
    EntryCommands.SetHelpProc(HelpRoutine);
{   ESR.Draw;}
    ESR.UpdateScreenSize;
    Offset:=(ScreenWidth-80) DIV 2;
    ESR.AdjustWindow(2+Offset,3,79+Offset,ScreenHeight-3);
    Topic:=0 ;
  END;

END.

