UNIT Init;
{ͻ}
{ Initialization routines                       Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE InitPortal;

IMPLEMENTATION

USES Dos, OpCrt, OpString,
{$IFNDEF OS2}
     OpMacro,
{$ENDIF}
     OpDos, OpWindow, OpDate, OpEdit, OpEditor, OpBrowse,
     OpPick, OpMenu, OpEntry, OpFrame, OpAbsFld, OpKey, OpLArray, ApTimer,
     NlComp, Util, Com, Modem, Globals, Config, OproUtil, OutInfo,
     NodeList, FileUtil, Keyboard, LogFile, Display, Event, Resource, NetFile,
     MTask, AreaMan, Session, PoPTypes,BbsDef, List,
{$IFDEF MSGOBJECT}
     PoPEd,
{$ENDIF}
{$IFNDEF OS2}
     Macro,
{$ELSE}
     VpUtils,
{$ENDIF}
     PFix, Input, StrUtil;

  PROCEDURE SetupVar;
  BEGIN
    New(OutList, Init);
    New(StatRec);
    CLOutListPtr:=Nil ; FLOutListPtr:=Nil ;
    FillChar(Call, SizeOf(Call), 0);
    MemUsage:=[mu_Upper, mu_EMS, mu_XMS];
    NewTimer(OutboundReRead, 0);
  END;

  PROCEDURE ShowRTFM(CONST s: String; MustExit: Boolean);
  VAR
    HelpWin : WindowPtr;
    t       : EventTimer;
  BEGIN
    IF s<>'' THEN WriteLn('Unknown commandline switch: ',s);
    WriteLn;
    WriteLn('PORTAL.EXE [Switches] [CfgFile]');
    WriteLn;
    WriteLn('  /A        Enter AreaMan');
    WriteLn('  /B<Size>  Set extra overlay buffer size');
    WriteLn('  /C        Enter Configuration');
    WriteLn('  /D[U|E|X] Disable Upper, EMS, XMS memory usage');
    WriteLn('  /E        Don''t use XMS or EMS for overlay buffer');
{$IFDEF MSGOBJECT}
    WriteLn('  /F        Enter PoPEd');
{$ENDIF}
    WriteLn('  /H<Path>  Portal homedir');
    WriteLn('  /J        Jump to current event');
    WriteLn('  /M        Turn off macros');
{$IFNDEF NOMAILSCANNER}
    WriteLn('  /M[S|T|P] Perform Mail Scan/Toss/Pack');
{$ENDIF}
    WriteLn('  /N        No-Modem');
    WriteLn('  /O        Check on-line');
    WriteLn('  /Q        Run PoPList (generate filelist)');
    WriteLn('  /R<Secs>  Wait <Secs> before scanning outbound on startup');
    WriteLn('  /T<Task>  Task number');
    WriteLn('  /V        Compile nodelist');
    WriteLn('  /?        Show this help');
    WriteLn;
    WriteLn('  CfgFile   Name of the configuration file to use');
    WriteLn;
    IF NOT MustExit THEN
    BEGIN
      WriteLn;
      WriteLn('Press ESC within 10 seconds to abort Portal');
      WriteLn;
      NewTimerSecs(t, 10);
      WHILE NOT TimerExpired(t) AND NOT KeyPressed DO
        GiveUpTime;
      MustExit:=(KeyPressed) AND (ReadKeyWord=ESC);
    END;
    IF MustExit THEN Halt;
  END;

  PROCEDURE ParseCmdLine;
  VAR
    pc,i: Byte;
    Tmp, Param : String;
    x  : Word;
    Ok : Integer;
    Secs : LongInt;
  BEGIN
    Tmp:=StUpCase(GetEnv('POPCMDLINE'));
    FOR i:=1 TO ParamCount DO
      Tmp:=Tmp+' '+StUpCase(ParamStr(i));
    FOR pc:=1 TO WordCount(Tmp, [' ']) DO
    BEGIN
      Param:=ExtractWord(pc, Tmp, [' ']);

      IF Param[1] IN ['-','/'] THEN
      BEGIN
        Delete(Param,1,1);
        CASE Param[1] OF
          'A' : CmdLineFlags:=CmdLineFlags OR clAreaMan OR clNoModem;
          'C' : BEGIN
                  CmdLineFlags:=CmdLineFlags OR clNoModem;
                  DoConfig:=1;
                END;
          'B',
          'E' : ;   { Bruges i OvrlayIn }
          'F' : CmdLineFlags:=CmdLineFlags OR clPoPEd OR clNoModem;
          'D' : FOR i:=2 TO Length(Param) DO
                  CASE Param[i] OF
                    'U' : MemUsage:=MemUsage-[mu_Upper];
                    'E' : BEGIN
                            MemUsage:=MemUsage-[mu_EMS];
{$IFNDEF DPMI}
                            DefaultPriority[2]:=lNoArray;
{$ENDIF}
                          END;
                    'X' : BEGIN
                            MemUsage:=MemUsage-[mu_XMS];
{$IFNDEF DPMI}
  {$IFNDEF OS2}
                            DefaultPriority[3]:=lNoArray;
  {$ENDIF}
{$ENDIF}
                          END;
                    ELSE ShowRTFM('/'+Param, False);
                  END;
          'H' : ChangeDir(Copy(Param, 2, 255));
          'J' : CmdLineFlags:=CmdLineFlags OR clJump2Event;
          'M' : BEGIN
                  IF LENGTH(Param)=1 THEN CmdLineFlags:=CmdLineFlags OR clMacroDefeat ELSE
                  BEGIN
{$IFNDEF NOMAILSCANNER}
                    FOR i:=2 TO LENGTH(param) DO
                      CASE Param[i] OF
                        'S' : CmdLineFlags:=CmdLineFlags OR clMailScan;
                        'T' : CmdLineFlags:=CmdLineFlags OR clMailToss;
                        'P' : CmdLineFlags:=CmdLineFlags OR clMailPack;
                        ELSE ShowRTFM('/'+Param,FALSE);
                      END;
{$ENDIF}
                  END;
                END;
          'N' : CmdLineFlags:=CmdLineFlags OR clNoModem;
          'O' : CmdLineFlags:=CmdLineFlags OR clCheckOnline;
          'Q' : CmdLineFlags:=CmdLineFlags OR clPoPList OR clNoModem;
          'R' : BEGIN
                  Val(Copy(Param, 2, 255), Secs, Ok);
                  IF Ok=0 THEN
                    NewTimerSecs(OutboundReRead, Secs);
                END;
          'T' : BEGIN
                  Val(Copy(Param,2,255), i, Ok);
                  IF Ok=0 THEN PoPCfgFileName:='PORTAL'+LongIntForm('@@', i)+'.CFG';
                END;
          'V' : CmdLineFlags:=CmdLineFlags OR clCompileNL OR clNoModem;
          '?' : ShowRTFM('', True);
          ELSE  ShowRTFM('/'+Param, False);
        END;
      END ELSE
      BEGIN
        IF (Pos('?',Param)>0) Or (Pos('*',Param)>0) THEN
          ShowRTFM(Param, False)
        ELSE
          PoPCfgFileName:=JustFileName(Param);
      END;
    END;
  END;


  PROCEDURE InitPortal;
  VAR
    EventFile      : TNetFile;
    CopyRight      : WindowPtr;
    o              : Byte;
    Key            : LongInt;
    SkipOutboundScan : Boolean;

    PROCEDURE UpdateCallersList;
    TYPE
      LASTCALLrecord = record
        Line           : Byte;
        Name,
        Handle         : S35;
        City           : S25;
        Baud           : Word;
        Times          : LongInt;
        LogOn          : S5;
        LogOff         : S5;
        Attribute      : Byte;
      end;

    VAR
      fs:PFileStruct;
      f : TNetFile;
      FPath,FNam:PathStr;
      Buf:POINTER;
      s,ss:STRING;
      Tmp:BYTE;
      l:LONGINT;

      PROCEDURE AddUserName(CONST s: S35; FTime: LongInt);
      VAR
        i  : Byte;
        DT : DateTime;
      BEGIN
        IF FTime<>Data.UserTime THEN
        BEGIN
          i:=0;
          REPEAT
            Inc(i);
          UNTIL (i=5) OR (data.users[i].Name='');
          IF (data.users[5].Name<>'') THEN Move(data.users[2],data.users[1],4 * 40);
          data.users[i].Name:=s;
          UnPackTime(FTime,Dt);
          WITH Dt DO
            Data.Users[i].T:=HMSToTime(Hour,Min,Sec);
          Data.UserTime:=FTime;
        END;
      END;

    BEGIN
      GetFileStruct(fs,'LASTUSER');
      IF fs<>NIL THEN
      BEGIN
        IF Fs^.Tasks THEN FNam:=MakeTaskFileName(fs^.Name)
                     ELSE FNam:=fs^.Name;
        FPath:=JustPathName(FNam)+'\';
        IF FPath='\' THEN FPath:=Cfg.BBS.Path;
        IF f.Open(FPath+JustFileName(FNam),RecLen(fs),FALSE) THEN
        BEGIN
          GetMem(Buf,RecLen(Fs));
          f.GetRec(Buf^,f.FileSize-1,NoKeep,Wait);
          Tmp:=FindField(Fs,bdName);
          IF Tmp>0 THEN
          BEGIN
            ss:=GetFieldText(fs,Tmp,Buf);

            Tmp:=FindField(fs,bdTask);
            IF (Tmp>0) AND (Cfg.TaskNumber>0) THEN
            BEGIN
              GetField(fs,Tmp,Buf,Tmp);
              IF Cfg.TaskNumber<>Tmp THEN Tmp:=0;
            END ELSE Tmp:=1;
            IF Tmp>0 THEN
            BEGIN
              FreeMem(Buf,RecLen(Fs));
              GetFTime(f.f,l);
              f.Close;
              AddUserName(ss,l);
            END;
          END;
        END;
        DisposeFileStruct(fs);
      END;
    END;

    PROCEDURE WriteHead;
    VAR
      s : String[80];
    BEGIN
      s:='Portal Of Power v'+Ver;
      IF Cfg.TaskNumber<>0 THEN s:=s+' Task #'+Long2Str(Cfg.TaskNumber);
      TextAttr:=cfg.color[1].TextColor;
      ClrScr;
      FastCenter(s,1,Cfg.Color[1].TextColor);
    END;

    PROCEDURE SetupScreen;
    VAR
      Start : Byte;
    BEGIN
      WriteHead;
      FastText('F1=Help   F2=Menu',ScreenHeight-1,2+((ScreenWidth-80) DIV 2));
      FastText('F9=About Today   F10=Edit config',ScreenHeight,48+((ScreenWidth-80) DIV 2));
      MyWin(StatusWindow, 1,2,21,8,1,'Status',False);
      WITH StatusWindow^, Cfg.Color[1] DO
      BEGIN
        wfasttext('Date   :', 1, 2);
        wfasttext('Time   :', 2, 2);
        wfasttext('Event  :', 3, 2);
        wfasttext('Port/Sp:', 4, 2);
        wfasttext('Flags  :', 5, 2);
      END;
      UpdateStatusWindow;
      MyWin(OutBoundWindow, 22,2,80,8,1,'Outbound Packets',False);
      WITH OutboundWindow^ DO
        wfasttext('Destination        S ICDNH R M F  Fls Age  Size TfrTime', 1, 2);
      MyWin(ActivityWindow,1,9,80,ScreenHeight-2-Byte(ScreenHeight>LinesForStat)*7,1,'Activity',False);
      WITH ActivityWindow^.wFrame DO
      BEGIN
        AddHeader(StatusStr,heBR);
        ChangeHeaderAttr(1,Cfg.Color[1].FrameColor,Cfg.Color[1].FrameColor);
        DrawHeader(1);
{$IFDEF UseScrollBars}
        AddScrollBar(FrRR,1,10,Cfg.Color[1]);
{$ENDIF}
        AddHeader(StatusStr,heBL);
        ChangeHeaderAttr(2,Cfg.Color[1].FrameColor,Cfg.Color[1].FrameColor);
        DrawHeader(2);
      END;
      ActivityWindow^.wFrame.SetFrameType(SglWindowFrame);
      OutboundWindow^.wFrame.SetFrameType(DblWindowFrame);
      ActivityWindow^.wFrame.UpDateFrame;
      OutboundWindow^.wFrame.UpDateFrame;
      IF ScreenHeight>LinesForStat THEN
      BEGIN
        MyWin(CallsIn,1,ScreenHeight-8,40,ScreenHeight-2,1,'Last calls in',False);
        UpdateCallsWindow(CallsIn,1);
        MyWin(CallsOut,41,ScreenHeight-8,80,ScreenHeight-2,1,'Last calls out',False);
        UpdateCallsWindow(CallsOut,2);
      END;
      Start:=(ScreenHeight DIV 2)-4;
      MyWin(Copyright,18,Start,62,Start+6,2,'Initializing',True);
      WITH CopyRight^ DO
      BEGIN
        wFastCenter('Portal of Power v'+Ver,2,Cfg.Color[2].TextColor);
        wFastText('(C)  Copyright 1989-97 by The Portal Team',4,2);
      END;
    END;

    PROCEDURE GetLogFile;
    VAR
      BufSize,p,fs : LongInt;
      i : Byte;
      Buffer : Array[0..4097] Of Byte;
    BEGIN
      LogLines:=ScreenHeight-12-Byte(ScreenHeight>LinesForStat)*7;
      InLogWin:=False;
      fs:=PortalLog.FileSize; i:=LogLines+1;
      IF fs>4096 THEN BufSize:=4096 ELSE BufSize:=fs;
      PortalLog.Seek(fs-BufSize);
      PortalLog.BlockRead(Buffer,BufSize);
      p:=BufSize+1;
      REPEAT
        REPEAT
          DEC(p);
        UNTIL (p=0) OR (Buffer[p]=10);
        CurrentLogView[i]:=fs-BufSize+p+1;
        Dec(i);
      UNTIL (i=0) or (p=0);
      CurrentLogView[LogLines+1]:=fs+2;
      EndLogView:=CurrentLogView;
      ReWriteLogWindow;
    END;

    PROCEDURE ReadControlFile;
    CONST
      NumColors = 31;
    VAR
      f         : FILE OF TConfig;
      f2        : TNetFile;
      fr        : FILE;
      test      : Integer;
      tn,i      : Byte;
      ch        : Char;
      c         : ARRAY[1..4] OF ColorSet;
      ct        : ARRAY[1..4,1..NumColors,1..2] OF BYTE Absolute c;
      x         : TNodeStat;
    BEGIN
      Assign(f, PoPCfgFileName); FileMode:=ShareRead+ShareDenyW;
      Reset(f);

      FillChar(cfg,SizeOf(cfg),#0);
      IF IoResult<>0 THEN
      BEGIN
        { Make default configuration file }
        FOR test:=1 TO 4 DO
        BEGIN
          c[test]:=DefaultColorSet;
          IF CurrentMode=BW80 THEN
          BEGIN
            FOR i:=1 TO NumColors DO
              ct[test,i,1]:=ct[test,i,2];
          END ELSE
          BEGIN
            FOR i:=1 TO NumColors DO
              ct[test,i,2]:=ct[test,i,1];
          END;
          Cfg.Color[Test]:=c[Test];
        END;
        WITH cfg DO
        BEGIN
          Version:=CfgVersion;
          LogLevel:=4;
          calltime:=120;
          callwidth:=60;
          BiMail.MaxBaud:=2400;
          BiMail.BiOverride[1]:='/V32';
          ConnectFastest:=True;
          DumbTerm.DestructiveBS:=True;
          UseJanus:=True;
          UseEMSI:=True;
          FastCalls:=True;
          EnterBBSText:='Entering BBS, Fasten seat belts';
          PressESCText:='Press ESC to enter BBS';
          DoingMailText:='Sorry, we''re doing mail at the moment, please call back later';
          OutRereadDelay:=60*60;
          MainAdrNum:=1;
          WITH Screen DO
          BEGIN
            BlankTime:=120;
            HardwareBlank:=False;
            KeepOffScrMode:=True;
          END;
          WITH Modem DO
          BEGIN
            CommPort:=1;
            BaudRate:=2400;
            Init:='|ATZ|~ATS0=0|';
            Dial:='|ATDT';
            PreInit:='|v~^~';
            ReInit:=60*30; { once per 1/2 hour }
            Answer:='~ATA|';
            WaitTime:=60;
          END;
          SwapOnExec:=True;
          FOR x:=nsUnknown TO nsPassword DO
            Inbound[x]:=StartPath+'MAIL\IN\';
          Outbound:=StartPath+'MAIL\OUT';
          LogFileName:=StartPath+PoPLogFileName;
          Nodelist:=StartPath+'NODELIST\';
          Cfg.InboundToDo[nsKnown]:=itd_Tick+itd_File+itd_Mail;
          WITH Packer[1] DO
          BEGIN
            AddCmd:='PKPAK.EXE -oc -a $archive $filespec';
            UnPackCmd:='PKUNPAK.EXE -r $archive $filespec';
            EraseCmd:='PKPAK.EXE d $archive $filespec';
            TestCmd:='PKPAK.EXE t $archive $filespec';
          END;
          WITH Packer[2] DO
          BEGIN
            AddCmd:='PKZIP.EXE -a $archive $filespec';
            UnPackCmd:='PKUNZIP.EXE -e -o $archive $filespec';
            EraseCmd:='PKZIP.EXE -d $archive $filespec';
            TestCmd:='PKUNZIP.EXE -t $archive $filespec';
          END;
          WITH Packer[3] DO
          BEGIN
            AddCmd:='LHARC.EXE a /m $archive $filespec';
            UnPackCmd:='LHARC.EXE e /m $archive $filespec';
            EraseCmd:='LHARC.EXE d /m $archive $filespec';
            TestCmd:='LHARC.EXE t /m $archive $filespec';
          END;
          WITH Packer[4] DO
          BEGIN
            AddCmd:='PAK.EXE a $archive $filespec';
            UnPackCmd:='PAK.EXE e /WA $archive $filespec';
            EraseCmd:='PAK.EXE d $archive $filespec';
            TestCmd:='PAK.EXE t $archive $filespec';
          END;
          WITH Packer[6] DO
          BEGIN
            AddCmd:='SQZ.EXE a -q $archive $filespec';
            UnPackCmd:='SQZ.EXE e $archive $filespec';
            EraseCmd:='SQZ.EXE d $archive $filespec';
            TestCmd:='SQZ.EXE t $archive $filespec';
          END;
          WITH Packer[7] DO
          BEGIN
            AddCmd:='ARJ.EXE a $archive $filespec';
            UnPackCmd:='ARJ.EXE e -y $archive $filespec';
            EraseCmd:='ARJ.EXE d $archive $filespec';
            TestCmd:='ARJ.EXE t $archive $filespec';
          END;
          FOR i:=1 TO 5 DO
          BEGIN
            ExtProt[i].Key:=' ';
            BBS.Multi[i].Key:=' ';
          END;
          WITH AreaMan DO
          BEGIN
            DLCntStart:='[';
            DLCntStop:=']';
          END;
          WITH MailScanner DO
          BEGIN
            DefaultPacker:=1;
          END;
          Request.RspAsPkt:=True;
          KeepEmptyDirs:=(GetDiskClass(Outbound[1], Ch)=NovellDrive);
        END;
        { End of default configuration file }
        DoConfig:=2;
        CmdLineFlags:=CmdLineFlags OR clNoModem;
      END ELSE
      BEGIN
        Read(f,cfg);
        IF IOResult<>0 THEN ;
        Close(f);
{***** Fjernes engang.... *****}
        IF Cfg.Version=2 THEN
        BEGIN
          Cfg.Version:=CfgVersion;
          FOR x:=nsUnknown TO nsPassword DO
            Cfg.Inbound[x]:=Cfg.Filler1;
          Cfg.InboundToDo[nsKnown]:=itd_Tick+itd_File+itd_Mail;
          FillChar(Cfg.Filler1, SizeOf(Cfg.Filler1), 0);
          Cfg.Modem.WaitTime:=60;
          Move(Cfg.Modem.Init[41], Cfg.Modem.NoAnswer, 645);
          SaveConfiguration;
        END;
        IF Cfg.Version=3 THEN
        BEGIN
          Cfg.Version:=CfgVersion;
          Move(Cfg.Modem.Init[41], Cfg.Modem.NoAnswer, 645);
          SaveConfiguration;
        END;
        IF Cfg.Modem.WaitTime=0 THEN Cfg.Modem.WaitTime:=60;
{******************************}
        IF Cfg.Version<>CfgVersion THEN
        BEGIN
          WriteLn('Portal of Power v'+Ver+#10#13'Wrong .CFG-file version - please run CONVCFG.EXE');
          Halt(1);
        END;
      END;
      IF Cfg.HexTask THEN
        Val('$'+Copy(PoPCfgFileName, Pos('.', PoPCfgFileName)-2,2), tn, test)
      ELSE
        Val(Copy(PoPCfgFileName, Pos('.', PoPCfgFileName)-2,2), tn, test);
      IF (Test=0) And (tn<>Cfg.TaskNumber) THEN Cfg.TaskNumber:=tn;
      IF NOT f2.Open(MakeTaskFileName(PoPDataFileName), SizeOf(Data), False) THEN
      BEGIN
        FillChar(data,SizeOf(data),#0);
      END ELSE
      BEGIN
        f2.Read(data,NoKeep,Wait);
        f2.Close;
      END;
      IF NOT f2.Open(MakeTaskFileName(PoPStatisticsFileName), SizeOf(TPortalStat), False) THEN
      BEGIN
        FillChar(StatRec^, SizeOf(StatRec^), 0);
      END ELSE
      BEGIN
        f2.Read(StatRec^,NoKeep,Wait);
        IF f2.IOResult<>0 THEN FillChar(StatRec^, SizeOf(StatRec^), 0);
        f2.Close;
      END;
    END;

  BEGIN
    SetupVar;
    CheckBreak:=False;
    UseEnhancedKbd:=EnhancedKbdInstalled;
{$IFNDEF OS2}
    GetCBreak(SaveBreakState);
    SetCBreak(False);
{$ENDIF}
    DetectMultitasking:=True;
    ReInitCrt;
    ParseCmdLine;
    GetDir(0, StartPath);
    IF Copy(StartPath, Length(StartPath), 1)<>'\' THEN StartPath:=StartPath+'\';
    ReadControlFile;
    OldErrPtr:=ExitProc;
    ExitProc:=@ErrorHandler;
    IF NOT Cfg.Screen.KeepOffScrMode THEN SelectFont8x8(Cfg.Screen.ScrMode);
    CheckSnow:=Cfg.Screen.ChkSnow;
    StopClock;
    MenuCommands.SetGetKeyProc(PoPReadKeyWord);
    MenuCommands.SetKeyPressedProc(PoPKeyPressed);
    EntryCommands.SetGetKeyProc(PoPReadKeyWord);
    EntryCommands.SetKeyPressedProc(PoPKeyPressed);
    EditCommands.SetGetKeyProc(PoPReadKeyWord);
    EditCommands.SetKeyPressedProc(PoPKeyPressed);
    PickCommands.SetGetKeyProc(PoPReadKeyWord);
    PickCommands.SetKeyPressedProc(PoPKeyPressed);
    EditorCommands.SetGetKeyProc(PopReadKeyWord);
    EditorCommands.SetKeyPressedProc(PopKeyPressed);
    BrowseCommands.SetKeyPressedProc(PopKeyPressed);
    BrowseCommands.SetGetKeyProc(PopReadKeyWord);
    UserSet1:=['0','1'];
    UserSet2:=['N','Y'];
    ForceCaseUser['1']:=NoChange;
    ForceCaseUser['2']:=UpperCase;
    IF DoConfig<>0 THEN
    BEGIN
      OpenFiles(FALSE);
      WriteHead;
      Key:=-1;
      Configuration(DoConfig=2,Key);
      CloseFiles(FALSE);
      Halt;
    END;
    IF ((CmdLineFlags AND clAreaMan)<>0) THEN
    BEGIN
      OpenFiles(FALSE);
      WriteHead;
      AreaManager;
      CloseFiles(FALSE);
      Halt;
    END;
{$IFDEF MSGOBJECT}
    IF ((CmdLineFlags AND clPoPEd)<>0) THEN
    BEGIN
      OpenFiles(FALSE);
      WriteHead;
      PoPEdMain;
      CloseFiles(FALSE);
      Halt;
    END;
{$ENDIF}
    IF ((CmdLineFlags AND clPoPList)<>0) THEN
    BEGIN
      OpenFiles(FALSE);
      WriteHead;
      ListMain;
      CloseFiles(FALSE);
      Halt;
    END;
    IF ((CmdLineFlags AND clCompileNL)<>0) THEN
    BEGIN
      OpenFiles(FALSE);
      WriteHead;
      CompileNodelist(True);
      CloseFiles(FALSE);
      Halt;
    END;
    IF cfg.logfilename='' THEN
    BEGIN
      WriteLn(^G,'WARNING: No logfile specified...');
      Pause(200);
    END;
    IF (CmdLineFlags AND clNoModem)=0 THEN
{$IFNDEF OS2}
      ComPort:=New(PFossilCom, Init(cfg.Modem.commport))
{$ELSE}
      ComPort:=New(POS2Com, Init(cfg.Modem.commport))
{$ENDIF}
    ELSE
      ComPort:=New(PAbsCom, Init(cfg.Modem.commport));
    IF ComPort=NIL THEN
    BEGIN
{$IFNDEF OS2}
      WriteLn('No FOSSIL loaded - Aborting');
{$ELSE}
      WriteLn('Could not open: COM'+Long2Str(Cfg.Modem.CommPort)+' - Aborting');
{$ENDIF}
      Halt(251);
    END;
{   HiddenCursor;}
    IF (Data.Event<>0) THEN
    BEGIN
      EventFile.Open(StartPath+PoPEventFileName,SizeOf(TEvent),True);
      EventFile.GetRec(CurrentEvent,Data.Event-1,NoKeep,Wait);
      EventFile.Close;
    END ELSE
      FillChar(CurrentEvent, SizeOf(TEvent), 0);
    IF ScreenHeight-12-Byte(ScreenHeight>LinesForStat)*7>=MaxActivityLines THEN
    BEGIN
      WriteLn(^G,'Portal can''t handle more than ', MaxActivityLines+19, ' screenlines');
      Halt(0);
    END;
    SetupScreen;
    OpenFiles(True);
    GetLogFile;
    AddLog('+','Begin, Portal of Power v'+Ver);
    SkipOutboundScan:=PoPKeyPressed;
    WHILE PoPKeyPressed DO PoPReadKeyWord;
    IF NOT ((ComPort^.Carrier OR ComPort^.KeyPressed) AND ((CmdLineFlags AND clCheckOnLine)<>0)) THEN InitModemForEvent;
    IF Data.KbdPassword<>'' THEN
    BEGIN
      KeyboardLock:=True;
      AddLog(' ','Keyboard locked');
    END;
{$IFNDEF OS2}
    IF (Data.MacroStatus) AND ((CmdLineFlags AND clMacroDefeat)=0) THEN MacrosOn;
    WriteMacroStatus;
{$ENDIF}
    InitialiseNodelist(Cfg.NodeList, Cfg.NodelistTyp);
    IF (CurrentEvent.Typ AND etDynamic)=0 THEN ChangeEvent(True);
    IF ((CurrentEvent.Typ AND etUsers)=0) OR (TimerExpired(OutboundReRead) AND NOT SkipOutboundScan)THEN
    BEGIN
      GetOutboundInformation;
      UpdateOutboundWindow;
    END;
    UpdateCallersList;
    IF Data.NextTime.StartTics=0 THEN NewTimerSecs(Data.NextTime, CalculateNextTime) ELSE
      IF TimerExpired(Data.NextTime) THEN NewTimerSecs(Data.NextTime, 15);
{$IFNDEF OS2}
    IF cfg.Defaultmacro<>'' THEN
    BEGIN
      o:=ReadMacroFile(Cfg.DefaultMacro, False);
      IF o<>0 THEN AddLog('!','Error reading macrofile ('+Hexb(o)+')');
    END;
{$ENDIF}
    IF NOT ComPort^.KeyPressed THEN UpdateNetMailFlag;
    StartClock;
    KillWindow(Copyright);
  END;

END.
