UNIT BBSDef;
{ͻ}
{ BBSDEF.PAS - BBS definition reader/handler    Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, PoPTypes, Dos;

CONST
  bdName         =  1;
  bdTask         =  2;
  bdFilePath     =  3;
  bdListPath     =  4;
  bdAreaTag      =  5;
TYPE
  TFieldType=(ftAsciiZ,ftByte,ftShort,ftChar,ftWord,ftInt,ftLong,ftStr);
  PFileStruct=^TFileStruct;
  TField=RECORD
    Name      : S20;
    Typ       : TFieldType;
    Len       : WORD;
    Special   : BYTE;
  END;
  TFileStruct=RECORD
    NumFields : BYTE;
    Tasks     : BOOLEAN;
    FDBPath,
    Name      : PathStr;
    Fields    : ARRAY[0..0] OF TField;
  END;

PROCEDURE DisposeFileStruct(VAR u:PFileStruct);
PROCEDURE GetFileStruct(VAR fs:PFileStruct; CONST FName:S20);
FUNCTION  FieldLen(CONST F:TField):WORD;
FUNCTION  RecLen(Fs:PFileStruct):WORD;
PROCEDURE GetField(F:PFileStruct; FieldNum:BYTE; Buf:POINTER; VAR Adr);
FUNCTION  FindField(F:PFileStruct; Fl:BYTE):BYTE;
FUNCTION  GetFieldText(f:PFileStruct; Num:BYTE; Buf:POINTER):STRING;

IMPLEMENTATION

USES OpString, OpRoot,
     StrUtil, OproUtil, Globals, Util;

FUNCTION  GetFieldText(f:PFileStruct; Num:BYTE; Buf:POINTER):STRING;
VAR
  s,ss:STRING;
  BVal:BYTE ABSOLUTE s;
  Wval:WORD ABSOLUTE s;
  LVal:LONGINT ABSOLUTE s;
BEGIN
  s:='';
  IF Num>0 THEN
  BEGIN
    GetField(f,Num,Buf,s);
    CASE f^.Fields[Num].Typ OF
      ftByte   : s:=Long2Str(BVal);
      ftShort  : s:=Long2Str(ShortInt(BVal));
      ftChar   : s:=s[0];
      ftWord   : s:=Long2Str(Wval);
      ftInt    : s:=Long2Str(Integer(WVal));
      ftLong   : s:=Long2Str(LVal);
      ftStr    : ;
      ftAsciiZ : BEGIN
                   ss:=AsciiZ2Str(s,f^.Fields[Num].Len);
                   s:=ss;
                 END;
    END;
  END;
  GetFieldText:=s;
END;

FUNCTION  FindField(F:PFileStruct; Fl:BYTE):BYTE;
VAR
  i:BYTE;
BEGIN
  FindField:=0;
  WITH F^ DO
  BEGIN
    FOR i:=1 TO NumFields DO
      IF Fl=Fields[i].Special THEN
      BEGIN
        FindField:=i;
        Break;
      END;
  END;
END;

PROCEDURE GetField(F:PFileStruct; FieldNum:BYTE; Buf:POINTER; VAR Adr);
VAR
  offset:WORD;
  i:BYTE;
BEGIN
  offset:=0;
  FOR i:=1 TO FieldNum-1 DO
    INC(OffSet,FieldLen(f^.Fields[i]));
  MOVE(BT0(Buf^)[offset],Adr,FieldLen(f^.Fields[FieldNum]));
END;

FUNCTION RecLen(Fs:PFileStruct):WORD;
VAR
  l:WORD;
  i:BYTE;
BEGIN
  l:=0;
  FOR i:=1 TO Fs^.NumFields DO
    INC(l,FieldLen(Fs^.Fields[i]));
  RecLen:=l;
END;

FUNCTION FieldLen(CONST F:TField):WORD;
BEGIN
  CASE f.Typ OF
    ftByte,ftShort,ftChar : FieldLen:=1;
    ftInt,ftWord          : FieldLen:=2;
    ftLong                : FieldLen:=4;
    ftStr                 : FieldLen:=f.Len+1;
    ftAsciiZ              : FieldLen:=f.Len;
  END;
END;

PROCEDURE DisposeFileStruct(VAR u:PFileStruct);
VAR
  i: Word;
BEGIN
  IF u<>NIL THEN
  BEGIN
    i:=SizeOf(TFileStruct)+(SizeOf(TField)*u^.NumFields);
    FreeMemCheck(u,i);
  END;
END;

PROCEDURE GetFileStruct(VAR fs:PFileStruct; CONST FName:S20);
VAR
  i:INTEGER;
  f:TBufTextFile;
  s,ss:STRING;
  Flag:BOOLEAN;
  Tmp:TFileStruct;
BEGIN
  fs:=NIL;
  IF Cfg.BBS.DefFile<>'' THEN
    IF f.Init(StartPath+Cfg.BBS.DefFile+'.PBD',SOpenRead,1024) THEN
    BEGIN
      Flag:=FALSE;
      WHILE (NOT Flag) AND (NOT f.EoF) DO
      BEGIN
        f.ReadLn(s);
        s:=Trim(s);
        ss:=NextWord(' ',s);
        IF StUpCase(ss)='#'+FName THEN
        BEGIN
          Tmp.FDBPath:='';
          Tmp.Tasks:=FALSE;
          Tmp.Name:=NextWord(' ',s);
          Str2Int(NextWord(' ',s),i);
          Tmp.NumFields:=i;
          ss:=StUpCase(NextWord(' ',s));
          WHILE ss<>'' DO
          BEGIN
            IF ss='TASK' THEN Tmp.Tasks:=TRUE ELSE
              IF COPY(ss,1,4)='FDB=' THEN Tmp.FDBPath:=COPY(ss,5,80);
            ss:=StUpCase(NextWord(' ',s));
          END;
          GetMem(fs,SizeOf(TFileStruct)+(SizeOf(TField)*Tmp.NumFields));
          fs^.Name:=Tmp.Name;
          fs^.NumFields:=0;
          fs^.Tasks:=Tmp.Tasks;
          fs^.FDBPath:=Tmp.FDBPath;
          Flag:=FALSE;
          WHILE (NOT Flag) AND (NOT f.Eof) DO
          BEGIN
            f.ReadLn(s);
            s:=Trim(s);
            IF StUpCase(s)='#END' THEN Flag:=TRUE ELSE
            BEGIN
              INC(fs^.NumFields);
              WITH fs^.Fields[fs^.NumFields] DO
              BEGIN
                Len:=0;
                Name:=NextWord(' ',s);
                s:=Trim(s);
                Replace(Name,'_',' ',0);
                ss:=StUpCase(NextWord(' ',s));

                IF ss='BYTE' THEN Typ:=ftByte ELSE
                  IF ss='CHAR' THEN Typ:=ftChar ELSE
                    IF ss='SHORT' THEN Typ:=ftShort ELSE
                      IF ss='WORD' THEN Typ:=ftWord ELSE
                        IF ss='INTEGER' THEN Typ:=ftInt ELSE
                          IF ss='LONG' THEN Typ:=ftLong ELSE
                            IF ss='ASCIIZ' THEN
                            BEGIN
                              Typ:=ftAsciiZ;
                              ss:=NextWord(' ',s);
                              Str2Int(ss,i);
                              Len:=i;
                            END
                            ELSE
                              IF ss='STRING' THEN
                              BEGIN
                                Typ:=ftStr;
                                ss:=NextWord(' ',s);
                                Str2Int(ss,i);
                                Len:=i;
                              END;
                s:=StUpCase(Trim(s));
                IF s='NAME' THEN Special:=bdName ELSE
                  IF s='TASK' THEN Special:=bdTask ELSE
                    IF s='FILEPATH' THEN Special:=bdFilePath ELSE
                      IF s='LISTPATH' THEN Special:=bdListPath ELSE
                        IF s='AREATAG' THEN Special:=bdAreaTag ELSE
                          Special:=0;
              END;
            END;
          END;
        END;
      END;
      f.Done;
    END;
END;

END.
