PROGRAM MenuRes;
{ͻ}
{ Creates menues in PORTAL.RES                  Last changed: 20.06.95  SA }
{                                                                          }
{                         (C) Copyright 1989-95 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

uses use32, oproot,opmenu,opwindow,oproutil,input,globals,opframe,opcmd,opcrt,opkey,
     opselect,opstring,opfield,opedit,opfedit,nodelist,mailcfg,resource,Useredit,
     PoPTypes;

const
  Frame1         : FrameArray = 'Ȼͺ';

var
  m: TPoPmenu;
  lib: Oplibrary;
  status : word;

PROCEDURE PutMenu(Mnr:WORD);
BEGIN
  Lib.PutEntry('MNU'+LongIntForm('@@@',Mnr),m);
  Status:=Lib.GetStatus;
  IF Status<>0 THEN WriteLn('Error ',Status,' in MNU',LongIntForm('@@@',Mnr))
               ELSE WriteLn('Writing MNU',LongIntForm('@@@',Mnr));
  IF Lib.AvailableEntries=0 THEN
  BEGIN
    WRITELN('Directory full');
    HALT;
  END;
  m.Done;
END;


{Menu item constants}
const
  miMail100       = 100;
  miImmideate2    = 2;
  miPoll3         = 3;
  miScan4         = 4;
  miGlue5         = 5;
  miUnglue6       = 6;
  miManagers101   = 101;
  miOutbound8     = 8;
  miArea9         = 9;
  miNodelist10    = 10;
  miDumbTerm11    = 11;
  miUser12        = 12;
  miMessage13     = 13;
  miInformatio102 = 102;
  miAbout16       = 16;
  miWho17         = 17;
  miOutbound18    = 18;
  miMultiline19   = 19;
  miSystem0       = 0;
  miAction103     = 103;
  miCompile21     = 21;
  miFile22        = 22;
  miGenerate23    = 23;
  miMisc104       = 104;
  miBlank25       = 25;
  miLock26        = 26;
  miShow27        = 27;
  miUtils105      = 105;
  miText14        = 14;
  miCalculator78  = 78;
  miCalendar79    = 79;
  miQuick80       = 80;
  miConfig106     = 106;
  miMatrix1       = 1;
  miModem2        = 2;
  miDirectorie3   = 3;
  miEvent6        = 6;
  miConnection25  = 25;
  miMail7         = 7;
  miNetmail15     = 15;
  miEcho16        = 16;
  miRemapper17    = 17;
  miSchedules18   = 18;
  miConference19  = 19;
  miMiscOption20  = 20;
{  miNodelist10    = 10;}
  miNodelist34    = 34;
  miPhone29       = 29;
  miMiscOption10  = 10;
  miFile5         = 5;
  miOKFile30      = 30;
  miMiscOption31  = 31;
  miNodes4        = 4;
  miFile8         = 8;
  miFiles21       = 21;
  miMiscForwar22  = 22;
  miTick32        = 32;
  miMiscTick33    = 33;
  miFunction11    = 11;
  miArea26        = 26;
  miTerminal9     = 9;
  miExternal24    = 24;
  miMiscOption23  = 23;
  miPoPList35     = 35;
  miDirectorie35  = 35;
  miMiscOption36  = 36;
  miMultiple27    = 27;
  miArchiver28    = 28;
  miScreen5       = 5;
  miColor13       = 13;
  miMiscOption14  = 14;
  miGlobal12      = 12;
  miMacros107     = 107;
  miRecord70      = 70;
  miEdit71        = 71;
  miList72        = 72;
  miActive73      = 73;
  miDelete74      = 74;
  miOne81         = 81;
  miAll82         = 82;
  miLoad75        = 75;
  miSave76        = 76;
  miQuit108       = 108;
  miExit83        = 83;
  miShell84       = 84;
  miEditCostFile37 = 37;
  miEditTemplate38 = 38;
  miMultiListSetup39 = 39;

function ConfigMenu: Word;
  {-Initialize menu system generated by MAKEMENU}
const
  {Frame constants}
  Frame1 : FrameArray = 'Ըͳ';
begin
  with M do begin
    if not InitCustom(1, 1, 80, 1, Cfg.color[1],
                      wClear+wUserContents+wCoversOnDemand,
                      Horizontal) then begin
      ConfigMenu := InitStatus;
      Exit;
    end;
    mnOptionsOn(mnAlphaMatch+mnSelectOnMatch+mnArrowSelect+{mnPopOnSelect+}
                mnAllowPending{+mnAltMatch});
    mnOptionsOff(mnAllowPending+mnUseItemForTopic+mnSelectOnClick);
    AddItem('  ', 2, 1, 213);
    AddItem(' Mail ', 5, 2, miMail100);
      AddFramedSubMenu(6, 3, 29, 7, Vertical, Frame1);
      AddShadow(shBR, shSeeThru);
      AddItem('Immediate call   Alt+C', 1, 1, AltC);
      AddItem('Poll             Alt+P', 2, 1, AltP);
      AddItem('Scan matrix      Alt+Y', 3, 1, AltY);
      AddItem('Glue node        -', 4, 1, Minus);
      AddItem('Unglue node      +', 5, 1, Plus);
      ItemsDone;
    AddItem(' Manager ',11, 4, miManagers101);
      AddFramedSubMenu(12, 3, 35, 9, Vertical, Frame1);
      AddShadow(shBR, shSeeThru);
      AddSeparator('', '', '', 4);
      AddItem('Outbound         Alt+O', 1, 1, AltO);
      AddItem('Area             Alt+A', 2, 1, AltA);
      AddItem('Nodelist         Alt+N', 3, 1, AltN);
      AddItem('DumbTerm         Alt+D', 5, 1, AltD);
      AddItem('User browser     Alt+U', 6, 1, AltU);
      AddItem('Message editor   Alt+E', 7, 1, AltE);
      ItemsDone;
    AddItem(' Info ', 20, 2, miInformatio102);
      AddFramedSubMenu(21, 3, 46, 7, Vertical, Frame1);
      AddShadow(shBR, shSeeThru);
      AddItem('About today        F9', 1, 1, F9);
      AddItem('Who is node        Alt+W', 2, 1, AltW);
      AddItem('Outbound info      Alt+I', 3, 1, AltI);
      AddItem('Multiline status   Alt+S', 4, 1, AltS);
      AddItem('System info        Alt+G', 5, 1, AltG);
      ItemsDone;
    AddItem(' Action ', 26, 2, miAction103);
      AddFramedSubMenu(27, 3, 53, 13, Vertical, Frame1);
      AddShadow(shBR, shSeeThru);
      AddSeparator('', '', '', 5);
      AddSeparator('', '', '', 8);
      AddItem('Run mailscanner     Alt+M', 1, 5, AltM);
      AddItem('Compile nodelist    Alt+V', 2, 1, AltV);
      AddItem('File forward        Alt+Z', 3, 1, AltZ);
      AddItem('Generate filelist   Alt+Q', 4, 1, AltQ);
      AddItem('Rescan outbound', 6, 1, 200);
      AddItem('Pack Msg.base',7,1,216);
      AddItem('Init modem', 9, 1, 210);
      AddItem('Answer modem', 10, 1, 211);
      AddItem('Send busy string', 11, 6, 212);
      ItemsDone;
    AddItem(' Misc ', 34, 4, miMisc104);
      AddFramedSubMenu(35, 3, 62, 7, Vertical, Frame1);
      AddShadow(shBR, shSeeThru);
      AddItem('Blank screen         Alt+B', 1, 1, AltB);
      AddItem('Lock keyboard        Alt+L', 2, 1, AltL);
      AddItem('Show function keys   Alt+F', 3, 1, AltF);
      AddItem('Export setup', 4, 1, 214);
      AddItem('Import setup', 5, 1, 215);
      ItemsDone;
    AddItem(' Util ', 40, 2, miUtils105);
      AddFramedSubMenu(41, 3, 61, 6, Vertical, Frame1);
      AddShadow(shBR, shSeeThru);
      AddItem('Text editor   Alt+T', 1, 1, AltT);
      AddItem('Calendar      Alt+1', 2, 1, Alt1);
      AddItem('Calculator    Alt+2', 3, 2, Alt2);
      AddItem('Quick ref.    Alt+3', 4, 1, Alt3);
      ItemsDone;
    AddItem(' Config ', 46, 2, miConfig106);
      AddFramedSubMenu(47, 3, 69, 22, Vertical, Frame1);
      AddShadow(shBR, shSeeThru);
      AddItem('Matrix options', 1, 6, miMatrix1);
      AddItem('Modem setup         '^P, 2, 2, miModem2);
        AddFramedSubMenu(49, 6, 66, 8, Vertical, Frame1);
        AddShadow(shBR, shSeeThru);
        AddItem('Standard options', 1, 1, 2);
        AddItem('Advanced options', 2, 1, 5);
        AddItem('Connect stat.   ', 3, 1, 7);
        ItemsDone;
      AddItem('Directories & files', 3, 1, miDirectorie3);
      AddItem('Event manager', 4, 1, miEvent6);
      AddItem('Connection setup', 5, 1, miConnection25);
      AddItem('Mail scanner        '^P, 6, 1, miMail7);
        AddFramedSubMenu(49, 10, 63, 14, Vertical, Frame1);
        AddShadow(shBR, shSeeThru);
        AddItem('Netmail', 1, 1, miNetmail15);
        AddItem('Echo mail', 2, 1, miEcho16);
{        AddItem('Remapper', 3, 1, miRemapper17);}
        AddItem('Schedules', 3, 1, miSchedules18);
        AddItem('Conferences', 4, 1, miConference19);
        AddItem('Misc. options', 5, 1, miMiscOption20);
        ItemsDone;
      AddItem('Nodelist compiler   '^P, 7, 5, miNodelist10);
        AddFramedSubMenu(49, 11, 68, 14, Vertical, Frame1);
        AddShadow(shBR, shSeeThru);
        AddItem('Nodelist segments', 1, 1, miNodelist34);
        AddItem('Phone translations', 2, 1, miPhone29);
        AddItem('Misc. options', 3, 1, miMiscOption10);
        AddItem('Edit cost file', 4, 1, miEditCostFile37);
        ItemsDone;
      AddItem('File request        '^P, 8, 8, miFile5);
        AddFramedSubMenu(49, 12, 63, 13, Vertical, Frame1);
        AddShadow(shBR, shSeeThru);
        AddItem('OK-File', 1, 1, miOKFile30);
        AddItem('Misc. options', 2, 1, miMiscOption31);
        ItemsDone;
      AddItem('Nodes setup', 9, 1, miNodes4);
      AddItem('File forward        '^P, 10, 1, miFile8);
        AddFramedSubMenu(49, 14, 71, 17, Vertical, Frame1);
        AddShadow(shBR, shSeeThru);
        AddItem('Files to forward', 1, 1, miFiles21);
        AddItem('Misc. forward options', 2, 1, miMiscForwar22);
        AddItem('Tick areas', 3, 1, miTick32);
        AddItem('Misc. tick options', 4, 12, miMiscTick33);
        ItemsDone;
      AddItem('Function keys', 11, 2, miFunction11);
      AddItem('Area manager', 12, 2, miArea26);
      AddItem('Terminal setup      '^P, 13, 1, miTerminal9);
        AddFramedSubMenu(49, 17, 68, 18, Vertical, Frame1);
        AddShadow(shBR, shSeeThru);
        AddItem('External protocols', 1, 1, miExternal24);
        AddItem('Misc. options', 2, 1, miMiscOption23);
        ItemsDone;
      AddItem('PoP-List setup      '^P, 14, 6, miPoPList35);
        AddFramedSubMenu(49, 18, 69, 20, Vertical, Frame1);
        AddShadow(shBR, shSeeThru);
        AddItem('Directories & files', 1, 1, miDirectorie35);
        AddItem('Misc. options', 2, 1, miMiscOption36);
        AddItem('Multi List Segments', 3, 7, miMultiListSetup39);
        ItemsDone;
      AddItem('Multiple BBS setup', 15, 6, miMultiple27);
      AddItem('Archiver setup', 16, 4, miArchiver28);
      AddItem('Screen & colors     '^P, 17, 1, miScreen5);
        AddFramedSubMenu(49, 21, 67, 24, Vertical, Frame1);
        AddShadow(shBR, shSeeThru);
        AddItem('Color setup', 1, 1, miColor13);
        AddItem('Load color scheme', 2, 1, 8);
        AddItem('Save color scheme', 3, 1, 9);
        AddItem('Misc. options', 4, 1, miMiscOption14);
        ItemsDone;
      AddItem('Inbound control', 18, 3, 17);
      AddItem('Global values', 19, 1, miGlobal12);
      AddItem('Edit template', 20, 11, miEditTemplate38);
      ItemsDone;
    AddItem(' Macro ', 54, 6, miMacros107);
      AddFramedSubMenu(55, 3, 68, 9, Vertical, Frame1);
      AddShadow(shBR, shSeeThru);
      AddItem('Record', 1, 1, 90);
      AddItem('Edit', 2, 1, 91);
      AddItem('List', 3, 2, 92);
      AddItem('Active   Yes', 4, 1, 93);
      AddItem('Delete     '^P, 5, 1, 94);
        AddFramedSubMenu(57, 9, 61, 10, Vertical, Frame1);
        AddShadow(shBR, shSeeThru);
        AddItem('One', 1, 1, 94);
        AddItem('All', 2, 1, 95);
        ItemsDone;
      AddItem('Load', 6, 1, 96);
      AddItem('Save', 7, 1, 97);
      ItemsDone;
    AddItem(' Quit ', 61, 2, miQuit108);
      AddFramedSubMenu(62, 3, 76, 4, Vertical, Frame1);
      AddShadow(shBR, shSeeThru);
      AddItem('Exit    Alt+X', 1, 1, AltX);
      AddItem('Shell   Alt+J', 2, 1, AltJ);
      ItemsDone;
    ItemsDone;

    ConfigMenu := RawError;
  end;
end;


PROCEDURE EventFlagsMenu;
BEGIN
  WITH m DO
  BEGIN
    InitCustom(29,7,52,21,Cfg.Color[3],wBordered+wClear+wUserContents+wCoversOnDemand,Vertical);
    m.WFrame.AddHeader(' Event flags ',heTC);
    AddShadow(shBR, shSeeThru);
    AddItem('Forced         :',1,1,1);
    AddItem('Request Ok.    :',2,1,2);
    AddItem('User / Mail    :',3,1,3);
    AddItem('Receive only   :',4,5,4);
    AddItem('CM-only        :',5,1,5);
    AddItem('No-send        :',6,1,6);
    AddItem('Dynamic        :',7,1,7);
    AddItem('Clear Outbound :',8,7,8);
    AddItem('No answer      :',9,4,9);
    AddItem('Once only      :',10,8,10);
    AddItem('PoP-List       :',11,1,11);
    AddItem('Toss mail      :',12,1,12);
    AddItem('Scan new mail  :',13,1,13);
    AddItem('Pack mail      :',14,4,14);
    AddItem('Don''t send fls :',15,8,15);
    ItemsDone;
  END;
END;

PROCEDURE DialDirMenu;
BEGIN
  WITH m DO
  BEGIN
    InitCustom(2,23,79,23,Cfg.Color[3],wBordered+wClear+wUserContents+wCoversOnDemand,Horizontal);
    MenuCommands.AddCommand(ccUser1,1,Word(256 * 73),0);
    MenuCommands.AddCommand(ccUser2,1,Word(256 * 81),0);
    AddItem('Dial',2,1,1);
    AddItem('Edit',11,1,2);
    AddItem('Find',19,1,3);
    AddItem('Add',27,1,4);
    AddItem('Remove',34,1,5);
    AddItem('Print',45,1,6);
    AddItem('Sort',53,1,7);
    AddItem('List',60,1,8);
    ItemsDone;
  END;
END;

PROCEDURE AInsertMenu;
BEGIN
  WITH m DO
  BEGIN
    m.init(29,8,49,9,3,'Insert line');
    AddItem('Before this line',1,1,1);
    AddItem('After this line',2,1,2);
    ItemsDone;
  END;
END;

PROCEDURE AMoveMenu;
BEGIN
  WITH m DO
  BEGIN
    m.init(30,8,51,12,3,'Move File');
    AddItem('Other Area (Move)',1,1,1);
    AddItem('To Disk (Move)',2,1,2);
    AddItem('Other Area (Copy)',3,7,3);
    AddItem('To Disk (Copy)',4,4,4);
    AddItem('Same Area',5,1,5);
    ItemsDone;
  END;
END;

PROCEDURE AGlobalCmdMenu;
BEGIN
  WITH m DO
  BEGIN
    m.init(10,8,40,13,3,'Global functions');
    AddItem('Adopt orphan files',1,1,1);
    AddItem('Touch files',2,1,2);
    AddItem('Delete download counters',3,1,3);
    AddItem('Reset download counters',4,1,4);
    AddItem('Insert download counters',5,1,5);
    AddItem('Reallign download counters',6,2,6);
    ItemsDone;
  END;
END;

procedure ACopyErrorMenu;
begin
  WITH m DO
  BEGIN
    m.init(25,8,57,10,3,'');
    AddItem('Retry current file',1,1,1);
    AddItem('Abort operation',2,1,2);
    AddItem('Skip this file',3,1,3);
    ItemsDone;
  END;
end;

PROCEDURE SelectMailType;
BEGIN
  WITH m DO
  BEGIN
    m.init(32,9,45,13,3,'Send as');
    AddItem('Hold', 1, 1, 1);
    AddItem('Direct', 2, 1, 2);
    AddItem('Normal', 3, 1, 3);
    AddItem('Crash', 4, 1, 4);
    AddItem('Important', 5, 1, 5);
    ItemsDone;
  END;
END;

PROCEDURE GlobalCmdMenu;
BEGIN
  m.init(32,9,53,10,3,'Global Commands');
  WITH m DO
  BEGIN
    AddItem('Clean Outbound', 1, 7, 1);
    AddItem('Clear Undialables', 2, 7, 2);
    ItemsDone;
  END;
END;

PROCEDURE GetUpdateType;
BEGIN
  WITH m DO
  BEGIN
    m.init(32,9,51,10,3,'Request type');
    AddItem('Update Request ', 1, 1, 1);
    AddItem('Olddate Request', 2, 1, 2);
    ItemsDone;
  END;
END;

PROCEDURE SelectSendType;
BEGIN
  WITH m DO
  BEGIN
    m.init(32,9,44,11,3,'Do after');
    AddItem('Nothing ', 1, 1, 1);
    AddItem('Delete  ', 2, 1, 2);
    AddItem('Truncate', 3, 1, 3);
    ItemsDone;
  END;
END;

PROCEDURE TermEmulMenu;
BEGIN
  WITH m DO
  BEGIN
    m.init(2,3,14,5,3,'Emulation');
    AddItem('AUTOMODE',1,2,1);
    AddItem('ANSI-BBS',2,1,2);
    AddItem('AVATAR',3,2,3);
    ItemsDone;
  END;
END;

PROCEDURE MacroMenu;
BEGIN
  WITH m DO
  BEGIN
    m.init(35,11,45,17,2,'Macros');
    AddItem('Record', 1, 1, 1);
    AddItem('Edit', 2, 1, 2);
    AddItem('List', 3, 1, 3);
    AddItem('Toggle', 4, 1, 4);
    AddFramedSubMenu(38, 13, 43, 14, Vertical, Frame1);
    WFrame.AddShadow(shBR,shSeeThru);
    AddItem('On', 1, 1, 8);
    AddItem('Off', 2, 1, 9);
    ItemsDone;
    AddItem('Delete', 5, 1, 5);
    AddFramedSubMenu(38, 14, 45, 15, Vertical, Frame1);
    WFrame.AddShadow(shBR,shSeeThru);
    AddItem('One', 1, 1, 10);
    AddItem('All', 2, 1, 11);
    ItemsDone;
    AddItem('Load', 6, 1, 6);
    AddItem('Save', 7, 1, 7);
    ItemsDone;
  END;
END;

PROCEDURE InitNlMenu;
BEGIN
  WITH m DO
  BEGIN
    m.init(29,7,49,8,3,'Insert node');
    AddItem('Before this node',1,1,1);
    AddItem('After this node',2,1,2);
    ItemsDone;
  END;
END;

PROCEDURE InitUEMaxFlagsMenu;
BEGIN
  WITH m DO
  BEGIN
    InitCustom(29,8,52,19,Cfg.Color[3],wBordered+wClear+wUserContents+wCoversOnDemand,Vertical);
    m.WFrame.AddHeader(' Maximus flags ',heTC);
    AddShadow(shBR, shSeeThru);
    AddItem('FS Editor      :',1,4,1);
    AddItem('FS Reader      :',2,4,2);
    AddItem('HotKeys        :',3,1,3);
    AddItem('IBM Chars      :',4,1,4);
    AddItem('More Prompt    :',5,1,5);
    AddItem('Use Tabs       :',6,5,6);
    AddItem('User List      :',7,6,7);
    AddItem('Chat Avail     :',8,1,8);
    AddItem('Used Max       :',9,8,9);
    AddItem('Bad Logon      :',10,1,10);
    AddItem('Clear Screen   :',11,4,11);
    AddItem('Nerd User      :',12,4,12);
    ItemsDone;
  END;
END;

PROCEDURE InitUEQBBSFlagsMenu;
BEGIN
  WITH m DO
  BEGIN
    InitCustom(24,9,50,15,Cfg.Color[4],wClear+wUserContents+wCoversOnDemand,Vertical);
    AddItem('DELETED                  :',1,1,1);
    AddItem('Send ScreenClear Codes   :',2,1,2);
    AddItem('Use MORE-Prompt          :',3,5,3);
    AddItem('Use ANSI-Emulation       :',4,5,4);
    AddItem('No-Kill                  :',5,1,5);
    AddItem('Ignore Download Hours    :',6,1,6);
    AddItem('Ansi FullScreen Editor   :',7,6,7);
    ItemsDone;
  END;
END;

PROCEDURE InitUEOPUS110FlagsMenu;
BEGIN
  WITH m DO
  BEGIN
    InitCustom(24,8,50,16,Cfg.Color[4],wClear+wUserContents+wCoversOnDemand,Vertical);
    AddItem('Use IBM Chars            :',1,5,1);
    AddItem('Use OPED (FullScrnEd.)   :',2,5,2);
    AddItem('Use MORE-prompt          :',3,5,3);
    AddItem('Use ANSI/AVATAR/ASCII    :',4,5,4);
    AddItem('Ask CONFIGURATION        :',5,2,5);
    AddItem('Send FormFeed-chars      :',6,6,6);
    AddItem('Show NAME in userlist    :',7,6,7);
    AddItem('Show TIME in userlist    :',8,6,8);
    AddItem('Show CITY in userlist    :',9,6,9);
    ItemsDone;
  END;
END;

PROCEDURE InitNlSearchOptMenu;
BEGIN
  WITH m DO
  BEGIN
    m.init(30,10,45,13,3,'Search by');
    AddItem('Address',1,1,1);
    AddItem('System Name',2,1,2);
    AddItem('Misc. Info',3,1,3);
    AddItem('SysOp Name',4,7,4);
    ItemsDone;
  END;
END;

BEGIN
  cfg.color[1]:=defaultcolorset;
  cfg.color[2]:=defaultcolorset;
  cfg.color[3]:=defaultcolorset;
  cfg.color[4]:=defaultcolorset;
  if not Lib.Init(PoPResourceFileName,SOpen,10240,'POP-RES') then
    Lib.Create(PoPResourceFileName,10240,'POP-RES',2048);
  Lib.RegisterHier(TPoPMenuStream);

  Lib.DeleteEntry('MNU012');
  Status:=Lib.GetStatus;

  ConfigMenu;             PutMenu(MNUMain);
  EventFlagsMenu;         PutMenu(MNUEventFlags);
  DialDirMenu;            PutMenu(MNUDTDialDir);
  AInsertMenu;            PutMenu(MNUAMInsertLine);
  AMoveMenu;              PutMenu(MNUAMMoveFile);
  AGlobalCmdMenu;         PutMenu(MNUAMGlobalFunc);
  ACopyErrorMenu;         PutMenu(MNUCopyFileError);
  SelectMailType;         PutMenu(MNUOMSelMailType);
  GlobalCmdMenu;          PutMenu(MNUOMGlobalCmd);
  GetUpdateType;          PutMenu(MNUOMGetUpdType);
  SelectSendType;         PutMenu(MNUOMSelSendAs);
  TermEmulMenu;           PutMenu(MNUDTEmulation);
{ MacroMenu;              PutMenu(MNUMacros);}
  InitNlMenu;             PutMenu(MNUNLInsNode);
  InitUEQBBSFlagsMenu;    PutMenu(MNUUEQBbsFlags);
  InitUEMaxFlagsMenu;     PutMenu(MNUUEMaxFlags);
  InitUEOPUS110FlagsMenu; PutMenu(MNUUEOPUS110Flags);
  InitNlSearchOptMenu;    PutMenu(MNUNlSearchOpt);

  WriteLn(Lib.GetStatus);
  Lib.Pack;
  Lib.Done;
end.
