UNIT PoPTypes;
{ͻ}
{ Global types & constants                      Last changed: 20.02.94  SA }
{                                                                          }
{                         (C) Copyright 1989-94 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}

{$IFNDEF NoOPro}
  {$I OPDEFINE.INC}

  {$IFNDEF FourByteDates}
    Portal requires FourByteDates to be defined!
  {$ENDIF}
{$ENDIF}

INTERFACE

{$IFDEF NoOPro}
USES Dos;

CONST
  MaxSearchLen     = 30;
  MaxSearchOptions =  5;

TYPE
  DayType   = (Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday);
  Date      = LongInt;       { Days since ??          }
  Time      = LongInt;       { Seconds since midnight }
  DateTimeRec = RECORD
    D : Date;
    T : Time;
  END;
  ColorSet  = ARRAY[1..62] OF Byte;
  MarkerRec = RECORD
    Line, Col : Integer;
  END;
  EventTimer = record
    StartTics : LongInt;
    ExpireTics : LongInt;
  end;
{$ELSE}
USES Dos, OpCrt, OpDate, OpEditor, ApTimer;
{$ENDIF}

TYPE
  { All String types, very handy! }
  S1=STRING[1]; S2=STRING[2]; S3=STRING[3]; S4=STRING[4]; S5=STRING[5];
  S6=STRING[6]; S7=STRING[7]; S8=STRING[8]; S9=STRING[9]; S10=STRING[10];
  S11 =STRING[11]; S12=STRING[12]; S13=STRING[13]; S14=STRING[14]; S15=STRING[15];
  S16 =STRING[16]; S17=STRING[17]; S18=STRING[18]; S19=STRING[19]; S20=STRING[20];
  S21 =STRING[21]; S22=STRING[22]; S23=STRING[23]; S24=STRING[24]; S25=STRING[25];
  S26 =STRING[26]; S27=STRING[27]; S28=STRING[28]; S29=STRING[29]; S30=STRING[30];
  S31 =STRING[31]; S32=STRING[32]; S33=STRING[33]; S34=STRING[34]; S35=STRING[35];
  S36 =STRING[36]; S37=STRING[37]; S38=STRING[38]; S39=STRING[39]; S40=STRING[40];
  S41 =STRING[41]; S42=STRING[42]; S43=STRING[43]; S44=STRING[44]; S45=STRING[45];
  S46 =STRING[46]; S47=STRING[47]; S48=STRING[48]; S49=STRING[49]; S50=STRING[50];
  S51 =STRING[51]; S52=STRING[52]; S53=STRING[53]; S54=STRING[54]; S55=STRING[55];
  S56 =STRING[56]; S57=STRING[57]; S58=STRING[58]; S59=STRING[59]; S60=STRING[60];
  S61 =STRING[61]; S62=STRING[62]; S63=STRING[63]; S64=STRING[64]; S65=STRING[65];
  S66 =STRING[66]; S67=STRING[67]; S68=STRING[68]; S69=STRING[69]; S70=STRING[70];
  S71 =STRING[71]; S72=STRING[72]; S73=STRING[73]; S74=STRING[74]; S75=STRING[75];
  S76 =STRING[76]; S77=STRING[77]; S78=STRING[78]; S79=STRING[79]; S80=STRING[80];
  S81 =STRING[81]; S82=STRING[82]; S83=STRING[83]; S84=STRING[84]; S85=STRING[85];
  S86 =STRING[86]; S87=STRING[87]; S88=STRING[88]; S89=STRING[89]; S90=STRING[90];
  S91 =STRING[91]; S92=STRING[92]; S93=STRING[93]; S94=STRING[94]; S95=STRING[95];
  S96 =STRING[96]; S97=STRING[97]; S98=STRING[98]; S99=STRING[99]; S100=STRING[100];
  S101=STRING[101]; S102=STRING[102]; S103=STRING[103]; S104=STRING[104]; S105=STRING[105];
  S106=STRING[106]; S107=STRING[107]; S108=STRING[108]; S109=STRING[109]; S110=STRING[110];
  S111=STRING[111]; S112=STRING[112]; S113=STRING[113]; S114=STRING[114]; S115=STRING[115];
  S116=STRING[116]; S117=STRING[117]; S118=STRING[118]; S119=STRING[119]; S120=STRING[120];
  S121=STRING[121]; S122=STRING[122]; S123=STRING[123]; S124=STRING[124]; S125=STRING[125];
  S126=STRING[126]; S127=STRING[127]; S128=STRING[128]; S129=STRING[129]; S130=STRING[130];
  S131=STRING[131]; S132=STRING[132]; S133=STRING[133]; S134=STRING[134]; S135=STRING[135];
  S136=STRING[136]; S137=STRING[137]; S138=STRING[138]; S139=STRING[139]; S140=STRING[140];
  S141=STRING[141]; S142=STRING[142]; S143=STRING[143]; S144=STRING[144]; S145=STRING[145];
  S146=STRING[146]; S147=STRING[147]; S148=STRING[148]; S149=STRING[149]; S150=STRING[150];
  S151=STRING[151]; S152=STRING[152]; S153=STRING[153]; S154=STRING[154]; S155=STRING[155];
  S156=STRING[156]; S157=STRING[157]; S158=STRING[158]; S159=STRING[159]; S160=STRING[160];
  S161=STRING[161]; S162=STRING[162]; S163=STRING[163]; S164=STRING[164]; S165=STRING[165];
  S166=STRING[166]; S167=STRING[167]; S168=STRING[168]; S169=STRING[169]; S170=STRING[170];
  S171=STRING[171]; S172=STRING[172]; S173=STRING[173]; S174=STRING[174]; S175=STRING[175];
  S176=STRING[176]; S177=STRING[177]; S178=STRING[178]; S179=STRING[179]; S180=STRING[180];
  S181=STRING[181]; S182=STRING[182]; S183=STRING[183]; S184=STRING[184]; S185=STRING[185];
  S186=STRING[186]; S187=STRING[187]; S188=STRING[188]; S189=STRING[189]; S190=STRING[190];
  S191=STRING[191]; S192=STRING[192]; S193=STRING[193]; S194=STRING[194]; S195=STRING[195];
  S196=STRING[196]; S197=STRING[197]; S198=STRING[198]; S199=STRING[199]; S200=STRING[200];
  S201=STRING[201]; S202=STRING[202]; S203=STRING[203]; S204=STRING[204]; S205=STRING[205];
  S206=STRING[206]; S207=STRING[207]; S208=STRING[208]; S209=STRING[209]; S210=STRING[210];
  S211=STRING[211]; S212=STRING[212]; S213=STRING[213]; S214=STRING[214]; S215=STRING[215];
  S216=STRING[216]; S217=STRING[217]; S218=STRING[218]; S219=STRING[219]; S220=STRING[220];
  S221=STRING[221]; S222=STRING[222]; S223=STRING[223]; S224=STRING[224]; S225=STRING[225];
  S226=STRING[226]; S227=STRING[227]; S228=STRING[228]; S229=STRING[229]; S230=STRING[230];
  S231=STRING[231]; S232=STRING[232]; S233=STRING[233]; S234=STRING[234]; S235=STRING[235];
  S236=STRING[236]; S237=STRING[237]; S238=STRING[238]; S239=STRING[239]; S240=STRING[240];
  S241=STRING[241]; S242=STRING[242]; S243=STRING[243]; S244=STRING[244]; S245=STRING[245];
  S246=STRING[246]; S247=STRING[247]; S248=STRING[248]; S249=STRING[249]; S250=STRING[250];
  S251=STRING[251]; S252=STRING[252]; S253=STRING[253]; S254=STRING[254]; S255=STRING[255];

  { Various types for type casting buffers etc. }
  BT = ARRAY[1..65521] of Byte;
  CT = ARRAY[1..65521] of Char;
  BT0= ARRAY[0..65520] of Byte;
  CT0= ARRAY[0..65520] of Char;

CONST
  Ver = '0.62'

  { Add ,  or  to version }
{$IFNDEF Public}
  {$IFDEF Gamma}
    +''
  {$ELSE}
    {$IFDEF Beta}
    +''
    {$ELSE}
    +''
    {$ENDIF}
    +'9'           { Alpha/Beta release nr.}
  {$ENDIF}
{$ENDIF}

{$IFDEF PoPLite}
  +'/Lite'
{$ENDIF}

  { Add compilation type to version }
{$IFDEF StonyBrook}
  +'/SB'
{$ELSE}
  {$IFDEF DPMI}
  +'/DPMI'
  {$ELSE}
    {$IFDEF OS2}
    +'/OS2'
    {$ELSE}
      {$IFOPT G+}
      +'/286'
      {$ENDIF}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}
  ;

  MaxBaudStat      =  20;                 { Max. baudrates for PORTAL.STA    }
  MaxAddresses     =  16;
  CfgVersion       =   4;                 { Current version of the .CFG file }
  PoPProductCode   = $69;

  LinesForStat     =  32;
  MaxActivityLines =  80;

  { EMSI STRING constants }
  EMSIINQStr     = '**EMSI_INQC816';
  EMSIREQStr     = '**EMSI_REQA77E';
  EMSIACKStr     = '**EMSI_ACKA490';
  EMSINAKStr     = '**EMSI_NAKEEC3';

  On             = True;
  Off            = False;
  High           = True;
  Low            = False;

  { FileMode constants }
  ShareRead      = $00;
  ShareWrite     = $01;
  ShareRW        = $02;
  ShareDenyRW    = $10;
  ShareDenyW     = $20;
  ShareDenyR     = $30;
  ShareDenyNone  = $40;
  ShareExclusiv  = $80;

  clAreaMan      =   1;
  clJump2Event   =   2;
  clMacroDefeat  =   4;
  clNoModem      =   8;
  clCheckOnLine  =  16;
  clCompileNl    =  32;
  clMailScan     =  64;
  clMailPack     = 128;
  clMailToss     = 256;

  { For own objects in streams }
  otTPoPEntryScreen = 1200;
  otTPoPMenu        = 1201;

  veTPoPEntryScreen =    0;
  veTPoPMenu        =    0;

{----------------------------------------------------------------------------}
{ ASCII Values                                                               }
{----------------------------------------------------------------------------}
  Soh    = 01;
  Stx    = 02;
  Etx    = 03;
  Eot    = 04;
  Enq    = 05;
  Ack    = 06;
  Bs     = 08;
  Lf     = 10;
  Cr     = 13;
  Nak    = 21;
  Syn    = 22;
  Etb    = 23;
  Can    = 24;
  Sub    = 26;
  Escape = 27;
  TSync  = $ae;
  YooHoo = $f1;

{=== File names ============================================================}
  PoPMsgAreaFileName      = 'PORTAL.ARE';
  PoPBimodemCfgFileName   = 'PORTAL.BMC';
  PoPBadWaZooFileName     = 'PORTAL.BWZ';
  PoPDataFileName         = 'PORTAL.DAT';
  PoPDailyReqInfoFileName = 'PORTAL.DRI';
  PoPMsgDupeFileName      = 'PORTAL.EDS';
  PoPEventFileName        = 'PORTAL.EVT';
  PoPCfgExportFileName    = 'PORTAL.EXP';
  PoPFileFwdFileName      = 'PORTAL.FWD';
  PoPGenericAreaFile      = 'PORTAL.GAF';
  PoPHelpFileName         = 'PORTAL.HLP';
  PoPInterComFileName     = 'PORTAL.ICF';
  PoPBiModemInterComLog   = 'PORTAL.ICL';
  PoPDumbTermImageName    = 'PORTAL.IMG';
  PoPLogFileName          = 'PORTAL.LOG';
  PoPNetFileName          = 'PORTAL.NET';
  PoPNodelistIdxBuffer    = 'PORTAL.NIB';
  PoPNLSegmentFileName    = 'PORTAL.NLS';
  PoPNLTranslateFileName  = 'PORTAL.NLT';
  PoPNodesFileName        = 'PORTAL.NOD';
  PoPOkFileName           = 'PORTAL.OKF';
  PoPResourceFileName     = 'PORTAL.RES';
  PoPScheduleFileName     = 'PORTAL.SCD';
  PoPStatisticsFileName   = 'PORTAL.STA';
  PoPSwapFileName         = 'PORTAL.SWP';
  PoPDumbTermDialDirName  = 'PORTAL.TDD';
  PoPTextEditorPickFile   = 'PORTAL.TEP';
  PoPTickFileName         = 'PORTAL.TIC';
  PoPReceivedFiles        = 'PORTAL.TIT';
  PoPTemplateFileName     = 'PORTAL.TPL';
  PoPDumbTermLogFileName  = 'PORTAL.TRM';
  PoPUndialFileName       = 'PORTAL.UDF';

  PoPCfgFileName    : S12 = 'PORTAL.CFG';

TYPE
  { FidoNet Packet Header }
  TPktHeader = RECORD
    OrigNode,
    DestNode      : Integer;
    Year,
    Month,
    Day,
    Hour,
    Min,
    Sec,
    Baud          : Word;
    Filler1,                               { Always = 2 }
    OrigNet,
    DestNet       : Integer;
    Product,
    SerialNo      : Byte;
    Password      : ARRAY[1..8] OF Char;
    OrigZone,
    DestZone,
    AuxNet        : Integer;
    CWValLow,
    CWValHigh     : Byte;
    Product2,
    SerialNo2     : Byte;
    Capabil       : Word;
    OrigZone2,
    DestZone2     : Integer;
    OrigPoint,
    DestPoint     : Integer;
    Data          : ARRAY[1..4] OF Byte;
  END;

  { FidoNet Message Header Type }
  TPktMsgHeader = RECORD
    StartMsg,                              { $0200 }
    OrigNode,
    DestNode,
    OrigNet,
    DestNet,
    Attr,
    Cost       : Integer;
    Time       : ARRAY[1..20] OF Char;
  END;

  { Nodelist Types supported }
  NodeListType   = (NewNodelistType,
                    QBBSNodelistType,
                    RANodelistType,
                    Version7,
                    SBBSNodeListType);

  CostType = RECORD                     { Nodelist Cost Table record }
    Prefix : S10;
    Cost   : Word;
  END;
  CostTab = ARRAY[1..1000] OF CostType;

  { A 4D FidoNet address }
  TFidoAddress = RECORD
     Zone,
     Net,
     Node,
     Point : Integer;
   END;

  SendToTabType = ARRAY[1..50] OF TFidoAddress;

{Ŀ}
{ YooHoo Stuff - See FTSC-06 for more info.                                }
{}
  TYooHooCap = (YDietIfna,    { Can do SeaLink                            }
                FtbUser,      { Full Tilt Boogie??                        }
                ZedZipper,    { Can do ZModem 1K  (Normal ZModem)         }
                ZedZapper,    { Can do ZModem 8K                          }
                DoesJanus,    { Can do Janus                              }
                DoesHydra,    { Can do Hydra                              }
                Bit6,
                Bit7,
                Bit8,
                Bit9,
                CanDoBiMail,  { Can do BiModem (NOT STANDARD)             }
                BitB,
                BitC,
                BitD,
                BitE,
                WzFreq);      { Accepts file requests                     }

  YooHooCapSet = SET OF TYooHooCap;

  { WaZOO packet type }
  THelloPacket = RECORD
    Signal,
    HelloVersion,
    ProductCode,
    ProductMaj,
    ProductMin     : Word;
    SystemName     : ARRAY[1..60] OF Char;
    Sysop          : ARRAY[1..20] OF Char;
    Address        : TFidoAddress;
    Password       : ARRAY[1..8] OF Char;
    Reserved2      : ARRAY[1..8] OF Char;
    Capabilities   : YooHooCapSet;
    Reserved3      : ARRAY[1..12] OF Char;
  END;

  SendToType = ARRAY[1..2] Of S50;

  TFunctionKey = RECORD
    ErrorLevel     : Byte;
    Description    : S70;
  END;

{Ŀ}
{ Contents : Configuration information.                                    }
{ FileName : PORTAL.CFG                                                    }
{ Size     : 10240 bytes                                                   }
{ Comments :                                                               }
{}
CONST
  itd_Tick = 1;
  itd_File = 2;
  itd_Mail = 4;

TYPE
  TNodeStat = (nsUnknown, nsKnown, nsPassword);
  TReqLimit = (rlPrCall, rlPrDay);
  TBBSType  = (btNone, btQBBS, btProBoard, btOpus110, btRA, btOpus170, btSBBS, btMax);

  TConfig = RECORD
    Version        : Byte;             { .CFG file version                   }
    TaskNumber     : Byte;             { Which task number are we            }
    SwapDir        : PathStr;          { Where to swap to                    }
    Filler1        : PathStr;
    Outbound,                          { Outbound directories                }
    Banner,                            { Name of banner to show callers      }
    DefaultMacro,                      { Name of default keyboard-macro file }
    Editor,                            { Command to envoke message editor    }
    LogfileName    : PathStr;          { Log file for your system            }
    LogLevel       : Byte;             { Desired log level (1-5)             }
    UseYearInLog   : Boolean;          { False= ! dd-nnn hh:mm PORTAL        }
                                       { True = ! dd-nnn-yy hh:mm PORTAL     }
    NodeList       : PathStr;          { Directory of your nodelist files    }
    NodelistTyp    : NodeListType;     { Type of nodelist used               }

    MainAdrNum     : Byte;
    Addresses      : ARRAY[1..MaxAddresses] Of TFidoAddress;
                                       { Defined addresses                   }
    PointNet       : Integer;          { Number of point-net (for fake)      }
    UseFakeAddress : Boolean;          { Should PORTAL Use fake or real      }
                                       { addresses                           }
    Sysop          : S20;              { Name of SysOp                       }
    System         : S60;              { Name of system                      }
    SwapOnExec     : Boolean;          { Swap on exec of any command         }
    EnterBBSText,                      { Text displayed while loading        }
                                       { BBS software                        }
    DoingMailText,                     { Text to display, while in a         }
                                       { mail-only event                     }
    PressESCText   : PathStr;          { Text displayed when user should     }
                                       { press ESC                           }
    MaxRinging     : Byte;             { Max RINGING on calls out            }
    ZMHStart,                          { Start of Zone Mail Hour             }
    ZMHEnd,                            { End of Zone Mail Hour               }
    CallTime,                          { Global call frequency               }
    CallWidth      : Time;             { Global max call delay               }
    ConnectFastest : Boolean;          { Check node list for max. speed      }
                                       { and abort poll, if lower            }
    OutReReadDelay : Time;             { Delay between reading outbound      }
                                       { information                         }
    FuncReqPwd     : S20;              { Password for function requests      }
    UseJanus       : Boolean;          { Allow Janus protocol                }
    UseEMSI        : Boolean;          { Allow EMSI hand shake               }
    FastCalls      : Boolean;          { Call systems faster than us         }
    KeepEmptyDirs  : Boolean;          { If Yes, don't delete Zone, 4D Point }
    Curmudgeon     : Boolean;          { If Yes, hang up on calls from       }
                                       { unknown systems           SA:930330 }
    RereadOnCall   : Boolean;          { If set to Y, PoP will reread the    }
                                       { outbound if there is nothing to send}
    Inbound        : ARRAY[TNodeStat] OF PathStr;
    InboundToDo    : ARRAY[TNodeStat] OF Word;
    Filler         : ARRAY[1..24] of Byte;
    FKey           : ARRAY[1..2, 1..10] OF TFunctionKey;    { See above      }
    Color          : ARRAY[1..4] OF ColorSet;               { See above      }
    BBS : RECORD
      BBSType        : TBBSType;       { BBS Type used                       }
      Path           : PathStr;        { Path to BBS-information files       }
      UserFile       : PathStr;        { Name of user file, for user editor  }
      MinBaud        : Word;           { Min. baud to enter BBS              }
      MinBaudFile    : PathStr;        { File to show slower callers         }
      UserErrorLevel : Byte;           { Error level for all callers         }
      Multi : ARRAY[1..5] OF RECORD
        Key     : Char;                { Key to select BBS                   }
        BatName : S8;                  { Name of .BAT file to create         }
      END;
      Filler         : ARRAY[1..64] of Byte;
    END;
    Modem : RECORD
      CommPort   : Byte;                    { Comm. port number              }
      BaudRate   : Word;                    { Baud rate to initialize modem  }
      PreInit    : S40;                     { ??? }
      Init       : S80;                     { Init. command                  }
      NoAnswer,                             { Init cmd. in NoAnswer event    }
      Dial,                                 { Dial command                   }
      Busy,                                 { Cmd. to make line busy         }
      HangUp,                               { Hang-up command                }
      Answer     : S40;                     { Answer command                 }
      ReInit     : Time;                    { Delay between modem inits,     }
                                            { while the system is idle       }
      LockedBaud : S10;                     { Part of connect STRING, to tell}
                                            { the system that the baud rate  }
                                            { should remain locked (/ARQ)    }
      ExitStr : ARRAY[1..5] Of RECORD
        ConStr : S10;                       { Special exit STRING e.g. /FAX  }
        ErrLvl : Byte;                      { Exit error level for above str }
      END;
      ModemType : ARRAY[0..7] OF RECORD
        Bit     : Byte;
        Dial    : S40;
        DialOut : Boolean;
        Baud    : Word;
      END;
      WaitTime    : Time;              { Sek. to wait for logon   250593 SBC }
      InternalFax : Boolean;           { Use internal fax receive  191093 SA }
      Filler      : ARRAY[1..19] OF Byte;
    END;

    Screen         : RECORD
      BlankTime      : Time;           { Time of inactivity, before blanking }
                                       { the screen                          }
      ChkSnow,                         { Check for 'snow' during screen      }
                                       { updates (CGA only)                  }
      KeepOffScrMode,                  { Allow to change screen mode         }
      ScrMode,                         { False=25, True=43/50 lines          }
      HardwareBlank,                   { Blank using hardware interrupt      }
      ExplodingWin   : Boolean;        { Use fancy display of menus and      }
                                       { windows                             }
      Filler         : ARRAY[1..32] OF Byte;
    END;

    ListFiles : RECORD
      FileList,                          { Name of finished file list         }
      NewsList,                          { Name of new files list             }
      Header,                            { Name of header file for file list  }
      Footer,                            { Name of footer file for file list  }
      TopFile,                           { Name of most downloaded files list }
      StatFile       : PathStr;          { Name of area statistics file       }
      Adopt          : Boolean;          { Adopt orphan files while running   }
      AdoptComment   : S40;              { Comment for adopted files          }
      DupeCheck      : Boolean;          { Perform dupe check of file base    }
      Stat           : Boolean;          { Include statistics file in Filelist}
      IncludeTop     : Boolean;          { Include top list in file list      }
      Top            : Byte;             { How many files (0-50) to include in}
                                         { top downloads list                 }
      DkDate         : Boolean;          { Use european date format           }
      NewsDays       : Byte;             { How old files to include in news   }
                                         { file                               }
      Threshold      : Byte;             { DupeCheck Size Threshold           }
      RemMissing,                        { Remove Missing Files               }
      OkPortal,                          { Update portal compatible ok file   }
      ZapZero,                           { Delete zero Byte files             }
      Touch          : Boolean;          { Touch files with invalid time stamp}
      CrapFiles,                            { Files to delete                 }
      ExcludeFiles,                         { Files not to include in FileList}
      NoDupeCheck    : ARRAY[1..10] of S12; { Files not to check for dupes    }
      NonAdoptFiles  : ARRAY[1..10] of S12; { Files not to adopt              }
      NonAdoptAreas  : ARRAY[1..10] of S3;  { Areas not to adopt files in     }
      PrivateAreas   : ARRAY[1..11] of S3;  { Areas to leave out from list    }
      DoBefore       : PathStr;             { Command to do before generation }
      DoAfter        : PathStr;             { Command to do after generation  }
      DoPack         : PathStr;             { Command to pack finished list   }
      DupeReport     : PathStr;             { DupeReport filename             }
      TXTFreq        : ARRAY[0..3] of S55;  { Txt to display if Freq is OK    }
      OkBimodempath  : PathStr;             { Bimodem compatible OK-File      }
      Filler         : ARRAY[1..32] of Byte;
    END;

                        { 1..3, 1..2 (PrCall, PrDay) }
    Request : RECORD
      Limit : ARRAY[TNodeStat,TReqLimit] OF RECORD
        MaxFiles : Word;
        MaxTime  : Time;
        MaxBytes : LongInt;
      END;
      RspAsPkt       : Boolean;
      SkipAfterFirst : Boolean;        { Skip search after first matching    }
                                       { file - if no jokers in requested    }
                                       { name                                }
      MinBaud        : Word;           { Minimum baudrate required for       }
                                       { requests                  SA:170593 }
      Filler         : ARRAY[1..61] of Byte;
    END;

    MailScanner    : RECORD
      Filler1      : ARRAY[1..50] OF Char;
      RenumThresh  : Integer;
      NetMailDir   : PathStr;
      Filler3      : PathStr;
      Secure       : Boolean;
      BadMsgs      : PathStr;
      SaveDupesDir : PathStr;
      MaxDupes     : Word;
      EchoTossLog  : PathStr;
      StripCrash   : Boolean;
      SetAKASent   : Boolean;
      PvtEchoMail  : Boolean;
      SaveFwdMail  : Boolean;
      RouteFile    : PathStr;
      ForwardMail  : Boolean;
      KillFwdFiles : Boolean;
      Filler2      : PathStr;
      OldExt       : Boolean;
      DefaultPacker: Byte;
      NetMailBoard : Byte;
      ForceWIPMode : Boolean;
      Filler       : ARRAY[1..127] OF Char;
    END;
    FwdFile        : RECORD
      PreCmd       : PathStr;        { Cmd. to run before forwarding }
      SecureDir    : PathStr;        { Path to security directory    }
      MsgAttribute : Word;
      KillSent     : Boolean;        { Mark msgs. as kill/sent       }
      MsgPrivate   : Boolean;        { Mark msgs. as private         }
      Subject      : S72;            { Subject of forward msgs.      }
      Filler       : ARRAY[1..64] OF Byte;
    END;
    Tick : RECORD
      DupeDir        : PathStr;          { Dupe check directory               }
      HoldDir        : PathStr;          { Where to place outgoing .TIC files }
      BeforeMoving   : PathStr;          { Command to execute before          }
                                         { processing any ticks               }
      RequestMissing : Boolean;          { Should Portal try to make a file
                                         { request for any files, not received}
      Filler         : ARRAY[1..64] of Byte;
    END;
    BiMail         : RECORD
      BiOverride     : ARRAY[1..5] Of S10;   { Protocol flags to override    }
                                             { full duplex max baud          }
      NoSendOverride : Boolean;              { Override no send events when  }
                                             { using a full duplex protocol  }
      MaxBaud        : Word;                 { Max. baud rate for full       }
                                             { duplex.                       }
      BiModemPath    : PathStr;              { Path & file name of BiModem   }
                                             { program                       }
      Filler         : ARRAY[1..16] OF Byte;
    END;
    NLCompiler     : RECORD
      CostFileName   : PathStr;            { Name of cost file               }
      IntPrefix      : S10;                { Int. dial prefix                }
      OurPrefix      : S10;                { Prefix (direction number) of    }
                                           { your country                    }
      UseFidoUserLst : Boolean;            { Create FIDOUSER.LST file        }
      MTypeStr       : ARRAY[0..7] OF S5;  { Node list flag for modem type   }
      Filler         : ARRAY[1..64] OF Byte;
    END;
    DumbTerm : RECORD
      CRSendsLF,                               { Make a CR after receiving a }
                                               { line feed character         }
      DestructiveBS : Boolean;                 { BS deletes characters       }
      ModemInit     : S40;                     { Cmd. to initialize modem    }
      Filler        : ARRAY[1..128] OF Byte;
    END;
    ExtProt : ARRAY[1..5] OF Record
      Key       : Char;                      { Key to use on menu            }
      Name      : S8;                        { Name of protocol              }
      AskDLName : Boolean;                   { Does it need a name to be     }
                                             { supplied by the user          }
      AutoStart : S10;                       { STRING to detect auto-start   }
      SendCmd   : PathStr;                   { upload command                }
      RecvCmd   : PathStr;                   { download command              }
    END;
    AreaMan : RECORD
      DLCntStart,                            { Character to use for start of }
                                             { a download counter, in a      }
                                             { FILES.BBS                     }
      DLCntStop    : Char;                   { Character to use for stop of  }
                                             { a download counter, in a      }
                                             { FILES.BBS                     }
      AdoptDefault,                          { Adopt orphans when entering a }
                                             { file area                     }
      InsDLCnt,                              { Insert download counters, when}
                                             { entering a file area          }
      AddInbound   : Boolean;                { add inbound to file area list }
      FirstArea,                             { First area # (for OPUS)       }
      LastArea     : Byte;                   { Last area # (for OPUS)        }
      DlCDigits    : Byte;                   { Number of digits in DL Cnt    }
      DlCZeroFill  : Boolean;                { Fill with zero [000] or [   ] }
      ViewCMD      : S50;                    { GIF-Viewer command            } {JS 06-03-93}
      Filler       : ARRAY[1..11] OF Byte;
    END;
    Packer : ARRAY[1..7] OF RECORD
      AddCmd,                          { Cmd. to add files to an archive     }
      UnPackCmd,                       { Cmd. to extract files from archive  }
      EraseCmd,                        { Cmd. to delete files from archive   }
      TestCmd    : S40;                { Cmd. to test files in an archive    }
    END;
  END;

{Ŀ}
{ Contents : Information about daily request pr system                     }
{ FileName : PORTAL.DRI                                                    }
{ Size     : 64 bytes                                                      }
{ Comments : Is deleted at midnight                                        }
{}
  PDailyReqInfo = ^TDailyReqInfo;
  TDailyReqInfo = RECORD
    Address  : TFidoAddress;
    NumFiles : Word;
    NumBytes : LongInt;
    UsedTime : Time;
    Filler   : ARRAY[1..46] OF Byte;
  END;

{Ŀ}
{ Contents : Undialable information.                                       }
{ FileName : PORTAL.UDF                                                    }
{ Size     : 13 bytes                                                      }
{ Comments :                                                               }
{}
  PUndialable = ^TUndialable;
  TUndialable = RECORD
    DelFlag     : LongInt;          { MUST BE 0 WHEN ADDING                  }
    Address     : TFidoAddress;      { Address of Node                        }
    NoConnect,                      { Number of BUSY's                       }
    BadWaZOO    : Word;             { Number of failed WaZOO's               }
  END;

{Ŀ}
{ Contents : BadWaZOO Information.                                         }
{ FileName : PORTAL.BWZ                                                    }
{ Size     : 47 bytes                                                      }
{ Comments :                                                               }
{}
  PBadWaZOO = ^TBadWaZOO;
  TBadWaZOO = RECORD
    DelFlag        : LongInt;       { MUST BE 0 WHEN ADDING                  }
    Address        : TFidoAddress;   { Address of Node                        }
    FName          : S12;           { Original filename                      }
    FSize          : LongInt;       { Original File Size                     }
    FTime          : LongInt;       { Original File Time                     }
    NewName        : S12;           { New filename (BADWAZOO.<Num>)          }
    NodeStat       : TNodeStat;
  END;

{Ŀ}
{ Contents : Message Areas                                                 }
{ FileName : PORTAL.ARE                                                    }
{ Size     : 1024                                                          }
{ Comments : **NOT USED YET**                                              }
{}
  TMsgArea = RECORD
    Directory  : PathStr;           { QBBS/SBBS/RA=Board number, other=Directory path }
    EchoNames  : ARRAY[1..3] Of S32;{ Echo mail tags }
    Origin     : S50;               { Origin line, if any }
    SendTo     : SendToType;        { Who to send to and receive from }
    SendOnly   : SendToType;        { Who only to send to }
    ScramblePwd: S20;               { Password }
    StripSeenBy: Boolean;           { Strip seen-by down to own net + rcv. nets }
    Pvt2EMail  : Boolean;
    Level,                          { Security level }
    Keys       : Byte;              { Security keys }
    MaxScan    : Word;              { Max. number of msgs. to scan per day }
    ScanDate   : Date;              { Date of last scan }
    Scanned    : Word;              { Number of msgs. scanned on the above date }
    Description: S40;               { The title or description of this area }
    AreaType   : Byte;              { 0=Default, 1=Msg 2=Squish }
    ImportSB   : Boolean;           { Should SEEN-BY - lines be stripped on import }
    UsedAka    : Byte;              { Which AKA address to use, 0=Main address }
    msgcount   : Word;              { Number of msg. to keep in board}
    datecount  : Word;              { Number of days to keep msg. in board}
    msgkeep    : byte;              { Number of start msg. to keep before sorting and deleting}
    Filler     : ARRAY[1..508] of Byte;
  END;

{Ŀ}
{ Contents : Mail schedules                                                }
{ FileName : PORTAL.SCD                                                    }
{ Size     : 256                                                           }
{ Comments :                                                               }
{}
  PSchedule = ^TSchedule;
  TSchedule = RECORD
    Number  : Byte;
    Action  : Byte;
    Adr     : SendToType;
    Stat    : Char;
    SubLine : Byte;
    Filler  : ARRAY[1..130] OF Byte;
  END;

{Ŀ}
{ Contents : Nodelist Segments - for Nodelist Compiler                     }
{ FileName : PORTAL.NLS                                                    }
{ Size     : 512 bytes                                                     }
{ Comments : One record per used nodelist. Shared among all tasks          }
{}
  PNodelistSeg = ^TNodelistSeg;
  TNodelistSeg = RECORD
    NodeListName : S8;                     { Basename of Nodelist    NODELIST }
    DiffFileName : S8;                     { Basename of difffile    NODEDIFF }
    CheckCRC     : Boolean;                { Check CRC on nodelist update     }
    NewNLPath    : PathStr;                { Where to put the new packed NL   }
    Include      : SendToType;             { Who to include         2:All/All }
    Exclude      : SendToType;             { Who to exclude         2:230/All }
    Filler       : ARRAY[1..209] OF Byte;
  END;

{Ŀ}
{ Contents : Misc. data and Statistics.                                    }
{ FileName : PORTAL.DAT                                                    }
{ Size     : 1024 bytes                                                    }
{ Comments : One file pr. task: PORTAL<Task>.DAT                           }
{}
  PDataFile = ^TDataFile;
  TDataFile = RECORD
    Event          : Byte;                       { Current event             }
    Filler1        : ARRAY[1..14] OF Byte;
    LastRan        : Date;                       {                           }
    LastEventDate  : Date;                       {                           }
    Filler2        : Byte;
    LastEventStart : Time;                       {                           }
    Filler3        : Integer;
    Users          : ARRAY[1..5] OF RECORD       { Last 5 BBS Users          }
      Name : S35;
      T    : Time;
    END;
    UserTime       : LongInt;                    { Timestamp of LASTUSER file}
    KbdPassword    : S20;                        { Keyboard lock password    }
    Filler4        : ARRAY[1..46] OF Byte;
    Calls          : ARRAY[1..2,1..5] OF RECORD  { Call's in/Out list        }
      Adr : TFidoAddress;
      Name: S16;
      T   : Time;
    END;
    MacroStatus    : Boolean;                    { Keyboard macro status     }
    Poll           : TFidoAddress;               { Address of last manually  }
                                                 { polled node  (ALT-P)      }
    LastCalled     : TFidoAddress;               { Address of last node we   }
                                                 { have called               }
    NextTime       : EventTimer;                 { Dial out timer            }
    filler         : ARRAY[1..408] OF Char;
  END;

{Ŀ}
{ Contents : Events                                                        }
{ FileName : PORTAL.EVT                                                    }
{ Size     : 128 bytes                                                     }
{ Comments : Shared among all tasks.                                       }
{}
CONST
  { TEvent.Typ }
  etForced    =     1;     { Event must run even if it is past it's time     }
  etRequests  =     2;     { Allow file requests                             }
  etUsers     =     4;     { Allow usesr on BBS                              }
  etReceive   =     8;     { Don't send ANY mail - even if somebody poll     }
  etCrash     =    16;     { Only send crash mail                            }
  etNoSend    =    32;     {                                                 }
  etDynamic   =    64;     {                                                 }
  etClrOut    =   128;     { Clear outbound at start of event                }
  etNoAnswer  =   256;     { Don't answer the phone                          }
  etOnceOnly  =   512;     { Disable event when is has run                   }
  etPoPList   =  1024;     { Generate filelist                               }
  etTossMail  =  2048;
  etScanMail  =  4096;
  etPackMail  =  8192;
  etNoFiles   = 16384;     { Don't send anything that is not in the outbound }
  etBit15     = 32768;     { Reserved                                        }

TYPE
  PEvent = ^TEvent;
  TEvent = RECORD
    Active       : Byte;            { BIT: 7=Active, 0..6=DayNumber          }
    Start        : Time;            { Start time                             }
    Month        : Byte;            { Only run on this month (1-12)          }
    Day          : Byte;            { Only run on this day (1-31)            }
    InitExit     : Byte;            { 0 If no exit. Exit err.level at start  }
    MailExit     : Byte;            { -"- Exit err.level after rcv. mail     }
    PollExit     : Byte;            { -"- Exit err.level after a poll        }
    FilesExit    : Byte;            { -"- Exit err.level after rcv. file(s)  }
    Typ          : LongInt;         { See above                              }
    Tries        : RECORD
      Bad,                          { Max number of BadWaZOO's and BUSY's    }
      Busy : Byte;                  { before marking the node undialable     }
    END;
    CallTime     : Time;            {                                        }
    CallWidth    : Time;            {                                        }
    Description  : S20;             { Short description of this event        }
    ConnectTo    : TFidoAddress;     { Only if not in ZMH                     }
    SchedNumber  : Byte;            { Mail packer                            }
    MaxCost      : Word;            { Maximum cost                           }
    MinMail      : LongInt;         { Minimum mail to dial out               }
    SpecDial     : Byte;            { Special nodes dial number              }
    TaskNumber   : Byte;            { Task number, 0=All tasks               }
    Filler       : ARRAY[1..65] Of Byte;
  END;

{Ŀ}
{ Contents : Nodes setup.                                                  }
{ FileName : PORTAL.NOD                                                    }
{ Size     : 256 bytes                                                     }
{ Comments :                                                               }
{}
  PNodeInfo = ^TNodeInfo;
  TNodeInfo = RECORD
    Address       : TFidoAddress;         { Node address                       }
    PktPassword   : S7;                  { ** Not used yet**                  }
    AreaFixPwd    : S20;                 { Password to PortalFix              }
    SessionPwd    : S8;                  { Session Password                   }
    PackerType    : Byte;                { 1-7 = Arcnum, 0=Arc...             }
    Level         : Byte;                { Security level  of node            }
    Keys          : Byte;                { Security flags of node             }
    OpenFrom,                            { Used if the node is not            }
    OpenTo        : Time;                { running CM                         }
    UseEmsi       : Char;                { Yes, No, ' '                       }
    Filler1       : ARRAY[1..20] OF Byte;
    SendFwdLetter : Boolean;             { Send letter when forwarding files  }
    PointNet      : Integer;             { Fake net if this is a node         }
    CheckConnect  : Char;                { Yes, No, ' '                       }
    UseFake       : Char;                { Yes, No, ' '                       }
    DisallowReq   : Boolean;             {                                    }
    UseFullDuplex : Char;                { Yes, No, BiModem, Janus, ' '       }
    Phone         : S22;                 { Phone - Override nodelist          }
    TickPassword  : S20;                 { Password for .TIC files            }
    PackTick      : Boolean;             { Pack all .TIC files                }
    Flavor        : Char;                { Hold, Direct, Normal, Crash,       }
                                         { or Important                       }
    SpecialDials  : ARRAY[0..2] OF S20;  { Used in events                     }
    EMSISetTime   : Boolean;             { Set time to EMSI tranx             }
    NodeFiller    : ARRAY[1..61] OF Byte;
  END;

{Ŀ}
{ Contents : Files to forward.                                             }
{ FileName : PORTAL.FWD                                                    }
{ Size     : 512 bytes                                                     }
{ Comments : One record per file to forward. Shared among all tasks.       }
{}
  PFileFwd = ^TFileFwd;
  TFileFwd = RECORD
    FileName     : S12;          { File mask to look for in inbound area     }
    WhereToPut   : PathStr;      { Path to move file to                      }
    AddToFiles   : Boolean;      { Add to FILES.BBS                          }
    AddBeforeLine: Word;         { Insert entry before line #                }
    Description  : S80;          { Description to use for this file          }
    SendTo       : SendToType;   { Who to send to                            }
    BeforeCmd    : PathStr;      { Cmd. to do before moving the file         }
    AfterCmd     : PathStr;      { Cmd. to do after moving the file          }
    TouchFile    : Boolean;      { Touch the file's time stamp when moving it}
    GetFrom      : TFidoAddress;  { Who is allowed to send it to you          }
    LastForward  : Date;         { Last date forwarded                       }
    KillDupe     : Boolean;      { Kill received duplicates of this file     }
    CheckDate    : Boolean;      { File must be newer than LastForaward      }
    Level        : Byte;         { Security level for this entry             }
    Keys         : Byte;         { Security keys for this entry              }
    PortalFixName: S10;          { Name to use for it, in PortalFix          }
    KeepMax      : Byte;         { How many old files to keep (0=All)        }
    Filler       : ARRAY[1..44] Of Byte;
  END;


{Ŀ}
{ Contents : Phone translations for Nodelist Compiler.                     }
{ FileName : PORTAL.NLT                                                    }
{ Size     : 64 bytes                                                      }
{ Comments :                                                               }
{}
  TNLTranslat = RECORD
    NumFrom,                     { If phone number starts with this   }
    NumTo      : S31;            { Replace it with this!!             }
  END;
  NLTranslatTab = ARRAY[1..1000] OF TNLTranslat; { For typecasting }


{Ŀ}
{ Contents : Ok-File (File request)                                        }
{ FileName : PORTAL.OKF                                                    }
{ Size     : 128 bytes                                                     }
{ Comments :                                                               }
{}
  TFreeArea = (faNoWay,          { Not a free area                           }
               faIfAccess,       { If file within limits, send it but don't  }
                                 { add it to limits (same limits after file) }
               faTotally);       { Totally free - only check time to next    }
                                 { NoRequest event                           }

  POkFile = ^TOkFile;
  TOkFile = RECORD
    NodeStat  : TNodeStat;       { Nodestat:                                 }
    MagicName : S20;             { Magic name, if any                        }
    FilePath  : PathStr;         { Path and filespec.                        }
    Password  : S10;             { Password for area                         }
    Level,
    Keys      : Byte;
    FreeArea  : TFreeArea;
    TaskNumber: Byte;
    Filler    : ARRAY[1..11] of Byte;
  END ;


{Ŀ}
{ Contents : Tick areas setup.                                             }
{ FileName : PORTAL.TIC                                                    }
{ Size     : 512 bytes                                                     }
{ Comments :                                                               }
{}
  PTickArea = ^TTickArea;
  TTickArea = RECORD
    AreaName      : S20;         { Name of the area                          }
    GroupName     : S10;         { All areas with same group name is         }
                                 { announced in same letter                  }
    HumanName     : S40;         { Human understandable areaname             }
    AreaPath      : PathStr;     { Where to copy to                          }
    WriteLetter   : Boolean;     { Write letter when files arrive            }
    AnnouncePath  : PathStr;     { Where to write letter                     }
    CanBeRepacked : Boolean ;    { Allow other ext. than in .TIC             }
    GetFrom       : SendToType;  { These nodes can hatch into this area      }
    SendTo        : SendToType;  { These nodes can only receive files in     }
                                 { this area                                 }
    Level,Keys    : Byte;        { Level and Keys needed to access this area }
    CheckCRC      : Boolean;     { Check CRC in this area                    }
    FilesBBS      : S12;         { Name of file to update                    }
    AKAToUse      : Byte;        { Which AKA to use (0=Main address)         }
    CheckDupe     : Boolean;     { Should this area be checked for dupes     }
    Filler        : ARRAY[1..55] Of Byte;
  END;


{Ŀ}
{ Contents : Intercommunication.                                           }
{ FileName : PORTAL.ICF                                                    }
{ Size     : 32 bytes                                                      }
{ Comments :                                                               }
{}
CONST
  ICUnused     = $00;    { Informal }
  ICIdle       = $01;    { Informal }
  ICAreaMan    = $02;    { Informal }
  ICTextEdit   = $03;    { Informal }
  ICDumbTerm   = $04;    { Informal }
  ICDosShell   = $05;    { Informal }
  ICUserInBBS  = $06;    { Informal }
  ICMsgEdit    = $07;    { Informal }
  ICConfig     = $08;    { Informal }
  ICSemExit    = $09;

  ICPolling    = $80;
  ICFileFwd    = $81;
  ICConnect    = $82;
  ICNLComp     = $83;
  ICUnpackMail = $84;
  ICOutMan     = $85;
  ICNLMan      = $86;
  ICUserEd     = $87;
  ICScanNetMail= $88;
  ICTick       = $89;

{ ToDoFlags: }
  ICTDUnpackMail  = $0001;
  ICTDReReadNLIdx = $0002;


TYPE
  PInterCom = ^TInterCom;
  TInterCom = RECORD
    Status     : Byte;
    MyAddress,
    PollAddress: TFidoAddress;
    ToDoFlags  : Word;
    Filler     : ARRAY[1..13] of Byte;
  END;


{ Ŀ }
{  Contents : Information about received files.                             }
{  FileName : PORTAL.TIT                                                    }
{  Size     : 64 bytes                                                      }
{  Comments :                                                               }
{  }
  TInboundFile = RECORD
    DelFlag    : LongInt;
    FileName   : S8;                   { Filename                             }
    From       : TFidoAddress;          { Address of node we got the file from }
    RecvDate   : Date;                 { Date received                        }
    RecvTime   : Time;                 { Time received                        }
    TaskNum    : Byte;                 { Received on tasknumber               }
    Filler     : ARRAY[1..34] OF Byte;
  END;


{ Ŀ }
{  Contents : Text Editor pick list.                                        }
{  FileName : PORTAL.TEP                                                    }
{  Size     : ?? bytes                                                      }
{  Comments :                                                               }
{  }
  TPickList = RECORD
    FileName   : PathStr;
    LineAtTop  : Integer;
    CurLine    : Integer;
    CurCol     : Byte;
    BlkBegin,
    BlkEnd     : MarkerRec;
    SearchStr,
    ReplaceStr : STRING[MaxSearchLen];
    OptionStr  : STRING[MaxSearchOptions];
    LastSearch : Byte;
    Filler     : ARRAY[1..94] of Byte;
  END;
  PickListArrayType = ARRAY[0..15] Of TPickList;


{Ŀ}
{ Contents : Dialing directory for Terminal mode                           }
{ FileName : PORTAL.TDD                                                    }
{ Size     : 128 bytes                                                     }
{ Comments : One record per entry                                          }
{}
  TDialDir = RECORD
    Name           : S30;                   { Name of the board              }
    Phone          : S20;                   { Phone number                   }
    TermMode       : Byte;                  { Emulation. 0=Auto, 1=ANSI-BBS, }
                                            {            2=AVATAR            }
    Settings       : Word;                  { Not used yet                   }
    Filler         : ARRAY[1..73] OF Char;
  END;


{Ŀ}
{ Contents : Portal Statistics                                             }
{ FileName : PORTAL.STA                                                    }
{ Size     : 6144 bytes                                                    }
{ Comments : 0=User, 1=MailIn, 2=MailOut, 3=MailProcessing, 4=, 5=, 6=     }
{}
  PPortalStat = ^TPortalStat;
  TPortalStat = RECORD
    Start     : DateTimeRec;                     { Start date/time of stat   }
    Usage     : ARRAY[0..6,DayType,0..23] OF LongInt; { Connect time/day/hour}
    Connect   : RECORD
      Bauds : ARRAY[0..MaxBaudStat] OF Byte;     { Baudrate/300 - NOT sorted }
      Stat  : ARRAY[0..1,0..1,0..MaxBaudStat] OF LongInt;  { 0=Mail, 1=User  }
    END;               { ^-- 0=Incomming, 1=Outgoing }
    DayStat   : ARRAY[0..1] OF RECORD            { Today/Yesterday           }
      CallsOut      : Word;
      CallsGood     : Word;
      Cost          : Word;
      BbsSessions   : Word;
      MailSessions  : Word;
      FilesIn       : Word;
      FilesOut      : Word;
    END;
    Total     : RECORD
      CallsOut      : LongInt;
      CallsGood     : LongInt;
      Cost          : LongInt;
      BbsSessions   : LongInt;
      MailSessions  : LongInt;
      FilesIn       : LongInt;
      FilesOut      : LongInt;
    END;
    Filler  : ARRAY[0..1018] OF Byte;
  END;


{Ŀ}
{ Contents : Portal color schemes                                          }
{ FileName : *.CLR                                                         }
{ Size     : 512 bytes                                                     }
{ Comments :                                                               }
{}
  PColorScheme = ^TColorScheme;
  TColorScheme = RECORD
    Color   : ARRAY[1..4] OF ColorSet;
    Desc    : S40;
    MadeBy  : S20;
    Address : TFidoAddress;
    Filler  : ARRAY[1..194] OF Byte;
  END;


{ Ŀ }
{  BiModem Stuff - see BiModem manual for more info!                        }
{  }
  TBiModemCfg = RECORD
    MaxTime100         : Byte;
    MaxTimeSec         : Byte;
    MaxTimeMin         : Byte;
    MaxTimeHour        : Byte;
    MaxSize            : LongInt;
    BaudRate           : LongInt;
    ComPort            : Byte;

    IntReqPort1        : Byte;
    PortAddr1          : Integer;
    IntReqPort2        : Byte;
    PortAddr2          : Integer;
    IntReqPort3        : Byte;
    PortAddr3          : Integer;
    IntReqPort4        : Byte;
    PortAddr4          : Integer;
    IntReqPort5        : Byte;
    PortAddr5          : Integer;
    IntReqPort6        : Byte;
    PortAddr6          : Integer;
    IntReqPort7        : Byte;
    PortAddr7          : Integer;
    IntReqPort8        : Byte;
    PortAddr8          : Integer;

    BitMap1            : Byte;
    BitMap2            : Byte;
    BitMap3            : Byte;
    BitMap4            : Byte;
    DefaultSend        : STRING[79];
    DefaultReceive     : STRING[79];
    DefaultLogPath     : STRING[79];
    DefaultPathFile    : STRING[79];
    RemoveSnow         : Char;
    ModemType          : Char;
    BiosIndicator      : Char;
    UseCTS             : Char;
    UseCarrier         : Char;
    UseDSR             : Char;
    ReplaceTimer       : Char;
    ReplaceKbd         : Char;
    PromptColor        : Byte;
    FieldColor         : Byte;
    CharRcvColor       : Byte;
    ChatSendColor      : Byte;
    MenuCurColor       : Byte;
    MenuNotCurColor    : Byte;
    WaitForConnect     : Integer;
    StartPageMin       : Byte;
    StartPageHour      : Byte;
    EndPageMin         : Byte;
    EndPageHour        : Byte;
    PhoneEdit          : STRING[12];
    RejectListPath     : STRING[79];
    AbortPath          : STRING[79];
    CurDirAccess       : Char;
    RemoteFReq         : Char;
    LocalFReq          : Char;
    BiHotActKey        : Integer;
    BiHotActKeyName    : STRING[5];
    BiHotUnLoadKey     : Integer;
    BiHotUnloadKeyName : STRING[5];
    PwdFilePath        : STRING[79];
  { --- NEW IN BIMODEM v1.22 --- }
    MaxErrPrFile       : Integer;
    MenuNotCurMarkColor: Byte;
    MenuCurMarkColor   : Byte;
    ErrorColor         : Byte;
    BiListFilePath     : STRING[79];
    SkipIfSameDate     : Char;

  END;

  TBiModemInterComm = RECORD
    DayTransComp  : Byte;
    MonthTransComp: Byte;
    YearTransComp : Integer;
    TransComp100  : Byte;
    SecTransComp  : Byte;
    MinTransComp  : Byte;
    HourTransComp : Byte;
    Direction     : Char;
    FilePath      : STRING[78];
    Status        : Char;
    Description   : STRING[79];
    Cps           : Integer;
    RegID         : STRING[59];
    AreaCodePhone : Integer;
    RestPhone1    : Byte;
    RestPhone2    : Byte;
    RestPhone3    : Byte;
  END;

  TBiModemTransfer = RECORD
    Direction,
    Refresh,
    ReplaceExist,
    VerifyWhenDone,
    DeleteSource,
    Filler,
    AllowDirectory,
    IncludeSubs    : Char;
    Source,
    Destination,
    Description    : ARRAY[1..80] OF Char;
  END;

  RunParametersType=RECORD
    Toss,
    Scan,
    Pack   : Boolean;
    Sched  : BYTE;
  END;

{ Ŀ }
{  Hudson message base structures                                           }
{  }
  HudsonInfoRecord = Record
    LowMsg:      Integer;
    HighMsg:     Integer;
    TotalActive: Integer;
    ActiveMsgs:  Array[1..200] of Integer;
  End;

  HudsonIdxRecord = Record
    MsgNum:       Integer;
    Board:        Byte;
  End;

(* Msg Attributes: (MsgAttr: Byte)
      Bit 0: Deleted
      Bit 1: Unmoved Outgoing Net Message
      Bit 2: Is a Net Mail Message
      Bit 3: Private
      Bit 4: Received
      Bit 5: Unmoved Outgoing Echo Message
      Bit 6: Local Bit

   Net Attributes: (NetAttr: Byte)
      Bit 0: Kill Message after it's been sent
      Bit 1: Sent OK
      Bit 2: File(s) Attached
      Bit 3: Crash Priority
      Bit 4: Request Receipt
      Bit 5: Audit Request
      Bit 6: Is a Return Receipt *)

  HudsonHdrRecord = Record
    MsgNum,
    ReplyTo,
    SeeAlsoNum,
    TRead:              Integer;
    StartRec:           Word;
    NumRecs,
    DestNet,
    DestNode,
    OrigNet,
    OrigNode:           Integer;
    DestZone,
    OrigZone:           Byte;
    Cost:               Integer;
    MsgAttr,
    NetAttr,
    Board:              Byte;
    PostTime:           S5;
    PostDate:           S8;
    WhoTo,
    WhoFrom:            S35;
    Subj:               S72;
  End;

CONST
  { MsgAttr : BYTE }
  qbDeleted    = 1;
  qbPrivate    = 8;
  qbReceived   = 16;
  qbLocal      = 64;

  { NetAttr : BYTE }
  qbKill       = 1;
  qbSent       = 2;
  qbFileAttach = 4;
  qbCrash      = 8;
  qbReqRcpt    = 16;
  qbAuditReq   = 32;
  qbReturnRcpt = 64;

IMPLEMENTATION

END.

