PROGRAM LogCut;
{ͻ}
{ Removes logentries older than x days          Last changed: 07.01.94  SA }
{                                                                          }
{                         (C) Copyright 1989-94 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}
USES Dos, OpString, OpDate, OpStrDev, UnixDate, PoPTypes;

CONST
  MonthName      : ARRAY[1..12] OF String[3] = ('Jan', 'Feb', 'Mar', 'Apr',
                                                'May', 'Jun', 'Jul', 'Aug',
                                                'Sep', 'Oct', 'Nov', 'Dec');


  PROCEDURE Copyright;
  BEGIN
    WriteLn('Log cutter v'+Ver);
    WriteLn('(c) Copyright 1993 by The Portal Team');
    WriteLn;
  END;

  PROCEDURE ShowHelp;
  BEGIN
    WriteLn('USAGE:   LogCut Days {LogFile}');
    WriteLn;
    WriteLn('EXAMPLE: LogCut 7 Portal01.Log Portal02.Log');
    WriteLn;
  END;

  FUNCTION ConvertDate(DateStr : String) : LongInt;
  VAR
    MonthNow,
    Year, Month, Day, DoW,
    Hour, Min, Sec : Word;
    Temp           : String[5];
    ok             : Integer;
  BEGIN
    IF Length(DateStr)<>15 THEN
    BEGIN
      Convertdate:=0;
      Exit;
    END;
    GetDate(Year, MonthNow, Day, DoW);
    Temp := Copy(DateStr, 1, 2);
    Val(Temp, Day, ok);
    Temp := Copy(DateStr, 4, 3);
    Month := 1;
    WHILE (Month < 12) AND (MonthName[Month] <> Temp) DO
      Inc(Month);
    IF Month = 13 THEN
    BEGIN
      ConvertDate := 0;
      Exit;
    END;
    IF MonthNow<Month THEN Dec(Year);
    Temp := Copy(DateStr, 8, 2);
    Val(Temp, Hour, ok);
    Temp := Copy(DateStr, 11, 2);
    Val(Temp, Min, ok);
    Temp := Copy(DateStr, 14, 2);
    Val(Temp, Sec, ok);
    ConvertDate := GetUnixDate(Year, Month, Day, Hour, Min, Sec);
  END;

  PROCEDURE ReadLine(VAR f: File; VAR s: String);
  VAR
    OldPos : LongInt;
    Buf    : Array[0..254] Of Char;
    Test   : Integer;
    i      : Byte;
  BEGIN
    S:='';
    OldPos:=FilePos(f);
    BlockRead(f,Buf,SizeOf(Buf),Test);
    i:=0;
    WHILE (Test<>0) And (i<Test) AND (Buf[i]<>#10) DO
    BEGIN
      IF (Buf[i]<>#10) AND (Buf[i]<>#13) THEN S:=S+Buf[i];
      Inc(i);
    END;
    Seek(f,OldPos+i+1);
    IF IoResult<>0 THEN ;
  END;

  PROCEDURE WriteLine(VAR f: File; s: String);
  BEGIN
    s:=s+#13#10;
    BlockWrite(f, s[1], Length(s));
  END;

  FUNCTION UnixToDateStr(UDate: LongInt): String;
  VAR
    Year, Month, Day,
    Hour, Min, Sec    : Word;
    MinStr, SecStr    : String[3];
  BEGIN
    UnPackUnix(UDate, Year, Month, Day, Hour, Min, Sec);
    Str(Min,MinStr);
    If Min<10 THEN MinStr:='0'+MinStr;
    Str(Sec,SecStr);
    If Sec<10 THEN SecStr:='0'+SecStr;
    Write(TpStr,Day, '/', Month, '-', Year, '  ', Hour, ':', MinStr, ':', SecStr);
    UnixToDateStr:=ReturnStr;
  END;

  PROCEDURE CutTheLogs;
  VAR
    Days, i : Byte;
    Err  : Integer;
    Line,
    OldestDate : LongInt;
    BufSize, Read,
    Hour, Min, Sec, Sec100,
    Day, Month, Year, DoW : Word;
    LogFile, f : File;
    InStr   : STRING;
    Buf     : Pointer;
  BEGIN
    Val(ParamStr(1), Days, Err);
    IF Err=0 THEN
    BEGIN
      GetTime(Hour, Min, Sec, Sec100);
      GetDate(Year, Month, Day, DoW);
      OldestDate:=GetUnixDate(Year, Month, Day, Hour, Min, Sec)-(LongInt(Days)*60*60*24);
      WriteLn('Deleting logentries before: ',UnixToDateStr(OldestDate));
      WriteLn;
      FOR i:=2 TO ParamCount DO
      BEGIN
        Assign(LogFile, ParamStr(i));
        Reset(LogFile, 1);
        IF IOResult=0 THEN
        BEGIN
          WriteLn('Cutting: '+ParamStr(i));
          Line:=1;
          ReadLine(LogFile, InStr);
          IF (Trim(InStr)<>'') AND (ConvertDate(Copy(InStr, 3, 15))>0) THEN
          BEGIN
            WHILE ConvertDate(Copy(InStr, 3, 15))<OldestDate DO
            BEGIN
              Write('Analyzing: ',Line:5,#13);
              Inc(Line);
              ReadLine(LogFile, InStr);
            END;

            IF ConvertDate(Copy(InStr, 3, 15))>=OldestDate THEN
            BEGIN
              Assign(f, ForceExtension(ParamStr(i),'LC$'));
              ReWrite(f,1);
              WriteLine(f, InStr);
              IF MaxAvail>$fff0 THEN BufSize:=$fff0 ELSE BufSize:=MaxAvail-1024;
              GetMem(Buf, BufSize);
              Line:=0;
              REPEAT
                BlockRead(LogFile, Buf^, BufSize, Read);
                BlockWrite(f, Buf^, Read);
                Err:=IOResult;
                Inc(Line, Read);
                Write('Copying  : ',Line:8,#13);
              UNTIL (Read<>BufSize) OR (Err<>0);
              FreeMem(Buf, BufSize);
              Close(f);
              Close(LogFile);
              IF Err=0 THEN
              BEGIN
                Erase(LogFile);
                Rename(f, ParamStr(i));
              END ELSE
              BEGIN
                Erase(f);
                WriteLn('Error writing temp file');
              END;
            END ELSE
            BEGIN
              Close(LogFile);
              WriteLn('Nothing to do!');
            END;
            WriteLn;
          END ELSE
          BEGIN
            Close(LogFile);
            WriteLn('Unknown logdate in: '+ParamStr(i)+' - skipping file!');
          END;
        END ELSE
          WriteLn('Error opening: '+ParamStr(i));
        WriteLn;
      END;
    END ELSE
      ShowHelp;
  END;

BEGIN
  Copyright;
  IF ParamCount>1 THEN
    CutTheLogs
  ELSE
    ShowHelp;
END.
