PROGRAM Add2Ok;
{ͻ}
{ Adds missing paths to PORTAL.OKF              Last changed: 24.04.93  SA }
{                                                                          }
{                         (C) Copyright 1989-93 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}

USES OpCrt, Dos, OpString, PopTypes;

LABEL
  Out;

VAR
  i : Byte;
  PathName : PathStr;
  OkFileRec : TOkFile;
  OkFile : File Of TOkFile;
  Sr : SearchRec;
  Found, All : Boolean;
  Ch : Char;

  PROCEDURE ShowHelp;
  BEGIN
    WriteLn;
    WriteLn('  USAGE: Add2Ok <Path>');
  END;

BEGIN
  WriteLn('Add2Ok, (C) 1992-93 by The Portal Team, v', Ver);
  IF ParamCount=0 THEN
    ShowHelp
  ELSE
  BEGIN
    Assign(OkFile, 'PORTAL.OKF'); FileMode:=$42;
    Reset(OkFile);
{   IF IOResult<>0 THEN ReWrite(OkFile);}
    IF IOResult=0 THEN
    BEGIN
      FOR i:=1 TO ParamCount DO
      BEGIN
        WriteLn;
        All:=False;
        FindFirst(AddBackSlash(ParamStr(i))+'*.*',Directory,Sr);
        WHILE DosError=0 DO
        BEGIN
          IF (Copy(Sr.name,1,1)<>'.') And ((Sr.Attr And Directory)=Directory) THEN
          BEGIN
            PathName:=StUpCase(AddBackSlash(ParamStr(i))+Sr.Name+'\');
            Write(Pad(PathName,75),#13);
            Seek(OkFile,0); Found:=False;
            WHILE Not Eof(OkFile) And Not Found DO
            BEGIN
              Read(OkFile, OkFileRec);
              Found:=(Copy(OkFileRec.FilePath, 1, Length(PathName))=PathName);
            END;
            IF Not Found THEN
            BEGIN
              IF Not All THEN
              BEGIN
                Write('Add: ',PathName,'*.*  (Y/N/A/S) ');
                Ch:=UpCase(ReadKey);
                WriteLn(ch);
                IF Ch='S' THEN Goto Out;
                IF Ch='A' THEN All:=True;
              END ELSE
                Ch:='Y';
              IF Ch='Y' then
              BEGIN
                FillChar(OkFileRec, SizeOf(OkFileRec), 0);
                OkFileRec.FilePath:=PathName+'*.*';
                Seek(OkFile, FileSize(OkFile));
                Write(OkFile, OkFileRec);
              END;
            END;
          END;
          FindNext(Sr);
        END;
      END;
Out:
      Close(OkFile);
    END ELSE
    BEGIN
      WriteLn;
      WriteLn('PORTAL.OKF not found in current directory.');
      ShowHelp;
    END;
  END;
  WriteLn;
END.
