; 386POWER example program #1.

        .386p
code32 segment para public use32
       assume cs:code32,ds:code32

include 386power.inc
include 386file.inc
include 386arg.inc
include pcx.inc
include 386video.inc
include chtil.inc
include chario.inc

public  _Main
        align byte
        
nomem   db 'Not enough memory for .CBF buffer',CR,LF,'$'
nopars2 db 'file name for .CBF destination not found',CR,LF 
nopars  db 'Not enough file names on command line',CR,LF
        db 'PCX2CBF needs to be called this way:',CR,LF
        db '   PCX2CBF file.PCX file.CBF',CR,LF,CR,LF
        db 'And remember that the file extensions are not checked!'
        db CR,LF,CR,LF,'$'
badpcx  db 'Not a valid PCX file',CR,LF,'$'

        align dword
CHRPAL  dd 9 dup(0)  ; 12*3 bytes  = 3*3 dwords
        align byte
CHRFNT  db (CHARSIZE*128) dup(0)

GetCHR:
         ; copia da RAM VIDEO sul BUFFER dei caratteri
         ; una matrice 
         ; esi = screen base offset
         ; edi = character bitmap index
         ; eax = x position in pixels
         ; edx = y position in pixels
        pushad
        and edi,127
        add esi,eax
        mov ebp,_ScrX
        shl edi,CHARSHIFT
        add esi,[edx*4+_RowStart]
        add edi,offset CHRFNT
        sub ebp,8
        mov ecx,8
chanplane:        
        movsd
        movsd
        add esi,ebp
        dec ecx
        jne chanplane
        popad
	ret

        
_Main:  sti
        call _ArgInit
        call _ArgFile
        mov _386Return,offset nopars
        cmp byte ptr [esi],0
        je orrore
        mov _DispX,320
        mov _ScrX,320
        mov _DispY,200
        mov _ScrY,200
        call _SetXVDMode
        call _PcxLoad
        mov _386Return,offset badpcx
        cmp _PcxDecoded,0
        je orrore
        call _PageFlip0
        ; get palette entries
        mov edi,offset CHRPAL ; get pointer to character's private palette entries
        mov al,BRIGHT1_TEXT
palettb:
        call _Get1Pal
        inc al
        mov [edi],edx
        add edi,3
        cmp al,BRIGHT6_TEXT
        jbe palettb
        mov al,DARK1_TEXT
palettd:
        call _Get1Pal
        inc al
        mov [edi],edx
        add edi,3
        cmp al,DARK6_TEXT
        jbe palettd

        ; fetch character bitmaps
        mov esi,_ScrBase
        mov edi,0
        mov edx,0
ch_row:        
        mov eax,0
ch_col:        
        call GetCHR
        add eax,8
        inc edi
        cmp eax,256
        jb ch_col
        add edx,8
        cmp edx,32
        jb ch_row
        ; now write .CBF file
        call _ArgFile
        mov _386Return, offset nopars2
        cmp byte ptr [esi],0
        je orrore
        mov _386Return,offset _386Terminator 
        ; If we got here, no errors. But we let the last word to _FSave.
        mov eax,((CHARSIZE*128)+(12*3))
        mov edi,offset CHRPAL
        call _FSave
orrore: call _RestoreTextMode
        jmp _Exit
code32  ends
        end

