; 386POWER example program #0.
; Install a mouse driver, compile, and run.
; When run, use the left mouse button to draw. Any key exits.
        .386p
code32 segment para public use32
       assume cs:code32,ds:code32

include 386power.inc
include 386keyb.inc
include 386timer.inc
include 386file.inc
include 386arg.inc

public  _Main

CR equ 0dh
LF equ 0ah
DBLANK = 07200720h ; black bg, white fg,blank space
; DATA
ex_text         db      'TEST ZERO for 386POWER',CR,LF
                db      'Testing startup, FILE I/0 & Keyboard',CR,LF
                db      'PRESS ESC TO EXIT',0
txt_mem         db      'AVAILABLE EXTENDED MEMORY',CR,LF
                db      'AVAILABLE DOS MEMORY',0

fl_mem          db      'SIZE OF HELLO.TXT FILE',0
tt_mem          db      'TEXT CONTAINED INTO HELLO.TXT:',0
man_text        db      'SYSTEM TYPE:',0
pro_text        db      '  PROCESSOR:',0
optext          db      ' _____Command__line__text_____',CR,LF
                db      'Filenames:      Options:',0
systypestr      db      'VCPI','DPMI'
cputypestr      db      '8086',' 186',' 286',' 386',' 486',' 586'
hextuff         db      '0123456789ABCDEF'
d_text          db      8 dup(0)
fname           db      'hello.txt',0
rkbtext         db      'RAW KEYBOARD TEST:',0
esctext         db      'Press & release keys ',0

; CODE

CHROW  = 160
MAXCOL   = 80
MAXROW   = 25
CHCELL   = 2
textbase dd 0B8000h

PutText:  ; put max. ECX chars pointed by ESI
          ; to screen location pointed by EDI
          ; with attr AH
        push ecx
        push edi
        add edi,textbase
        mov ebp,edi
XPutText:        
        lodsb
        cmp al,0
        je CHend
        cmp al,CR
        jne noCR
        mov edi,ebp
        jmp nxCH
noCR:   cmp al,LF
        jne noLF
        add ebp,CHROW
        add edi,CHROW
        jmp nxCH
noLF:                
        stosw
nxCH:   dec ecx     
        jne XPutText
CHend:  pop edi
        pop ecx
        ret
        

;----------------------
Bin2Hex:; edx = dword to convert to hex
        ; edi = ptr to 8byte "converted dword" destination
        push ebx
        push ecx
        push edi
        push edx
        xor ebx,ebx
        mov ecx, 8
        add edi, 7
        std
txpit:        
        mov ebx,edx
        and ebx,0Fh
        mov al,[ebx+hextuff]
        stosb
        shr edx,4
        dec ecx
        jne txpit
        pop edx
        pop edi
        pop ecx
        pop ebx
        cld
        ret
        
d2text macro
        push edi
        mov edi,offset d_text
        call Bin2Hex
        pop edi
       endm



zaptext:
        push ecx
        push eax
        push edi
        mov ecx,(80*25)/2    ; text screen size in dwords
        mov eax,DBLANK       ; character and attributes
        mov edi,textbase
        rep stosd
        pop edi
        pop eax
        pop ecx
        ret
;
_Main:  sti  ; enable interrupts (386P disables them)
        mov al,10h
        mov V86ax,0003 ; text mode 80 columns, 16 colors
        call _ExecINT
        mov eax,_Code32Base  ;
        sub textbase,eax     ; convert to to code32 offset

        call zaptext

        mov edi,(CHROW*4)
        mov ah,7
        mov ecx,-1
        mov esi,offset optext
        call PutText

        call _ArgInit           ; initialize command line scanner
        mov edi,(CHROW*6)
        mov ah,14
        mov ecx,-1
     argc:
        call _ArgFile           ; read filename
        cmp byte ptr [esi],0
        je nofarg
        call PutText
        add edi,CHROW
        jmp argc
nofarg:        
        mov edi,(CHROW*6+30)
     optc:
        call _ArgOpt           ; read option
        cmp byte ptr [esi],0
        je noopt
        call PutText
        add edi,CHROW
        jmp optc
noopt:  ; system type info
        mov edi,(50*CHCELL)    ; put type of system
        mov esi,offset man_text
        mov ecx,-1
        mov ah,14
        call PutText
        movzx esi,_386Man
        lea esi,[esi*4+systypestr]
        add edi,15*CHCELL
        mov ecx,4
        mov ah,15
        call PutText
        ; cpu type info
        mov edi,CHROW+(50*CHCELL) ; put cpu type
        mov esi,offset pro_text
        mov ecx,-1
        mov ah,14
        call PutText
        movzx esi,_CPUPower
        lea esi,[esi*4+cputypestr]
        add edi,15*CHCELL
        mov ecx,4
        mov ah,15
        call PutText

        ;  available memory info text

        mov edi,18
        mov esi,offset txt_mem
        mov ecx,-1
        mov ah,13
        call PutText
        ; high mem.
        mov edx,_HiMemTop
        sub edx,_HiMemBase
        d2text
        mov edi,0
        mov esi,offset d_text
        mov ecx,8
        mov ah,12
        call PutText

        ; low mem.
        mov edx,_LoMemTop
        sub edx,_LoMemBase
        d2text
        mov edi,CHROW
        mov esi,offset d_text
        mov ecx,8
        mov ah,12
        call PutText


        mov esi, offset fname
        call _FLoad
        
        pushad
        mov edx,eax
        d2text
        
        mov edi,(CHROW*2)
        mov esi,offset d_text
        mov ecx,8
        mov ah,11
        call PutText
        
        mov edi,18+(CHROW*2)
        mov esi,offset fl_mem
        mov ecx,-1
        mov ah,11
        call PutText
        
        popad
        
        mov ecx,eax
        
        cmp eax,-1
        je noputthis
        mov esi,_HiMemBase
        mov edi,(CHROW*15)
        mov ah,5
        call PutText
        
        mov edi,(CHROW*14)
        mov esi,offset tt_mem
        mov ecx,-1
        mov ah,7
        call PutText
        
noputthis:       
        mov edi,(CHROW*22)+(40*CHCELL)
        mov esi,offset ex_text
        mov ecx,-1
        mov ah,10
        call PutText
        
        call _KeybInst
        
        mov edi,(CHROW*3)+100
        mov ah,7
        mov ecx,-1
        mov esi,offset rkbtext
        call PutText
        mov edi,(CHROW*4)+100
        mov ah,7
        mov ecx,-1
        mov esi,offset esctext
        call PutText
        
kkey:        
        call _WaitKey
        mov edi,(0b8000h+(CHROW*5)+120)
        sub edi,_Code32Base
        mov esi,eax
        mov ebx,16
inlup:        
        push edi
        mov ecx,8
glup:        
        lodsb
        mov dx,1720h
        test al,01
        jz zogg
        mov dx,1740h
zogg:   mov [edi],dx
        add edi,2
        dec ecx
        jne glup
        pop edi
        add edi,CHROW
        dec ebx
        jne inlup
        sub esi,128
        cmp byte ptr [esi+_ESC],KPRESSED
        je thend
        jmp kkey        
thend:        
        call zaptext
        jmp _Exit

code32  ends
        end

