#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>
#include <secure.h>

#include <string.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <os2/devhlp32.h>
#define FSD32
#include <os2/fnmatch.h>
#undef FSD32
#include "sec32.h"

/*
 * This callback is called by the OS/2 kernel before any open call issued to the kernel.
 *
 * This dummy implementation prevents ANY access to files named CONFIG.SYS, in any directory.
 */
ULONG CallType OPEN_PRE(PSZ pszPath, ULONG fsOpenFlags, ULONG fsOpenMode, ULONG SFN) { 
    int   i;
    ULONG rc;

    i = strlen(pszPath);

    while ((pszPath[i] != '\\') && (pszPath[i] != '/') && (i > 0)) i--;

    if (i) {
        if (!fnmatch("CONFIG.*", pszPath + i + 1, _FNM_OS2 | _FNM_IGNORECASE)) {
            rc = ERROR_ACCESS_DENIED;
        } else {
            rc = NO_ERROR;
        }
    } else {
        rc = ERROR_INVALID_PARAMETER;
    }
    return rc;
}

