/****************************************************************************
*                                  MAIN.C                                   *
*                                                                           *
*             Compile this module with Watcom C++ and Dos4g.                *
*       eg. WCL386 /L=DOS4G MAIN FG32.LIB FG32DPMI.LIB FG32WC.LIB           *  
*                                                                           *
*     You will need to rename main.exe PMODE1.PMP unless you change         *
*     the spawn program name.                                               *
*                                                                           *
*       NOTE* ALL FUNCTIONS ARE NEAR. THERE IS NO FAR IN FLAT MEMORY        *
*                                                                           *
*                   Copyright (c) 1995 By Mark R. Miller                    *
****************************************************************************/
#include <fastgraf.h>
#include <fgimage.h> 
#include <dos.h>
#include <i86.h>
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#ifdef __TURBOC__
#include <alloc.h>
#else
#include <malloc.h>
#endif

/* macros */
#define fade_in(start,count)  fade(1,start,count);
#define fade_out(start,count) fade(0,start,count);



int old_mode;               /*  INTEGER TO HOLD OLD VIDEO MODE NUMBER ie. 3 */  
char menu_buf[1985];        /*  A BUFFER FOR THE BEER BOTTLE CURSOR         */
char good_pal[768];         /*  OUR GOOD PAL STORAGE BUF DONT TOUCH THIS    */
char work_pal[768];
int fade_steps=32;




/* FUNCTION DECLARATIONS FOR SETUP, AND QUITTING GAME */

void main(void);
void init_mode(void);
void quit_with(int Error);
void play_sound(int sound_number);
void opener(void);  
void menu(void);
void fade(int dir, int start, int count);
void fade_init(void);


void main()
{
 
 init_mode();
 opener();
 play_sound(6);
 menu();
 fg_getdacs(0,255,work_pal);
 fg_getdacs(0,255,good_pal); 
 fade_out(0,255); 
 quit_with(0);
}





void init_mode(void)            /* Our function to check and set video mode */
{
   
   fg_initpm();                 /* FASTGRAPHSs PROTECTED MODE INIT FUNCTION */  
   old_mode=fg_getmode();       /* MOVE THE OLD MODE INTO OLD_MODE FOR LATER*/ 
   
   

   if (fg_testmode(20,4) == 0)  /* TEST FOR 320x200 VIDEO MODE WITH 4 PAGES */
       quit_with(2);            /* If not available call our quit function  */

   fg_setmode(20);              /* SET OUR MODE TO MODE 20 IF TEST = 1.     */

}


/******** QUIT_WITH IS THE ONLY EXIT...CLOSES DOWN OUR WHOLE PROJECT ********/   
   
void quit_with(Error)      /* A BUNCH OF ERROR MESSAGES, GENERIC TYPE. */
{
    static char *msg[9] = {"THANK YOU FOR PLAYING, WE HOPE YOU ENJOYED OUR GAME.",
                           "ERROR READING-WRITING FILE. PLEASE RE-RUN PROGRAM TO VERIFY. OR REINSTALL.",
                           "ERROR- VIDEO MODE NOT AVAILABLE. REQUIRES VGA 320X240 COLOR GRAPHICS MODE",
                           "ERROR- CORRUPT OR MODIFIED FILE DETECTED BY SECURITY CHECK.", 
                           "ERROR- THIS PROGRAM REQUIRES A 386 OR HIGHER PROCESSOR",
                           "ERROR- SOUND CARD ERROR, RESTART PROGRAM WITH -NS SWITCH",
                           "ERROR- MEMORY ALLOCATION ERROR, NOT ENOUGH MEMORY TO CONTINUE",
                           "ERROR- INTERNAL PROXIMITY ENGINE ERROR PLEASE SEE *HELP.TXT",
                           "ERROR- UNKNOWN ERROR, SEE HELP.TXT TO REPORT CONDITION. SORRY."};
    

   fg_setmode(old_mode);      /* SET UP THE OLD VIDEO MODE, HOPE IT'S TEXT  */
   printf("\n %s", msg[Error]);     /* PRINT THE APPROPRIATE ERROR MESSAGE  */
   fg_reset();                /* FAST GRAPHS ? RESET FUNCTION. DON'T KNOW.  */
   if(Error==0)               /* IF NORMAL EXIT, RETURN TO DOS WITH AN OK,  */
     exit(0);                 /* SO BILL KNOWS NO PROBLEM WAS ENCOUNTERED.  */
     exit(1);                 /* IF IT'S AN ERROR EXIT & LET BILL KNOW IT.  */
                              
}                          
/************** QUIT_WITH INT ERROR NUMBER, 0 IS NORMAL EXIT. ***************/   





/***** SOUND INTERUPT FUNCTION, PARAMETERS ARE INT SOUND_NUMBER TO PLAY *****/   

void play_sound(sound_number)
{
        union REGS inregs, outregs;

        inregs.w.ax = sound_number;
        int386 (0x33, &inregs, &outregs);
}

/********* CREATES AN INT 0x33 WITH ax AS THE NUMBER TO SWITCH ON. **********/   




void opener(void)  
{
   int status;                                  /* INT STORAGE              */
   
   fg_setpage(1);
   fg_move(0,0);
   status= fg_showpcx("demo.pcx",0);           /* SHOW INTRO 2 ON PAGE 1  */
   if (status!=0)
   quit_with(1);
   fg_move(0,15);
   fg_getimage(menu_buf, 124,16);                /* GET THE BOTTLE IMAGE   */
   fg_setpage(0); 
   fg_move(0,0); 
   status= fg_showpcx("menu.pcx",0);           /* SHOW INTRO 2 ON PAGE 1  */
   if (status!=0)
   quit_with(1);
}


/* THIS IS THE MENU FUNCTION, FUNCTIONS CALLED HAVE BEEN REMOVED AND SOME
   SIMPLE SOUND CALLS HAVE BEEN ADDED. THIS IS BY NO MEANS GOOD CODE, BUT
   FOR THIS EXAMPLE IT WORKS.
   DEMO.C CAN BE CHANGED TO ALSO PLAY MUSIC FILES, STOP PLAYING SPECIFIC
   SOUNDS OR ANY REQUEST TO THE INT DATA TYPE MAX.                         */

void menu(void) 
{
   int xpos=98;
   int ypos;
   int i,selection;
   unsigned key,aux;
   ypos=118;
   key=0;
   aux=0;
   selection=1;
   fg_move(xpos,ypos);                          /* OUR FIRST MENU OPTION */
   fg_drwimage(menu_buf,124,16);
   while(key!=27)
       {
        fg_getkey(&key,&aux);                    /* GET A KEY (NON KBINIT) */
        if(aux==80)                              /* if down arrow  */
             { 
             play_sound(5);                   /* move cursor, bottle clink */
             if(ypos>150)  
              {
               for(i=0; i<50; i++)
                 { ypos--;
                 fg_move(xpos,ypos);
                 fg_drwimage(menu_buf,124,16);   /* NICELY SLIDE OUR CURSOR */
                 }                               /* TO NEXT OPTION          */
                 selection=0;
                 aux=0;
                 }
                
               for(i=0; i<10; i++)
                 { ypos++;
                 fg_move(xpos,ypos);
                 fg_drwimage(menu_buf,124,16); 
                 }
                 selection+=1;
                 aux=0;
                 
              }   
               
        if(aux==72)                              /* down arrow  */
             { 
             play_sound(5);
             if(ypos<120)  
              {
               for(i=0; i<40; i++)
                 { ypos++;
                 fg_move(xpos,ypos);
                 fg_drwimage(menu_buf,124,16); 
                 }
                 selection=5;
                 aux=0;
                 
                 }
          /*   if(ypos>120)  
              {   */
                 
                 for(i=0; i<10; i++)
                 { ypos--;
                 fg_move(xpos,ypos);
                 fg_drwimage(menu_buf,124,16); 
                 }
                 selection--;
                 aux=0;
                 
               /*  } */
                } 
        if(key==13)                              /* enter key  */
             { 
                if(selection==5)                 /* IF ON EXIT GAME? BAIL */
                return;
               
               play_sound(selection);            /* IF NOT, PLAY SELECTION # */

              }

           

     }

}

/************PALETTE FADING ROUTINE, NO KEYHIT CHECKING, NO DELAY************/

void fade (int dir,int start,int count)
{
   register int k,n;
   int i,j;                           /* loop variables */
   
   /* loop through all gradations of the fade */
   for (i=dir?1:fade_steps-1; dir?i<=fade_steps:i>=0; dir?i++:i--)
   {
      /* create new (faded) palette */
      for (k=0, n=start*3, j=0; j<count; j++)
      {
         work_pal[k++] = (char)(((int)good_pal[n++] * i)/fade_steps);
         work_pal[k++] = (char)(((int)good_pal[n++] * i)/fade_steps);
         work_pal[k++] = (char)(((int)good_pal[n++] * i)/fade_steps);
      }
      fg_setdacs(start,count,work_pal); /* install new palette */
   }
}
/***************FADES IN AND OUT ANY COLOR INDEXES REQUESTED*****************/


/***********ZERO THE DAC REGISTERS IN VIDEO MEMORY BEFORE FADE IN************/
void fade_init(void)
{
   char shit_pal[768];
   /* set all palette entries to 0 */
   memset (shit_pal,0,768);

   /* set dacs to zero */
   fg_setdacs(0,256,shit_pal); 
}
/*******THIS ROUTINE IS A TEMP WILL BE INCLUDED IN LOAD LEVEL(level)*********/   



