/*
    TCC -ml VLS02.C GRAPHICS.LIB XLIB04L.LIB VIDEOF.LIB
*/

#include <graphics.h> 
#include <stdlib.h>   
#include <stdio.h>    
#include <xlib.h>
#include <xbezier.h>
#include <xpal.h>
#include <xcircle.h>
#include <vidlib.h>
#include <math.h>
#include <ctype.h>
#include <dos.h>

void helpscreen(void);
void CircleDemo(void);                                                                                                                                                      
void PolyDemo(void);     
void PutPixelDemo(void); 
void Initialize(void);   
void firstdemo(void);
void seconddemo(void);
void ShareWare(void);

int    pattern, Color, COOL=0;
int    GraphDriver;               /* The Graphics device driver            */
int    GraphMode;                 /* The Graphics mode value               */
double AspectRatio;               /* Aspect ratio of a pixel on the screen */
int    MaxX, MaxY;                /* The maximum resolution of the screen  */
int    MaxColors;                 /* The maximum # of colors available     */
int    ErrorCode;                 /* Reports any graphics errors           */
struct palettetype palette;       /* Used to read palette info             */
double db1, db2;
int SHARE=1;

#define MAX_X 79

void main(int argc, char *argv[]) 
{                                 
int i, j=1, T, B, L, R, Y1, Y2, X1, X2;
int x1, y1, x2, y2, dx1, dy1, dx2, dy2, count=0;
int x, y;
int row, col;
unsigned char color;
char far *farptr;
struct dave{
    int x;
    int y;
    } P[60], P1, P2, P3, P4;

x1=x2=y1=y2=10;
dx1=dy1=2;
dx2=dy2=3;

    if(strstr(argv[1], "?")) helpscreen();

  randomize();
  Initialize();

    while(kbhit()) getch();

Color=random(15)+1;
strupr(argv[1]);
if(argc==1){  pattern=random(31)+1;    COOL=1;  }
if(argv[1]){  pattern=atoi(argv[1]);  setcolor(random(15)+1);  }
if(argv[2]){
    strupr(argv[2]);
    if(strstr(argv[2], "COOL")) COOL=1;
    }


switch(pattern){
case 1:   setcolor(Color);
          for(L=0,R=MaxY; L<MaxY; L++,R--)
             {
			  line(0, L, MaxX, R);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
             }			  
		  for(T=MaxX,B=0; B<MaxX; B++,T--)
		     {
		      line(B, MaxY, T, 0);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
			 }                                                                                    
		  break;
		  
case 2:   setcolor(EGA_BLUE);                                             
          for(T=1; T<=MaxX; T++){
            delay(2);
            if(COOL) setcolor(random(15)+1);
            if(kbhit()) break;
            line(1, 1, T, MaxY);    }
		  setcolor(EGA_LIGHTCYAN);                                        
          for(T=MaxY; T>1; T--){
            delay(2);
            if(COOL) setcolor(random(15)+1);
            if(kbhit()) break;
            line(1, 1, MaxX, T);    }
		  break;
		  
case 3:   setcolor(1);                                              
          for(T=1; T<=MaxX; T++){   delay(2);   if(kbhit()) break;  line(1, 1, T, MaxY);   j++; if(j>25){ Color++; if(Color>15) Color=1; j=0; setcolor(Color); }     }
          for(T=MaxY; T>1; T--){    delay(2);   if(kbhit()) break;  line(1, 1, MaxX, T);   j++; if(j>25){ Color++; if(Color>15) Color=1; j=0; setcolor(Color); }     }
		  break;                                                           

case 4:   for(T=1; T<(MaxX/2)+100; T++){
			  setfillstyle(1, Color);
              circle(MaxX/2, MaxY/2, T);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
               }
          break;
		  
case 5:   setcolor(Color);
          for(L=0,R=MaxY,T=MaxX,B=0; L<MaxY+50; L++,R--,B++,T--)
		     {                                                                                   
		      line(0, L, MaxX, R);                                                               
              line(B, MaxY, T, 0);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
		     }                                                                                   
		  break;

case 6:   PutPixelDemo(); 
		  break;
case 7:   CircleDemo(); 
		  break;
case 8:   PolyDemo(); 
		  break;

case 9:   for(i=1; i<500; i++){
            Y1=random(MaxY);
            Y2=random(MaxY);     		  
  		    X1=random(MaxX); 
		    X2=random(MaxX); 
		    setcolor(random(15)+1);
		    line(X1, MaxY, X2, 0);
		    setcolor(random(15)+1);
		    line(0, Y1, MaxX, Y2);
            if(kbhit()) break;
		    delay(15);                  }
          break;
          
case 10:  setcolor(Color);
          for(T=0,L=0; L<MaxX; T++,L++){
              line(L, 0, L, MaxY);
              line(0, T, MaxX, T);
              if(kbhit()) break;
              if(COOL)  setcolor(random(15)+1);
			     }
		  break;
		  
case 11:  setcolor(Color);
          for(T=MaxX/2; T<MaxX; T++){
              line(MaxX/2, MaxY/2, T, 0);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
			    }
		  for(R=0; R<MaxY; R++){                                                              
              line(MaxX/2, MaxY/2, MaxX, R);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
		        }                                                                                  
		  for(B=MaxX; B>0; B--){                                                              
              line(MaxX/2, MaxY/2, B, MaxY);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
		        }                                                                                  
		  for(L=MaxY; L>0; L--){                                                              
              line(MaxX/2, MaxY/2, 0, L);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
		        }                                                                                  
		  for(T=0; T<MaxX/2; T++){                                                              
              line(MaxX/2, MaxY/2, T, 0);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
		        }                                                                                  
		  break;

case 12:  setcolor(Color);
          for(B=MaxY,L=0; L<MaxY; B--,L++){
              line(0, L, MaxX, L);
              line(0, B, MaxX, B);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
			   }                                                                                  
          break;

case 13:  for(R=MaxX,L=0; L<MaxX; R--,L++){
              line(L, 0, L, MaxY);
              line(R, 0, R, MaxY);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
               }
		  break;
		   
case 14:  for(T=MaxX,B=0; B<MaxX; T--,B++){
              line(0, 0, B, MaxY);
              line(MaxX, MaxY, T, 0);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
               }
		  for(R=MaxY,L=0; L<MaxY; R--,L++){                                                         
		      line(0, 0, MaxX, R);                                                                  
              line(MaxX, MaxY, 0, L);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
		       }                                                                                    
		  break;
		  
case 15:  for(L=0,R=MaxX; L<MaxY+200; R--,L++){
              line(0, L, R, MaxY);
              line(L, 0, MaxX, R);
              if(kbhit()) break;
              if(COOL) setcolor(random(15)+1);
                }   
          break;
          
case 16:  for(i=1; i<120; i++){
		    Y1=random(MaxY);             
		    Y2=random(MaxY);             
		    X1=random(MaxX);             
		    X2=random(MaxX);             
		    setcolor(random(15)+1);      
		    line(X1, MaxY, X2, 0);       
		    setcolor(random(15)+1);      
		    line(0, Y1, MaxX, Y2);       
		    delay(25); 
		    setcolor(0);
			line(X1, MaxY, X2, 0);        
            line(0, Y1, MaxX, Y2);
            if(kbhit()) break;
		    delay(25);                      }                                                
           break;

case 17:  setcolor(Color);
          for(L=0; L<MaxY; L++){
               line(0, L, MaxX, L);
               if(kbhit()) break;
               if(COOL) setcolor(random(15)+1);
                }
          setcolor(0);
          for(L=0; L<MaxY; L++) line(0, L, MaxX, L);
          break;

case 18:  Y1=random(MaxY);
          Y2=random(MaxY);
          X1=random(MaxX);
          X2=random(MaxX);
          for(i=1;i<1000;i++){
            setcolor(random(15)+1);
            setlinestyle(SOLID_LINE, 0, THICK_WIDTH);
            line(X1, Y1, X2, Y2);
            X1=X2;
            Y1=Y2;
            Y2=random(MaxY);
            X2=random(MaxX);
            if(kbhit()) break;
            }
          break;

case 19:  for(i=0; i<3000; i++){
            line(x1, y1, x2, y2);
            x1+=dx1;    y1+=dy1;
            x2+=dx2;    y2+=dy2;
            if(x1<=0 || x1>=MaxX) dx1=-dx1;
            if(y1<=0 || y1>=MaxY) dy1=-dy1;
            if(x2<=0 || x2>=MaxX) dx1=-dx2;
            if(y2<=0 || y2>=MaxY) dy2=-dy2;
            if(kbhit()) break;
            if(++count > 100){
                setcolor(Color);
                Color=(Color >= 15) ? 0 : ++Color;
                count=0;
                }
            }
            break;

case 20:  for(j=0;j<2;j++){
          P1.x=P2.x=P3.x=P4.x=MaxX/2;
          P1.y=P2.y=P3.y=P4.y=MaxY/2;
          for(i=0;i<500;i++){
            if(COOL) setcolor(random(15)+1);
            if(!COOL) setcolor(1);
            line(P1.x, P1.y, P2.x, P2.y);
            if(COOL) setcolor(random(15)+1);
            if(!COOL) setcolor(4);
            line(P2.x, P2.y, P3.x, P3.y);
            if(COOL) setcolor(random(15)+1);
            if(!COOL) setcolor(14);
            line(P3.x, P3.y, P4.x, P4.y);
            if(COOL) setcolor(random(15)+1);
            if(!COOL) setcolor(10);
            if(kbhit()) break;
            line(P4.x, P4.y, P1.x, P1.y);
            P1.y--;   P1.x--;
            P2.y--;   P2.x++;
            P3.y++;   P3.x++;
            P4.y++;   P4.x--;
            }
           if(!COOL) break;
           COOL=0;      }
           break;

case 21:  firstdemo();
          break;

case 22:  seconddemo();
          break;

case 23:  B=1;
          for(T=MaxX/2; T>(MaxX/4)-50; T-=10){
              setcolor(B);
              B++;
              if(B>15) B=1;
              if(kbhit()) break;
              for(i=0; i<MaxY/2; i+=10){
                  ellipse(MaxX/2, MaxY/2, 0, 360, T, i);
                                      }
                                        }
          break;

case 24:  for(j=230; j>1; j-=10){
              L++;
              if(L>15) L=1;
          for(i=0; i<MaxX; i++){
              db1=((double)i / 100) * (2 * 3.14159265);
              db2=sin(db1);
              x1= (MaxY/2)-(j*db2);
              putpixel(i, x1, L);
              if(kbhit()) break;
                               }
                                }
          break;

				
case 25:  setcolor(1);
          for(L=MaxX/2,R=MaxX/2; L>0; L--,R++){
				line(MaxX/2, 0, L, MaxY);
                if(kbhit()) break;
				if(COOL) setcolor(random(15)+1); 
				line(MaxX/2, 0, R, MaxY);    }
		  for(L=MaxX/2,R=MaxX/2; L>0; L--,R++){
		  		line(0, MaxY, L, 0);
                if(kbhit()) break;
		  		if(COOL) setcolor(random(15)+1); 
		  		line(MaxX, MaxY, R, 0);      }
		  setcolor(14);
		  for(L=0,R=MaxX; R>MaxX/2; L++,R--){
		  		line(0, 0, L, MaxY);
                if(kbhit()) break;
		  		if(COOL) setcolor(random(15)+1); 
		  		line(MaxX, 0, R, MaxY);   }
		  for(L=0,R=MaxX; R>MaxX/2; L++,R--){
		  		line(MaxX/2, MaxY, L, 0);
                if(kbhit()) break;
		  		if(COOL) setcolor(random(15)+1); 
		  		line(MaxX/2, MaxY, R, 0);    }
		  break;
		  
case 26:  for(L=MaxY,R=0; L>0; L--,R++){
				setcolor(14);
				if(COOL) setcolor(random(15)+1); 
				line(0, L, MaxX, R);
				setcolor(1);
                if(COOL) setcolor(random(15)+1);
                if(kbhit()) break;
				line(0, R, MaxX, L);	}
		  break;
		  
case 27:  for(L=MaxX,R=0; L>0; L--,R++){
				setcolor(14);
				if(COOL) setcolor(random(15)+1); 
				line(R, 0, L, MaxY);
				setcolor(1);
                if(COOL) setcolor(random(15)+1);
                if(kbhit()) break;
				line(L, 0, R, MaxY);	}
		  break;
		  
case 28:  for(L=MaxY,R=0; L>0; L--,R++){ 
		        setcolor(14);            
		        if(COOL) setcolor(random(15)+1); 
		        line(0, L, MaxX, R);     
		        setcolor(1);             
                if(COOL) setcolor(random(15)+1);
                if(kbhit()) break;
		        line(0, R, MaxX, L);    }
		  for(L=MaxX,R=0; L>0; L--,R++){ 
		        setcolor(14);            
		        if(COOL) setcolor(random(15)+1); 
		        line(R, 0, L, MaxY);     
                setcolor(1);
                if(kbhit()) break;
		        if(COOL) setcolor(random(15)+1); 
		        line(L, 0, R, MaxY);    }
		  break;                         

case 29: farptr = (char far *) 0xA0000000;
         for(y=0; y<MaxY; y++)
             for(x=0; x<MaxX; x++){
                 if(kbhit()) break;
                 col = x/(MaxX/16);
                 row = y/(MaxY/16);
                 color = col + row*16;
                 *(farptr + y*MaxX + x) = color;
                 }
         break;

case 30: x1=10; y1=10; x2=4; y2=4;
         for(T=0; T<50000; T++)
          {
             x1+=x2;  y1+=y2;
             B++;
             if(B>100){ B=0;  i=random(14)+1; }
             if(x1<10 || x1>MaxX-20) x2*=-1;
             if(y1<10 || y1>MaxY-20) y2*=-1;
             if(kbhit()) break;
             putpixel(x1, y1, i);
          }
         break;

case 31: setcolor(14);
         for(i=0; i<60; i++){  P[i].x=0;  P[i].y=0;  }
         x1=10; y1=10; x2=4; y2=4;
         for(B=0; B<500; B++)
          {
             x1+=x2;  y1+=y2;
             if(x1<10 || x1>MaxX-20) x2*=-1;
             if(y1<10 || y1>MaxY-20) y2*=-1;

             for(i=60; i>0; i--){  P[i].x=P[i-1].x;  P[i].y=P[i-1].y;  }
             P[0].x=x1;  P[0].y=y1;

             setcolor(random(14)+1);
             circle(x1, y1, 20);
             setcolor(0);
             circle(P[60].x, P[60].y, 20);
             if(kbhit()) break;
             delay(25);
          }
         break;

default:  break;
           }


closegraph();
clrscr();
ShareWare();
exit(0);
}


void PutPixelDemo(void)                         
{                                               
  int seed = 1958;                              
  int i, x, y, h, w, color;                     
  struct viewporttype vp;                       
                                                
  getviewsettings( &vp );                       
  h = vp.bottom - vp.top;                       
  w = vp.right  - vp.left;                      
                                                
  srand( seed );                                
                                                
  for( i=0 ; i<19000 ; ++i ){                    
    x = 1 + random( w - 1 );                    
    y = 1 + random( h - 1 );                    
    color = random( 15 );                
    if(kbhit()) break;
    putpixel( x, y, color );                    
  }                                             
}


#define MaxPts      6                          
                                               
void PolyDemo(void)                            
{                                              
  struct PTS {int x, y;};                      
  struct PTS poly[MaxPts];                     
  int color;                                   
  int i, p;                                    
                                               
  for(p=0;p<60;p++){                           
    color = 1 + random( MaxColors-1 );         
    setfillstyle( 1, color );                  
    setcolor( color );                         
                                               
    for( i=0 ; i<MaxPts-1 ; i++ ){             
      poly[i].x = random( MaxX );              
      poly[i].y = random( MaxY );              
    }                                          
                                               
    poly[i].x = poly[0].x;                     
    poly[i].y = poly[1].y;                     
                                               
    fillpoly(MaxPts, (int far *)poly );        
    if(kbhit()) break;
  }                                            
} 


void Initialize(void)                                                                 
{                                                                                     
  int xasp, yasp;                                                                     

  if(registerbgidriver(IBM8514_driver) < 0) exit(1);
  if(registerbgidriver(EGAVGA_driver) < 0) exit(1);                                   

  if(registerfarbgifont(triplex_font_far) <0) exit(1);
                                                                                      
  GraphDriver = DETECT;                                                               
  initgraph( &GraphDriver, &GraphMode, "" );                                          
  ErrorCode = graphresult();                                                          
  if( ErrorCode != grOk ){                                                            
    printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );              
    exit( 1 );                                                                        
  }                                                                                   
                                                                                      
  getpalette( &palette );                                                             
  MaxColors = getmaxcolor() + 1;                                                      
                                                                                      
  MaxX = getmaxx();                                                                   
  MaxY = getmaxy();                                                                   
                                                                                      
  getaspectratio( &xasp, &yasp );                                                     
  AspectRatio = (double)xasp / (double)yasp;                                          
}


void CircleDemo(void)                                                                                                                                                      
{                                                                                     
  int mradius, i;             
                                                                                      
  mradius = MaxY / 10;     
                                                                                      
  for(i=0;i<1000;i++){     
    setcolor( random( 15 ) + 1 );  
    circle( random(MaxX), random(MaxY), random(mradius) );                            
    if(kbhit()) break;
  }         
}                                                                                     

void helpscreen(void)
{
int b;

printf("\n                                                           ");
printf("\n                     ķ ķ ķ       ķ ķ ķ ķ ");
printf("\n                              Ľ         ");
printf("\n                     2.1                                       ");
printf("\n\n                        Usage:  VLS [pattern] [COOL]           ");
printf("\n                    'COOL' alternates color every pixel    ");
printf("\n\n   1    Moving round          12   Shades pulled       23   Quick balls");
printf("\n   2    Slide up              13   Close curtain       24   Nice curves");
printf("\n   3    Slide up colorful     14   Double swivel       25   Open and shut");
printf("\n   4    Exploding ball        15   Open diagonal       26   Side shadows");
printf("\n   5    Round and round       16   Shooting lines      27   Top shadows");
printf("\n   6    Stars                 17   Falling brick       28   Both shadows");
printf("\n   7    Circles               18   Squirmy lines       29   Window panes");
printf("\n   8    Polygons              19   Wiggly line         30   City lights");
printf("\n   9    Yarn Ball             20   Square explode      31   Snake!     ");
printf("\n   10   Slide across          21   Wow !                               ");
printf("\n   11   Clock                 22   Moving curves                       ");
printf("\n\n              Copyright 1994    David Smith    All Rights Reserved \n");
exit(0);
}

void firstdemo(void)
{
    int i;

    x_set_mode(1, 320);
    for (i = 0; i < 150; i++) {
        delay(30);
        x_filled_circle(10 + i, i-20, 301 - (i << 1), i+1, 0);
        if(kbhit()) break;
    }
    delay(400);

    x_text_mode();
}

void seconddemo(void)
{
    int i, r, g, b;

    x_set_mode(X_MODE_360x480, 360);

    for (b = 0; b <14; b++)
        for (g = 0; g < 4; g++)
            for (r = 0; r <10; r++){
                if(kbhit()) break;
                x_set_rgb(b + 6 * g + 36 * r,
                          12 * b + 3, 12 * g + 3, 12 * r + 3);    }

    for (i = 216; i < 256; i++){
        if(kbhit()) break;
        x_set_rgb(i, i - 193, i - 193, 279 - i);       }

    for (i = 0; i <= 1180; i++) {
        x_bezier(i, 240, 90, i, 170, 279-i, 359 - i, 140,
                 6, i ,0);
        if(kbhit()) break;
    }

    for (i = 920; i >= 0; i--) {
        x_bezier(150 - i, i/3, 360 - i, i, i, i, i, i/3,
                 4, i ,0);
        x_bezier(240 - i, 479-i/3, 360 - i, 479-i, i, 479-i, i, 479-i/3,
                 4, i+5 ,0);
        if(kbhit()) break;
    }

     delay(400);

    x_text_mode();
}


void ShareWare(void)
{
}
