/*
          |
       Y  |
          |
          ---------
               X
*/
#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <stdarg.h>

#define ESC 0x1b                 /* Define the escape key    */
#define TRUE    1                /* Define some handy constants  */
#define FALSE   0                /* Define some handy constants  */
#define PI  3.14159              /* Define a value for PI    */
#define ON  1                    /* Define some handy constants  */
#define OFF 0                    /* Define some handy constants  */
#define NFONTS 11

int    GraphDriver;               /* The Graphics device driver       */
int    GraphMode;                 /* The Graphics mode value      */
double AspectRatio;               /* Aspect ratio of a pixel on the screen*/
int    MaxX, MaxY;                /* The maximum resolution of the screen */
int    MaxColors;                 /* The maximum # of colors available    */
int    ErrorCode;                 /* Reports any graphics errors      */
struct palettetype palette;       /* Used to read palette info    */
int totdirs=1, totfiles=0;
int compress, execu, docs, data, prog, graph, wind, syst;

void PolyDemo(void);
void PutPixelDemo(void);
void Ending(void);
void Bar3D(int onex, int oney, int twox, int twoy, ... );
void changetextstyle(int font, int direction, int charsize);
void Pause(void);
int gprintf( int *xloc, int *yloc, char *fmt, ... );
void Initialize(void);
void getfiles(void);
void show(char *stuff, int w, int w2);
void ShareWare(void);


int zip,arj,arcs,zoo,sqz,lzh,exe,bat,com,doc,txt,hlp,dat,tmp,log,eng,man;
int bas,pas,lib,asms,obj,c,h,tpu,tch,map,sys,dsk,set,cfg,prn;
int pcx,gif,tif,mac,wpg,img,fra,cit,tga;
int bmp,ini,pif,grp,fon,dll,drv,mod,inf, onlyhere=1;
char origdir[130];




void main(int argc, char *argv[])
{
int i, a, b, xmult, xdiv, ymult, ydiv;

getcwd(origdir, 128);

if(argc==1) onlyhere=1;
strupr(argv[1]);
if(strstr(argv[1], "/S")){ onlyhere=0; chdir("\\"); }
if(strstr(argv[1], "\\")) chdir(argv[1]);

zip=arj=arcs=zoo=sqz=lzh=exe=bat=com=doc=txt=hlp=dat=tmp=log=eng=man=0;
bas=pas=lib=asms=obj=c=h=tpu=tch=map=sys=dsk=set=cfg=prn=0;
pcx=gif=tif=mac=wpg=img=fra=cit=tga=0;
bmp=ini=pif=grp=fon=dll=drv=mod=inf=0;

    Initialize();

 setcolor(10);
 line(5, 5, 5, MaxY-30);
 line(5,MaxY-30, MaxX-40,MaxY-30);
 line(MaxX-40, MaxY-30, MaxX-40,5);


 b=0;
 for(i=MaxY-30; i>25; i-=50){
       setcolor(10);
     line(5, i, MaxX-40, i);
     moveto(MaxX-26, i);
       setcolor(14);
     if(b==0) outtext ("0" );
     if(b==1) outtext ("25");
     if(b==2) outtext ("50");
     if(b==3) outtext ("75");
     if(b==4) outtext("100");
     if(b==5) outtext("125");
     if(b==6) outtext("150");
     if(b==7) outtext("175");
     if(b==8) outtext("200");
     b++;
     }



       setcolor(9);
       outtextxy(535,MaxY-290,"Dave's");
       outtextxy(535,MaxY-270,"File");
       setcolor(8);
       outtextxy(535,MaxY-250,"Usage");
       setcolor(9);
       outtextxy(535,MaxY-230,"Graph 2");
       setcolor(11);
       outtextxy(530,MaxY-210,"(c) 1994");


 getfiles();

setcolor(3);
setfillstyle(1, 1);
 Bar3D( 15, MaxY-30-zip-zip,  20, MaxY-30, 2, 1);
 Bar3D( 25, MaxY-30-arcs-arcs, 30, MaxY-30, 2, 1);
 Bar3D( 35, MaxY-30-zoo-zoo,  40, MaxY-30, 2, 1);
 Bar3D( 45, MaxY-30-sqz-sqz,  50, MaxY-30, 2, 1);
 Bar3D( 55, MaxY-30-arj-arj,  60, MaxY-30, 2, 1);
 Bar3D( 65, MaxY-30-lzh-lzh,  70, MaxY-30, 2, 1);
 compress=zip+arcs+zoo+sqz+arj+lzh;

setcolor(11);
setfillstyle(2, 2);
 Bar3D( 75, MaxY-30-exe-exe,  80, MaxY-30, 2, 1);
 Bar3D( 85, MaxY-30-bat-bat,  90, MaxY-30, 2, 1);
 Bar3D( 95, MaxY-30-com-com,  100, MaxY-30, 2, 1);
 Bar3D( 105, MaxY-30-bat-bat, 110, MaxY-30, 2, 1);
 execu=exe+bat+com;

setcolor(15);
setfillstyle(3, 3);
 Bar3D( 115, MaxY-30-doc-doc, 120, MaxY-30, 2, 1);
 Bar3D( 125, MaxY-30-txt-txt, 130, MaxY-30, 2, 1);
 Bar3D( 135, MaxY-30-hlp-hlp, 140, MaxY-30, 2, 1);
 Bar3D( 145, MaxY-30-log-log, 150, MaxY-30, 2, 1);
 Bar3D( 155, MaxY-30-man-man, 160, MaxY-30, 2, 1);
 docs=doc+txt+hlp+log+man;

setcolor(9);
setfillstyle(4, 4);
 Bar3D( 165, MaxY-30-eng-eng, 170, MaxY-30, 2, 1);
 Bar3D( 175, MaxY-30-dat-dat, 180, MaxY-30, 2, 1);
 Bar3D( 185, MaxY-30-tmp-tmp, 190, MaxY-30, 2, 1);
 data=eng+dat+tmp;

setcolor(13);
setfillstyle(10, 5);
 Bar3D( 195, MaxY-30-bas-bas, 200, MaxY-30, 2, 1);
 Bar3D( 205, MaxY-30-pas-pas, 210, MaxY-30, 2, 1);
 Bar3D( 215, MaxY-30-lib-lib, 220, MaxY-30, 2, 1);
 Bar3D( 225, MaxY-30-asms-asms,230, MaxY-30, 2, 1);
 Bar3D( 235, MaxY-30-obj-obj, 240, MaxY-30, 2, 1);
 Bar3D( 245, MaxY-30-c-c,  250, MaxY-30, 2, 1);
 Bar3D( 255, MaxY-30-h-h, 260, MaxY-30, 2, 1);
 Bar3D( 265, MaxY-30-tpu-tpu, 270, MaxY-30, 2, 1);
 Bar3D( 275, MaxY-30-tch-tch, 280, MaxY-30, 2, 1);
 Bar3D( 285, MaxY-30-map-map, 290, MaxY-30, 2, 1);
 prog=bas+pas+lib+asms+obj+c+h+tpu+tch+map;

setcolor(7);
setfillstyle(11, 6);
 Bar3D( 295, MaxY-30-sys-sys, 300, MaxY-30, 2, 1);
 Bar3D( 305, MaxY-30-dsk-dsk, 310, MaxY-30, 2, 1);
 Bar3D( 315, MaxY-30-set-set, 320, MaxY-30, 2, 1);
 Bar3D( 325, MaxY-30-cfg-cfg, 330, MaxY-30, 2, 1);
 Bar3D( 335, MaxY-30-prn-prn, 340, MaxY-30, 2, 1);
 syst=sys+dsk+set+cfg+prn;

setcolor(6);
setfillstyle(7, 7);
 Bar3D( 345, MaxY-30-pcx-pcx, 350, MaxY-30, 2, 1);
 Bar3D( 355, MaxY-30-gif-gif, 360, MaxY-30, 2, 1);
 Bar3D( 365, MaxY-30-tif-tif, 370, MaxY-30, 2, 1);
 Bar3D( 375, MaxY-30-mac-mac, 380, MaxY-30, 2, 1);
 Bar3D( 385, MaxY-30-wpg-wpg, 390, MaxY-30, 2, 1);
 Bar3D( 395, MaxY-30-img-img, 400, MaxY-30, 2, 1);
 Bar3D( 405, MaxY-30-fra-fra, 410, MaxY-30, 2, 1);
 Bar3D( 415, MaxY-30-cit-cit, 420, MaxY-30, 2, 1);
 Bar3D( 425, MaxY-30-tga-tga, 430, MaxY-30, 2, 1);
 graph=pcx+gif+tif+mac+wpg+img+fra+cit+tga;

setcolor(11);
setfillstyle(8, 8);
 Bar3D( 435, MaxY-30-bmp-bmp, 440, MaxY-30, 2, 1);
 Bar3D( 445, MaxY-30-ini-ini, 450, MaxY-30, 2, 1);
 Bar3D( 455, MaxY-30-pif-pif, 460, MaxY-30, 2, 1);
 Bar3D( 465, MaxY-30-grp-grp, 470, MaxY-30, 2, 1);
 Bar3D( 475, MaxY-30-fon-fon, 480, MaxY-30, 2, 1);
 Bar3D( 485, MaxY-30-dll-dll, 490, MaxY-30, 2, 1);
 Bar3D( 495, MaxY-30-drv-drv, 500, MaxY-30, 2, 1);
 Bar3D( 505, MaxY-30-mod-mod, 510, MaxY-30, 2, 1);
 Bar3D( 515, MaxY-30-inf-inf, 520, MaxY-30, 2, 1);
 wind=bmp+ini+pif+grp+fon+dll+drv+mod+inf;


    /*       settextstyle(2, 0, 1);  */

           changetextstyle( DEFAULT_FONT, HORIZ_DIR, 1 );


setcolor(3);  outtextxy(15, MaxY-25, "COMPR");
setcolor(11); outtextxy(75, MaxY-25, "EXEC");
setcolor(15); outtextxy(115, MaxY-25,"DOCS");
setcolor(9);  outtextxy(165, MaxY-25, "DAT");
setcolor(13); outtextxy(195, MaxY-25,"PROGRAMMING");
setcolor(7);  outtextxy(295, MaxY-25,"SYSTEM");
setcolor(6);  outtextxy(352, MaxY-25,"GRAPHICS");
setcolor(11); outtextxy(445, MaxY-25, "WINDOWS");


  changetextstyle( DEFAULT_FONT, VERT_DIR, 1 );

  if(zip>3) show("zip", zip,15);
  if(arcs>3)show("arc", arcs,25);
  if(zoo>3) show("zoo", zoo,35);
  if(sqz>3) show("sqz", sqz,45);
  if(arj>3) show("arj", arj,55);
  if(lzh>3) show("lzh", lzh,65);
  if(exe>3) show("exe", exe,75);
  if(bat>3) show("bat", bat,85);
  if(com>3) show("com", com,95);
  if(doc>3) show("doc", doc,115);
  if(txt>3) show("txt", txt,125);
  if(hlp>3) show("hlp", hlp,135);
  if(log>3) show("log", log,145);
  if(man>3) show("man", man,155);
  if(eng>3) show("eng", eng,165);
  if(dat>3) show("dat", dat,175);
  if(tmp>3) show("tmp", tmp,185);
  if(bas>3) show("bas", bas,195);
  if(pas>3) show("pas", pas,205);
  if(lib>3) show("lib", lib,215);
  if(asms>3)show("asm", asms,225);
  if(obj>3) show("obj", obj, 235);
  if(c>3)   show("c"  , c  , 245);
  if(h>3)   show("h"  , h  , 255);
  if(tpu>3) show("tpu", tpu, 265);
  if(tch>3) show("tch", tch, 275);
  if(map>3) show("map", map, 285);
  if(sys>3) show("sys", sys, 295);
  if(dsk>3) show("dsk", dsk, 305);
  if(set>3) show("set", set, 315);
  if(cfg>3) show("cfg", cfg, 325);
  if(prn>3) show("prn", prn, 335);
  if(pcx>3) show("pcx", pcx, 345);
  if(gif>3) show("gif", gif, 355);
  if(tif>3) show("tif", tif, 365);
  if(mac>3) show("mac", mac, 375);
  if(wpg>3) show("wpg", wpg, 385);
  if(img>3) show("img", img, 395);
  if(fra>3) show("fra", fra, 405);
  if(cit>3) show("cit", cit, 415);
  if(tga>3) show("tga", tga, 425);
  if(bmp>3) show("bmp", bmp, 435);
  if(ini>3) show("ini", ini, 445);
  if(pif>3) show("pif", pif, 455);
  if(grp>3) show("grp", grp, 465);
  if(fon>3) show("fon", fon, 475);
  if(dll>3) show("dll", dll, 485);
  if(drv>3) show("drv", drv, 495);
  if(mod>3) show("mod", mod, 505);
  if(inf>3) show("inf", inf, 515);

 getch();
 PolyDemo();
 Ending();
chdir(origdir);
exit(1);
}



void Bar3D(int onex, int oney, int twox, int twoy, ... )
{
  if(oney < MaxY-415) oney=MaxY-415;
  bar3d(onex,oney,twox,twoy,2,1);
}



void getfiles(void)
{
struct ffblk dta;
int done, hag=0, cag=0;
char curdir[31], temp[4];

getcwd(curdir, 30);

done=findfirst("*.*", &dta, 47);
while(!done)
  {
 totfiles++;
 if(strstr(dta.ff_name, ".ZIP")) zip++;
 if(strstr(dta.ff_name, ".ARC")) arcs++;
 if(strstr(dta.ff_name, ".ZOO")) zoo++;
 if(strstr(dta.ff_name, ".SQZ")) sqz++;
 if(strstr(dta.ff_name, ".ARJ")) arj++;
 if(strstr(dta.ff_name, ".LZH")) lzh++;
 if(strstr(dta.ff_name, ".EXE")) exe++;
 if(strstr(dta.ff_name, ".BAT")) bat++;
 if(strstr(dta.ff_name, ".COM")){ com++; cag=1; }
 if(strstr(dta.ff_name, ".DOC")) doc++;
 if(strstr(dta.ff_name, ".TXT")) txt++;
 if(strstr(dta.ff_name, ".HLP")){ hlp++; hag=1; }
 if(strstr(dta.ff_name, ".DAT")) dat++;
 if(strstr(dta.ff_name, ".TMP")) tmp++;
 if(strstr(dta.ff_name, ".LOG")) log++;
 if(strstr(dta.ff_name, ".ENG")) eng++;
 if(strstr(dta.ff_name, ".MAN")) man++;
 if(strstr(dta.ff_name, ".BAS")) bas++;
 if(strstr(dta.ff_name, ".PAS")) pas++;
 if(strstr(dta.ff_name, ".LIB")) lib++;
 if(strstr(dta.ff_name, ".ASM")) asms++;
 if(strstr(dta.ff_name, ".OBJ")) obj++;
 if(strstr(dta.ff_name, ".TPU")) tpu++;
 if(strstr(dta.ff_name, ".TCH")) tch++;
 if(strstr(dta.ff_name, ".MAP")) map++;
 if(strstr(dta.ff_name, ".SYS")) sys++;
 if(strstr(dta.ff_name, ".DSK")) dsk++;
 if(strstr(dta.ff_name, ".SET")) set++;
 if(strstr(dta.ff_name, ".CFG")){ cfg++; cag=1; }
 if(strstr(dta.ff_name, ".PRN")) prn++;
 if(strstr(dta.ff_name, ".PCX")) pcx++;
 if(strstr(dta.ff_name, ".GIF")) gif++;
 if(strstr(dta.ff_name, ".TIF")) tif++;
 if(strstr(dta.ff_name, ".MAC")) mac++;
 if(strstr(dta.ff_name, ".WPG")) wpg++;
 if(strstr(dta.ff_name, ".IMG")) img++;
 if(strstr(dta.ff_name, ".FRA")) fra++;
 if(strstr(dta.ff_name, ".CIT")){ cit++; cag=1; }
 if(strstr(dta.ff_name, ".TGA")) tga++;
 if(strstr(dta.ff_name, ".BMP")) bmp++;
 if(strstr(dta.ff_name, ".INI")) ini++;
 if(strstr(dta.ff_name, ".PIF")) pif++;
 if(strstr(dta.ff_name, ".GRP")) grp++;
 if(strstr(dta.ff_name, ".FON")) fon++;
 if(strstr(dta.ff_name, ".DLL")) dll++;
 if(strstr(dta.ff_name, ".DRV")) drv++;
 if(strstr(dta.ff_name, ".MOD")) mod++;
 if(strstr(dta.ff_name, ".INF")) inf++;
 if(strstr(dta.ff_name, ".C") && !cag) c++;
 if(strstr(dta.ff_name, ".H") && !hag) h++;
    cag=0;    hag=0;
    done=findnext(&dta);
    }
 if(onlyhere) return;

done=findfirst("*.*",&dta,FA_DIREC+FA_SYSTEM+FA_HIDDEN);
while(!done)
 {
 strncpy(temp,dta.ff_name,2);
 if(((dta.ff_attrib & FA_DIREC) == FA_DIREC) && (temp[0] !='.'))
  {
   totdirs++;
   if(strlen(curdir) !=3)
    strcat(curdir,"\\");
   strcat(curdir,dta.ff_name);
   chdir(curdir);
   getfiles();
   chdir("..");
   getcwd(curdir, 30);
   }
 done=findnext(&dta);
 }
}

void show(char *stuff, int w, int w2)
{
char tosee[40];
int WhereY;

WhereY=MaxY-85-w-w;
if(WhereY < MaxY-470) WhereY=MaxY-470;

moveto (w2+4, WhereY);
sprintf(tosee, "%s %d", stuff, w);

textcolor(15);
outtext(tosee);
}

void Initialize(void)
{
  int xasp, yasp;           /* Used to read the aspect ratio*/

  if(registerbgidriver(EGAVGA_driver) < 0) exit(1);
  if(registerbgidriver(CGA_driver) < 0) exit(1);
  if(registerbgidriver(Herc_driver) < 0) exit(1);
  if(registerbgidriver(IBM8514_driver) < 0) exit(1);

  if(registerfarbgifont(triplex_font_far) <0) exit(1);
  if(registerfarbgifont(gothic_font_far) <0) exit(1);
  if(registerfarbgifont(small_font_far) <0) exit(1);

  GraphDriver = DETECT;         /* Request auto-detection   */
  initgraph( &GraphDriver, &GraphMode, "" );
  ErrorCode = graphresult();        /* Read result of initialization*/
  if( ErrorCode != grOk ){      /* Error occured during init    */
    printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );
    exit( 1 );
  }

  getpalette( &palette );       /* Read the palette from board  */
  MaxColors = getmaxcolor() + 1;    /* Read maximum number of colors*/

  MaxX = getmaxx();
  MaxY = getmaxy();         /* Read size of screen      */

  getaspectratio( &xasp, &yasp );   /* read the hardware aspect */
  AspectRatio = (double)xasp / (double)yasp; /* Get correction factor   */
}

/*                                  */
/*  GPRINTF: Used like PRINTF except the output is sent to the  */
/*  screen in graphics mode at the specified co-ordinate.       */
/*                                  */

int gprintf( int *xloc, int *yloc, char *fmt, ... )
{
  va_list  argptr;          /* Argument list pointer    */
  char str[140];            /* Buffer to build sting into   */
  int cnt;              /* Result of SPRINTF for return */

  va_start( argptr, fmt );      /* Initialize va_ functions */

  cnt = vsprintf( str, fmt, argptr );   /* prints string to buffer  */
  outtextxy( *xloc, *yloc, str );   /* Send string in graphics mode */
  *yloc += textheight( "H" ) + 2;       /* Advance to next line         */

  va_end( argptr );         /* Close va_ functions      */

  return( cnt );            /* Return the conversion count  */

}

/*                                  */
/*  PAUSE: Pause until the user enters a keystroke. If the      */
/*  key is an ESC, then exit program, else simply return.       */
/*                                  */

void Pause(void)
{
  int c;

  c = getch();              /* Read a character from kbd    */

  if( ESC == c ){           /* Does user wish to leave? */
    closegraph();           /* Change to text mode      */
    exit( 1 );              /* Return to OS         */
  }

  if( 0 == c ){             /* Did use hit a non-ASCII key? */
    c = getch();            /* Read scan code for keyboard  */
  }

  cleardevice();            /* Clear the screen     */

}

/*                                  */
/*  CHANGETEXTSTYLE: similar to settextstyle, but checks for    */
/*  errors that might occur whil loading the font file.     */
/*                                  */

void changetextstyle(int font, int direction, int charsize)
{
  int ErrorCode;

  graphresult();            /* clear error code     */
  settextstyle(font, direction, charsize);
  ErrorCode = graphresult();        /* check result         */
  if( ErrorCode != grOk ){      /* if error occured     */
    closegraph();
    printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );
    exit( 1 );
  }
}


void Ending(void)
{
int x, y;
struct viewporttype     viewinfo; /* Params for inquiry procedures*/
char *driver, *mode;          /* Strings for driver and mode  */

  driver = getdrivername();
  mode = getmodename(GraphMode);    /* get current setting      */
  getviewsettings( &viewinfo );

    cleardevice();
    PutPixelDemo();

    setcolor(EGA_BLUE);
    for(x=1; x<=MaxX; x++){   delay(2);   line(1, 1, x, MaxY);    }
    setcolor(EGA_LIGHTCYAN);
    for(x=MaxY; x>1; x--){    delay(2);   line(1, 1, MaxX, x);    }
    closegraph();

    clrscr();
    printf("\n          ͸");
    printf("\n                    Statistics for Bar Graphs 2.0         ");
    printf("\n          ;");
    printf("\n                                                            ");
    printf("\n           Total Directories Scanned   =   %d",totdirs);
    printf("\n           Total Files Found           =   %d",totfiles);
    printf("\n                                                                     ");
    printf("\n           Compressors     =   %d",compress);
    printf("\n           Executables     =   %d",execu);
    printf("\n           Documents       =   %d",docs);
    printf("\n           Data Files      =   %d",data);
    printf("\n           Programming     =   %d",prog);
    printf("\n           System Files    =   %d",syst);
    printf("\n           Graphics        =   %d",graph);
    printf("\n           Windows         =   %d",wind);
    printf("\n                                                                     ");
    printf("\n           Graphics device    : %s", driver );
    printf("\n           Graphics mode      : %s", mode );
    printf("\n           Screen resolution  : %d X %d ", getmaxx(), getmaxy() );
    printf("\n           Graphics view port : ( %d, %d, %d, %d )", viewinfo.left, viewinfo.top, viewinfo.right, viewinfo.bottom );
    printf("\n           Clipping           : %s", viewinfo.clip ? "ON" : "OFF" );
    printf("\n           Colors available   : %d\n", MaxColors );
}

void PutPixelDemo(void)
{
  int seed = 1958;
  int i, x, y, h, w, color;
  struct viewporttype vp;

  getviewsettings( &vp );
  h = vp.bottom - vp.top;
  w = vp.right  - vp.left;

  srand( seed );                    /* Restart random # function    */

  for( i=0 ; i<9000 ; ++i ){        /* Put 5000 pixels on screen    */
    x = 1 + random( w - 1 );        /* Generate a random location   */
    y = 1 + random( h - 1 );
    color = random( MaxColors );
    putpixel( x, y, color );
  }

  srand( seed );            /* Restart Random # at same #   */

  for( i=0 ; i<9000 ; ++i ){        /* Take the 5000 pixels off */
    x = 1 + random( w - 1 );        /* Generate a random location   */
    y = 1 + random( h - 1 );
    color = getpixel( x, y );       /* Read the color pixel     */
    if( color == random( MaxColors ) )  /* Used to keep RANDOM in sync  */
      putpixel( x, y, 0 );      /* Write pixel to BLACK     */
  }

}

#define MaxPts      6       /* Maximum # of pts in polygon  */

void PolyDemo(void)
{
  struct PTS {int x, y;};
  struct PTS poly[MaxPts];        /* Space to hold datapoints */
  int color;                /* Current drawing color    */
  int i, p;

  for(p=0;p<60;p++){
    color = 1 + random( MaxColors-1 );  /* Get a random color # (no blk)*/
    setfillstyle( 1, color );  /* Set a random line style  */
    setcolor( color );          /* Set the desired color    */

    for( i=0 ; i<5 ; i++ ){    /* Determine a random polygon   */
      poly[i].x = random( MaxX );   /* Set the x coord of point */
      poly[i].y = random( MaxY );   /* Set the y coord of point */
    }

    poly[i].x = poly[0].x;      /* last point = first point */
    poly[i].y = poly[1].y;

    fillpoly(MaxPts, (int far *)poly );    /* Draw the actual polygon      */
  }
}


void ShareWare(void)
{
}
