#include <windows.h>
#include "dibutil.h"

/*
 * LibMain
 *
 * Purpose:
 *  DLL-specific entry point called from LibEntry.  Initializes
 *  the DLL's heap and registers the MicroScroll custom control
 *  class.
 *
 * Parameters:
 *  hInstance       HANDLE instance of the DLL.
 *  wDataSeg        WORD segment selector of the DLL's data segment.
 *  wHeapSize       WORD byte count of the heap.
 *  lpCmdLine       LPSTR to command line used to start the module.
 *
 * Return Value:
 *  HANDLE          Instance handle of the DLL.
 *
 */

VOID FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg,
                          WORD cbHeapSize, LPSTR lpCmdLine)
    {
    	hInst = hInstance;
    }


/*
 * WEP
 *
 * Purpose:
 *  Required DLL Exit function.  Does nothing.
 *
 * Parameters:
 *  bSystemExit     BOOL indicating if the system is being shut
 *                  down or the DLL has just been unloaded.
 *
 * Return Value:
 *  void
 *
 */

void FAR PASCAL WEP(int bSystemExit)
    {
    if (bSystemExit)
        {
        //Shutdown
        }
    else
        {
        //DLL use count is zero
        }

    return;
    }

