#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( none )
#endif
#pragma info( restore )

#ifndef __stdio_h
   #define __stdio_h

   #ifdef __cplusplus
      extern "C" {
   #endif

   /********************************************************************/
   /*  <stdio.h> header file                                           */
   /*                                                                  */
   /*  Licensed Materials - Property of IBM                            */
   /*                                                                  */
   /*  IBM C/C++ FirstStep Tools Version 2.01                          */
   /*  Copyright (C) International Business Machines Corp., 1991,1993  */
   /*  All rights reserved                                             */
   /*                                                                  */
   /*  US Government Users Restricted Rights -                         */
   /*  Use, duplication, or disclosure restricted                      */
   /*  by GSA ADP Schedule Contract with IBM Corp.                     */
   /*                                                                  */
   /********************************************************************/

   #ifndef __size_t
      #define __size_t
      typedef unsigned int size_t;
   #endif

   enum _OPERATIONS { _IOINIT, _IOREAD, _IOWRITE, _IOREPOSITION,
                      _IOFLUSH, _IOUNDEFOP };

   #define _MAX_UNGET 2

   #pragma pack( 1 )
   typedef struct __file       /* visible portion of the FILE struct */
      {
      unsigned char     *_bufPtr;
      unsigned long int  _count;
      unsigned long int  _userFlags;
      unsigned long int  _bufLen;
      unsigned long int  _ungetCount;
      int                _tempStore;
      unsigned char      _ungetBuf[_MAX_UNGET];
      enum _OPERATIONS   _lastOp;
      char               _filler;
      } FILE;
   #pragma pack( )

   typedef struct __fpos_t      /* Definition of file positioning structure */
      {
      long int __fpos_elem[2];
      } fpos_t;

   #ifndef NULL
      #if (defined(__EXTENDED__)  || defined( __cplusplus ))
         #define NULL 0
      #else
         #define NULL ((void *)0)
      #endif
   #endif

   #define _IOFBF              1   /* Buffer modes */
   #define _IOLBF              2
   #define _IONBF              3
   #define BUFSIZ           4096   /* Default buffer size */
   #define EOF              (-1)
   #define L_tmpnam          260   /* Maximum length of temporary names */
   #define FOPEN_MAX          20   /* Minimum number of open files guaranteed */
   #define FILENAME_MAX      260   /* Maximum file name length */
   #define SEEK_SET            0   /* fseek constants */
   #define SEEK_CUR            1
   #define SEEK_END            2
   #define TMP_MAX        100000   /* Maximum guaranteed unique file names */

   #define _IOEOF         0x0001   /* EOF flag mask */
   #define _IOERR         0x0002   /* ERR flag mask */

   typedef char *__va_list;

   /* Standard stream pointers. */

   extern FILE * const stdin;
   extern FILE * const stdout;
   extern FILE * const stderr;

   #define stdin          stdin
   #define stdout         stdout
   #define stderr         stderr

   /* Function declarations. */

   int      _Optlink fprintf( FILE *, const char *, ... );
   int      _Optlink fscanf( FILE *, const char *, ... );
   int      _Optlink printf( const char *, ... );
   int      _Optlink scanf( const char *, ... );
   int      _Optlink sprintf( char *, const char *, ... );
   int      _Optlink sscanf( const char *, const char *, ... );
   void     _Optlink clearerr( FILE * );
   int      _Optlink fclose( FILE * );
   int      _Optlink feof( FILE * );
   int      _Optlink ferror( FILE * );
   int      _Optlink fflush( FILE * );
   int      _Optlink fgetc( FILE * );
   int      _Optlink fgetpos( FILE *, fpos_t * );
   char   * _Optlink fgets( char *, int, FILE * );
   FILE   * _Optlink fopen( const char *, const char * );
   int      _Optlink fputc( int, FILE * );
   int      _Optlink fputs( const char *, FILE * );
   size_t   _Optlink fread( void *, size_t, size_t, FILE * );
   FILE   * _Optlink freopen( const char *, const char *, FILE * );
   int      _Optlink fseek( FILE *, long int, int );
   int      _Optlink fsetpos( FILE *, const fpos_t * );
   long int _Optlink ftell( FILE * );
   size_t   _Optlink fwrite( const void *, size_t, size_t, FILE * );
   int      _Optlink getc( FILE * );
   int      _Optlink getchar( void );
   char   * _Optlink gets( char * );
   void     _Optlink perror( const char * );
   int      _Optlink putc( int, FILE * );
   int      _Optlink putchar( int );
   int      _Optlink puts( const char * );
   int      _Optlink remove( const char * );
   int      _Optlink rename( const char *, const char * );
   void     _Optlink rewind( FILE * );
   void     _Optlink setbuf( FILE *, char * );
   int      _Optlink setvbuf( FILE *, char *, int, size_t );
   FILE   * _Optlink tmpfile( void );
   char   * _Optlink tmpnam( char * );
   int      _Optlink ungetc( int, FILE * );
   int      _Optlink vfprintf( FILE *, const char *, __va_list );
   int      _Optlink vprintf( const char *, __va_list );
   int      _Optlink vsprintf( char *, const char *, __va_list );

   #define __getc(p) ( \
      (((p)->_lastOp == _IOREAD) && ((p)->_ungetCount==0) && ((p)->_count!=0))? \
         (--(p)->_count, (int)(*(p)->_bufPtr++)) :\
         fgetc((p)) )

   #define __putc(c, p) ( \
      ((((p)->_tempStore = (c)) != '\n') && \
      ((p)->_lastOp == _IOWRITE) && ((p)->_count < (p)->_bufLen)) ? \
         (++(p)->_count, *(p)->_bufPtr++ = (p)->_tempStore): \
         fputc((p)->_tempStore,(p)) )

   #pragma info( none )
   #ifndef __MULTI__
      #ifdef __cplusplus
         inline int getc( FILE * p )        { return __getc( p ); }
         inline int putc( int c, FILE * p ) { return __putc( c, p ); }
      #else
         #define getc( p )    __getc( (p) )
         #define putc( c, p ) __putc( (c), (p) )
      #endif
   #else
      #ifdef __cplusplus
         inline int getc( FILE * p )        { return fgetc( p ); }
         inline int putc( int c, FILE * p ) { return fputc( c, p ); }
      #else
         #define getc( p )  fgetc( (p) )
         #define putc( c, p ) fputc( (c), (p) )
      #endif
   #endif

   #ifdef __cplusplus
      inline int getchar( void )   { return getc( stdin ); }
      inline int putchar( int c ) { return putc( c, stdout ); }
   #else
      #define getchar( )   getc( stdin )
      #define putchar( c ) putc( (c), stdout )
   #endif

   /* clearerr, feof, and ferror macros - single threaded only */

   #ifndef __MULTI__
      #define clearerr( stream ) \
         ( ((stream) == NULL) ? clearerr( (stream) ):\
                                ( ( void )( (stream)->_userFlags = 0L ) ) )
      #define feof( stream ) \
         ( ((stream) == NULL) ? feof( (stream) ):\
                                ( ( int )( (stream)->_userFlags & _IOEOF ) ) )
      #define ferror( stream ) \
         ( ((stream) == NULL) ? ferror( (stream) ):\
                                ( ( int )( (stream)->_userFlags & _IOERR ) ) )
   #endif
   #pragma info( restore )

   #if (defined(__EXTENDED__)  || defined( __cplusplus ))

      #define _IO_WRITETHRU  0x0004   /* WRITETHRU mask */

      #pragma map( fprintf, "_fprintfieee" )
      #pragma map( printf , "_printfieee"  )
      #pragma map( sprintf, "_sprintfieee" )
      #pragma map( fscanf , "_fscanfieee"  )
      #pragma map( scanf  , "_scanfieee"   )
      #pragma map( sscanf , "_sscanfieee"  )

      #pragma map( vfprintf, "_vfprintfieee" )
      #pragma map( vprintf , "_vprintfieee"  )
      #pragma map( vsprintf, "_vsprintfieee" )

      int _Optlink _fcloseall( void );
      int _Optlink _rmtmp( void );

      #define P_tmpdir "\\"
      FILE * _Optlink fdopen( int, const char *);
      int    _Optlink fgetchar( void );
      int    _Optlink fileno( FILE * );
      int    _Optlink flushall( void );
      int    _Optlink fputchar( int );
      char * _Optlink tempnam( char *, char * );
      int    _Optlink unlink( const char * );

      FILE * _Optlink _fdopen( int, const char *);
      int    _Optlink _fgetchar( void );
      int    _Optlink _fileno( FILE * );
      int    _Optlink _flushall( void );
      int    _Optlink _fputchar( int );
      char * _Optlink _tempnam( char *, char * );
      int    _Optlink _unlink( const char * );

      int    _Optlink _set_crt_msg_handle( int );

      #pragma map( fdopen  , "_fdopen"   )
      #pragma map( fgetchar, "_fgetchar" )
      #pragma map( fileno  , "_fileno"   )
      #pragma map( flushall, "_flushall" )
      #pragma map( fputchar, "_fputchar" )
      #pragma map( tempnam , "_tempnam"  )
      #ifndef __unlink
         #define __unlink
         #pragma map( unlink  , "_unlink"   )
      #endif

   #else

      #pragma map( fprintf, "_fprintf_ansi" )
      #pragma map( printf , "_printf_ansi"  )
      #pragma map( sprintf, "_sprintf_ansi" )
      #pragma map( fscanf , "_fscanf_ansi"  )
      #pragma map( scanf  , "_scanf_ansi"   )
      #pragma map( sscanf , "_sscanf_ansi"  )

   #endif

   #ifdef __cplusplus
      }
   #endif

#endif

#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( restore )
#endif
#pragma info( restore )
