/* OXBOW.H a conglomeration of .h files */

#include <setjmp.h>

#ifndef SUPPORT_LONG_LONG
#define SUPPORT_LONG_LONG 1
#endif

#ifndef SUPPORT_LONG_DOUBLE
#define SUPPORT_LONG_DOUBLE 0
#endif

#if SUPPORT_LONG_LONG
#define _LONGLONG_ long long
#else
#define _LONGLONG_ double
#endif

#ifdef __cplusplus
extern "C" {
#endif

enum evTypes {
#undef defEvent
#define defEvent(a,b) \
a=b,
#include <oxevents.h>
};

#undef max
#define max(a,b) \
({typedef _ta = (a), _tb = (b); \
_ta _a = (a); _tb _b = (b); \
_a > _b ? _a : _b; })

#undef min
#define min(a,b) \
({typedef _ta = (a), _tb = (b); \
_ta _a = (a); _tb _b = (b);\
_a < _b ? _a : _b; })

#define ROUNDING(a,b) ((b-(a&(b-1)))&(b-1))
#define ROUNDUP(a,b) a += ROUNDING(a,b)
#define round_up(a,b) (a+ROUNDING(a,b))
#define CALLER(a) (((unsigned*)&a)[-1])

typedef unsigned long SIZE_T;

/* CFF.H	-- user api include file for the cff library */
#ifndef __ITEMH__
#define __ITEMH__
#if SUPPORT_LONG_LONG
typedef unsigned long long  KeyItem;   /* type for a key's associated item */
#else
typedef double KeyItem;
#endif
#endif __ITEMH__

typedef union 			/* 2 BYTES */
	{
		unsigned short val;
		unsigned char b[2];
} SVAL;

typedef union			/* 4 BYTES */
	{
	unsigned long a0;
	void *a1;
	struct
		{
		SVAL	lo_word;
		SVAL	hi_word;
		} a2;
	struct
		{
			unsigned int pad :28;
			unsigned int type :4;
		} a3;
	struct
		{
			unsigned char b[4];
		} a4;
	int a8;
	short a9;
	char a10;
	float a11;
} ADDR;

#ifndef __STORH__
#define __STORH__
typedef union _stor	/* 8 BYTES */
	{
	KeyItem item;
	unsigned long	a0;
	void *a1;
	struct 
	{
		unsigned char b0 : 3;
		unsigned char b1 : 1;
		unsigned char b2 : 1;
		unsigned char b3 : 1;
		unsigned char b4 : 2;
	} bits;
	struct
		{
		unsigned short	lo_word;
		unsigned short	hi_word;
		unsigned int size :28;		/* in bytes or nibbles */
		unsigned int type :4;	    /* describes the STOR type */
		} a2;
	struct
		{
			short s0;
			short s1;
			short s2;
			short s3;
		} a3;
	struct
		{
			unsigned long	s0;
			unsigned long	s1;
		} a4;
	struct
		{
			long	s0;
			long	s1;
		} a4s;
	struct
		{
			void	*a0;
			void	*a1;
		} a4a;
	struct
		{
			unsigned char	b[8];
		} a5;
	struct
		{
			signed char	b[8];
		} a5t;
#if SUPPORT_LONG_LONG
	struct
		{
			unsigned long long dupname :48;
			unsigned long long dupid :16;
		} a6;
#endif
	struct
		{
			unsigned int home : 30;
			unsigned int full : 2;
		} a7;
	int a8;
	short a9;
	char a10;
	float a11;
	double a12;
#if SUPPORT_LONG_LONG
	long long a13;
	unsigned long long a14;
#endif
	unsigned char	Uuchar;
	char			Uchar;
	unsigned short	Uushort;
	short			Ushort;
	unsigned int	Uuint;
	int				Uint;
	unsigned long 	Uulong;
	long			Ulong;
#if SUPPORT_LONG_LONG
	unsigned long long Uulonglong;
	long long		Ulonglong;
#endif
	void *			Upointer;
	float			Ufloat;
	double			Udouble;
} STOR, Item;
#endif __STORH__

/* DEFINITIONS FOR "a2.type */
#define STO_INACTIVE (0)
#define STO_NIL  (1)
#define STO_VALUE (2)	
#define STO_CHUNK (3)
#define STO_KEYINFO (4)
#define STO_NILCHUNK (5)
#define STO_COMPCHUNK (6)
#define STO_ALLOCATED (7)
#define STO_DELETED (8)	/* always ored with non zero */
#define STOMASK (7)

typedef struct {
	unsigned long	name;
	unsigned short	xname;
	unsigned short	id;
} DupName;

typedef struct			/* 12 BYTES */
	{
		STOR c0;
		ADDR c1;
	} CAT;
#define CATEXACT  (8)
#define CATHASH (cat.c1.a0)

typedef struct	/* 20 bytes */
	{
		STOR	stor;
		CAT		cat;
} SDB;


/* DEFINE CFF OPEN MODES */

#define F_RDONLY	(0x0001)
#define F_WRONLY	(0x0002)
#define F_RDWR		(0x0003)
#define F_CREAT		(0x0004)
#define F_TEMP		(0x0008)
#define F_UNIQ		(0x0010)
#define F_EXCL		(0x0020)
#define F_BITMAP	(0x0040)
#define F_TRUNC		(0x0080)
#define F_APPEND	(0x0100)
#define F_DELETING	(0x0200)
#define F_FILEONLY	(0x0400)
#define F_BIGDIR	(0x0800)
#define F_HUGEDIR	(0x1000)
#define F_SETUP		(0x4000)
#define F_PARENTS	(0x4000)
#define F_SORTED	(0x8000)
#define F_UNTAGGED	(0x10000)
#define F_STAT		(0x20000)	/* TRULY READONLY */
#define F_TEXT		(0x40000)	/* DOS crap, default mode is binary */
#define F_ZIPFILE	(0x80000)	/* compress the file aspect */
#define F_ZIPDATA	(0x100000)	/* compress data chunks */
#define F_TEMPFILE	(F_RDWR|F_CREAT|F_UNIQ|F_TEMP)

/* BUFFER RELEASE MODES */
#define R_DIRTY		(0x80000000)
#define R_CLEAN		(0x40000000)
#define R_FLUSH		(0x20000000)

/* DEFINE SOME SYSTEM CALL VALUES */
#define S_READBLK (1)
#define S_WRITEBLK (2)
#define S_GETSPACE (3)
#define S_GIVESPACE (4)
#define S_CLOSE (5)
#define S_OPEN (6)
#define S_CREATE (7)
#define S_UNLINK (8)
#define S_SEEK (9)
#define S_FLUSH (10)
#define S_CLOSETRUNC (11)

#define S_SET (0)
#define S_CUR (1)
#define S_END (2)

/* DEFINE CFF OBJECT PROPERTIES -- returned by cfobtype(void *something) */
#define OB_SHARE	(0x00000001)
#define OB_ISDIR	(0x00000002)
#define OB_BMOK		(0x00000004)
#define OB_SMOK		(0x00000008)
#define OB_MEM		(0x00000010)
#define OB_RAWDEV	(0x00000020)
#define OB_CFILE	(0x00000040)
#define OB_SETUP	(0x00000080)
#define OB_FOD		(0x00000100)
#define OB_ROOTDIR	(0x00000200)
#define OB_DIRTY	(0x00000400)
#define OB_DELCLOSE	(0x00000800)
#define OB_WRITE	(0x00001000)
#define OB_BITMAP	(0x00002000)
#define OB_XFILE	(0x00004000)
#define OB_ISNEW	(0x00008000)
#define OB_SMEM		(0x00010000)
#define OB_FILEONLY	(0x40000000)
#define OB_HASHDIR	(0x20000000)
#define OB_TREEDIR	(0x10000000)
#define OB_UNTAGGED (0x08000000)
#define OB_PREALLOC (0x01000000)
#define OB_ZIPFILE	(0x00800000)
#define OB_ZIPDATA	(0x00400000)
#define OB_CHUNK	(0x00200000)
#define OB_VALUE	(0x00100000)

#ifndef NULL
#define NULL ((void *)0)
#endif

#ifndef EOF
#define EOF     (-1)
#endif

#define YES     (1)
#define NO      (0)
#define OK      (1)
#define NODUPS	(0)
#define OKDUPS	(1)
#define CNTDUPS (2)
#define DUPNAMES (4)

#define PREALLOC1 (8)
#define PREALLOC2 (16)
#define PREALLOC3 (32)

#define ERROR   (-1)
#define FOUND	(1)
#define NOTFOUND (0)
#define NONE	(-1)	/* no value */
#define INVALID (-4)	/* invalid value */
#define LESS	(-1)	/* a is less than b */
#define EQUAL	(0)		/* a and b are equal */
#define GREATER	(2)		/* a is greater than b */
#define	BOI	(-2)		/* beginning of index */
#define	EOI	(-3)		/* end of index */

typedef struct opninfo {
	long initial_entries;
	unsigned long bitmap_prealloc;
	long data_prealloc;
} OPNINFO;

typedef struct cfdirent {
	int d_namlen;
	char *d_name;
	unsigned long d_bytesalloc;
	unsigned long d_bytesused;
	unsigned long d_mode;
	unsigned long d_entrycnt;
	unsigned long d_ino;
	unsigned long d_mtime;
	unsigned long d_ctime;
	void *d_fpt;
} CFDIRENT;

/* Function codes for the cfmisc instruction */
enum CfMisc {
	CF_ALLOC,CF_USED,CF_DEPTH,CF_MARK,CF_HEAD,CF_TAIL,CF_NEXT,
	CF_PREV,CF_KEYLEN,CF_DATALEN,CF_MODBUFS,
	CF_CURBUFS,CF_SETKEYCMP,CF_SETITEMCMP,CF_SETERRFUNC,
	CF_LAZY,CF_VERYLAZY,CF_CLRLAZY,CF_ISNEW,CF_FLUSH,
	CF_FILESIZE,CF_FILEALLOC,CF_PREALLOC,CF_ALIGNMENT,
	CF_MAPSIZE,CF_ISSORTED,CF_KEY,CF_ITEM,CF_CREEP,
	CF_SETPRINTFUNC,CF_DATA,CF_GETMARK,CF_SETMARK
};

typedef struct cfstat {
		unsigned long	st_smhead;
		unsigned long	st_smtail;
		unsigned short	st_id;
		unsigned short	st_keysize;

		STOR		   st_dups;
		unsigned long  st_bmhead;
		unsigned long  st_bmtail;
        unsigned long  st_mode;
        short st_uid;
        short st_gid;
        long  st_mtime;
        long  st_ctime;

		unsigned long  st_highleaf;
        unsigned long  st_size;
		unsigned long  st_alloc;
		unsigned long  st_entrycnt;
		short 		   st_mapsize;
		unsigned short st_dupids;

        long  st_atime;
		long  st_filesize;
		long  st_filealloc;
		long  st_obtype;
		unsigned int st_filedups;
        long  st_ino;
        short st_blksize;
        short st_dev;
        short st_nlink;
        short st_rdev;
} CFSTAT;

/* MODE BITS */
#define M_AFMT		(0x30000000)
#define M_ROOTDIR	(0x80000000)
#define M_FILEONLY	(0x40000000)
#define M_HASHDIR	(0x20000000)
#define M_TREEDIR	(0x10000000)
#define M_UNTAGGED	(0x08000000)
#define M_BITMAP	(0x04000000)
#define M_EXTRNFILE	(0x02000000)
#define M_PREALLOC	(0x01000000)
#define M_ZIPFILE	(0x00800000)
#define M_ZIPDATA	(0x00400000)
#define M_CHUNK		(0x00200000)
#define M_VALUE		(0x00100000)
#define M_IFMT		(0x0000F000)
#define M_IFDIR		(0x00004000)
#define M_IFIFO		(0x00002000)
#define M_IFCHR		(0x00001000)
#define M_IFBLK		(0x00003000)
#define M_IFREG		(0x00008000)
#define M_IREAD		(0x00000100)
#define M_IWRITE	(0x00000080)
#define M_IEXEC		(0x00000040)


extern void *PERMCAT;
extern void *PERMINFO;
extern void *PERMFILE;
extern void *MEMTEMP;
#define MEMTMP MEMTEMP

extern char *cff_version;
extern char *cff_copyright;



/* STDIO STUFF */
#ifndef __STDIOH__
#define __STDIOH__

#define __BUFSIZ_  (4096)

extern  struct  cf_iobuf {
    int      _cnt;
    char*    _ptr;
    char*    _base;
	int		 _bufsiz;
    short	 _flag;
    unsigned char	 _file;
	char	 _sbuf;
} cf_iob[];
#endif /* __STDIOH__ */

#define cfstdin     (&cf_iob[0])
#define cfstdout    (&cf_iob[1])
#define cfstderr    (&cf_iob[2])
#define cfstdaux    (&cf_iob[3])
#define cfstdprn    (&cf_iob[4])

extern void *cf_filelist[];

typedef struct cf_iobuf cfFILE;

#define cf_IOFBF    (00000)
#define cf_IOREAD   (00001)
#define cf_IOWRT    (00002)
#define cf_IONBF    (00004)
#define cf_IOMYBUF  (00010)
#define cf_IOEOF    (00020)
#define cf_IOERR    (00040)
#define cf_IOSTRG   (00100)
#define cf_IOLBF    (00200)
#define cf_IORW     (00400)
#define cf_IOAPPEND (01000)
#define cf_IOTEXT   (02000)  /* for MSDOS cr/lf style files */


#define cfgetc(p) (--(p)->_cnt>=0 ? \
  (int)(*(unsigned char*)(p)->_ptr++) : \
  cf_filbuf(p))
#define cfputc(x,p) (--(p)->_cnt>=0? \
  ((int)((unsigned char)((*(p)->_ptr++=(unsigned)(x))))): \
  cf_flsbuf((unsigned)(x),p))

#define cfclearerr(p) ((p)->_flag &= ~(cf_IOERR|cf_IOEOF))
#define cfgetchar()   cfgetc(cfstdin)
#define cfputchar(x)  cfputc(x,cfstdout)
#define cffeof(p)     (((p)->_flag&cf_IOEOF)!=0)
#define cfferror(p)   (((p)->_flag&cf_IOERR)!=0)
#define cffileno(p)   (cf_filelist[(p)->_file])

int    cf_filbuf(cfFILE*);
int    cf_flsbuf(unsigned, cfFILE*);
int    cffclose(cfFILE*);
cfFILE*  cffdopen(void *, const char*);
int    cffflush(cfFILE*);
int    cffgetc(cfFILE*);
char*  cffgets(char*, int, cfFILE *);
cfFILE*  cffopen(const char*, const char*);
int    cffputc(int, cfFILE*);
int    cffputs(const char*, cfFILE*);
int    cffread(void*, int, int, cfFILE*);
cfFILE*  cffreopen(const char*, const char*, cfFILE*);
int    cffseek(cfFILE*, long, int);
long   cfftell(cfFILE *);
int    cffwrite(const void*, int, int, cfFILE*);
char*  cfgets(char*);
int    cfgetw(cfFILE*);
int    cfputs(const char*);
int    cfputw(int, cfFILE*);
void   cfrewind(cfFILE*);
int    cfsetbuf(cfFILE*, char*);
int    cfsetbuffer(cfFILE*, char*, int);
int    cfsetlinebuf(cfFILE*);
int    cfsetvbuf(cfFILE*, char*, int, int);
int    cfungetc(int, cfFILE*);
int	   cffgetpos(cfFILE*, long *);
int	   cffsetpos(cfFILE*, long *);
cfFILE *cftmpfile(void);
char   *cftmpnam(char *);
char   *cftempnam(char *, char *);
int	cfprintf(const char *fmt, ...);
int	cfeprintf(const char *fmt, ...);
int cfveprintf(const char *fmt, char *args);
int cffprintf(cfFILE *iop, const char *fmt, ...);
int cfsprintf(char *str, const char *fmt, ...);
int cfvprintf(const char *fmt, char *args);
int cfvvprintf(const char *fmt, char **args);
int cfvfprintf(cfFILE *iop, const char *fmt, char *args);
int cfvvfprintf(cfFILE *iop, const char *fmt, char **args);
int cfvsprintf(char *str, const char *fmt, char *args);
int cfvvsprintf(char *str, const char *fmt, char **args);

int cfsscanf(char *str, const char *fmt, ...);
int cfvsscanf(char *str, const char *fmt, char **args);
int cffscanf(cfFILE *iop, const char *fmt, ...);
int cfvfscanf(cfFILE *iop, const char *fmt, char **args);
int cfscanf(const char *fmt, ...);
int cfvscanf(const char *fmt, char **args);

void cfinit(char *appname, int lbufpages, char *permfile);
void cfexit();
void cfport_settestflags(int flags);

void cfhash(const void *keyptr, int keysize, CAT *cat);
long cfrdwr_object(void *handle, void *userbuffer, long amount, int mode);
long cfseek(void *handle, long amount, int mode);

int cfkeycmp (void *keya, int lena, void *keyb, int lenb);
int cflexical_keycmp (void *keya, int lena, void *keyb, int lenb);
int cfitemcmp(void *itema, void *itemb);

void cfprintbitmaps(void *something);
void cfprintentries(void *something);
void *cfopen(const char *path, long mode, void *info);
void *cfsubopen(void *handle, const char *name, long mode, void *info);
void *cfopen_chunk(void *handle, void *item);
void *cfmake_chunk(void *handle, void *key, int keylen, int size);
void *cfdup(void *handle);
void cfclose(void *handle);
int cfunlink(void *something, ... );
int cfstat(void *something, void *stbuf);
int cfsubstat(void *handle,const char *name, void *stbuf);
void *cfcopy(void *something_dst, void *something_src);
long cfcopy_file(void *handle_dst, void *handle_src);
int cfcopy_object(void *handle_dst, void *handle_src);
void cftotalloc(void *something, unsigned long *used, unsigned long *alloc);
long cffilesize(void *something);
void *cflocalize(void *handle, void *item);
void cfrelease(void *ptr, long mode);

#define cfread(a,b,c) \
cfrdwr_object(a,b,c,S_READBLK)
#define cfwrite(a,b,c) \
cfrdwr_object(a,b,c,S_WRITEBLK)

int cfdef(const char *key, const char *def);
int cfsysdef(const char *key, const char *def);
int cfappdef(const char *key, const char *def);
int cfundef(const char *key);
int cfsysundef(const char *key); 
int cfappundef(const char *key);
int cftrn(const char *strn, char **newstrn);
int cfpathtrn(const char *strn, char **newstrn);
void cfflush(void *handle);
void cfsync(void);
int cftruncate(void *something, unsigned long size);

int cfqinsert(void *handle,const void *key, int len, void *item);
int cfinsertx(void *handle,const void *key,int len,void *item,int dups,void *adup);
#define cfinsert(handle,keyptr,keylen,itemptr) \
cfinsertx(handle,keyptr,keylen,itemptr,NODUPS,NULL)
#define cfinsert_dupnum(handle,keyptr,keylen,itemptr,dupnum) \
cfinsertx(handle,keyptr,keylen,itemptr,OKDUPS,dupnum)
#define cfinsert_dupname(handle,keyptr,keylen,itemptr,dupname) \
cfinsertx(handle,keyptr,keylen,itemptr,DUPNAMES,dupname)

int cfqget(void *handle, const void *keyptr, int keylen, void *bufptr, int buflen);
int cfqfind(void *handle, const void *keyptr, int keylen, Item *keyi, Item *dati);
int cfqfindkey(void *handle, const void *keyptr, int keylen, Item *keyi);
int cfqfinddat(void *handle, const void *keyptr, int keylen, Item *dati);

int cffindx(void *handle, const void *keyptr, int keylen, void *itemptr, void *adup);
#define cffind(handle,key,len,item) \
cffindx(handle,key,len,item,NULL)
#define cffind_dupnum(handle,key,len,item,dupnum) \
cffindx(handle,key,len,item,dupnum)
#define cffind_dupname(handle,dupname,itemptr) \
cffindx(handle,dupname,8,itemptr,(void *)0xffffffff)
#define cfreinsert(handle,key,len,item) \
cffindx(handle,key,-len,item,NULL)
#define cfreinsert_dupnum(handle,key,len,item,dupnum) \
cffindx(handle,key,-len,item,dupnum)
#define cfreinsert_dupname(handle,key,len,itemptr,dupname) \
cffindx(handle,dupname,-8,itemptr,(void *)0xffffffff)

int cffind_item(void *handle, const void *key, int keylen, void *itemptr);
int cffind_mark(void *handle, void *itemptr);

#define cfdelete(a,b,c) \
cfdelete_item(a,b,c,NULL)
int cfdelete_item(void *handle, void *key, int keylen, void *itemptr);
int cfdelete_dupnum(void *handle, void *key, int keylen, long dupnum);
#define cfdelete_lastdupnum(a,b,c) \
cfdelete_dupnum(a,b,c,-1)
int cfdelete_dupname(void *handle, const void *key, int keylen, void *dupname);
int cfdelete_lastdupname(void *handle, const void *key, int keylen);
int cfdelete_alldupnames(void *handle, const void *key, int keylen);
int cfdelete_alldupnums(void *handle, const void *key, int keylen);
int cflastdupname(void *handle, const void *key, int keylen, void *dupname);

long cfpush_item(void *handle, void *itemptr);
long cfpush_value(void *handle, unsigned long *value);
long cfpush_data(void *handle, void *datptr, int datsize);
long cfpop_item(void *handle, void *itemptr);
long cfpop_value(void *handle, unsigned long *value);
long cfpop_data(void *handle, void *datptr, int datsize);
long cfstackdepth(void *handle);

long cfcountdups(void *handle, void *key, int keylen);
long cfmisc(void *something, int func, ...);

void *cfopendir(const void *path);
void cfclosedir(void *it);
CFDIRENT *cfreaddir(void *it);
CFDIRENT *cfreadfulldir(void *it);
void cfrewinddir(void *it);
void cftelldir(void *it, STOR *entry);
void cfseekdir(void *it, STOR *entry);
long cfentrycnt(void *something);

int cfseq_dupnum(void *handle, const void *key, int len, void *itemptr, int mode);
#define cfhead_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_HEAD)
#define cftail_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_TAIL)
#define cfnext_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_NEXT)
#define cfprev_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_PREV)

int cfseq_dupname(void *handle, void *key, int len, void *itemptr, int mode);
#define cfhead_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_HEAD)
#define cftail_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_TAIL)
#define cfnext_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_NEXT)
#define cfprev_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_PREV)


#define cfdepth(a) \
cfmisc(a, CF_DEPTH)
#define cfmark(a) \
cfmisc(a, CF_MARK)
#define cfgetmark(a,b) \
cfmisc(a, CF_GETMARK, b)
#define cfsetmark(a,b) \
cfmisc(a, CF_SETMARK, b)
#define cfhead(a,b) \
cfmisc(a, CF_HEAD, b)
#define cftail(a,b) \
cfmisc(a, CF_TAIL, b)
#define cfnext(a,b) \
cfmisc(a, CF_NEXT, b)
#define cfprev(a,b) \
cfmisc(a, CF_PREV, b)
#define cfkeylen(a,b) \
cfmisc(a, CF_KEYLEN, b)
#define cfdatalen(a,b) \
cfmisc(a, CF_DATALEN, b)
#define cfbytesused(a) \
cfmisc(a, CF_USED)
#define cfbytesalloc(a) \
cfmisc(a, CF_ALLOC)
#define cfmodbufs(a) \
cfmisc(NULL, CF_MODBUFS, a)
#define cfcurbufs() \
cfmisc(NULL, CF_CURBUFS)
#define cfsetkeycmp(a,b) \
cfmisc(a, CF_SETKEYCMP, b)
#define cfsetitemcmp(a,b) \
cfmisc(a, CF_SETITEMCMP, b)
#define cfseterrfunc(a) \
cfmisc(NULL, CF_SETERRFUNC, a)
#define cfsetprintfunc(a) \
cfmisc(NULL, CF_SETPRINTFUNC, a)
#define cfisnew(a) \
cfmisc(a,CF_ISNEW)
#define cfsetverylazy(a) \
cfmisc(a, CF_LAZY)
#define cfsetlazy(a) \
cfmisc(a, CF_VERYLAZY)
#define cfclrlazy(a) \
cfmisc(a, CF_CLRLAZY)
#define cffilealloc(a) \
cfmisc(a, CF_FILEALLOC)
#define cfprealloc(a) \
cfmisc(a, CF_PREALLOC)
#define cfalignment(a) \
cfmisc(a, CF_ALIGNMENT)
#define cfmapsize(a) \
cfmisc(a, CF_MAPSIZE)
#define cfissorted(a) \
cfmisc(a, CF_ISSORTED)
#define cfkey(ccb,key,len) \
cfmisc(ccb, CF_KEY, key, len)
#define cfitem(ccb, item) \
cfmisc(ccb, CF_ITEM, item)
#define cfdata(ccb, buf, len) \
cfmisc(ccb, CF_DATA, buf, len)

void cfpflags(char *name, void *handle);
long cfobtype(void *handle);
void *cfgetspace(void *handle, long amount, void *addr);
int cfretspace(void *handle, void *addr);

void *cfputx(void *handle, const void *keyptr, int keylen, void *itemptr,
					int dupflg, void *adup, void *bufptr, long buflen);
#define cfput(handle,key,len,buf,buflen,itemptr) \
cfputx(handle,key,len,itemptr,NODUPS,NULL,buf,buflen)
#define cfput_dupnum(handle,key,len,buf,buflen,itemptr,dupnum) \
cfputx(handle,key,len,itemptr,OKDUPS,dupnum,buf,buflen)
#define cfput_dupname(handle,key,len,buf,buflen,itemptr,dupname) \
cfputx(handle,key,len,itemptr,DUPNAMES,dupname,buf,buflen)
#define cfreput(handle,key,len,buf,buflen,itemptr) \
cfputx(handle,key,len,itemptr,NODUPS,NULL,buf,-buflen)
#define cfreput_dupnum(handle,key,len,buf,buflen,itemptr,dupnum) \
cfputx(handle,key,len,itemptr,OKDUPS,dupnum,buf,-buflen)
#define cfreput_dupname(handle,key,len,buf,buflen,itemptr,dupname) \
cfputx(handle,key,len,itemptr,DUPNAMES,dupname,buf,-buflen)


int cfgetx(void *handle, const void *keyptr, int keylen,
					void *bufptr, long buflen, void *adup);
#define cfget(handle,key,len,buf,buflen) \
cfgetx(handle,key,len,buf,buflen,NULL)
#define cfget_dupnum(handle,key,len,buf,buflen,dupnum) \
cfgetx(handle,key,len,buf,buflen,dupnum)
#define cfget_dupname(handle,dupname,buf,buflen) \
cfgetx(handle,dupname,8,buf,buflen,(void *)0xffffffff)
int cfchdir(char *);
void cfgetcwd(char *cwd, int size);
int cfdozip(void *, int, void *, int, int);
#define cfzip(dst,dsize,src,ssize)\
cfdozip(dst,dsize,src,ssize,0)
#define cfunzip(dst,dsize,src,ssize)\
cfdozip(dst,dsize,src,ssize,-1)


void *malloc(SIZE_T);
void free(void *);
unsigned mallocsize(const void *);

void *calloc(SIZE_T, SIZE_T);
void *realloc(void *, SIZE_T);
void *memalign(unsigned, unsigned);
void *valloc(unsigned);

void *mallocC(long, unsigned);
void *callocC(long, unsigned, unsigned);
void *reallocC(long, void *, unsigned);
void *vallocC(long, unsigned);
void *memalignC(long, unsigned, unsigned);
void freeC(long, void *);
void freecat(long);
void *cfmalloc(unsigned, STOR *);
void cffree(STOR *);
void cfmemrange(long category, unsigned int* min, unsigned int* max);
void cftotrange(unsigned int* min, unsigned int* max);
char *cf_find_file(const char *, char *);
void cf_set_search_path(char *);
char *cf_get_search_path(void);

extern unsigned long _oxlink_trace;
int oxlink_init ();
int oxlink_load_file (const char *);
int oxlink_load_object(const char*);
void * oxlink_find_symb (const char *);
void *oxlink_find_bare_symb (const char *);
void *oxlink_find_func (const char *);
void *oxlink_find_bare_func (const char *);
int oxlink_unload_file (const char *name, int force);
int oxlink_unload_symb (const char *name, int force);
int oxlink_unload_bare_symb (const char *name, int force);
char **oxlink_list_undefined_sym (void);
int oxlink_export_symb(const char *name, unsigned addr);
int oxlink_export_bare_symb(const char *name, unsigned addr);
int oxlink_unexport_symb(const char *);
int oxlink_unexport_bare_symb(const char *);
void oxlink_demand_load(void);
void oxlink_use_library(const char *);
void oxlink_nouse_library(const char *);
void  *oxlink_resolve_symb(int symnum);
void oxlink_trace(int level);
char *oxlink_symname(int symnum);
void *oxlink_rename_symb(const char *old, const char *new);
int oxlink_rename_file(const char *old, const char *new);
void *oxlink_load_symb(const char *symb, int dynlink);
void *oxlink_load_bare_symb(const char *symb, int dynlink);
int oxlink_scan_file(void *fhandle, void *thandle);
void oxlink_load_thunk(int thunknum);
int oxlink_prep_thunk(const char *symb);
void oxlink_clear_bss(const char *filename);
char *oxlink_file_of(const char *symb);
char *oxlink_file_of_bare(const char *symb);
void *oxlink_get_entry_struct(const char *filename);

void oxlink_lib_check(int dynlink);
void oxlink_set_libtype(int type);
void oxlink_set_libnum(int libnum); 
char *oxlink_errstr(void);

int NewMallocCategory();

/* PATTERN MATCH FLAGS */
#define P_LEADING_DOT	(0x1)
#define P_IS_PATH		(0x2)
#define P_PAT_PATH		(0x4)
#define P_USES_ESCAPES	(0x8)
#define P_PCDOS			(0x10)

int pattern_match (const char *pattern, const char *string, int flags);
int check_for_pattern(const char *cp, int flags);

/* CTYPE DEFINITIONS */
   
#ifndef _CTYPE_
#define _CTYPE_

#ifndef offsetof
#define offsetof(type, member) ((unsigned) &((type *)0)->member)
#endif

#define _mU (0x01)
#define _mL (0x02)
#define _mN (0x04)
#define _mX (0x08)
#define _mS (0x10)
#define _mP (0x20)
#define _mC (0x40)
#define _mB (0x80)

extern  unsigned char      cfctype[];
   
#define isalpha(c)  (cfctype[(unsigned char) c]&(_mU|_mL))
#define isupper(c)  (cfctype[(unsigned char) c]&_mU)
#define islower(c)  (cfctype[(unsigned char) c]&_mL)
#define isdigit(c)  (cfctype[(unsigned char) c]&_mN)
#define isxdigit(c) (cfctype[(unsigned char) c]&(_mX|_mN))
#define isspace(c)  (cfctype[(unsigned char) c]&_mS)
#define ispunct(c)  (cfctype[(unsigned char) c]&_mP)
#define isalnum(c)  (cfctype[(unsigned char) c]&(_mU|_mL|_mN))
#define isprint(c)  (cfctype[(unsigned char) c]&(_mP|_mU|_mL|_mN|_mB))
#define isgraph(c)  (cfctype[(unsigned char) c]&(_mP|_mU|_mL|_mN))
#define iscntrl(c)  (cfctype[(unsigned char) c]&_mC)
#define isascii(c)  ((unsigned char)(c)<=(0x7f))

#define toupper(c)  ({unsigned char _c = (unsigned char)(c); islower(_c) ? (_c-32) : _c; })
#define tolower(c)  ({unsigned char _c = (unsigned char)(c); isupper(_c) ? (_c+32) : _c; })
#define toascii(c)  ((c)&(0x7f))

#endif /* _CTYPE_ */

/* COS.H */

/* in cossys.o -- returns a 28 bit, very random, number */
unsigned long strHash(char *str, int *len); /* ret length if 'len' nonnull */
unsigned long charHash(char);		/* argument size is assumed 1 */
unsigned long shortHash(short);		/* argument size is assumed 2 */
unsigned long longHash();		/* argument size is assumed 4 */
unsigned long longlongHash();	/* argument size is assumed 8 */

/*  object must be declared volatile because if the variable is kept in a
    register, it may not be garbage collected  */

typedef void * vobject;		/* methods are defined to return vobject, avoids
								gcc 'volatile' bug */
#ifdef KERNEL
typedef	struct	_object	 * volatile object;
#else
typedef void * object;
#endif

typedef	vobject	(*ofun)();	/* note that functions return 'vobject' */
typedef int (*ifun)();
typedef _LONGLONG_ (*llfun)();

void	InitCOS(void *);
ofun	_FindMethod(object, object);		/* used internally only */
ofun	_FindMethod2(object, object, int);	/* error if no find */
ofun	_FindMethod3(object, object, int);	/* return nulfunc if no find */
ofun	FindMethod(object, object, int);	/* return NULL if no find */
vobject	FindMethodObject(object, object, int);
vobject	_jumpToMethod(ofun f);
_LONGLONG_ _callExtern(void *fp, void *sp, void *ap, int ac);
_LONGLONG_ _callExtern1(void *fp, void *sp, void *ap, int ac);
void	*GetIVptr(object, object);
int	IsObj(object);

#define TRACE_DONT_CARE		0
#define TRACE_OFF		1
#define TRACE_ON		2
#define TRACE_ALL		3


#define _cat5_(a, b, c, d, e) a##b##c##d##e
#define _5cat_(a, b, c, d, e) _cat5_(a, b, c, d, e)
#define _cat4_(a, b, c) a##b##c##d
#define _4cat_(a, b, c, d) _cat4_(a, b, c, d)
#define _cat3_(a, b, c) a##b##c
#define _3cat_(a, b, c) _cat3_(a, b, c)
#define	_cat2_(a, b)	a##b
#define _cat_(a, b)	_cat2_(a, b)
#define CLASS_I		_cat_(CLASS, _i)
#define CLASS_C		_cat_(CLASS, _c)
#define CLASS_A		_cat_(CLASS, _a)
#define Generic(x)	_cat_(x, _i)
#define Genericm(x)	_cat_(g, Generic(x))

#define _cname2_(x)	#x
#define _cname1_(x)	_cname2_(x)
#define cName		_cname1_(CLASS)

#define _im2_(x)	Init##x##Class
#define _im_(x)		_im2_(x)
#define InitMethod	void	_im_(CLASS)


#define ivType		struct	CLASS_I
#define ivTypedef	typedef struct CLASS_I
#define cvType		struct	CLASS_C
#define cvTypedef	typedef struct CLASS_C
#define instanceVars	ivType
#define classVars	cvType

#define ivPtr(x)	((ivType *) GetIVptr((x), CLASS))
#define cvsPtr		((cvType *) GetIVptr(CLASS, ClassOf(CLASS)))
#define ivsPtr		ivPtr(self)
#define accessCVs	cvType *cv = cvsPtr
#define accessIVs	ivType *iv = ivsPtr

#ifdef KERNEL
#define usesClass(c)	{ if (c == NULL) Init##c##Class(); }
#define iMethod(x)	gNew(Method, #x, CLASS, Genericm(x), x)
#define cMethod(x)	gNew(Method, #x, ClassOf(CLASS), Genericm(x), x)
#define iMethodFor(x,y)	gNew(Method, #y, CLASS, Generic(x), y)
#define cMethodFor(x,y)	gNew(Method, #y, ClassOf(CLASS), Generic(x), y)
#else
#define usesClass(c)
#define IMethod(x)	({extern vobject Genericm(x); gNew(Method, #x, CLASS, Genericm(x), x);})
#define CMethod(x)	({extern vobject Genericm(x); gNew(Method, #x, ClassOf(CLASS), Genericm(x), x);})
#define IMethodFor(x,y)	({extern vobject Generic(x);gNew(Method, #y, CLASS, Generic(x), y);})
#define CMethodFor(x,y)	({extern vobject Generic(x);gNew(Method, #y, ClassOf(CLASS), Generic(x), y);})
#define iMethod(x)	({extern vobject Genericm(x); gNew(Method, #x, CLASS, Genericm(x), x);})
#define cMethod(x)	({extern vobject Genericm(x); gNew(Method, #x, ClassOf(CLASS), Genericm(x), x);})
#define iMethodFor(x,y)	({extern vobject Generic(x);gNew(Method, #y, CLASS, Generic(x), y);})
#define cMethodFor(x,y)	({extern vobject Generic(x);gNew(Method, #y, ClassOf(CLASS), Generic(x), y);})
#endif

#define ivSize		sizeof(instanceVars)
#define cvSize		sizeof(classVars)

#define ClassOf(x)	(vobject) *((object *) (x))
#define method		static
#define imethod		method
#define cmethod		method
#define END		(vobject) 0

#define IsInstanceOf(i,c)	(ClassOf(i) == (c))
#define IsaMetaClass(x)		(ClassOf(x) == MetaClass)
#define IsaClass(x)		(IsaMetaClass(ClassOf(x)) || IsaMetaClass(x))

#define EQ(a,b)		((a) == (b))
#define NEQ(a,b)	((a) != (b))



#define tFindMethod(t, c, g, l)  (*(t (*)()) _FindMethod2(c, g, l))

#ifndef KERNEL
#define super(g)	({extern vobject Generic(g);(*_FindMethod2(CLASS, Generic(g), 2));})
#define cSuper(g)	({extern vobject Generic(g);(*_FindMethod2(ClassOf(CLASS), Generic(g), 2));})
#define typedSuper(t,g)	({extern vobject Generic(g);(*tFindMethod(t, ClassOf(self), Generic(g), 2));})
#define mSuper(g,c) ({extern vobject Generic(g);(*_FindMethod2(c, Generic(g), 2));})
#define mDirect(g,c) ({extern vobject Generic(g);(*_FindMethod2(c, Generic(g), 1));})
#define mSuperNoError(g,c) ({extern vobject Generic(g);(*_FindMethod3(c, Generic(g), 2));})
#define mDirectNoError(g,c) ({extern vobject Generic(g);(*_FindMethod3(c, Generic(g), 1));})


/* get instance method from a class object */
#define imcPointer(c,g)  (ofun)({extern vobject Generic(g);gFindMethod(c, Generic(g), 1);})
/* get class method from a class object */
#define cmcPointer(c,g)  (ofun)({extern vobject Generic(g);gFindMethod(ClassOf(c), Generic(g), 1);})
/* get instance method from an instance object */
#define imiPointer(i,g)  (ofun)({extern vobject Generic(g);gFindMethod(ClassOf(i), Generic(g), 1);})
/* get class method from an instance object */
#define cmiPointer(i,g)  (ofun)({extern vobject Generic(g);gFindMethod(ClassOf(ClassOf(i)), Generic(g), 1);})
#define RespondsTo(i,g)	(ofun)({extern vobject Generic(g);(gFindMethod(ClassOf(i), Generic(g), 1) != NULL);})

extern object Class;
extern object Method;
extern object COS;
extern vobject gNew(object, ...);
extern vobject gDispose(object);
extern ofun gFindMethod();
extern vobject LoadClass(void *);

#else /* KERNEL */
#define super(g)	(*_FindMethod2(CLASS, Generic(g), 2))
#define cSuper(g)	(*_FindMethod2(ClassOf(CLASS), Generic(g), 2))
#define typedSuper(t,g)	(*tFindMethod(t, ClassOf(self), Generic(g), 2))
/* get instance method from a class object */
#define imcPointer(c,g)  gFindMethod(c, Generic(g), 1)
/* get class method from a class object */
#define cmcPointer(c,g)  gFindMethod(ClassOf(c), Generic(g), 1)
/* get instance method from an instance object */
#define imiPointer(i,g)  gFindMethod(ClassOf(i), Generic(g), 1)
/* get class method from an instance object */
#define cmiPointer(i,g)  gFindMethod(ClassOf(ClassOf(i)), Generic(g), 1)
#define RespondsTo(i,g)	(gFindMethod(ClassOf(i), Generic(g), 1) != NULL)
#define mDirect(g,c) (*_FindMethod2(c, Generic(g), 1))
#endif /* KERNEL */

#define typedGeneric(t,g) 	(*(t (*)()) &g)


#define RegisterVariable(v)	gRegisterMemory(COS, &v, (long) sizeof(object))

#define makeThenAccess(self, obj, iv)  		\
	object	obj = cSuper(gNew)(self);	\
	ivType	*iv = ivPtr(obj)

extern	int	_CheckObjects_;
extern	object	_LastGeneric_;		/*  last generic called  */

#define ChkArg(obj, argn)						\
	if (_CheckObjects_  &&  !IsObj(obj))				\
		gInvalidObject(_LastGeneric_, argn, self)

#define ChkArgTyp(obj, argn, argType)					\
	if (_CheckObjects_)  {						\
		if (!IsObj(obj))					\
			gInvalidObject(_LastGeneric_, argn, self);	\
		if (argType)  {						\
			object	lg = _LastGeneric_;			\
			if (!gIsKindOf(obj, argType))			\
				gInvalidType(lg, argn, self, argType, obj); \
			_LastGeneric_ = lg;				\
		}							\
	}

#define ChkArgNul(obj, argn)           if (obj)  ChkArg(obj, argn)

#define ChkArgTypNul(obj, argn, argType) 	\
	if (obj)  ChkArgTyp(obj, argn, argType)

#define CheckArg(obj, argn, argType)					\
	if (_CheckObjects_)  {						\
		if (!IsObj(obj))					\
			gInvalidObject(_LastGeneric_, argn, self);	\
		if (argType)  {						\
			object	lg = _LastGeneric_;			\
			if (!gIsKindOf(obj, argType))			\
				gInvalidType(lg, argn, self, argType, obj); \
			_LastGeneric_ = lg;				\
		}							\
	}


/*  Thread stuff  */


/*  thread states   */

#define NEW_THREAD			(0)
#define	RUNNING_THREAD		(1)
#define HOLD_THREAD			(2)
#define DONE_THREAD			(3)
#define EXPUNGE_THREAD		(4)
#define WAITING_FOR_THREAD	(5)
#define WAITING_FOR_SEMAPHORE	(6)

#define DEFAULT_PRIORITY	100

#define TIMESTAMP (OXPORT_timestamp())
#define THREAD_COUNTDOWN (OXPORT_thread_countdown())
#define THREAD_MSEC (oxport_thread_msec)
#define MSEC_PER_TICK (55)
#define DEFAULT_THREAD_MSEC MSEC_PER_TICK

extern	unsigned long	_final_thread_tick;
extern	int	_no_context_switch;
extern	jmp_buf	_t_start;

extern	void	(*__cos_yield)();
extern	void	_start_threader(), _start_thread();

#define INHIBIT_THREADER	_no_context_switch++
#define ENABLE_THREADER		if (_no_context_switch) _no_context_switch--

#if 0  /*  Debugging or to disable Threads  */
#define YIELD	
#else
#define YIELD	({if (!_no_context_switch){if(THREAD_COUNTDOWN){(*__cos_yield)(0);}}})
#endif

#define StartThreader(x)		\
	_start_threader(&x);		\
	if (setjmp(_t_start))		\
		_start_thread()


/*  End of thread specific stuff  */

/* Message dispatch */
#define __CFWNDCLASS_ID__ 0xd24f193c
#define __CFMSGCLASS_ID__ 0x87104be5

typedef struct __mdis__ {
	long id;
	_LONGLONG_ (*defproc)();
	_LONGLONG_ (*usrproc)();
} *MD, MDIV;

#define ClassMsgProc(cl) \
({MD biv=GetIVptr(self,cl);(*biv->defproc)(self,wnd,it);})

#define DefaultMsgProc() \
({MD biv=GetIVptr(self,ClassOf(self));(*biv->defproc)(self,wnd,it);})

#define Mfunc(a) _5cat_(CLASS,_,MPROC,_,a)

#if 0
#define MsgFunc(a) _LONGLONG_ Mfunc(a)(object self,WINDOW wnd,CFmsg it,CLASS_I *iv,CLASS_C *cv)
#else
#define MsgFunc(a) _LONGLONG_ Mfunc(a)(MSGARGS *args)
#endif

typedef struct msgbitstuf {
void *cmdDict;
vobject bitVec;
int (*bitTest)();	
} MSGBITSTUF;

#define MSGARGS CLASS_A

#define MSGARGDEF \
typedef struct CLASS_A { \
	vobject self; \
	struct window  *wnd; \
	CFmsg it; \
	CLASS_I *iv; \
	CLASS_C *cv; \
	MSGBITSTUF bs; \
	char *fn; \
} CLASS_A;

#define TO_SUPERCLASS (0x7a6b290cf31e4811LL)

#define CLASSMSG(args...) \
({\
extern _LONGLONG_ MASTERdomsg();\
static MSGARGS margs = {fn: "_" cName "_" __FUNCTION__ "_"};\
_LONGLONG_ result; \
if(it.e_type == evAddCmd) {\
if(margs.bs.bitVec)\
  if(margs.bs.bitTest(margs.bs.bitVec, it.m_lparam))\
	gReset(margs.bs.bitVec, it.m_lparam);\
  result = 0;\
}else {\
margs.cv = cvsPtr;\
margs.iv = ivsPtr;\
margs.it = it;\
margs.wnd = wnd;\
margs.self = self;\
result = MASTERdomsg(&margs , ## args);\
}\
result;})

#if 0
#define defGeneric(t, g)   					\
	object	Generic(g) = (vobject) 0;			\
	t	g(object i, ...)			\
        {							\
		if (_CheckObjects_)  {				\
			if (!IsObj(i))				\
				gInvalidObject(Generic(g), 1, i);  \
			_LastGeneric_ = Generic(g);		\
		}						\
		YIELD;						\
		_jumpToMethod( _FindMethod(ClassOf(i), Generic(g), 1) ); \
	}
#else
#define defGeneric(t, g)   					\
	object	Generic(g) = (object) 0;			\
	t	g(object i, ...)			\
    {							\
		_jumpToMethod( _FindMethod(i, Generic(g)) ); 	\
	}
#endif

#define externGeneric(t, g)					\
	extern	object	Generic(g);				\
	extern	t	g(object i, ...);

#define InitGeneric(x)	Generic(x) = gNew(GenericFunction, #x)

#define _qt2_(x) #x
#define _qt_(x) _qt2_(x)

#define oxcall(func, args...) ({ \
typedef _fret = (func()); \
_fret (*dofunc)(); _fret _ret; \
dofunc = oxlink_find_bare_func(_qt_(_cat_(_, func))); \
if(!dofunc) \
dofunc = oxlink_load_bare_symb(_qt_(_cat_(_, func)),1); \
else oxlink_clear_bss(oxlink_file_of_bare(_qt_(_cat_(_, func))));\
if(dofunc) _ret = dofunc(## args); \
else _ret = (_fret) -1; \
_ret;})


#define oxrun(func, args...) ({ \
typedef _fret = (func()); \
_fret (*dofunc)(); _fret _ret; \
dofunc = oxlink_find_bare_func(_qt_(_cat_(_, func))); \
if(!dofunc) \
dofunc = oxlink_load_bare_symb(_qt_(_cat_(_, func)),1); \
if(dofunc) { _ret = dofunc(## args);gGC(COS);oxlink_unload_symb(#func, 0); } \
else _ret = (_fret) -1; \
_ret;})

#define oxfunc(func, args...) ({ \
typedef _fret = (appfunc()); \
_fret (*dofunc)(); _fret _ret; \
dofunc = oxlink_load_bare_symb(func,1); \
if(dofunc) _ret = dofunc(## args); \
else _ret = (_fret) -1; \
_ret;})

#define oxload_bare(func) \
oxlink_load_bare_symb(_qt_(_cat_(_, func)),1)

#define oxload(func) \
oxlink_load_symb(#func,1)

#define oxunload(func) \
oxlink_unload_symb(#func, 0)


#define DISPATCH_MESSAGES \
({extern vobject Thread; vobject _th = (vobject)gFind(Thread, NULL); \
while(DispatchMessages(_th));})

#define INIT_IO(arg) \
({_LONGLONG_ AppMsg();CF_InitIO(arg, AppMsg); \
if((arg & (CF_USE_MESSAGES|CF_USE_EVENTS)) && !(arg & CF_USE_GUI)) { \
extern object Absorber; \
extern object Application; \
vobject pgm = gNew(Absorber, AppMsg); \
Application = Absorber; \
CaptureKeyboard(pgm, 0);}})

extern void *_cos_malloc(unsigned);
extern void *_cos_calloc(unsigned, unsigned);
extern void *_cos_realloc(void *, unsigned);
#define	 Talloc(t)   (t *) _cos_malloc(sizeof(t))
#define	 Tcalloc(t)  (t *) _cos_calloc(1, sizeof(t))
#define	 Tnalloc(t,n)   (t *) _cos_malloc((n) * sizeof(t))
#define	 Tncalloc(t,n)  (t *) _cos_calloc((n), sizeof(t))
#define  Tnrealloc(t,n,b) (t *) _cos_realloc(b, (n) * sizeof(t))

#ifdef KERNEL
#include <generics.h>
#endif /* KERNEL */

/*  from the Stream class  */
extern	object	stdoutStream, stdinStream, stderrStream;
extern	object	traceStream;

void	*MA_malloc(unsigned, void *);
void	MA_free(void *);
void	*MA_realloc(void *, unsigned);
void	MA_compact(void);
void	*MA_calloc(unsigned, void *);

#define	 MTncalloc(t,n,v)  (t *) MA_calloc((n) * sizeof(t), &v)
#define	 MTnalloc(t,n,v)   (t *) MA_malloc((n) * sizeof(t), &v)

/* KEYCODES */
/* ----------- keys ------------ */

/* 
	This file defines all extended keys which can be read from DOS in
	raw unfiltered mode with CTRL BREAK checking turned off. i.e.
	the first character read is == 0 and the second character contains
	a scan code. Here we create a 2 byte character with the scan code
	in the low order byte and a flag bit in the high order byte.
	
	Non printable characters created by typing the CTRL key are also
	defined here.
*/
/* 
	Believe it or not, gcc 2.2.2 has a bug which causes parsing to fail
	if a hex constant ends in E or e. So you will see decimal values
	occasionally. [NDC]
*/
#define EFLAG 		(0x0100)
#define SHIFTFLAG	(0x0200)
#define ALTFLAG		(0x0400)
#define CTRLFLAG	(0x0800)

#define CTL_AT	(0x0)
#define NUL		(0x0)
#define CTL_A	(0x1)
#define SOH		(0x1) 
#define CTL_B	(0x2)
#define STX		(0x2)
#define CTL_C	(0x3)
#define ETX		(0x3)
#define CTL_D	(0x4)
#define EOT		(0x4)
#define CTL_E	(0x5)
#define ENQ		(0x5)
#define CTL_F	(0x6)
#define ACK		(0x6)
#define CTL_G	(0x7)
#define BELL	(0x7)
#define CTL_H	(0x8)
#define RUBOUT	(0x8)
#define BS		(0x8)
#define CTL_I	(0x9)
#define HT		(0x9)
#define TAB		(0x9)
#define CTL_J	(0xA)
#define LF		(0xA)
#define CTL_K	(0xB)
#define VT		(0xB)
#define CTL_L	(0xC)
#define FF		(0xC)
#define CTL_M	(0xD)
#define CR		(0xD)
#define ENTER	(0xD)
#define CTL_N	(6)
#define SO		(6)
#define CTL_O	(0xF)
#define SI		(0xF)
#define CTL_P	(0x10)
#define DLE		(0x10)
#define CTL_Q	(0x11)
#define DC1		(0x11)
#define CTL_R	(0x12)
#define DC2		(0x12)
#define CTL_S	(0x13)
#define DC3		(0x13)
#define CTL_T	(0x14)
#define DC4		(0x14)
#define CTL_U	(0x15)
#define NAK		(0x15)
#define CTL_V	(0x16)
#define SYN		(0x16)
#define CTL_W	(0x17)
#define ETB		(0x17)
#define CTL_X	(0x18)
#define CAN		(0x18)
#define CTL_Y	(0x19)
#define EM		(0x19)
#define CTL_Z	(0x1A)
#define SUB		(0x1A)
#define CTL_LBRK	(0x1B)
#define ESCKEY		(0x1B)
#define CTL_BKSLSH	(0x1C)
#define FS			(0x1C)
#define CTL_RBRK	(0x1D)
#define GS			(0x1D)
#define CTL_CARAT	(30) 
#define RS			(30)
#define CTL_HYPHEN	(0x1F)
#define US			(0x1F)
#define CTL_BS		(0x7F)
#define ASCIDEL		(0x7F)
#define SLASHKEY 	('/')
#define SPACEKEY 	(' ')

#define F1			(0x3B+EFLAG)
#define F2			(0x3C+EFLAG)
#define F3			(0x3D+EFLAG)
#define F4			(62+EFLAG)
#define F5			(0x3F+EFLAG)
#define F6			(0x40+EFLAG)
#define F7			(0x41+EFLAG)
#define F8			(0x42+EFLAG)
#define F9			(0x43+EFLAG)
#define F10			(0x44+EFLAG)
#define F11			(0x85+EFLAG)
#define F12			(0x86+EFLAG)
#define SHIFT_F1	(0x54+EFLAG)
#define SHIFT_F2	(0x55+EFLAG)
#define SHIFT_F3	(0x56+EFLAG)
#define SHIFT_F4	(0x57+EFLAG)
#define SHIFT_F5	(0x58+EFLAG)
#define SHIFT_F6	(0x59+EFLAG)
#define SHIFT_F7	(0x5A+EFLAG)
#define SHIFT_F8	(0x5B+EFLAG)
#define SHIFT_F9	(0x5C+EFLAG)
#define SHIFT_F10	(0x5D+EFLAG)
#define SHIFT_F11	(0x87+EFLAG)
#define SHIFT_F12	(0x88+EFLAG)
#define CTRL_F1		(94+EFLAG)
#define CTRL_F2     (0x5F+EFLAG)
#define CTRL_F3     (0x60+EFLAG)
#define CTRL_F4     (0x61+EFLAG)
#define CTRL_F5     (0x62+EFLAG)
#define CTRL_F6     (0x63+EFLAG)
#define CTRL_F7     (0x64+EFLAG)
#define CTRL_F8     (0x65+EFLAG)
#define CTRL_F9     (0x66+EFLAG)
#define CTRL_F10    (0x67+EFLAG)
#define CTRL_F11    (0x89+EFLAG)
#define CTRL_F12    (0x8A+EFLAG)
#define ALT_F1      (0x68+EFLAG)
#define ALT_F2      (0x69+EFLAG)
#define ALT_F3      (0x6A+EFLAG)
#define ALT_F4      (0x6B+EFLAG)
#define ALT_F5      (0x6C+EFLAG)
#define ALT_F6      (0x6D+EFLAG)
#define ALT_F7		(110+EFLAG)
#define ALT_F8      (0x6F+EFLAG)
#define ALT_F9      (0x70+EFLAG)
#define ALT_F10     (0x71+EFLAG)
#define ALT_F11     (0x8B+EFLAG)
#define ALT_F12     (0x8C+EFLAG)

#define HOMEKEY		(0x47+EFLAG)
#define UPKEY		(0x48+EFLAG)
#define PGUP		(0x49+EFLAG)
#define BAKKEY		(0x4B+EFLAG)
#define FWDKEY		(0x4D+EFLAG)

#define ENDKEY		(0x4F+EFLAG)
#define DNKEY		(0x50+EFLAG)
#define PGDN		(0x51+EFLAG)
#define INSERTKEY	(0x52+EFLAG)
#define DELETEKEY	(0x53+EFLAG)

#define CTRL_HOME	(0x77+EFLAG)
#define CTRL_UP		(0x8D+EFLAG)
#define CTRL_PGUP	(0x84+EFLAG)
#define CTRL_BAK	(0x73+EFLAG)
#define CTRL_FWD	(0x74+EFLAG)
#define CTRL_END	(0x75+EFLAG)
#define CTRL_DN		(0x91+EFLAG)
#define CTRL_PGDN	(0x76+EFLAG)
#define CTRL_INSERT	(0x92+EFLAG)
#define CTRL_DELETE	(0x93+EFLAG)
#define CTRL_HT		(0x94+EFLAG)
#define CTRL_TAB	CTRL_HT
#define CTRL_2		(0x03+EFLAG)

/* keypad keys */
#define KP_FIVE			(0x4c+EFLAG)
#define CTRL_KP_SLASH	(0x95+EFLAG)
#define CTRL_KP_STAR	(0x96+EFLAG)
#define CTRL_KP_PLUS	(0x90+EFLAG)
#define CTRL_KP_MINUS	(142+EFLAG)
#define CTRL_KP_FIVE	(0x8F+EFLAG)

/* *** GRAY CENTER KEYS ONLY *** */
#define ALT_HOME	(0x97+EFLAG)
#define ALT_UP		(0x98+EFLAG)
#define ALT_PGUP	(0x99+EFLAG)
#define ALT_BAK		(0x9B+EFLAG)
#define ALT_FWD		(0x9D+EFLAG)
#define ALT_END		(0x9F+EFLAG)
#define ALT_DN		(0xA0+EFLAG)
#define ALT_PGDN	(0xA1+EFLAG)
#define ALT_INSERT	(0xA2+EFLAG)
#define ALT_DELETE	(0xA3+EFLAG)
/* ****************************** */

#define ALT_A		(30+EFLAG)
#define ALT_B		(0x30+EFLAG)
#define ALT_C		(46+EFLAG)
#define ALT_D		(0x20+EFLAG)
#define ALT_E		(0x12+EFLAG)
#define ALT_F		(0x21+EFLAG)
#define ALT_G		(0x22+EFLAG)
#define ALT_H		(0x23+EFLAG)
#define ALT_I		(0x17+EFLAG)
#define ALT_J		(0x24+EFLAG)
#define ALT_K		(0x25+EFLAG)
#define ALT_L		(0x26+EFLAG)
#define ALT_M		(0x32+EFLAG)
#define ALT_N		(0x31+EFLAG)
#define ALT_O		(0x18+EFLAG)
#define ALT_P		(0x19+EFLAG)
#define ALT_Q		(0x10+EFLAG)
#define ALT_R		(0x13+EFLAG)
#define ALT_S		(0x1F+EFLAG)
#define ALT_T		(0x14+EFLAG)
#define ALT_U		(0x16+EFLAG)
#define ALT_V		(0x2F+EFLAG)
#define ALT_W		(0x11+EFLAG)
#define ALT_X		(0x2D+EFLAG)
#define ALT_Y		(0x15+EFLAG)
#define ALT_Z		(0x2C+EFLAG)
#define ALT_1		(0x78+EFLAG)
#define ALT_2		(0x79+EFLAG)
#define ALT_3		(0x7A+EFLAG)
#define ALT_4		(0x7B+EFLAG)
#define ALT_5		(0x7C+EFLAG)
#define ALT_6		(0x7D+EFLAG)
#define ALT_7		(126+EFLAG)
#define ALT_8		(0x7F+EFLAG)
#define ALT_9		(0x80+EFLAG)
#define ALT_0		(0x81+EFLAG)
#define ALT_HYPHEN	(0x82+EFLAG)
#define ALT_EQUALS	(0x83+EFLAG)
#define ALT_LBRK	(0x1A+EFLAG)
#define ALT_RBRK	(0x1B+EFLAG)
#define ALT_SEMI	(0x27+EFLAG)
#define ALT_RAPOS	(0x28+EFLAG)
#define ALT_LAPOS	(0x29+EFLAG)
#define ALT_BKSLSH	(0x2B+EFLAG)
#define ALT_COMMA	(0x33+EFLAG)
#define ALT_PERIOD	(0x34+EFLAG)
#define ALT_SLASH	(0x35+EFLAG)
#define ALT_BS		(6+EFLAG)
#define ALT_ENTER	(0x1C+EFLAG)
#define ALT_HT		(0xA5+EFLAG)
#define ALT_TAB		ALT_HT
#define ALT_ESC		(0x01+EFLAG)

/* keypad keys */
#define ALT_KP_ENTER	(0xA6+EFLAG)
#define ALT_KP_PLUS		(78+EFLAG)
#define ALT_KP_MINUS	(0x4A+EFLAG)
#define ALT_KP_STAR		(0x37+EFLAG)
#define ALT_KP_SLASH	(0xA4+EFLAG)

#define SHIFT_HT		(0x0F+EFLAG)
#define SHIFT_TAB 		SHIFT_HT
/* 
	Artificial codes produced by testing the shift states

	Unused codes:
	02,04,05,06,07,08,09,0A,0B,0C,0D,2A,36,38,39,3A,45,46,
	72,9A,A7-AF,BC-BF,C0-CF,E0-EF,F0-FF
*/

#define SHIFT_INSERT		(INSERTKEY+SHIFTFLAG)
#define SHIFT_END			(ENDKEY+SHIFTFLAG)
#define SHIFT_DN			(DNKEY+SHIFTFLAG)
#define SHIFT_PGDN			(PGDN+SHIFTFLAG)
#define SHIFT_BAK			(BAKKEY+SHIFTFLAG)
#define SHIFT_KP_FIVE		(KP_FIVE+SHIFTFLAG)
#define SHIFT_FWD			(FWDKEY+SHIFTFLAG)
#define SHIFT_HOME			(HOMEKEY+SHIFTFLAG)
#define SHIFT_UP			(UPKEY+SHIFTFLAG)
#define SHIFT_PGUP			(PGUP+SHIFTFLAG)
#define SHIFT_DELETE		(DELETEKEY+SHIFTFLAG)

#define SHIFT_CTRL_INSERT	(CTRL_INSERT+SHIFTFLAG)
#define SHIFT_CTRL_END		(CTRL_END+SHIFTFLAG)
#define SHIFT_CTRL_DN		(CTRL_DN+SHIFTFLAG)
#define SHIFT_CTRL_PGDN		(CTRL_PGDN+SHIFTFLAG)
#define SHIFT_CTRL_BAK		(CTRL_BAK+SHIFTFLAG)
#define SHIFT_CTRL_KP_FIVE	(CTRL_KP_FIVE+SHIFTFLAG)
#define SHIFT_CTRL_FWD		(CTRL_FWD+SHIFTFLAG)
#define SHIFT_CTRL_HOME		(CTRL_HOME+SHIFTFLAG)
#define SHIFT_CTRL_UP		(CTRL_UP+SHIFTFLAG)
#define SHIFT_CTRL_PGUP		(CTRL_PGUP+SHIFTFLAG)
#define SHIFT_CTRL_DELETE	(CTRL_DELETE+SHIFTFLAG)

#define SHIFT_ALT_INSERT	(ALT_INSERT+SHIFTFLAG)
#define SHIFT_ALT_END		(ALT_END+SHIFTFLAG)
#define SHIFT_ALT_DN		(ALT_DN+SHIFTFLAG)
#define SHIFT_ALT_PGDN		(ALT_PGDN+SHIFTFLAG)
#define SHIFT_ALT_BAK		(ALT_BAK+SHIFTFLAG)
#define SHIFT_ALT_FWD		(ALT_FWD+SHIFTFLAG)
#define SHIFT_ALT_HOME		(ALT_HOME+SHIFTFLAG)
#define SHIFT_ALT_UP		(ALT_UP+SHIFTFLAG)
#define SHIFT_ALT_PGUP		(ALT_PGUP+SHIFTFLAG)
#define SHIFT_ALT_DELETE	(ALT_DELETE+SHIFTFLAG)

#define CTRL_ALT_INSERT		(ALT_INSERT+CTRLFLAG)
#define CTRL_ALT_END		(ALT_END+CTRLFLAG)
#define CTRL_ALT_DN			(ALT_DN+CTRLFLAG)
#define CTRL_ALT_PGDN		(ALT_PGDN+CTRLFLAG)
#define CTRL_ALT_BAK		(ALT_BAK+CTRLFLAG)
#define CTRL_ALT_FWD		(ALT_FWD+CTRLFLAG)
#define CTRL_ALT_HOME		(ALT_HOME+CTRLFLAG)
#define CTRL_ALT_UP			(ALT_UP+CTRLFLAG)
#define CTRL_ALT_PGUP		(ALT_PGUP+CTRLFLAG)
#define CTRL_ALT_DELETE		(ALT_DELETE+CTRLFLAG)

#define SHIFT_CTRL_KP_SLASH	(CTRL_KP_SLASH+SHIFTFLAG)
#define SHIFT_CTRL_KP_STAR	(CTRL_KP_STAR+SHIFTFLAG)
#define SHIFT_CTRL_KP_MINUS	(CTRL_KP_MINUS+SHIFTFLAG)
#define SHIFT_CTRL_KP_PLUS	(CTRL_KP_PLUS+SHIFTFLAG)
#define SHIFT_ALT_KP_ENTER	(ALT_KP_ENTER+SHIFTFLAG)
#define CTRL_ALT_KP_ENTER	(ALT_KP_ENTER+CTRLFLAG)
#define CTRL_ALT_KP_PLUS	(ALT_KP_PLUS+CTRLFLAG)
#define CTRL_ALT_KP_MINUS	(ALT_KP_MINUS+CTRLFLAG)
#define CTRL_ALT_KP_STAR	(ALT_KP_STAR+CTRLFLAG)
#define CTRL_ALT_KP_SLASH	(ALT_KP_SLASH+CTRLFLAG)


#define SHIFT_CTRL_BS		(CTL_BS+SHIFTFLAG)
#define SHIFT_ALT_BS		(ALT_BS+SHIFTFLAG)
#define SHIFT_CTRL_HT		(CTRL_HT+SHIFTFLAG)
#define SHIFT_CTRL_TAB		SHIFT_CTRL_HT
#define SHIFT_ALT_HT		(ALT_HT+SHIFTFLAG)
#define SHIFT_ALT_TAB		SHIFT_ALT_HT

#define CTRL_ALT_BS			(ALT_BS+CTRLFLAG)
#define CTRL_SLASH			(SLASHKEY+CTRLFLAG)
#define CTRL_ESC			(ESCKEY+CTRLFLAG)
#define CTRL_SPACE			(SPACEKEY+CTRLFLAG)
#define SHIFT_ESC			(ESCKEY+SHIFTFLAG)
#define ALT_SPACE			(SPACEKEY+ALTFLAG)

/* keypad specials (not usually implemented) */
#define KP_ENTER			(0xB0+EFLAG)
#define KP_PLUS				(0xB1+EFLAG)
#define KP_MINUS			(0xB2+EFLAG)
#define KP_STAR				(0xB3+EFLAG)
#define KP_SLASH			(0xB4+EFLAG)
#define SHIFT_KP_ENTER		(0xB5+EFLAG)
#define SHIFT_KP_PLUS		(0xB6+EFLAG)
#define SHIFT_KP_MINUS		(0xB7+EFLAG)
#define SHIFT_KP_STAR		(0xB8+EFLAG)
#define SHIFT_KP_SLASH		(0xB9+EFLAG)
#define CTRL_KP_ENTER		(0xBA+EFLAG)
#define SHIFT_CTRL_KP_ENTER	(0xBB+EFLAG)



/* ---------- EVENT STUFF ------------- */

typedef union {		/* 8 bytes (a long long ) */
	_LONGLONG_ item;
	short m_type;
	STOR s;
#define e_keychar s.a5.b[4]
#define e_keyflag s.a5.b[5]
#define m_sparam s.a3.s1
#define m_lparam s.a4.s1
	struct {
		unsigned short type;
		unsigned char kbstat;
		unsigned char mask;
		short xpos;
		short ypos;
#define e_type e.type
#define e_kbstat e.kbstat
#define e_mask e.mask
#define e_xpos e.xpos
#define e_ypos e.ypos
#define e_keycode e.xpos
	} e;
} RawEvent, CFmsg;


#define M_MOTION		(0x001)
#define M_LEFT_DOWN		(0x002)
#define M_LEFT_UP		(0x004)
#define M_RIGHT_DOWN	(0x008)
#define M_RIGHT_UP		(0x010)
#define M_MIDDLE_DOWN	(0x020)
#define M_MIDDLE_UP		(0x040)
#define M_BUTTON_DOWN	(M_LEFT_DOWN | M_MIDDLE_DOWN | M_RIGHT_DOWN)
#define M_BUTTON_UP		(M_LEFT_UP   | M_MIDDLE_UP   | M_RIGHT_UP)
#define M_BUTTON_CHANGE (M_BUTTON_UP | M_BUTTON_DOWN )

#define KB_RIGHTSHIFT	(0x01)		/* right shift key depressed */
#define KB_LEFTSHIFT	(0x02)		/* left shift key depressed */
#define KB_CTRL			(0x04)		/* CTRL depressed */
#define KB_ALT			(0x08)		/* ALT depressed */
#define KB_SCROLLOCK	(0x10)		/* SCROLL LOCK active */
#define KB_NUMLOCK		(0x20)		/* NUM LOCK active */
#define KB_CAPSLOCK		(0x40)		/* CAPS LOCK active */
#define GLBLKEY			(0x80)
#define KB_SHIFT		(KB_LEFTSHIFT | KB_RIGHTSHIFT)

/* A complicated CUA information word */
extern int AltDown;

typedef struct {
    unsigned short  width;
    unsigned short  height;
    unsigned short  number_of_colors;
    unsigned char   BIOS_mode;
    unsigned char   special;
} DRIVER_MODE_ENTRY;

/* Pointer to a millisecond unsigned long ticker */
extern unsigned long oxport_thread_msec;

int OXPORT_shift_state();
void OXPORT_deinit_kbd(long arg);
void OXPORT_init_kbd(long arg);
int OXPORT_was_kbd();
int OXPORT_get_kbd();
void OXPORT_flush_kbd(void);
void OXPORT_position_kb_cursor(int x, int y);
void OXPORT_get_kb_cursor_pos_shape(int *pos, int *shape);
void OXPORT_set_kb_cursor_shape(int shape);
void OXPORT_hide_kb_cursor();
void OXPORT_unhide_kb_cursor();
void OXPORT_direct_attr_text_output(int offset, short *buf, int len);
void OXPORT_bios_attr_text_output(int x, int y, short *buf, int len);

void OXPORT_read_image(void *dst, int x, int y, int wd, int ht, int dw);
void OXPORT_write_image(void *src, int x, int y, int wd, int ht, int sw);
void OXPORT_or_image(void *src, int x, int y, int wd, int ht, int sw);
void OXPORT_and_image(void *src, int x, int y, int wd, int ht, int sw);
void OXPORT_xor_image(void *src, int x, int y, int wd, int ht, int sw);

void OXPORT_deinit_events(long arg);
int OXPORT_init_events(long arg);
int OXPORT_was_event(void);
RawEvent OXPORT_get_event(void);

void OXPORT_set_mouse_cursor_shape(void *shape);
int OXPORT_register_mouse_cursor_shape(void *shape);
void OXPORT_set_mouse_limits(int x1, int y1, int x2, int y2);
void OXPORT_set_mouse_speed(int speed);
void OXPORT_set_mouse_accel(int thresh, int accel);
void OXPORT_disable_mouse(void);
void OXPORT_enable_mouse(void);
void OXPORT_set_mousepos(int x, int y);

int OXPORT_get_curr_screen_mode(void);
int OXPORT_get_curr_screen_cols(void);
int OXPORT_get_curr_screen_rows(void);
void OXPORT_get_video_modes(void);
void OXPORT_set_video_mode(int mode);
void OXPORT_set_ORIGvideo_mode(int mode);
void OXPORT_read_palette_register(int n, int *red, int *green, int *blue);
void OXPORT_write_palette_register(int n, int *red, int *green, int *blue);
void OXPORT_clear_screen(void);
void OXPORT_fill_screen_rect(int color, int x, int y, int w, int h);

void OXPORT_start_timer(void);
void OXPORT_stop_timer(void);
void OXPORT_set_thread_msec(int msec);
void OXPORT_compute_final_tick(void);
unsigned long OXPORT_get_clock_ticks(void);
unsigned long OXPORT_get_timestamp(void);
void OXPORT_wait_msec(long n);
void OXPORT_beep(int freq);
void OXPORT_beeplen(int freq, int msec);

void OXPORT_crash(char *msg);
void OXPORT_nulproc(void);

int CF_was_msg(void);
CFmsg CF_get_msg(void);
void CF_InitIO(long arg, _LONGLONG_ (*msgproc)());

#define CF_REMOTE_KEYBOARD (1)
#define CF_USE_EVENTS	(2)
#define CF_USE_MESSAGES	(4)
#define CF_USE_GUI		(8)
#define CF_ANSI_TEXT_OUTPUT	(16)
#define CF_BIOS_TEXT_OUTPUT (32)
#define CF_DIRECT_TEXT_OUTPUT (64)
#define CF_GRAPHIC_TEXT_OUTPUT (128)
#define CF_GRAPHIC_OUTPUT (256)
#define CF_TEXT_MODE (CF_ANSI_TEXT_OUTPUT|CF_BIOS_TEXT_OUTPUT|CF_DIRECT_TEXT_OUTPUT)
#define CF_GRAPHIC_MODE (CF_GRAPHIC_TEXT_OUTPUT|CF_GRAPHIC_OUTPUT)

extern _LONGLONG_
DeliverMessage(vobject to, CFmsg m);
extern void
QueueMessage(vobject to, CFmsg m);

#define SendEvent(to, msg, sparm, lparm) \
({CFmsg it;it.e_type=msg;it.m_sparam=(short)sparm;it.m_lparam=(long)lparm; \
DeliverMessage(to,it);})

#define PostEvent(to, msg, sparm, lparm) \
({CFmsg it;it.e_type=msg;it.m_sparam=(short)sparm;it.m_lparam=(long)lparm; \
QueueMessage(to,it);})

extern _LONGLONG_
ConstructCommand(vobject to, char *cmd, short sparm, long lparm, int flag);

#define SendCommand(to, cmd, sparm, lparm) \
ConstructCommand(to, #cmd, sparm, lparm, 0)

#define PostCommand(to, cmd, sparm, lparm) \
ConstructCommand(to, #cmd, sparm, lparm, 1)

extern vobject CaptureKeyboard(vobject self, int nochild);
extern void ReleaseKeyboard(vobject self, vobject prev);
extern vobject CaptureMouse(vobject self, int nochild);
extern void ReleaseMouse(vobject self, vobject prev);
extern void CaptureMotion(vobject self);
extern void ReleaseMotion(vobject self);
extern void CaptureClock(vobject self);
extern void ReleaseClock(vobject self);
extern void CaptureTicker(vobject self);
extern void ReleaseTicker(vobject self);
extern void EnterLeave(int flag);

/* ------------ Global coordinate macros -------------- */

#define SCREENXMAX _SCREENXMAX
#define SCREENYMAX _SCREENYMAX
#define SCREENHEIGHT _SCREENHEIGHT
#define SCREENWIDTH _SCREENWIDTH
#define EFFECTIVE_SCREENWIDTH _EFFECTIVE_SCREENWIDTH
#define EFFECTIVE_SCREENHEIGHT _EFFECTIVE_SCREENHEIGHT
#define GLOBALHEIGHT _GLOBALHEIGHT
#define GLOBALWIDTH _GLOBALWIDTH
#define FONTHEIGHT _FONTHEIGHT
#define FONTWIDTH _FONTWIDTH
#define CURCOLS _CURCOLS
#define CURROWS _CURROWS
#define MAXROWS _MAXROWS
#define MAXCOLS _MAXCOLS
#define LINEHEIGHT _LINEHEIGHT
#define CHARWIDTH _CHARWIDTH
#define GRIDWIDTH _GRIDWIDTH
#define GRIDHEIGHT _GRIDHEIGHT
#define GLOBALX _GLOBALX
#define GLOBALY _GLOBALY
#define UserXMin GLOBALX
#define UserYMin GLOBALY
#define UserXMax (GLOBALX+GLOBALWIDTH-1)
#define UserYMax (GLOBALY+GLOBALHEIGHT-1)
#define VBUF_SIZE (MAXROWS*MAXCOLS)
#define VIDEOMODE _VIDEOMODE
#define LOOK _LOOK
#define FEEL _FEEL
#define REMOTEFD _REMOTEFD

extern int GuiEnabled;
extern long AppArg;
extern int _SCREENXMAX;
extern int _SCREENYMAX;
extern int _SCREENHEIGHT;
extern int _SCREENWIDTH;
extern int _EFFECTIVE_SCREENWIDTH;
extern int _EFFECTIVE_SCREENHEIGHT;
extern int _GLOBALHEIGHT;
extern int _GLOBALWIDTH;
extern int _FONTHEIGHT;
extern int _FONTWIDTH;
extern int _CURCOLS;
extern int _CURROWS;
extern int _LINEHEIGHT;
extern int _CHARWIDTH;
extern int _GRIDWIDTH;
extern int _GRIDHEIGHT;
extern int _GLOBALX;
extern int _GLOBALY;
extern int _MAXROWS;
extern int _MAXCOLS;
extern int _VIDEOMODE;
extern int _LOOK;
extern int _FEEL;
extern int _REMOTEFD;
extern DRIVER_MODE_ENTRY *TextModes;
extern int numTextModes;
extern DRIVER_MODE_ENTRY *GraphicModes;
extern int numGraphicModes;
extern int MouseEnabled;

#define DEFAULT_LOOK 0
#define LOOK_TEXT1		1
#define LOOK_TEXT2		2
#define LOOK_TEXT3		3
#define LOOK_TEXT4		4
#define LOOK_GRAPHICS1	20
#define LOOK_GRAPHICS2	21
#define LOOK_GRAPHICS3	22
#define LOOK_GRAPHICS4	23
#define LOOK_GRAPHICS5	24

#define DEFAULT_FEEL 0
#define FEEL_CUA 1


#define rdiv(a,b) \
	((a)/(b))
#define Scale(var,arg,num,den)	\
((var) = rdiv(((arg) * (num)),(den)))

#define g2sx(x) \
Scale(x,x,EFFECTIVE_SCREENWIDTH,GLOBALWIDTH)
#define g2sy(y) \
Scale(y,y,EFFECTIVE_SCREENHEIGHT,GLOBALHEIGHT)
#define s2gx(x) \
Scale(x,x,GLOBALWIDTH,EFFECTIVE_SCREENWIDTH)
#define s2gy(y) \
Scale(y,y,GLOBALHEIGHT,EFFECTIVE_SCREENHEIGHT)
#define c2gx(x) \
Scale(x,x,GLOBALWIDTH,CURCOLS)
#define c2gy(y) \
Scale(y,y,GLOBALHEIGHT,CURROWS)
#define c2sx(x) \
Scale(x,x,EFFECTIVE_SCREENWIDTH,CURCOLS)
#define c2sy(y) \
Scale(y,y,EFFECTIVE_SCREENHEIGHT,CURROWS)
#define s2cx(x) \
Scale(x,x,1,FONTWIDTH)
#define s2cy(y) \
Scale(y,y,1,FONTHEIGHT)
#define g2cx(x) \
Scale(x,x,1,CHARWIDTH)
#define g2cy(y) \
Scale(y,y,1,LINEHEIGHT)


vobject
NewGuiClass(
    object cl,       	      /* class      				*/
    char *title,              /* window title or NULL       */
    int left, int top,        /* upper left coordinates     */
    int height, int width,    /* dimensions (global coords) */
    void *extension,          /* pointer to additional data */
    void *parent,             /* parent of window (a window)*/
	_LONGLONG_ (*msgproc)(),  /* message proc for user      */
    unsigned long attrib,     /* window attributes          */
	int look, int feel
	);

/* PARSER STUFF */
#define ASTMODE 1
#define LEXMODE 2
#define EOF_MARK       26   /* End of file character.                  */
#define ACTION         1           /* Call action function.            */
#define MAKENODE       2           /* Make a node.                     */
#define DELTREE        4           /* Delete the subtree.              */
#define PL_ACTION	0x10
#define PL_MAKENODE 0x20
#define PL_DELTREE  0x40
#define LEFT_ASSOC 0
#define RIGHT_ASSOC 1
#define NON_ASSOC 2
#define PARSER_STKSIZE 512
#define ASTMINADDR ((AstP)(100000))	/* lowest allowed address (line numbers here ) */

/*--- PARSER SYMBOL Structure. ---------------------------------------------*/

typedef struct                 /* Symbol table cell structure (4 bytes). */
{
   char   *name;		/* Pointer to name.               */
} PARSER_SYMBOL;

typedef struct
{
	int cnt;
	PARSER_SYMBOL *ptr;
} PARSER_SYMBOL_TABLE;

/*--- AST NODE Structure. --------------------------------------------------*/
#ifndef __ASTNODEH__
#define __ASTNODEH__
typedef union _datum { /* 16 bytes */
	STOR stor;
	CAT cat;
	struct {
		char d[16];
	} chr;
	struct {
		unsigned char d[16];
	} uchr;
	struct {
		short d[8];
	} shrt;
	struct {
		unsigned short d[8];
	} ushrt;
	struct {
		long d[4];
	} lng;
	struct {
		unsigned long d[4];
	} ulng;
	struct {
		_LONGLONG_ d[2];
	} lnglng;
	struct {
		unsigned _LONGLONG_ d[2];
	} ulnglng;
	struct {
		void *d[4];
	} ptr;
	unsigned char	Uuchar;
	char			Uchar;
	unsigned short	Uushort;
	short			Ushort;
	unsigned int	Uuint;
	int				Uint;
	unsigned long	Uulong;
	long			Ulong;
	void *			Upointer;
	float			Ufloat;
	double			Udouble;
	unsigned _LONGLONG_ Uulonglong;
	_LONGLONG_		Ulonglong;

#if SUPPORT_LONG_DOUBLE
	long double		Ulongdouble;
#endif
} DATUM, *PDATUM;

typedef struct  ast_node 
{/* MINIMUM AST Node structure. (20 bytes)  */
   struct ast_node *right;
   struct ast_node *down;
   short  symb;				/* Symbol number */
   short    id;				/* Nodeid  ((id<<6)|subid) */
   unsigned short Tindx; 	/* Terminal type (is a symbol number) */
   unsigned short lineno;	/* line number */
   unsigned short flags;	/* general purpose flags */
   unsigned char fileno;	/* File number */
   unsigned char colno;		/* column of input text */
} AST_NODE, *AstP;

#endif /* __ASTNODEH__ */

typedef struct
{
	int cnt;
	int freecnt;
	AstP free;
} PARSER_AST_TABLE;

/* The structure at the beginning of each set of tables in the .lod file */
typedef struct lodtable {

long	type;		/* type of tables, LEXMODE, ASTMODE etc */
long	next;		/* offset from start of current structure to next structure */

/* Offsets to tables in the file */
long	t_D_red;
long	t_R_start;
long	t_R_symbol;
long	t_R_prod;
long	t_rBase;
long	t_Head;
long	t_MT_beg;
long	t_MT_tran;
long	t_MN_beg;
long	t_MN_tran;
long	t_M_bits;
long	t_G_symbol;
long	t_PL;
long	t_LGT;
long	n_actions;

long	t_ACTIONS;
long	t_ACTIONSTRINGS;
long	t_ia_numb;			/* unused */
long	t_oa_numb;			/* unused */
long	t_ia_proc;			/* unused */
long	t_oa_proc;			/* unused */
long	t_node_proc;		/* unused */

/* constants */
long	TM;
long	bitwords;
long	n_terms;
long	n_vars;
long	n_symbs;
long	n_rules;
long	n_states;
long	maxtoken;
} LODTABLE;
typedef struct _pactions {
	void (*func)();
	int args[9];
} *PACTIONS;

typedef struct {
	PARSER_AST_TABLE pat;
	PARSER_SYMBOL_TABLE pst;
	AstP	root;
	int		category;
	char	language[32];

	struct lodtable *lod_table;
	void	*in_file;
	void	*symhandle;
	void	*ROOT;
	unsigned int		line_numb;
	unsigned int		line_char;
	unsigned int		line_file;	/* entry in the 'files' array below */
	int		parsecnt;
	int		n_actions;
	PACTIONS ACTIONS;
	char 	*ACTIONSTRINGS;
	struct ptable	*ptab;
	struct ltable	*ltab;
	int		LSP;
	int		errors;
#define PARSER_DEBUG 1
#define LEXER_DEBUG 2
#define NO_DYNAMIC_TOKENS 4
	int 	debug;
	int 	lastsymnum;
	int		lastclass;
	char	*actionerr;
	int		maxfile;
	int		numfiles;
	int		curfile;
	int		totsymlen;
	int		hashdups;
	short	L_stack[4];
	short	files[64];	/* contains symbol numbers of filenames */
	short	blockinID;
	short	blockoutID;
	int		blocklevel; /* block nesting level */
	char	*chunkbase;	/* symbol text is stored in chunks during parse */
	char	*chunkend;
	char	*symbase;
	char	*symend;
	_LONGLONG_	symhash;
	unsigned int symspot;
	int		(*readfunc)();	/* stream reader function */
	int		(*writefunc)();	/* stream writer function */
	int		(*readcharfunc)();
	int		(*writecharfuc)();
	int		(*statfunc)();
	int		fstack_depth;
	int		fstack[64];		/* for included file nesting */
	int		obj_inbufcnt;
	int		obj_inbufsize;
	unsigned char	obj_inbuf[128];
	int		astchunk;
	int		symbolchunk;
	int		textchunk;
	int		astsize;
} PG;

typedef struct ptable {

/* Pointers to tables produced by the parser generator 	*/

PG		*pg;		/* Pointer to multiparser global variable structure */
short	*D_red;     /* Default reduction.                        */
short	*R_start;   /* Reduction start.                          */
short	*R_symbol;  /* Reduction symbol.                         */
short	*R_prod;    /* Reduction production.                     */
short	*rBase;
short	*Head;         /* Head symbol number for a production.   */
short	*MT_beg;
short	*MT_tran;
short	*MN_beg;
short	*MN_tran;
short	*M_bits;
long	*G_symbol;		/* Symbol names of the grammar			*/
short 	*PL;			/* Production length less one.			*/
short	*LGT;
long	*ACTIONS;
char	*ACTIONSTRINGS;

/* constants provided by the load module */
short	TM;
short	bitwords;
int		n_terms;
int		n_vars;
int		n_symbs;
int		n_states;
int		n_rules;
int		n_actions;
short	maxtoken;

/* variables */

short	rule;
short	state;
short	token;

/* Pointers used during parse */

short	*SS;                /* State stack pointer.             */
short	SStop[PARSER_STKSIZE];
short	*SSmax;             /* State stack maximum height.      */

/* PARSER AND LEXER TABLES MUST BE THE SAME UP TO THIS POINT */

AstP	*NS;                /* AST node stack pointer.          */
AstP	NStop[PARSER_STKSIZE];
short	*LS;
short	LStop[PARSER_STKSIZE];
short	*Rs;
short	RStop[PARSER_STKSIZE];
int		xx;
int		linksize;
AstP	*link;
AstP	node;

} PTABLE;

typedef struct ltable {

/* Pointers to tables produced by the parser generator 	*/

PG		*pg;		/* Pointer to multiparser global variable structure */
short	*D_red;     /* Default reduction.                        */
short	*R_start;   /* Reduction start.                          */
short	*R_symbol;  /* Reduction symbol.                         */
short	*R_prod;    /* Reduction production.                     */
short	*rBase;
short	*Head;         /* Head symbol number for a production.   */
short	*MT_beg;
short	*MT_tran;
short	*MN_beg;
short	*MN_tran;
short	*M_bits;
long	*G_symbol;		/* Symbol names of the grammar			*/
short 	*PL;			/* Production length less one.			*/
short	*LGT;
long	*ACTIONS;
char	*ACTIONSTRINGS;

/* constants provided by the load module */
short	TM;
short	bitwords;
int		n_terms;
int		n_vars;
int		n_symbs;
int		n_states;
int		n_rules;
int		n_actions;
short	maxtoken;

/* Variables */

short	rule;
short	state;
short	token;


/* Pointers used during lex */

short	*SS;                /* State stack pointer.             */
short	SStop[PARSER_STKSIZE];
short	*SSmax;             /* State stack maximum height.      */

/* PARSER AND LEXER TABLES MUST BE THE SAME UP TO THIS POINT */

short	lextoken;
#if 0
char	ibuf[512];
#endif
} LTABLE;

#define ASTVARS(n) AstP curnode, pstack[n], *stack=pstack
#define SYMBOLCOUNT (pg->pst.cnt)
#define PARSERSYMBOLS (pg->pst.ptr)
#define MARK(sp) (*(++sp) = (AstP)0)
#define STACKTOP(sp) (**sp)
#define TOPDOWN(n) AstTopDown(&stack, n, pg)
#define BOTTOMUP(n) AstBottomUp(&stack, n, pg)
#define MARKAST MARK(stack)
#define DOWNAST (curnode = TOPDOWN(curnode))
#define UPAST (curnode = BOTTOMUP(curnode))
#define IGNOREBRANCH (curnode = 0)
#define nID(symb) _cat_(LANGUAGE, symb)
#define fID(symb) _cat_(symb, LANGUAGE)
#define lName		_cname1_(LANGUAGE)

#define NODERIGHT(n) (((AstP)n)->right)
#define NODEDOWN(n) (((AstP)n)->down)
#define ISEQUAL(n, s) (((AstP)n)->id == s)
#define NODEID (((AstP)curnode)->id)
#define NODECLASS (((AstP)curnode)->id & 0xffc0)
#define NODEFLAGS (((AstP)curnode)->flags)
#define NODESYMB (((AstP)curnode)->symb)

AstP NewAstNode(PG *pg, int id, int symb);
int NewParserSymbol(PG *pg, const char *name);
void ParserPush(PG *pg, int data);
int ParserPop(PG *pg);
int ParserStackdepth(PG *pg);

void *NewParserSymTable(PG *pg, int size);

AstP AstTopDown(AstP **sp, const AstP cur_node, PG *pg);
AstP AstBottomUp(AstP **sp, const AstP start_node, PG *pg);
void PrintAst (PG *pg, AstP root, void *file, int ptrs);
void HowBigAst(PG *pg, void *file);
void PruneAstTree(PG *pg,AstP root,int preserve_root,const AstP top);
void FreeAstNode(PG *pg, AstP node);
char *GetH_symbol(PG *pg, int numb);
void DelLastParserSymbol(PG *pg);
int AstPackSize(PG *pg);
void *PackAst(PG *pg, void *buf);

/* END: PARSER STUFF */

#ifndef __OXCCFUNCSH__
#define __OXCCFUNCSH__
extern void oxcc_proc_syms(void *iv, unsigned namespace, void (*func)());
/* func(void *node, int symb, void *container) */

extern void oxcc_proc_ptr_info(void *iv, void (*func)());
/* func(void *addr, void *mino, void *maxo) */

extern void oxcc_proc_mallocs(void *iv, void (*func)());
/* func(void *loc, int size, DATUM *ip) */

extern int oxcc(int argc, char **argv);
extern void *oxcc_get_pg(void *iv);
extern void oxcc_debug(void *iv, int flags);
extern void oxcc_enable_trace(void *iv);
extern void oxcc_disable_trace(void *iv);

extern void *oxcc_open_instance(void);
extern void oxcc_set_options(void *iv, char *opts);
extern int oxcc_preproc_file(void *iv, void *is, void *os, void *es,
								int argc, char **argv);
extern int oxcc_parse_file(void *iv, void *is, void *es, char *filename);
extern void oxcc_print_parse_errors(void *iv, void *es);
extern int oxcc_check_ast_tree(void *iv, void *es, char *filename);
extern int oxcc_init_outers(void *iv, void *es);
extern int oxcc_run_tree(void *iv, void *es, char *fname, char *args, char *rnm);
extern int oxcc_gen_code(void *iv, void *es, char *filename, void *os);
extern void oxcc_cleanup_parse(void *iv);
extern void oxcc_close_codefile(void *iv);
extern void oxcc_close_instance(void *iv);

extern void oxcc_print_ast(void *iv, void *os, int flag);
extern void *oxcc_get_ast_root(void *iv);
extern int oxcc_eval_expr(void *iv, void *buf, double *result, void *es);
extern void *__builtin_iv(void);
extern void *__builtin_pg(void);
#endif /* __OXCCFUNCSH__ */

#ifdef __cplusplus
}
#endif
