/* binimg.h -- defs for a.out+coff+elf+pe+exe+ne+le+omf formats */

#ifndef __GNUC__
#pragma pack(1)
#define __attribute__()
#endif

/* ****************** MAGIC NUMBERS ************************ */
#define OBJMAGIC 0x80   /* omf THEADR record type, first byte */
#define LIBMAGIC 0xF0   /* omf LIBR first byte */
#define ARMAGIC  0x3c21 /* !< beginning of unix style archive */
#define OMAGIC   0x0107	/* a.out object file 0407 */
#define NMAGIC   0x0108	/* a.out pure executable 0410 */
#define ZMAGIC   0x010b	/* a.out demand paged executable 0413 */
#define IMAGIC   0x014c	/* coff header f_magic for i386 */
#define AIXMAGIC 0x0175	/* coff header f_magic for aix i386 */
#define MIBMAGIC 0x0162 /* coff header f_magic for mips big endian R3000 */
#define MI3MAGIC 0x0162 /* coff header f_magic for mips little endian R3000 */
#define MI4MAGIC 0x0166 /* coff header f_magic for mips little endian R4000 */
#define MI1MAGIC 0x0166 /* coff header f_magic for mips little endian R10000 */
#define AL1MAGIC 0x0184 /* coff header f_magic for Alpha AXP */
#define AL2MAGIC 0x0186 /* coff header f_magic for Alpha APX */
#define M68MAGIC 0x0268 /* coff header f_magic for M68000 series */
#define PPCMAGIC 0x01f0 /* coff header f_magic for PowerPC little endian */
#define PAMAGIC  0x0290 /* coff header f_magic for HP PA RISC */
#define DOSMAGIC 0x5A4D	/* MZ start of .exe files */
#define NEMAGIC  0x454E	/* NE os2,win31 16bit */
#define LEMAGIC  0x454C /* LE os2,vxd 32 bit */
#define PEMAGIC  0x4550 /* PE nt,win95,win32s */
#define NTMAGIC  0x010b /* NT OPTIONAL HEADER */
#define ROMMAGIC 0x0107 /* NT ROM OPTIONAL HEADER */
#define OPOMAGIC 0x0104 /* coff optional header object file, as output */
#define OPZMAGIC 0x010b /* coff optional header demand load format, ld output */
#define OPTMAGIC 0x0101 /* coff optional header target shared library */
#define OPHMAGIC 0x0123 /* coff optional header host shared library */
#define ELFMAGIC 0x457f /* beginning of elf ident "\177ELF" */

/* ********************* FILE HEADERS *************************** */

#define NEW_EXECUTABLE(ptr) (ptr->e_lfarlc >= 0x0040)

typedef struct {      /* DOS .EXE header */
    unsigned short   e_magic;       /* 00 Magic number */
    unsigned short   e_cblp;        /* 02 Bytes on last page of file */
    unsigned short   e_cp;          /* 04 Pages in file */
    unsigned short   e_crlc;        /* 06 Relocations */
    unsigned short   e_cparhdr;     /* 08 Size of header in paragraphs */
    unsigned short   e_minalloc;    /* 0A Minimum extra paragraphs needed */
    unsigned short   e_maxalloc;    /* 0C Maximum extra paragraphs needed */
    unsigned short   e_ss;          /* 0E Initial (relative) SS value */
    unsigned short   e_sp;          /* 10 Initial SP value */
    unsigned short   e_csum;        /* 12 Checksum */
    unsigned short   e_ip;          /* 14 Initial IP value */
    unsigned short   e_cs;          /* 16 Initial (relative) CS value */
    unsigned short   e_lfarlc;      /* 18 File address of relocation table */
    unsigned short   e_ovno;        /* 1A Overlay number */
    unsigned short   e_res[4];      /* 1C Reserved words */
    unsigned short   e_oemid;       /* 24 OEM identifier (for e_oeminfo) */
    unsigned short   e_oeminfo;     /* 26 OEM information; e_oemid specific */
    unsigned short   e_res2[10];    /* 28 Reserved words */
    long   e_lfanew __attribute__((packed));  /* 3C File address of new exe header */
  } DOS_HDR, *PDOS_HDR;

typedef struct {      /* OS/2 .EXE header */
    unsigned short   ne_magic;     /* Magic number */
    char   ne_ver;                 /* Version number */
    char   ne_rev;                 /* Revision number */
    unsigned short   ne_enttab __attribute__((packed));/* Offset of Entry Table */
    unsigned short   ne_cbenttab;  /* Number of bytes in Entry Table */
    long   ne_crc __attribute__((packed)); /* Checksum of whole file */
    unsigned short   ne_flags;     /* Flag word */
    unsigned short   ne_autodata;  /* Automatic data segment number */
    unsigned short   ne_heap;      /* Initial heap allocation */
    unsigned short   ne_stack;     /* Initial stack allocation */
    long   ne_csip __attribute__((packed)); /* Initial CS:IP setting */
    long   ne_sssp;                /* Initial SS:SP setting */
    unsigned short   ne_cseg;      /* Count of file segments */
    unsigned short   ne_cmod;      /* Entries in Module Reference Table */
    unsigned short   ne_cbnrestab; /* Size of non-resident name table */
    unsigned short   ne_segtab;    /* Offset of Segment Table */
    unsigned short   ne_rsrctab;   /* Offset of Resource Table */
    unsigned short   ne_restab;    /* Offset of resident name table */
    unsigned short   ne_modtab;    /* Offset of Module Reference Table */
    unsigned short   ne_imptab;    /* Offset of Imported Names Table */
    long   ne_nrestab __attribute__((packed)); /* Offset of Non-resident Names Table */
    unsigned short   ne_cmovent;   /* Count of movable entries */
    unsigned short   ne_align;     /* Segment alignment shift count */
    unsigned short   ne_cres;      /* Count of resource segments */
    unsigned char   ne_exetyp;     /* Target Operating system */
    unsigned char   ne_flagsothers; /* Other .EXE flags */
    unsigned short   ne_pretthunks __attribute__((packed)); /* offset to return thunks */
    unsigned short   ne_psegrefbytes; /* offset to segment ref. bytes */
    unsigned short   ne_swaparea;     /* Minimum code swap area size */
    unsigned short   ne_expver;       /* Expected Windows version number */
  } OS2_HDR, *POS2_HDR;

typedef struct {      /* WIN31 .EXE header */
    unsigned short   ne_magic;     /* Magic number */
    char   ne_ver;                 /* Version number */
    char   ne_rev;                 /* Revision number */
    unsigned short   ne_enttab __attribute__((packed));/* Offset of Entry Table */
    unsigned short   ne_cbenttab;  /* Number of bytes in Entry Table */
    long   ne_crc __attribute__((packed)); /* Checksum of whole file */
    unsigned short   ne_flags;     /* Flag word */
    unsigned short   ne_autodata;  /* Automatic data segment number */
    unsigned short   ne_heap;      /* Initial heap allocation */
    unsigned short   ne_stack;     /* Initial stack allocation */
    long   ne_csip __attribute__((packed)); /* Initial CS:IP setting */
    long   ne_sssp;                /* Initial SS:SP setting */
    unsigned short   ne_cseg;      /* Count of file segments */
    unsigned short   ne_cmod;      /* Entries in Module Reference Table */
    unsigned short   ne_cbnrestab; /* Size of non-resident name table */
    unsigned short   ne_segtab;    /* Offset of Segment Table */
    unsigned short   ne_rsrctab;   /* Offset of Resource Table */
    unsigned short   ne_restab;    /* Offset of resident name table */
    unsigned short   ne_modtab;    /* Offset of Module Reference Table */
    unsigned short   ne_imptab;    /* Offset of Imported Names Table */
    long   ne_nrestab __attribute__((packed)); /* Offset of Non-resident Names Table */
    unsigned short   ne_cmovent;   /* Count of movable entries */
    unsigned short   ne_align;     /* Segment alignment shift count */
    unsigned short   ne_cres;      /* Count of resource segments */
    unsigned char   ne_exetyp;     /* Target Operating system */
    unsigned char   ne_flagsothers; /* Other .EXE flags */
    unsigned short   ne_fastload __attribute__((packed)); /* ofs in sectors to fast load area */
    unsigned short   ne_fastsize; /* size in sectors of fast load area */
    unsigned short   ne_swaparea;     /* reserved */
    unsigned short   ne_expver;       /* Expected Windows version number */
  } WIN31_HDR, *PWIN31_HDR;

typedef struct {      /* Windows VXD header */
    unsigned short   e32_magic;       /* Magic number */
    unsigned char   e32_border;       /* The byte ordering for the VXD */
    unsigned char   e32_worder;       /* The word ordering for the VXD */
    unsigned long  e32_level __attribute__((packed));/* The EXE format level for now = 0 */
    unsigned short   e32_cpu;         /* The CPU type */
    unsigned short   e32_os;          /* The OS type */
    unsigned long  e32_ver __attribute__((packed)); /* Module version */
    unsigned long  e32_mflags;        /* Module flags */
    unsigned long  e32_mpages;        /* Module # pages */
    unsigned long  e32_startobj;      /* Object # for instruction pointer */
    unsigned long  e32_eip;           /* Extended instruction pointer */
    unsigned long  e32_stackobj;      /* Object # for stack pointer */
    unsigned long  e32_esp;           /* Extended stack pointer */
    unsigned long  e32_pagesize;      /* VXD page size */
    unsigned long  e32_lastpagesize;  /* Last page size in VXD */
    unsigned long  e32_fixupsize;     /* Fixup section size */
    unsigned long  e32_fixupsum;      /* Fixup section checksum */
    unsigned long  e32_ldrsize;       /* Loader section size */
    unsigned long  e32_ldrsum;        /* Loader section checksum */
    unsigned long  e32_objtab;        /* Object table offset */
    unsigned long  e32_objcnt;        /* Number of objects in module */
    unsigned long  e32_objmap;        /* Object page map offset */
    unsigned long  e32_itermap;       /* Object iterated data map offset */
    unsigned long  e32_rsrctab;       /* Offset of Resource Table */
    unsigned long  e32_rsrccnt;       /* Number of resource entries */
    unsigned long  e32_restab;        /* Offset of resident name table */
    unsigned long  e32_enttab;        /* Offset of Entry Table */
    unsigned long  e32_dirtab;        /* Offset of Module Directive Table */
    unsigned long  e32_dircnt;        /* Number of module directives */
    unsigned long  e32_fpagetab;      /* Offset of Fixup Page Table */
    unsigned long  e32_frectab;       /* Offset of Fixup Record Table */
    unsigned long  e32_impmod;        /* Offset of Import Module Name Table */
    unsigned long  e32_impmodcnt;     /* Number of entries in Import Module Name Table */
    unsigned long  e32_impproc;       /* Offset of Import Procedure Name Table */
    unsigned long  e32_pagesum;       /* Offset of Per-Page Checksum Table */
    unsigned long  e32_datapage;      /* Offset of Enumerated Data Pages */
    unsigned long  e32_preload;       /* Number of preload pages */
    unsigned long  e32_nrestab;       /* Offset of Non-resident Names Table */
    unsigned long  e32_cbnrestab;     /* Size of Non-resident Name Table */
    unsigned long  e32_nressum;       /* Non-resident Name Table Checksum */
    unsigned long  e32_autodata;      /* Object # for automatic data object */
    unsigned long  e32_debuginfo;     /* Offset of the debugging information */
    unsigned long  e32_debuglen;      /* The length of the debugging info. in bytes */
    unsigned long  e32_instpreload;   /* Number of instance pages in preload section of VXD file */
    unsigned long  e32_instdemand;    /* Number of instance pages in demand load section of VXD file */
    unsigned long  e32_heapsize;      /* Size of heap - for 16-bit apps */
    unsigned char   e32_res3[12];     /* Reserved words */
    unsigned long  e32_winresoff __attribute__((packed));
    unsigned long  e32_winreslen;
    unsigned short   e32_devid;       /* Device ID for VxD */
    unsigned short   e32_ddkver;      /* DDK version for VxD */
  } VXD_HDR, *PVXD_HDR;

typedef struct exec
{
  short a_magic;     /* a magic number */
  short a_whocares;	 /* machtype and flags, set to zero */
  unsigned a_text __attribute__((packed));   /* length of text, in bytes */
  unsigned a_data;   /* length of data, in bytes */
  unsigned a_bss;    /* length of uninitialized data area for file, in bytes */
  unsigned a_syms;   /* length of symbol table data in file, in bytes */
  unsigned a_entry;  /* start address */
  unsigned a_trsize; /* length of relocation info for text, in bytes */
  unsigned a_drsize; /* length of relocation info for data, in bytes */
} EXEC_HDR, *PEXEC_HDR;

typedef struct {
	unsigned short f_magic;		/* magic number, machine type		*/
	unsigned short f_nscns;		/* number of sections		*/
	unsigned long f_timdat __attribute__((packed));	/* time & date stamp */
	unsigned long f_symptr;		/* file pointer to symtab	*/
	unsigned long f_nsyms;		/* number of symtab entries	*/
	unsigned short f_opthdr;	/* sizeof(optional hdr)		*/
	unsigned short f_flags;		/* flags			*/
} COFF_HDR, *PCOFF_HDR;


/* Bits for f_flags:
 *	F_RELFLG	relocation info stripped from file
 *	F_EXEC		file is executable (no unresolved external references)
 *	F_LINNO		line numbers stripped from file
 *	F_LSYMS		local symbols stripped from file
 *  F_MINIMAL	minimal object, reserved NT
 *  F_UPDATE	update object, reserved NT
 *	F_16BIT		16 bit machine, reserved NT
 *	F_LILEND	file has little endian byte ordering
 *	F_32BIT		32 bit machine
 *	F_DEBUG		debug info stripped
 *  F_PATCH		reserved NT
 *	F_SYSTEM	system file, not a user pgm NT
 *	F_DLL		dynamic link library, NT
 *	F_BIGEND	file has big endian byte ordering
 */

#define F_RELFLG		(0x0001)
#define COFF_F_RELFLG	(0x0001)
#define F_EXEC			(0x0002)
#define COFF_F_EXEC		(0x0002)
#define F_LINNO			(0x0004)
#define COFF_F_LINNO	(0x0004)
#define F_LSYMS			(0x0008)
#define COFF_F_LSYMS	(0x0008)
#define F_MINIMAL		(0x0010)
#define COFF_F_MINMAL	(0x0020)
#define F_UPDATE		(0x0020)
#define COFF_F_UPDATE	(0x0040)
#define F_16BIT			(0x0040)
#define F_LILEND		(0x0080)
#define F_32BIT			(0x0100)
#define COFF_F_SWABD	(0x0100)
#define F_DEBUG			(0x0200)
#define COFF_F_AR16WR	(0x0200)
#define F_PATCH			(0x0400)
#define COFF_F_AR32WR	(0x0400)
#define F_SYSTEM		(0x1000)
#define COFF_F_AR32W	(0x1000)
#define F_DLL			(0x2000)
#define COFF_F_PATCH	(0x2000)
#define COFF_F_NODF		(0x2000)
#define F_BIGEND		(0x8000)

/*
 * These defines are byte order independent. There is no alignment of fields
 * permitted in the structures. Therefore they are declared as characters
 * and the values loaded from the character positions. It also makes it
 * nice to have it "endian" independent.
 */
 
/* Load a short int from the following tables with little-endian formats */
#define COFF_SHORT_L(ps) ((short)(((unsigned short)((unsigned char)ps[1])<<8)|\
				  ((unsigned short)((unsigned char)ps[0]))))

/* Load a long int from the following tables with little-endian formats */
#define COFF_LONG_L(ps) (((long)(((unsigned long)((unsigned char)ps[3])<<24) |\
				 ((unsigned long)((unsigned char)ps[2])<<16) |\
				 ((unsigned long)((unsigned char)ps[1])<<8)  |\
				 ((unsigned long)((unsigned char)ps[0])))))
 
/* Load a short int from the following tables with big-endian formats */
#define COFF_SHORT_H(ps) ((short)(((unsigned short)((unsigned char)ps[0])<<8)|\
				  ((unsigned short)((unsigned char)ps[1]))))

/* Load a long int from the following tables with big-endian formats */
#define COFF_LONG_H(ps) (((long)(((unsigned long)((unsigned char)ps[0])<<24) |\
				 ((unsigned long)((unsigned char)ps[1])<<16) |\
				 ((unsigned long)((unsigned char)ps[2])<<8)  |\
				 ((unsigned long)((unsigned char)ps[3])))))

/* These may be overridden later by brain dead implementations which generate
   a big-endian header with little-endian data. In that case, generate a
   replacement macro which tests a flag and uses either of the two above
   as appropriate. */

#define COFF_LONG(v)   COFF_LONG_L(v)
#define COFF_SHORT(v)  COFF_SHORT_L(v)

/* linux style info */

struct COFF_filehdr {
	char f_magic[2];	/* magic number			*/
	char f_nscns[2];	/* number of sections		*/
	char f_timdat[4];	/* time & date stamp		*/
	char f_symptr[4];	/* file pointer to symtab	*/
	char f_nsyms[4];	/* number of symtab entries	*/
	char f_opthdr[2];	/* sizeof(optional hdr)		*/
	char f_flags[2];	/* flags			*/
};

#define COFF_STMAGIC	0401
#define COFF_OMAGIC     0404
#define COFF_JMAGIC     0407    /* dirty text and data image, can't share  */
#define COFF_DMAGIC     0410    /* dirty text segment, data aligned        */
#define COFF_ZMAGIC     0413    /* The proper magic number for executables  */
#define COFF_SHMAGIC	0443	/* shared library header                   */

/* ************************** A.OUT DEFS ************************** */
#define N_MAGIC(x) ((x).a_magic)
#define P_MAGIC(x) ((x)->a_magic)

/* file offsets */
#define N_TXTOFF(x) (sizeof(struct exec))
#define N_DATOFF(x) (N_TXTOFF(x) + (x).a_text)
#define N_TRELOFF(x) (N_DATOFF(x) + (x).a_data)
#define N_DRELOFF(x) (N_TRELOFF(x) + (x).a_trsize)
#define N_SYMOFF(x) (N_DRELOFF(x) + (x).a_drsize)
#define N_STROFF(x) (N_SYMOFF(x) + (x).a_syms)

#define P_TXTOFF(x) sizeof(struct exec)
#define P_DATOFF(x) (P_TXTOFF(x) + (x)->a_text)
#define P_TRELOFF(x) (P_DATOFF(x) + (x)->a_data)
#define P_DRELOFF(x) (P_TRELOFF(x) + (x)->a_trsize)
#define P_SYMOFF(x) (P_DRELOFF(x) + (x)->a_drsize)
#define P_STROFF(x) (P_SYMOFF(x) + (x)->a_syms)

/* loaded offsets */
#define N_TXTADDR(x) (0) /* depends on operating system and linker used */
#define N_DATADDR(x) (N_TXTADDR(x)+(x).a_text) 
#define N_BSSADDR(x) (N_DATADDR(x)+(x).a_data)

#define P_TXTADDR(x) (0) /* depends on operating system and linker used */
#define P_DATADDR(x) (N_TXTADDR(x)+(x)->a_text) 
#define P_BSSADDR(x) (N_DATADDR(x)+(x)->a_data)

typedef struct nlist {
  union {
    char *n_name;
    struct nlist *n_next;
    long n_strx;
  } n_un;
  unsigned char n_type;
  char n_other;
  short n_desc;
  unsigned long n_value;
} NLIST, *PNLIST;

/* entries in the n_type field */
#define N_UNDF 0x00
#define N_ABS 0x02
#define N_TEXT 0x04
#define N_DATA 0x06
#define N_BSS 0x08
#define N_NDC 0x10
#define N_COMM 0x12
#define N_FN 0x0f
#define N_EXT 0x01
#define N_TYPE 0x1e
#define N_STAB 0xe0
#define N_SWTAB 0x20			/* oxcc switch table entry */
#define N_STDCAL 0x24			/* rsxnt stuff */
#define N_THUNK 0x30
#define N_SETA  0x14            /* Absolute set element symbol */
#define N_SETT  0x16            /* Text set element symbol */
#define N_SETD  0x18            /* Data set element symbol */
#define N_SETB  0x1A            /* Bss set element symbol */
#define N_SETV  0x1C            /* Pointer to set vector in data area.  */

#define sym_in_text_section(sym) \
(((sym)->n_type  & (N_ABS | N_TEXT | N_DATA | N_BSS))== N_TEXT)
#define sym_in_data_section(sym) \
(((sym)->n_type  & (N_ABS | N_TEXT | N_DATA | N_BSS))== N_DATA)
#define sym_in_bss_section(sym) \
(((sym)->n_type  & (N_ABS | N_TEXT | N_DATA | N_BSS))== N_BSS)
#define sym_is_undefined(sym) \
((sym)->n_type == (N_EXT) && (sym)->n_value == 0)
#define sym_is_global_defn(sym) \
(((sym)->n_type & N_EXT) && (sym)->n_type & N_TYPE)
#define sym_is_debugger_info(sym) \
((sym)->n_type & ~(N_EXT | N_TYPE))
#define sym_is_fortrancommon(sym)       \
(((sym)->n_type == (N_EXT)) && (sym)->n_value != 0)
#define sym_is_absolute(sym) \
(((sym)->n_type  & N_TYPE)== N_ABS)
#define sym_is_indirect(sym) \
(((sym)->n_type & N_TYPE)== N_INDR)


typedef struct relocation_info
{
  /* Address (within segment) to be relocated.  */
  int r_address;
  unsigned int r_symbolnum:24;
  unsigned int r_pcrel:1;
  unsigned int r_length:2;
  unsigned int r_extern:1;
  unsigned int r_pad:4;
} RELOCATION_INFO, *PRELOCATION_INFO;

#define RELOC_ADDRESS(r)		((r)->r_address)
#define RELOC_EXTERN_P(r)		((r)->r_extern)
#define RELOC_SYMBOL(r)			((r)->r_symbolnum)
#define RELOC_PCREL_P(r)		((r)->r_pcrel)
#define RELOC_TARGET_SIZE(r)	((r)->r_length)

/* ****************** ARCHIVE FORMAT *********************** */

#define ARMAG "!<arch>\n"           /* archive start */
#define SARMAG 8
#define ARFMAG "`\n"                /* archive end */
#define ARPAD  "\n"                 /* null entry */
#define ARLNKR "/               "   /* NT linker member */
#define ARLONG "//              "   /* NT longnames member */

typedef struct ar_hdr {
  char ar_name[16];	/* member name, `/' terminated */
  char ar_date[12]; /* member date, decimal */
  char ar_uid[6];	/* member user id, decimal */
  char ar_gid[6];	/* member group id, decimal */
  char ar_mode[8];  /* member mode, octal */
  char ar_size[10]; /* member size, decimal */
  char ar_fmag[2];
} AR_HDR, *PAR_HDR;
/* 
   Format of __.SYMDEF:
   First, a longword containing the size of the 'symdef' data that follows.
   Second, zero or more 'symdef' structures.
   Third, a word containing the length of symbol name strings.
   Fourth, zero or more symbol name strings (each followed by a zero).
*/

struct symdef {
  long symbol_name_string_index;
  long library_member_offset;
};

/********************** COFF BASIC "OPTIONAL HEADER" **********************/
/* USED WITH PE format of WINNT also */

typedef struct 
{
  unsigned short 	magic;		/* type of file				*/
  unsigned short	vstamp;		/* version stamp			*/
  unsigned long		tsize;		/* text size in bytes, padded to FW bdry*/
  unsigned long		dsize;		/* initialized data "  "		*/
  unsigned long		bsize;		/* uninitialized data "   "		*/
  unsigned long		entry;		/* entry pt.				*/
  unsigned long 	text_start;	/* base of text used for this file */
  unsigned long 	data_start;	/* base of data used for this file */
} OPT_HDR, *POPT_HDR;

typedef struct {
	COFF_HDR c __attribute__((packed));
	OPT_HDR o __attribute__((packed));
} XCOFF_HDR, *PXCOFF_HDR;
/*************** NT SPECIFIC ADDITIONS TO OPTIONAL HDR **********/

#define PE_DIRS 16

typedef struct {
    unsigned long  RVA;
    unsigned long  size;
} PE_DATA_DIR, *PPE_DATA_DIR;

/*
// Directory Entries
*/

#define DIR_ENTRY_EXPORT         0   /* Export Directory */
#define DIR_ENTRY_IMPORT         1   /* Import Directory */
#define DIR_ENTRY_RESOURCE       2   /* Resource Directory */
#define DIR_ENTRY_EXCEPTION      3   /* Exception Directory */
#define DIR_ENTRY_SECURITY       4   /* Security Directory */
#define DIR_ENTRY_BASERELOC      5   /* Base Relocation Table */
#define DIR_ENTRY_DEBUG          6   /* Debug Directory */
#define DIR_ENTRY_COPYRIGHT      7   /* Description String */
#define DIR_ENTRY_GLOBALPTR      8   /* Machine Value (MIPS GP) size == 0 */
#define DIR_ENTRY_TLS            9   /* TLS Directory */
#define DIR_ENTRY_LOAD_CONFIG   10   /* Load Configuration Directory */
#define DIR_ENTRY_BOUND_IMPORT  11   /* Bound Import Directory in headers */
#define DIR_ENTRY_IAT           12   /* Import Address Table */

typedef struct {
    unsigned long   ImageBase;
    unsigned long   SectionAlignment;
    unsigned long   FileAlignment;
    unsigned short  MajorOperatingSystemVersion;
    unsigned short  MinorOperatingSystemVersion;
    unsigned short  MajorImageVersion;
    unsigned short  MinorImageVersion;
    unsigned short  MajorSubsystemVersion;
    unsigned short  MinorSubsystemVersion;
    unsigned long   Reserved1 __attribute__((packed));
    unsigned long   SizeOfImage;
    unsigned long   SizeOfHeaders;
    unsigned long   CheckSum;
    unsigned short  Subsystem;
    unsigned short  DllCharacteristics;
    unsigned long   SizeOfStackReserve __attribute__((packed));
    unsigned long   SizeOfStackCommit;
    unsigned long   SizeOfHeapReserve;
    unsigned long   SizeOfHeapCommit;
    unsigned long   LoaderFlags;
    unsigned long   NumberOfDataDirs;
    PE_DATA_DIR DataDirectory[PE_DIRS];
} PE_OPT_HDR, *PPE_OPT_HDR;

typedef struct {
    unsigned long  BaseOfBss;
    unsigned long  GprMask;
    unsigned long  CprMask[4];
    unsigned long  GpValue;
} PE_ROM_OPT_HDR, *PPE_ROM_OPT_HDR;

typedef struct {
	unsigned short magic;	/* PE */
	unsigned short pad;
	COFF_HDR c __attribute__((packed));
	OPT_HDR o __attribute__((packed));
	PE_OPT_HDR p __attribute__((packed));
} PE_HDR, *PPE_HDR;

/*
// Subsystem Values NT
*/
#define SUBSYS_UNKNOWN       0   /* Unknown subsystem. */
#define SUBSYS_NATIVE        1   /* doesn't require a subsystem. */
#define SUBSYS_WINDOWS_GUI   2   /* runs in the Windows GUI subsystem. */
#define SUBSYS_WINDOWS_CUI   3   /* runs in the Windows character subsystem. */
#define SUBSYS_OS2_CUI       5   /* runs in the OS/2 character subsystem. */
#define SUBSYS_POSIX_CUI     7   /* runs in the Posix character subsystem. */


	
/********************** SECTION HEADER **********************/

typedef struct scnhdr {
	char				s_name[8];	/* section name			*/
	unsigned long		s_vsize;	/* virtual size when loaded (image) */
	unsigned long		s_vaddr;	/* virtual address		*/
	unsigned long		s_size;		/* raw data size			*/
	unsigned long		s_scnptr;	/* file ptr to raw data for section */
	unsigned long		s_relptr;	/* file ptr to relocation	*/
	unsigned long		s_lnnoptr;	/* file ptr to line numbers	*/
	unsigned short		s_nreloc;	/* number of relocation entries	*/
	unsigned short		s_nlnno;	/* number of line number entries*/
	unsigned long		s_flags;	/* characteristics			*/
} SCNHDR, *PSCNHDR;
/*
 * names of "special" sections
 */
#define _TEXT	".text"
#define _DATA	".data"
#define _BSS	".bss"
#define _COMMENT ".comment"
#define _LIB 	".lib"
#define _EDATA	".edata"	/* export info */
#define _IDATA	".idata"	/* import info */
#define _RDATA  ".rdata"	/* read only data + debug directory info */
#define _RELOC  ".reloc"	/* PE image fixups */
#define _RSRC   ".rsrc"		/* windows resources */
#define _PDATA  ".pdata"
#define _DEBUG  ".debug"
/*
 * s_flags "type"
 */
#define STYP_TEXT	      (0x00000020) /* section contains text only */
#define STYP_DATA	      (0x00000040) /* section contains data only */
#define STYP_BSS	      (0x00000080) /* section contains bss only */
#define STYP_INFO	      (0x00000100) /* section contains comments or something */
#define STYP_REMOVE	      (0x00000800) /* don't include section in loaded image */
#define STYP_COMDAT	      (0x00001000) /* section contents comdat */
#define STYP_FARDATA      (0x00008000)
#define STYP_PURGABLE     (0x00020000)
#define STYP_16BIT	      (0x00020000)
#define STYP_MEMLOCK      (0x00040000)
#define STYP_PRELOAD      (0x00080000)
#define STYP_ALIGNMENT	  (0x00700000)
#define STYP_ALGN1	      (0x00100000)
#define STYP_ALGN2	      (0x00200000)
#define STYP_ALGN4	      (0x00300000) /* default for emx,djgpp */
#define STYP_ALGN8	      (0x00400000)
#define STYP_ALGN16	      (0x00500000) /* default for NT */
#define STYP_ALGN32	      (0x00600000)
#define STYP_ALGN64	      (0x00700000)
#define STYP_NRELOC_OVFL  (0x01000000) /* section contains extended relocations */
#define STYP_DISCARDABLE  (0x02000000) /* section can be discarded */
#define STYP_NOT_CACHED   (0x04000000) /* section is not cachable */
#define STYP_NOT_PAGED    (0x08000000) /* section is not pageable */
#define STYP_SHARED       (0x10000000) /* section is shareable */
#define STYP_EXECUTE      (0x20000000) /* section is executable */
#define STYP_READ         (0x40000000) /* section is readable */
#define STYP_WRITE        (0x80000000) /* section is writeable */

/* linux style */
#define COFF_STYP_REG     0x00 /* regular segment                          */
#define COFF_STYP_DSECT   0x01 /* dummy segment                            */
#define COFF_STYP_NOLOAD  0x02 /* no-load segment                          */
#define COFF_STYP_GROUP   0x04 /* group segment                            */
#define COFF_STYP_PAD     0x08 /* .pad segment                             */
#define COFF_STYP_COPY    0x10 /* copy section                             */
#define COFF_STYP_TEXT    0x20 /* .text segment                            */
#define COFF_STYP_DATA    0x40 /* .data segment                            */
#define COFF_STYP_BSS     0x80 /* .bss segment                             */
#define COFF_STYP_INFO   0x200 /* .comment section                         */
#define COFF_STYP_OVER   0x400 /* overlay section                          */
#define COFF_STYP_LIB    0x800 /* library section                          */

/*
 * Shared libraries have the following section header in the data field for
 * each library.
 */

struct COFF_slib {
  char		sl_entsz[4];	/* Size of this entry               */
  char		sl_pathndx[4];	/* size of the header field         */
};

#define	COFF_SLIBHD	struct COFF_slib
#define	COFF_SLIBSZ	sizeof(COFF_SLIBHD)

/********************** LINE NUMBERS **********************/

/* 1 line number entry for every "breakpointable" source line in a section.
 * Line numbers are grouped on a per function basis; first entry in a function
 * grouping will have l_lnno = 0 and in place of physical address will be the
 * symbol table index of the function name.
 */
typedef struct coff_lineno{
	union {
		unsigned long l_symndx __attribute__((packed));	/* function name symbol index, iff l_lnno == 0 */
		unsigned long l_vaddr __attribute__((packed));	/* RVA of line number */
	} l_addr;
	unsigned short l_lnno;						/* line number */
} LINENO, *PLINENO;
#define COFF_LINENO_SIZE (6)

/********************** SYMBOLS **********************/

#define E_SYMNMLEN	8	/* # characters in a symbol name	*/
#define E_FILNMLEN	14	/* # characters in a file name		*/
#define E_DIMNUM	4	/* # array dimensions in auxiliary entry */
#define COFF_E_SYMNMLEN	 8
#define COFF_E_FILNMLEN	14
#define COFF_E_DIMNUM	 4

struct COFF_symbol
{
  union {
    char e_name[E_SYMNMLEN];
    struct {
      unsigned long e_zeroes __attribute__((packed)); /* if 0 use string tbl */
      unsigned long e_offset __attribute__((packed)); /* offset into string tbl */
    } e;
  } e;
  unsigned long e_value __attribute__((packed));
  short e_scnum;				/* section number */
  unsigned short e_type;		/* type */
  unsigned char e_sclass;		/* storage class */
  unsigned char e_numaux;		/* number of aux symbols */
};
typedef struct COFF_symbol COFF_SYMBOL, *PCOFF_SYMBOL;
#define COFF_SYMBOL_SIZE (18)

union COFF_auxent {
	struct {
		unsigned long x_tagndx __attribute__((packed));/* str, un, or enum tag indx */
		union {
			struct {
			    unsigned short  x_lnno;	/* declaration line number */
			    unsigned short  x_size; /* str/union/array size */
			} x_lnsz;
			unsigned long x_fsize __attribute__((packed));/* size of function */
		} x_misc;
		union {
			struct { /* if ISFCN, tag, or .bb */
			    unsigned long x_lnnoptr __attribute__((packed));/* ptr to fcn line # */
			    unsigned long x_next __attribute__((packed));	/* ptr to next fcn */
			} x_fcn;
			struct { /* if ISARY, up to 4 dimen. */
			    unsigned short x_dimen[E_DIMNUM];
			} x_ary;
		} x_fcnary;
		unsigned short x_tvndx;	/* tv index */
	} x_sym;

	union {
		char x_fname[E_FILNMLEN];
		struct {
			unsigned long x_zeroes __attribute__((packed));
			unsigned long x_offset __attribute__((packed));
		} x_n;
	} x_file;

	struct {
		unsigned long x_scnlen __attribute__((packed));		/* section length */
		unsigned short x_nreloc;					/* # relocation entries */
		unsigned short x_nlinno;					/* # line numbers */
		unsigned long cksum __attribute__((packed)); /* cksum for communal NT */
		short x_scnum;   /* section number to associate with */
		char x_sel;		/* communal selection type NT */
	} x_scn;

        struct {
		unsigned long x_tvfill __attribute__((packed));		/* tv fill value */
		unsigned short x_tvlen;						/* length of .tv */
		unsigned short x_tvran[2];					/* tv range */
	} x_tv;		/* info about .tv section (in auxent of symbol .tv)) */
};
typedef union COFF_auxent AUXENT, *PAUXENT;

#define COFF_AUXENT_SIZE COFF_SYMBOL_SIZE

#define _ETEXT	"etext"


/* Relocatable symbols have number of the section in which they are defined,
   or one of the following: */

#define SYM_UNDEF ((short)0)	/* undefined symbol */
#define SYM_ABS	  ((short)-1)	/* value of symbol is absolute */
#define SYM_DEBUG ((short)-2)	/* debugging symbol -- value is meaningless */
#define SYM_NTV	  ((short)-3)	/* indicates symbol needs preload transfer vector */
#define SYM_PTV	  ((short)-4)	/* indicates symbol needs postload transfer vector*/

/*
 * Type of a symbol, in e_type
 */
#define T_NULL		0x0000
#define T_VOID		0x0001	/* function argument (only used by compiler) */
#define T_CHAR		0x0002	/* character		*/
#define T_SHORT		0x0003	/* short integer	*/
#define T_INT		0x0004	/* integer		*/
#define T_LONG		0x0005	/* long integer		*/
#define T_FLOAT		0x0006	/* floating point	*/
#define T_DOUBLE	0x0007	/* double word		*/
#define T_STRUCT	0x0008	/* structure 		*/
#define T_UNION		0x0009	/* union 		*/
#define T_ENUM		0x000A	/* enumeration 		*/
#define T_MOE		0x000B	/* member of enumeration*/
#define T_UCHAR		0x000C	/* unsigned character	*/
#define T_USHORT	0x000D	/* unsigned short	*/
#define T_UINT		0x000E	/* unsigned integer	*/
#define T_ULONG		0x000F	/* unsigned long	*/
#define T_LNGDBL	0x0010	/* long double		*/
#define T_PCODE		0x8000	/* pcode */

/*
 * derived types, in e_type
*/
#define DT_NON		(0)	/* no derived type */
#define DT_PTR		(1)	/* pointer */
#define DT_FCN		(2)	/* function */
#define DT_ARY		(3)	/* array */

/* type packing constants */
#define N_BTMASK	(0x000F)
#define N_TMASK		(0x0030)
#define N_TMASK1    (0x00C0)
#define N_TMASK2    (0x00F0)
#define N_BTSHFT	(4)
#define N_TSHIFT	(2)
  
#define BTYPE(x)	((x) & N_BTMASK)	/* basic type */

/* this stuff is bugged [NDC] */
#define ISPTR(x)	(((x) & N_TMASK) == (DT_PTR << N_BTSHFT))
#define ISFCN(x)	(((x) & N_TMASK) == (DT_FCN << N_BTSHFT))
#define ISARY(x)	(((x) & N_TMASK) == (DT_ARY << N_BTSHFT))
#define ISTAG(x)	((x)==C_STRTAG||(x)==C_UNTAG||(x)==C_ENTAG)
#define DECREF(x) ((((x)>>N_TSHIFT)&~N_BTMASK)|((x)&N_BTMASK))

/********************** STORAGE CLASSES **********************/

#define C_EFCN		0xff	/* physical end of function	*/
#define C_NULL		0x0000
#define C_AUTO		0x0001	/* automatic variable		*/
#define C_EXT		0x0002	/* external symbol		*/
#define C_STAT		0x0003	/* static			*/
#define C_REG		0x0004	/* register variable		*/
#define C_EXTDEF	0x0005	/* external definition		*/
#define C_LABEL		0x0006	/* label			*/
#define C_ULABEL	0x0007	/* undefined label		*/
#define C_MOS		0x0008	/* member of structure		*/
#define C_ARG		0x0009	/* function argument		*/
#define C_STRTAG	0x000A	/* structure tag		*/
#define C_MOU		0x000B	/* member of union		*/
#define C_UNTAG		0x000C	/* union tag			*/
#define C_TPDEF		0x000D	/* type definition		*/
#define C_USTATIC	0x000E	/* undefined static		*/
#define C_ENTAG		0x000F	/* enumeration tag		*/
#define C_MOE		0x0010	/* member of enumeration	*/
#define C_REGPARM	0x0011	/* register parameter		*/
#define C_FIELD		0x0012	/* bit field			*/
#define C_AUTOARG	0x0013	/* auto argument		*/
#define C_LASTENT	0x0014	/* dummy entry (end of block)	*/
#define C_FAREXT	0x0044	/* far external NT */
#define C_BLOCK		0x0064	/* ".bb" or ".eb"		*/
#define C_FCN		0x0065	/* ".bf" or ".ef"		*/
#define C_EOS		0x0066	/* end of structure		*/
#define C_FILE		0x0067	/* file name			*/
#define C_LINE		0x0068	/* line # reformatted as symbol table entry */
#define C_SECTION	0x0068	/* new NT section */
#define C_ALIAS	 	0x0069	/* duplicate tag		*/
#define C_WEAKEXT	0x0069	/* new NT weak external */
#define C_HIDDEN	0x0070	/* ext symbol in dmert public lib */


/********************** RELOCATION DIRECTIVES **********************/

struct coff_reloc {
  union {
    unsigned long r_vaddr __attribute__((packed));
 /* set to real count when STYP_RELOC_OVFL is set NT */
    unsigned long r_count __attribute__((packed));
  }u;
  unsigned long r_symndx __attribute__((packed));
  unsigned short r_type;
}; 

typedef struct coff_reloc COFF_RELOC, *PCOFF_RELOC;
#define COFF_RELOC_SIZE (10)

/*
// NT I386 relocation types in r_type.
*/

#define REL_I386_ABSOLUTE  0x0000  /* Reference is absolute, no relocation is necessary */
#define REL_I386_DIR16     0x0001  /* Direct 16-bit reference to the symbols virtual address */
#define REL_I386_REL16     0x0002  /* PC-relative 16-bit reference to the symbols virtual address */
#define REL_I386_DIR32     0x0006  /* Direct 32-bit reference to the symbols virtual address */
#define REL_I386_DIR32NB   0x0007  /* Direct 32-bit reference to the symbols virtual address, base not included */
#define REL_I386_SEG12     0x0009  /* Direct 16-bit reference to the segment-selector bits of a 32-bit virtual address */
#define REL_I386_SECTION   0x000A
#define REL_I386_SECREL    0x000B
#define REL_I386_REL32     0x0014  /* PC-relative 32-bit reference to the symbols virtual address */

/*
// NT MIPS relocation types.
*/

#define REL_MIPS_ABSOLUTE         0x0000  /* Reference is absolute, no relocation is necessary */
#define REL_MIPS_REFHALF          0x0001
#define REL_MIPS_REFWORD          0x0002
#define REL_MIPS_JMPADDR          0x0003
#define REL_MIPS_REFHI            0x0004
#define REL_MIPS_REFLO            0x0005
#define REL_MIPS_GPREL            0x0006
#define REL_MIPS_LITERAL          0x0007
#define REL_MIPS_SECTION          0x000A
#define REL_MIPS_SECREL           0x000B
#define REL_MIPS_SECRELLO         0x000C  /* Low 16-bit section relative referemce (used for >32k TLS) */
#define REL_MIPS_SECRELHI         0x000D  /* High 16-bit section relative reference (used for >32k TLS) */
#define REL_MIPS_REFWORDNB        0x0022
#define REL_MIPS_PAIR             0x0025

/*
// NT Alpha Relocation types.
*/

#define REL_ALPHA_ABSOLUTE        0x0000
#define REL_ALPHA_REFLONG         0x0001
#define REL_ALPHA_REFQUAD         0x0002
#define REL_ALPHA_GPREL32         0x0003
#define REL_ALPHA_LITERAL         0x0004
#define REL_ALPHA_LITUSE          0x0005
#define REL_ALPHA_GPDISP          0x0006
#define REL_ALPHA_BRADDR          0x0007
#define REL_ALPHA_HINT            0x0008
#define REL_ALPHA_INLINE_REFLONG  0x0009
#define REL_ALPHA_REFHI           0x000A
#define REL_ALPHA_REFLO           0x000B
#define REL_ALPHA_PAIR            0x000C
#define REL_ALPHA_MATCH           0x000D
#define REL_ALPHA_SECTION         0x000E
#define REL_ALPHA_SECREL          0x000F
#define REL_ALPHA_REFLONGNB       0x0010
#define REL_ALPHA_SECRELLO        0x0011  /* Low 16-bit section relative reference */
#define REL_ALPHA_SECRELHI        0x0012  /* High 16-bit section relative reference */

/*
// NT IBM PowerPC relocation types.
*/

#define REL_PPC_ABSOLUTE          0x0000  /* NOP */
#define REL_PPC_ADDR64            0x0001  /* 64-bit address */
#define REL_PPC_ADDR32            0x0002  /* 32-bit address */
#define REL_PPC_ADDR24            0x0003  /* 26-bit address, shifted left 2 (branch absolute) */
#define REL_PPC_ADDR16            0x0004  /* 16-bit address */
#define REL_PPC_ADDR14            0x0005  /* 16-bit address, shifted left 2 (load doubleword) */
#define REL_PPC_REL24             0x0006  /* 26-bit PC-relative offset, shifted left 2 (branch relative) */
#define REL_PPC_REL14             0x0007  /* 16-bit PC-relative offset, shifted left 2 (br cond relative) */
#define REL_PPC_TOCREL16          0x0008  /* 16-bit offset from TOC base */
#define REL_PPC_TOCREL14          0x0009  /* 16-bit offset from TOC base, shifted left 2 (load doubleword) */

#define REL_PPC_ADDR32NB          0x000A  /* 32-bit addr w/o image base */
#define REL_PPC_SECREL            0x000B  /* va of containing section (as in an image sectionhdr) */
#define REL_PPC_SECTION           0x000C  /* sectionheader number */
#define REL_PPC_IFGLUE            0x000D  /* substitute TOC restore instruction iff symbol is glue code */
#define REL_PPC_IMGLUE            0x000E  /* symbol is glue code; virtual address is TOC restore instruction */
#define REL_PPC_SECREL16          0x000F  /* va of containing section (limited to 16 bits) */
#define REL_PPC_REFHI             0x0010
#define REL_PPC_REFLO             0x0011
#define REL_PPC_PAIR              0x0012

#define REL_PPC_TYPEMASK          0x00FF  /* mask to isolate above values in IMAGE_RELOCATION.Type */

/* Flag bits in IMAGE_RELOCATION.TYPE */

#define REL_PPC_NEG               0x0100  /* subtract reloc value rather than adding it */
#define REL_PPC_BRTAKEN           0x0200  /* fix branch prediction bit to predict branch taken */
#define REL_PPC_BRNTAKEN          0x0400  /* fix branch prediction bit to predict branch not taken */
#define REL_PPC_TOCDEFN           0x0800  /* toc slot defined in file (or, data in toc) */

/*
// NT Based relocation format.
*/

typedef struct {
    unsigned long   RVA;
    unsigned long   size;
} PE_FIXUP, *PPE_FIXUP;


/*
// NT Based relocation types.
*/

#define REL_BASED_ABSOLUTE              0
#define REL_BASED_HIGH                  1
#define REL_BASED_LOW                   2
#define REL_BASED_HIGHLOW               3
#define REL_BASED_HIGHADJ               4
#define REL_BASED_MIPS_JMPADDR          5


#define DEFAULT_UNIX_ALIGNMENT 4
#define DEFAULT_NT_ALIGNMENT 16

/*
// NT Communal selection types.
*/

#define COMDAT_SELECT_NODUPLICATES    1
#define COMDAT_SELECT_ANY             2
#define COMDAT_SELECT_SAME_SIZE       3
#define COMDAT_SELECT_EXACT_MATCH     4
#define COMDAT_SELECT_ASSOCIATIVE     5
#define COMDAT_SELECT_LARGEST         6
#define COMDAT_SELECT_NEWEST          7

#define WEAK_EXTERN_SEARCH_NOLIBRARY  1
#define WEAK_EXTERN_SEARCH_LIBRARY    2
#define WEAK_EXTERN_SEARCH_ALIAS      3


/*
// NT DLL support.
*/

/*
// Export Format
*/

typedef struct {
    unsigned long   Flags;
    unsigned long   TimeDate;
    unsigned short  MajorVersion;
    unsigned short  MinorVersion;
    unsigned long   DllNameRVA;
    unsigned long   OrdinalBase;
    unsigned long   NumFuncs;
    unsigned long   NumNames;
    unsigned long   AddressTableRVA;
    unsigned long   NameTableRVA;
    unsigned long   OrdinalTableRVA;
} PE_EXPORT_DIR, *PPE_EXPORT_DIR;

/*
// Import Format
*/

typedef struct {
	unsigned long ILT_RVA;         /* RVA of the Import Lookup Table */
	unsigned long timedate;
	unsigned long ForwarderChain;  /* ??? */
	unsigned long DllNameRVA;      /* Address of asciiz dll name */
	unsigned long IAT_RVA;         /* RVA of the Import Address Table */
} PE_IMPORT_DIR, *PPE_IMPORT_DIR;

typedef struct {
	unsigned short hint;
	char name[1];
} PE_HINT_NAME, *PPE_HINT_NAME;


typedef struct {
    union {
        unsigned char*  ForwarderString;
        unsigned long* Function;
        unsigned long Ordinal;
        PPE_HINT_NAME AddressOfData;
    } u1;
} PE_THUNK_DATA, *PPE_THUNK_DATA;

#define IMAGE_ORDINAL_FLAG 0x80000000
#define IMAGE_SNAP_BY_ORDINAL(Ordinal) ((Ordinal & IMAGE_ORDINAL_FLAG) != 0)
#define IMAGE_ORDINAL(Ordinal) (Ordinal & 0xffff)

typedef struct _IMAGE_IMPORT_DESCRIPTOR {
    union {
     unsigned long   Characteristics; /* 0 for terminating null import descriptor */
     PPE_THUNK_DATA OriginalFirstThunk; /* RVA to original unbound IAT */
    } u;
    unsigned long   TimeDateStamp;  /* 0 if not bound, */
                                    /* -1 if bound, and real date\time stamp */
                         /* in IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT (new BIND) */
                          /* O.W. date/time stamp of DLL bound to (Old BIND) */

    long   ForwarderChain;         /* -1 if no forwarders */
    unsigned long   Name;
    PPE_THUNK_DATA FirstThunk;  /* RVA to IAT (if bound this IAT has actual addresses) */
} IMAGE_IMPORT_DESCRIPTOR, *PIMAGE_IMPORT_DESCRIPTOR;

/*
	New format import descriptors pointed to by
	DataDirectory[ IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT ]
*/

typedef struct _IMAGE_BOUND_IMPORT_DESCRIPTOR {
    unsigned long   TimeDateStamp;
    unsigned short    OffsetModuleName;
    unsigned short    NumberOfModuleForwarderRefs;
/* Array of zero or more IMAGE_BOUND_FORWARDER_REF follows */
} IMAGE_BOUND_IMPORT_DESCRIPTOR, *PIMAGE_BOUND_IMPORT_DESCRIPTOR;

typedef struct _IMAGE_BOUND_FORWARDER_REF {
    unsigned long   TimeDateStamp;
    unsigned short    OffsetModuleName;
    unsigned short    Reserved;
} IMAGE_BOUND_FORWARDER_REF, *PIMAGE_BOUND_FORWARDER_REF;


/*
// Thread Local Storage
*/

typedef void (*PIMAGE_TLS_CALLBACK) ();

typedef struct _IMAGE_TLS_DIRECTORY {
    unsigned long   StartAddressOfRawData;
    unsigned long   EndAddressOfRawData;
    unsigned long*  AddressOfIndex;
    PIMAGE_TLS_CALLBACK *AddressOfCallBacks;
    unsigned long   SizeOfZeroFill;
    unsigned long   Characteristics;
} IMAGE_TLS_DIRECTORY, *PIMAGE_TLS_DIRECTORY;


/*
// Resource Format.
*/

/*
// Resource directory consists of two counts, following by a variable length
// array of directory entries.  The first count is the number of entries at
// beginning of the array that have actual names associated with each entry.
// The entries are in ascending order, case insensitive strings.  The second
// count is the number of entries that immediately follow the named entries.
// This second count identifies the number of entries that have 16-bit integer
// Ids as their name.  These entries are also sorted in ascending order.
//
// This structure allows fast lookup by either name or number, but for any
// given resource entry only one form of lookup is supported, not both.
// This is consistant with the syntax of the .RC file and the .RES file.
*/

typedef struct _IMAGE_RESOURCE_DIRECTORY {
    unsigned long   Characteristics;
    unsigned long   TimeDateStamp;
    unsigned short    MajorVersion;
    unsigned short    MinorVersion;
    unsigned short    NumberOfNamedEntries;
    unsigned short    NumberOfIdEntries;
/*  IMAGE_RESOURCE_DIRECTORY_ENTRY DirectoryEntries[]; */
} IMAGE_RESOURCE_DIRECTORY, *PIMAGE_RESOURCE_DIRECTORY;

#define IMAGE_RESOURCE_NAME_IS_STRING        0x80000000
#define IMAGE_RESOURCE_DATA_IS_DIRECTORY     0x80000000

/*
// Each directory contains the 32-bit Name of the entry and an offset,
// relative to the beginning of the resource directory of the data associated
// with this directory entry.  If the name of the entry is an actual text
// string instead of an integer Id, then the high order bit of the name field
// is set to one and the low order 31-bits are an offset, relative to the
// beginning of the resource directory of the string, which is of type
// IMAGE_RESOURCE_DIRECTORY_STRING.  Otherwise the high bit is clear and the
// low-order 16-bits are the integer Id that identify this resource directory
// entry. If the directory entry is yet another resource directory (i.e. a
// subdirectory), then the high order bit of the offset field will be
// set to indicate this.  Otherwise the high bit is clear and the offset
// field points to a resource data entry.
*/

typedef struct _IMAGE_RESOURCE_DIRECTORY_ENTRY {
    union {
        struct {
            unsigned long NameOffset:31;
            unsigned long NameIsString:1;
        } s;
        unsigned long   Name;
        unsigned short    Id;
    } u1;
    union {
        unsigned long   OffsetToData;
        struct {
            unsigned long   OffsetToDirectory:31;
            unsigned long   DataIsDirectory:1;
        } s;
    } u2;
} IMAGE_RESOURCE_DIRECTORY_ENTRY, *PIMAGE_RESOURCE_DIRECTORY_ENTRY;

/*
// For resource directory entries that have actual string names, the Name
// field of the directory entry points to an object of the following type.
// All of these string objects are stored together after the last resource
// directory entry and before the first resource data object.  This minimizes
// the impact of these variable length objects on the alignment of the fixed
// size directory entry objects.
*/

typedef struct _IMAGE_RESOURCE_DIRECTORY_STRING {
    unsigned short    Length;
    char    		  NameString[ 1 ];
} IMAGE_RESOURCE_DIRECTORY_STRING, *PIMAGE_RESOURCE_DIRECTORY_STRING;


typedef struct _IMAGE_RESOURCE_DIR_STRING_U {
    unsigned short   Length;
    unsigned short   NameString[ 1 ];
} IMAGE_RESOURCE_DIR_STRING_U, *PIMAGE_RESOURCE_DIR_STRING_U;


/*
// Each resource data entry describes a leaf node in the resource directory
// tree.  It contains an offset, relative to the beginning of the resource
// directory of the data for the resource, a size field that gives the number
// of bytes of data at that offset, a CodePage that should be used when
// decoding code point values within the resource data.  Typically for new
// applications the code page would be the unicode code page.
*/

typedef struct _IMAGE_RESOURCE_DATA_ENTRY {
    unsigned long   OffsetToData;
    unsigned long   Size;
    unsigned long   CodePage;
    unsigned long   Reserved;
} IMAGE_RESOURCE_DATA_ENTRY, *PIMAGE_RESOURCE_DATA_ENTRY;

/*
// Load Configuration Directory Entry
*/

typedef struct _IMAGE_LOAD_CONFIG_DIRECTORY {
    unsigned long   Characteristics;
    unsigned long   TimeDateStamp;
    unsigned short    MajorVersion;
    unsigned short    MinorVersion;
    unsigned long   GlobalFlagsClear;
    unsigned long   GlobalFlagsSet;
    unsigned long   CriticalSectionDefaultTimeout;
    unsigned long   DeCommitFreeBlockThreshold;
    unsigned long   DeCommitTotalFreeThreshold;
    void*   		LockPrefixTable;
    unsigned long   MaximumAllocationSize;
    unsigned long   VirtualMemoryThreshold;
    unsigned long   ProcessHeapFlags;
    unsigned long   Reserved[ 4 ];
} IMAGE_LOAD_CONFIG_DIRECTORY, *PIMAGE_LOAD_CONFIG_DIRECTORY;


/*
// Function table entry format for MIPS/ALPHA images.  Function table is
// pointed to by the IMAGE_DIRECTORY_ENTRY_EXCEPTION directory entry.
// This definition duplicates ones in ntmips.h and ntalpha.h for use
// by portable image file mungers.
*/

typedef struct _IMAGE_RUNTIME_FUNCTION_ENTRY {
    unsigned long BeginAddress;
    unsigned long EndAddress;
    void* ExceptionHandler;
    void* HandlerData;
    unsigned long PrologEndAddress;
} IMAGE_RUNTIME_FUNCTION_ENTRY, *PIMAGE_RUNTIME_FUNCTION_ENTRY;

/*
// Debug Format
*/

typedef struct _IMAGE_DEBUG_DIRECTORY {
    unsigned long   Characteristics;
    unsigned long   TimeDateStamp;
    unsigned short    MajorVersion;
    unsigned short    MinorVersion;
    unsigned long   Type;
    unsigned long   SizeOfData;
    unsigned long   AddressOfRawData;
    unsigned long   PointerToRawData;
} IMAGE_DEBUG_DIRECTORY, *PIMAGE_DEBUG_DIRECTORY;

#define IMAGE_DEBUG_TYPE_UNKNOWN          0
#define IMAGE_DEBUG_TYPE_COFF             1
#define IMAGE_DEBUG_TYPE_CODEVIEW         2
#define IMAGE_DEBUG_TYPE_FPO              3
#define IMAGE_DEBUG_TYPE_MISC             4
#define IMAGE_DEBUG_TYPE_EXCEPTION        5
#define IMAGE_DEBUG_TYPE_FIXUP            6
#define IMAGE_DEBUG_TYPE_OMAP_TO_SRC      7
#define IMAGE_DEBUG_TYPE_OMAP_FROM_SRC    8

typedef struct _IMAGE_COFF_SYMBOLS_HEADER {
    unsigned long   NumberOfSymbols;
    unsigned long   LvaToFirstSymbol;
    unsigned long   NumberOfLinenumbers;
    unsigned long   LvaToFirstLinenumber;
    unsigned long   RvaToFirstByteOfCode;
    unsigned long   RvaToLastByteOfCode;
    unsigned long   RvaToFirstByteOfData;
    unsigned long   RvaToLastByteOfData;
} IMAGE_COFF_SYMBOLS_HEADER, *PIMAGE_COFF_SYMBOLS_HEADER;

#define FRAME_FPO       0
#define FRAME_TRAP      1
#define FRAME_TSS       2
#define FRAME_NONFPO    3

typedef struct _FPO_DATA {
    unsigned long       ulOffStart;      /* offset 1st byte of function code */
    unsigned long       cbProcSize;      /* # bytes in function */
    unsigned long       cdwLocals;       /* # bytes in locals/4 */
    unsigned short        cdwParams;     /* # bytes in params/4 */
    unsigned short        cbProlog : 8;  /* # bytes in prolog */
    unsigned short        cbRegs   : 3;  /* # regs saved */
    unsigned short        fHasSEH  : 1;  /* TRUE if SEH in func */
    unsigned short        fUseBP   : 1;  /* TRUE if EBP has been allocated */
    unsigned short        reserved : 1;  /* reserved for future use */
    unsigned short        cbFrame  : 2;  /* frame type */
} FPO_DATA, *PFPO_DATA;
#define SIZEOF_RFPO_DATA 16


#define IMAGE_DEBUG_MISC_EXENAME    1

typedef struct _IMAGE_DEBUG_MISC {
    unsigned long   DataType;   /* type of misc data, see defines */
    unsigned long   Length;     /* total length of record, rounded to four */
                                /* byte multiple. */
    unsigned char   Unicode;    /* TRUE if data is unicode string */
    unsigned char   Reserved[ 3 ];
    unsigned char   Data[ 1 ];     /* Actual data */
} IMAGE_DEBUG_MISC, *PIMAGE_DEBUG_MISC;


/*
// Function table extracted from MIPS/ALPHA images.  Does not contain
// information needed only for runtime support.  Just those fields for
// each entry needed by a debugger.
*/

typedef struct _IMAGE_FUNCTION_ENTRY {
    unsigned long   StartingAddress;
    unsigned long   EndingAddress;
    unsigned long   EndOfPrologue;
} IMAGE_FUNCTION_ENTRY, *PIMAGE_FUNCTION_ENTRY;

/*
// Debugging information can be stripped from an image file and placed
// in a separate .DBG file, whose file name part is the same as the
// image file name part (e.g. symbols for CMD.EXE could be stripped
// and placed in CMD.DBG).  This is indicated by the IMAGE_FILE_DEBUG_STRIPPED
// flag in the Characteristics field of the file header.  The beginning of
// the .DBG file contains the following structure which captures certain
// information from the image file.  This allows a debug to proceed even if
// the original image file is not accessable.  This header is followed by
// zero of more IMAGE_SECTION_HEADER structures, followed by zero or more
// IMAGE_DEBUG_DIRECTORY structures.  The latter structures and those in
// the image file contain file offsets relative to the beginning of the
// .DBG file.
//
// If symbols have been stripped from an image, the IMAGE_DEBUG_MISC structure
// is left in the image file, but not mapped.  This allows a debugger to
// compute the name of the .DBG file, from the name of the image in the
// IMAGE_DEBUG_MISC structure.
*/

typedef struct _IMAGE_SEPARATE_DEBUG_HEADER {
    unsigned short        Signature;
    unsigned short        Flags;
    unsigned short        Machine;
    unsigned short        Characteristics;
    unsigned long       TimeDateStamp;
    unsigned long       CheckSum;
    unsigned long       ImageBase;
    unsigned long       SizeOfImage;
    unsigned long       NumberOfSections;
    unsigned long       ExportedNamesSize;
    unsigned long       DebugDirectorySize;
    unsigned long       Reserved[ 3 ];/* Note: reserved[0] is 
    									actually the section alignment */
} IMAGE_SEPARATE_DEBUG_HEADER, *PIMAGE_SEPARATE_DEBUG_HEADER;

#define IMAGE_SEPARATE_DEBUG_SIGNATURE 0x4944

/* ======================= ELF DEFS FROM LINUX ============================ */

#ifndef _LINUX_ELF_H
#define _LINUX_ELF_H

typedef unsigned long	Elf32_Addr;
typedef unsigned short	Elf32_Half;
typedef unsigned long	Elf32_Off;
typedef long		    Elf32_Sword;
typedef unsigned long	Elf32_Word;

/* These constants are for the segment types stored in the image headers */
#define PT_NULL    0
#define PT_LOAD    1
#define PT_DYNAMIC 2
#define PT_INTERP  3
#define PT_NOTE    4
#define PT_SHLIB   5
#define PT_PHDR    6
#define PT_LOPROC  0x70000000
#define PT_HIPROC  0x7fffffff

/* These constants define the different elf file types */
#define ET_NONE   0
#define ET_REL    1
#define ET_EXEC   2
#define ET_DYN    3
#define ET_CORE   4
#define ET_LOPROC 5
#define ET_HIPROC 6

/* These constants define the various ELF target machines */
#define EM_NONE  0
#define EM_M32   1
#define EM_SPARC 2
#define EM_386   3
#define EM_68K   4
#define EM_88K   5
#define EM_486   6   /* Perhaps disused */
#define EM_860   7

/* This is the info that is needed to parse the dynamic section of the file */
#define DT_NULL		0
#define DT_NEEDED	1
#define DT_PLTRELSZ	2
#define DT_PLTGOT	3
#define DT_HASH		4
#define DT_STRTAB	5
#define DT_SYMTAB	6
#define DT_RELA		7
#define DT_RELASZ	8
#define DT_RELAENT	9
#define DT_STRSZ	10
#define DT_SYMENT	11
#define DT_INIT		12
#define DT_FINI		13
#define DT_SONAME	14
#define DT_RPATH 	15
#define DT_SYMBOLIC	16
#define DT_REL	    17
#define DT_RELSZ	18
#define DT_RELENT	19
#define DT_PLTREL	20
#define DT_DEBUG	21
#define DT_TEXTREL	22
#define DT_JMPREL	23
#define DT_LOPROC	0x70000000
#define DT_HIPROC	0x7fffffff

/* This info is needed when parsing the symbol table */
#define STB_LOCAL  0
#define STB_GLOBAL 1
#define STB_WEAK   2

#define STT_NOTYPE  0
#define STT_OBJECT  1
#define STT_FUNC    2
#define STT_SECTION 3
#define STT_FILE    4

#define ELF32_ST_BIND(x) ((x) >> 4)
#define ELF32_ST_TYPE(x) (((unsigned int) x) & 0xf)

typedef struct dynamic{
  Elf32_Sword   d_tag;
  union{
    Elf32_Sword	d_val;
    Elf32_Addr	d_ptr;
  } d_un;
} Elf32_Dyn;

extern Elf32_Dyn _DYNAMIC [];

/* The following are used with relocations */
#define ELF32_R_SYM(x) ((x) >> 8)
#define ELF32_R_TYPE(x) ((x) & 0xff)

#define R_386_NONE	0
#define R_386_32	1
#define R_386_PC32	2
#define R_386_GOT32	3
#define R_386_PLT32	4
#define R_386_COPY	5
#define R_386_GLOB_DAT	6
#define R_386_JMP_SLOT	7
#define R_386_RELATIVE	8
#define R_386_GOTOFF	9
#define R_386_GOTPC	10
#define R_386_NUM	11

typedef struct elf32_rel {
  Elf32_Addr	r_offset;
  Elf32_Word	r_info;
} Elf32_Rel;

typedef struct elf32_rela{
  Elf32_Addr	r_offset;
  Elf32_Word	r_info;
  Elf32_Sword	r_addend;
} Elf32_Rela;

typedef struct elf32_sym{
  Elf32_Word	st_name;
  Elf32_Addr	st_value;
  Elf32_Word	st_size;
  unsigned char	st_info;
  unsigned char	st_other;
  Elf32_Half	st_shndx;
} Elf32_Sym;


#define EI_NIDENT	16

typedef struct elfhdr{
  unsigned char	e_ident[EI_NIDENT];
  Elf32_Half	e_type;
  Elf32_Half	e_machine;
  Elf32_Word	e_version;
  Elf32_Addr	e_entry;  /* Entry point */
  Elf32_Off	    e_phoff;
  Elf32_Off	    e_shoff;
  Elf32_Word	e_flags;
  Elf32_Half	e_ehsize;
  Elf32_Half	e_phentsize;
  Elf32_Half	e_phnum;
  Elf32_Half	e_shentsize;
  Elf32_Half	e_shnum;
  Elf32_Half	e_shstrndx;
} Elf32_Ehdr;

typedef struct elf_phdr{
  Elf32_Word	p_type;
  Elf32_Off	    p_offset;
  Elf32_Addr	p_vaddr;
  Elf32_Addr	p_paddr;
  Elf32_Word	p_filesz;
  Elf32_Word	p_memsz;
  Elf32_Word	p_flags;
  Elf32_Word	p_align;
} Elf32_Phdr;

/* sh_type */
#define SHT_NULL	0
#define SHT_PROGBITS	1
#define SHT_SYMTAB	2
#define SHT_STRTAB	3
#define SHT_RELA	4
#define SHT_HASH	5
#define SHT_DYNAMIC	6
#define SHT_NOTE	7
#define SHT_NOBITS	8
#define SHT_REL		9
#define SHT_SHLIB	10
#define SHT_DYNSYM	11
#define SHT_NUM		12
#define SHT_LOPROC	0x70000000
#define SHT_HIPROC	0x7fffffff
#define SHT_LOUSER	0x80000000
#define SHT_HIUSER	0xffffffff

/* sh_flags */
#define SHF_WRITE	    0x1
#define SHF_ALLOC	    0x2
#define SHF_EXECINSTR	0x4
#define SHF_MASKPROC	0xf0000000

/* special section indexes */
#define SHN_UNDEF	0
#define SHN_LORESERVE	0xff00
#define SHN_LOPROC	0xff00
#define SHN_HIPROC	0xff1f
#define SHN_ABS		0xfff1
#define SHN_COMMON	0xfff2
#define SHN_HIRESERVE	0xffff
 
typedef struct {
  Elf32_Word	sh_name;
  Elf32_Word	sh_type;
  Elf32_Word	sh_flags;
  Elf32_Addr	sh_addr;
  Elf32_Off	    sh_offset;
  Elf32_Word	sh_size;
  Elf32_Word	sh_link;
  Elf32_Word	sh_info;
  Elf32_Word	sh_addralign;
  Elf32_Word	sh_entsize;
} Elf32_Shdr;

#define	EI_MAG0		0		/* e_ident[] indexes */
#define	EI_MAG1		1
#define	EI_MAG2		2
#define	EI_MAG3		3
#define	EI_CLASS	4
#define	EI_DATA		5
#define	EI_VERSION	6
#define	EI_PAD		7

#define	ELFMAG0		0x7f		/* EI_MAG */
#define	ELFMAG1		'E'
#define	ELFMAG2		'L'
#define	ELFMAG3		'F'
#define	ELFMAG		"\177ELF"
#define	SELFMAG		4

#define	ELFCLASSNONE	0		/* EI_CLASS */
#define	ELFCLASS32	1
#define	ELFCLASS64	2
#define	ELFCLASSNUM	3

#define ELFDATANONE	0		/* e_ident[EI_DATA] */
#define ELFDATA2LSB	1
#define ELFDATA2MSB	2

#define EV_NONE		0		/* e_version, EI_VERSION */
#define EV_CURRENT	1
#define EV_NUM		2

#define ELF_START_MMAP 0x80000000

#endif /* _LINUX_ELF_H */

/* whole file */

