/* TOXCC.C -- test program for running oxcc */
/* 
	try:	oxcc -r toxcc.c -TRACE=1 >trace
		  and
		    oxcc -Gb toxcc.c
		    bterp toxcc -TRACE=1 >trace
*/

#include <stdlib.h>
#include "oxcc.h"
#include "cff.h"

typedef void *object;

extern object Compiler;
extern object String;
extern object File;

extern int gSeek();
extern int gPosition();
extern int gGets();
extern void *gNew();
extern void gDispose();
extern void *oxlink_find_bare_symb();
extern void *oxlink_load_bare_symb();

static char *testcode =

	"static inline int addfunc(int a, int b)\n"
	"{"
	"int q;"
		"return a + b;"
	"}"
	"int func(void)\n"
	"{"
	"int x;"
		"x = addfunc(1,2);"
		"return x;"
	"}";


int toxcc(int argc, char **argv)
{
void *instance;
void *is;
void *os;
void *es;
char buf[200];
int err;

	cfprintf("toxcc running\n");

	/* METHOD 1 -- GET AN INSTANCE OF OXCC USING C CALLS */
	cfprintf("Method 1\n");

	if(!oxlink_find_bare_symb("_oxcc"))
	  if(!oxlink_load_bare_symb("_oxcc", 1))
	    {cfprintf("oxcc load failed\n"); return 1;}
	instance = oxcc_open_instance();

	is = cffopen(testcode, "x");	/* open string as a stream (readonly) */
	os = cffopen("", "w+UTM"); /* create a Unique Temp file in Memory */
	es = cffopen("", "w+UTM"); /* create a Unique Temp file in Memory */

	/* check the input file */
	if(!(err = oxcc_preproc_file(instance, is, os, es, 0, 0)))
	{
	  cfrewind(os);
	  if((err = oxcc_parse_file(instance, os, es, "testcode")))
	  {
		oxcc_print_parse_errors(instance, es);
	  }
	  else
	  {
		err = oxcc_check_ast_tree(instance, es, "testcode");
	  }
	}
	oxcc_cleanup_parse(instance);

	/* dump accumulated errors and warnings */
	if(cfftell(es) > 0)
	{
		cfrewind(es);
		while(cffgets(buf, 199, es))
		  cffputs(buf, cfstdout);
	}
	cffclose(is);
	cffclose(os);
	cffclose(es);
	/* could loop here on a new file */

	oxcc_close_instance(instance);


	/* METHOD 2 -- GET AN INSTANCE OF OXCC USING THE CLASS METHOD */
	cfprintf("\nMethod 2\n");

	if(!(instance = gNew(Compiler, "cc")))
	  {cfprintf("oxcc class failed\n"); return 1;}

	is = gNew(String, testcode); /* or could use gNew(File, testcode, "x") */
	os = gNew(File, "", "w+UTM");
	es = gNew(File, "", "w+UTM");

	/* check the input file */
	if(!(err = gPreProc(instance, is, os, es, 0, 0)))
	{
	  gSeek(os, 0);
	  if((err = gParse(instance, os, es, "testcode")))
	  {
		gPerror(instance, es);
	  }
	  else
	  {
		err = gCheckTree(instance, es, "testcode");
	  }
	}
	gCleanup(instance);

	/* dump accumulated errors and warnings */
	if(gPosition(es) > 0)
	{
		gSeek(es, 0);
		while(gGets(es, buf, 199))
		  cffputs(buf, cfstdout);
	}
	gDispose(is);
	gDispose(os);
	gDispose(es);
	/* could loop here on a new file */

	gDispose(instance);

	return 0;
}
