#include <stdio.h>
#include <process.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <dir.h>
#include <time.h>
#include "1ad.h"
#include "1adini.h"




/* global variables */
net_networks_rec thisnet;				// net struct for current network
net_system_list_rec thisboard;	// sys info struc for this board
char netpath[85];								// path to network files

FILE *log;											// the tron.log file handle
FILE *mail;											// file for outgoing mail
FILE *incomming;								// incomming file handle
time_t now;

char LOGFILE[201];
char text_file_dir[201];
char from[201];
char title[201];
char **pings;
int amount_pings;

char **ok_systems;
int amount_ok_systems;

ini_inforec ini_info;


void main(int argc, char *argv[])
{
  struct tm *time_now;
	int i, netnum;
  char s[101];

  read_ini();
  if(!amount_pings)
    return;

  if(argc < 2)
    return;


  log = fopen(LOGFILE, "at");         // open the log file
  if (!log)                           // serious problem...
  {
    printf("Couldn't open logfile\n");
    return;
  }

  now = time(NULL);                   // time at start of processing
  time_now = localtime(&now);
  strftime(s, 100, "Start entry at %X on %x\n", time_now);
  fprintf(log, s);


  // get info for current network from networks.dat, store in "thisnet"
	netnum = atoi(&argv[1][1]);		// skip the decimal point
	if (!get_net_info(netnum, &thisnet))
	{
		fprintf(log, "\nUnable to open network data file !\n");
    printf("\nUnable to open network data file !\n");

    fprintf(log, "Done\n\n");
    fclose(log);
		return;
	}
	// make a valid path string from path in networks.dat - store to "netpath"
	// this is the path where all incomming & outgoing files for this net are

	strcpy(netpath, thisnet.dir);
//  for (i = 0; i < strlen(netpath); i++) // change "\" to "/"
//    if (netpath[i] == 0x5c)
//      netpath[i] = 0x2f;
//  netpath[i] = '/';
//  netpath[++i] = '\0';


  sprintf(s, "%sP9.NET", netpath);
  mail = fopen(s, "ab");
  if(!mail)
  {
    printf("Couldn't open P9.NET");
    fclose(log);
    return;
  }

  get_board_info(&thisboard, thisnet.sysnum, 1); // get info for this board
	checklocal();									// process the incomming "local.net"

  fprintf(log, "Done\n\n");
	fclose(log);
  fclose(mail);
}

// process incomming "local.net" file
void checklocal(void)
{
	char tmppath[80];							// scratch path buffer
	FILE *in;											// handle for incomming local.net
	net_header_rec temp;					// current net packet header
  long this_pos, next_pos;


  sprintf(tmppath, "%slocal.net", netpath);
  in = fopen(tmppath, "rb+wb");
	if (!in)
		return;											// no local.net - nothing to do !

  fprintf(log, "\nProcessing %s at %s", tmppath, ctime(&now));
  printf("\nProcessing %s at %s", tmppath, ctime(&now));


#ifdef DEBUG
	fprintf(log, "   TO\t  FROM\t\t  DATE\t\t\tTYPE\t\tSIZE\n");
#endif



	// read a net header rec, store in temp
  while(1)
	{
    this_pos = ftell(in);
    if(fread((void *)&temp, sizeof(net_header_rec), 1, in) == NULL)
      break;

		fseek(in, temp.list_len * 2, SEEK_CUR);	// seek past list
    next_pos = ftell(in);


#ifdef DEBUG
    fprintf(log, "%3d@%-4d %3d@%-4d\t%s", temp.touser, temp.tosys, temp.fromuser, temp.fromsys, daten_to_date(temp.daten));
    if (temp.main_type < 0x01c)
      fprintf(log, "\t%x/%u %s", temp.main_type, temp.minor_type, types[temp.main_type]);
		else
      fprintf(log, "\t%x/%d UNKNOWN !", temp.main_type, temp.minor_type);
		fprintf(log, "\t%ld (%d)\n", temp.length, temp.method);
#endif


    if(sub_type_allowed(temp.main_type, temp.minor_type, temp.fromsys, temp.fromuser) == 0)
    {
      fseek(in, this_pos, SEEK_SET);
      temp.main_type = 0xffff;       /* set to deleted (65535) */
      fwrite((void *)&temp, sizeof(net_header_rec), 1, in);
      fseek(in, next_pos, SEEK_SET);
    }


    fseek(in, temp.length, SEEK_CUR); /* dunno - skip it */
	}

  fclose(in);
	fprintf(log, "** End of %s \n", tmppath);
  printf("** End of %s \n", tmppath);
	return;
}


int sub_type_allowed(unsigned main_type, unsigned minor_type, unsigned sys, unsigned user)
{
  int x = 0;
  char main[201], minor[201], tfile[201];


  while(x < amount_pings)
  {
    parse_unwanted_pings(pings[x], main, minor, tfile);

    if(atoi(main) == main_type && (atoi(minor) == minor_type || strcmpi(minor, "ALL") == 0))
    {
      if(is_sys_wanted(sys) == 0)
      {
        email(sys, tfile, sys, user);

        sprintf(main, "Killing %u/%u from %u, sent file %s", main_type, minor_type, sys, tfile);
        ssm(0, main);
        fprintf(log, "%s\n", main);

        return 0;    /* delete it, it isn't allowed */
      }
      else
      {
        sprintf(main, "Allowed %u/%u from %u to pass through", main_type, minor_type, sys);
        ssm(0, main);
        fprintf(log, "%s\n", main);
        return 1;    /* if system is wanted, return 1 */
      }
    }
    ++x;
  }
  return 1;    /* it is an allowed subtype */
}

int is_sys_wanted(unsigned sys)
{
  int x=0;

  while(x < amount_ok_systems)
  {
    if(atoi(ok_systems[x])==sys)
      return 1;

    ++x;
  }
  return 0;      /* not in the list of systems that are allowed to ping */
}


void parse_unwanted_pings(char *unwanted, char *main, char *minor, char *tfile)
{
  char *tmp1, *tmp2;

  tmp1 = strchr(unwanted, '/');

  if(!tmp1)
  {
    strcpy(main, unwanted);
    minor[0] = 0;
    tfile[0] = 0;
    return;
  }

  tmp1[0] = 0;
  ++tmp1;

  strcpy(main, unwanted);

  tmp2 = strchr(tmp1, '/');
  if(!tmp2)
  {
    strcpy(minor, tmp1);
    tfile[0] = 0;
    return;
  }

  tmp2[0] = 0;
  ++tmp2;

  strcpy(minor, tmp1);
  strcpy(tfile, tmp2);
}




/*** following function ripped off from uedit.c ***/
unsigned char *daten_to_date(long dt)
{
	struct date d;
	struct time t;
	static unsigned char s[9];

	unixtodos(dt, &d, &t);
	sprintf(s, "%02d/%02d/%02d", d.da_mon, d.da_day, (d.da_year - 1900));
	return (s);
}


int get_net_info(int num, net_networks_rec * rec)
{
	FILE *in;
	in = fopen("data/networks.dat", "rb");
	if (!in)
		return 0;
	fseek(in, (long) (num * sizeof(net_networks_rec)), SEEK_SET);
	fread(rec, sizeof(net_networks_rec), 1, in);
	fclose(in);
	return 1;
}

void ssm(unsigned sys, char *msg)
{
  net_header_rec h;
  FILE *locmail;
  char locpath[90];

  h.touser = 1;
  if (sys)                      // if sys == 0, it's a local ssm
    h.tosys = sys;
  else
    h.tosys = thisboard.sysnum;
  h.fromsys = thisboard.sysnum;
  h.fromuser = 1;
  h.length = (unsigned long) strlen(msg) + 1;
  h.main_type = 15;
  h.daten = now;
  h.method = 0;
  h.list_len = 0;

  if(mail)
  {
    fwrite(&h, sizeof(net_header_rec), 1, mail);
    fwrite(msg, strlen(msg) + 1, 1, mail);
  }

  return;
}


/*
  Need to add code to put the From name as well as the date in the email
*/
void email(unsigned sys, char *fname, unsigned from_sys, unsigned from_user)
{
  net_header_rec h;
  FILE *locmail, *textfile;
  char locpath[90], tf_path[101];
  char *msg, the_time[101], from_line[101];
  long ll;
  int x;



  sprintf(from_line, "%s\r\n", from);

  time(&ll);
  strcpy(the_time,ctime(&ll));
  the_time[strlen(the_time)-1]=0;      /* remove /n added with ctime */
  strcat(the_time, "\r\n");


  sprintf(tf_path, "%s%s", text_file_dir, fname);
  textfile=fopen(tf_path, "rb");
  if(!textfile)
  {
    sprintf(locpath, "Couldn't email system %d file '%s', file didn't exist", sys, fname);
    ssm(thisboard.sysnum, locpath);
    return;
  }
  fseek(textfile, 0, SEEK_END);
  h.length = ftell(textfile);
  fseek(textfile, 0, SEEK_SET);


  msg=(char *) malloc(h.length+3);
  if(!msg)
  {
    sprintf(locpath, "Couldn't email system %d file '%s', no mem to read file", sys, fname);
    ssm(thisboard.sysnum, locpath);
    fclose(textfile);
    return;
  }

  fread(msg, h.length, 1, textfile);
  msg[h.length]=0;
  ++h.length;
  fclose(textfile);


  h.length += strlen(title) + 1;
  h.length += strlen(from_line);
  h.length += strlen(the_time);



  h.touser = 1;
  if (sys)                      // if sys == 0, it's a local ssm
    h.tosys = sys;
  else
    h.tosys = thisboard.sysnum;
  h.fromsys = from_sys;
  h.fromuser = from_user;
  h.main_type = 2;
  h.daten = now;
  h.method = 0;
  h.list_len = 0;

  if(mail)
  {
    fwrite(&h, sizeof(net_header_rec), 1, mail);

    fwrite(title, strlen(title) + 1, 1, mail);
    fwrite(from_line, strlen(from_line), 1, mail);
    fwrite(the_time, strlen(the_time), 1, mail);
    fwrite(msg, strlen(msg) + 1, 1, mail);
  }

  free(msg);
  return;
}

void read_ini(void)
{
  ini_inforec ini_info;
  int x;

  if(!open_ini_file("1AD.INI", &ini_info))
  {
    amount_pings=0;
    return;
  }

  strcpy(text_file_dir, ".\\");
  read_ini_string(&ini_info, "Main", "Text file directory", text_file_dir, 100);
  x=strlen(text_file_dir);
  if(text_file_dir[x] != '\\' && text_file_dir[x] != '/')
    { text_file_dir[x] = '\\'; text_file_dir[x+1] = 0; }


  strcpy(LOGFILE, "1AD.LOG");
  read_ini_string(&ini_info, "Main", "Logfile", LOGFILE, 100);


  strcpy(from, "Sysop");
  read_ini_string(&ini_info, "Main", "From", from, 100);

  strcpy(title, "Your recent ping");
  read_ini_string(&ini_info, "Main", "Title", title, 100);


  pings = read_ini_indents(&ini_info, "Pings", "Unwanted");
  amount_pings = count_ini_indents(&ini_info, "Pings", "Unwanted");

  ok_systems = read_ini_indents(&ini_info, "Ok systems", "Wanted");
  amount_ok_systems = count_ini_indents(&ini_info, "Ok systems", "Wanted");

  if(ini_info.changes_made)
    write_ini_file(&ini_info);

  free_ini_info(&ini_info);
}


int get_board_info(net_system_list_rec *node,unsigned short sys)
{
  FILE *net;
  char fn[80];
  strcpy(fn,netpath);
  strcat(fn,"bbsdata.net");
  net=fopen(fn,"rb");
  while(fread(node,sizeof(net_system_list_rec),1,net))
    if(node->sysnum == sys)
    {
      fclose(net);
      return 1;
    }
  fclose(net);
  return 0;
}

