/* *******************************************************************

The Oracle SQL Class Library Version 1.0,
Author: Sergei Kuchin
Copyright (C) Mosakin Corp., 1995
This library is free software.  Permission to use, copy,
modify and redistribute the Oracle SQL class library for any
purpose is hereby granted without fee, provided that the
above copyright notice appear in all copies.


******************************************************************* */
#ifndef __SQL_REQ_H
#define __SQL_REQ_H

typedef void (*ERR_HANDLER)(char*);

class SQL{
public:

 static int open(char* Connect);
 static int close(void);

 static void  commit(void);
 static void  roll_back(void);
 static int   exec(char* Stm,int ignore_error=0);
 
 static void set_handler(ERR_HANDLER ahandler){external_handler=ahandler;};
 static ERR_HANDLER get_handler(){return external_handler;};

private:

 static ERR_HANDLER external_handler;
};

class onull{
public:
 onull(){};
 ~onull(){};
};

class SQLStream{
public:

 SQLStream(char* Stm,short BufSize=1);
 ~SQLStream();

 int  eof(void);
 int  is_null(void);
 void flush(void);
 void set_commit(int commit_when_flush=1);
 void commit(void);
 void roll_back(void);

 SQLStream& operator<<(char c);
 SQLStream& operator<<(unsigned char c);
 SQLStream& operator<<(const char* s);
 SQLStream& operator<<(const unsigned char* s);
 SQLStream& operator<<(int n);
 SQLStream& operator<<(unsigned u);
 SQLStream& operator<<(short sh);
 SQLStream& operator<<(long int l);
 SQLStream& operator<<(float f);
 SQLStream& operator<<(double d);
 SQLStream& operator<<(onull n); // write NULL into stream

 SQLStream& operator>>(char& c);
 SQLStream& operator>>(unsigned char& c);
 SQLStream& operator>>(char* s);
 SQLStream& operator>>(unsigned char* s);
 SQLStream& operator>>(int& n);
 SQLStream& operator>>(unsigned& u);
 SQLStream& operator>>(short& sh);
 SQLStream& operator>>(long int& l);
 SQLStream& operator>>(float& f);
 SQLStream& operator>>(double& d);

private:
 int ndx;
};

#endif
