/* *******************************************************************

The Oracle SQL Class Library Version 1.0,
Author: Sergei Kuchin
Copyright (C) Mosakin Corp., 1995
This library is free software.  Permission to use, copy,
modify and redistribute the Oracle SQL class library for any
purpose is hereby granted without fee, provided that the
above copyright notice appear in all copies.


******************************************************************* */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sql_req.h>
#include <sqlpipe.h>

static TBufHead buf_head;
static TBuf buf;
static int inp,outp;
static int fdc[2]; 
static int fds[2];

void default_handler(char* s);

static short connected=0;
static ERR_HANDLER handler=default_handler;
ERR_HANDLER SQL::external_handler=0;
static int timeout_on=0;

static void TimeOut(int p)
{
 if(timeout_on){
  if(SQL::get_handler())(*SQL::get_handler())(SQL_TIME_OUT_MSG);
  exit(1);
 }
} /* TimeOut */

static void SetTimeOut(void)
{timeout_on=1;
 signal(SIGALRM,TimeOut);
 alarm(SQL_TIME_OUT);
} /* SetTimeOut */

static int Read(int inp,void* buf,unsigned nbyte)
{int n;
 SetTimeOut();
 n=read(inp,buf,nbyte);
 timeout_on=0;
 return n;
} /* Read */

static int Write(int inp,void* buf,unsigned nbyte)
{int n;
 SetTimeOut();
 n=write(inp,buf,nbyte);
 timeout_on=0;
 return n;
} /* Read */

static void WrBufHead(short code,short len,short user=0)
{
 buf_head.code=code;
 buf_head.len=len;
 buf_head.user=user;
 Write(outp,&buf_head,sizeof(buf_head));
}

static int RdBufHead(void)
{
 return Read(inp,&buf_head,sizeof(buf_head));
} /* RdBufHead */

static int RdBuf(void)
{
 return Read(inp,buf,buf_head.len);
} /* RdBuf */

static void WrBuf(void)
{
 Write(outp,buf,buf_head.len);
} /* WrBuf */

static int ExecProg(char* path,char* arg,...)
{char **p,*argv[64];
 int i=1,status,rc;
 pid_t ps;
 
 argv[0]=path;
 for(p=&arg;*p;++p)
  argv[i++]=*p;
 argv[i]=0;
 ps=fork();
 if(ps==-1)return -1;
 if(ps>0){
  RdBufHead();
  switch(buf_head.code){
  case cNop:
   return 0;
  case cNotFound:
   return -2;
  case cError:
   RdBuf();
   fprintf(stderr,"%s\n",buf);
   return -1;
  default:
   return -1;
  }
 }else{
  rc=execvp(path,argv);
  if(rc==-1){
   buf_head.code=cNotFound;
   buf_head.len=0;
   Write(fdc[1],&buf_head,sizeof(buf_head));
   _exit(0);
  }
  return -1;
 }
} /* ExecProg */


int SQL::open(char* Connect)
{int rc;
 char fdc0[10];
 char fdc1[10];
 char fds0[10];
 char fds1[10];

 rc=pipe(fdc);
 if(rc==-1)return 1;
 sprintf(fdc0,"%d",fdc[0]);
 sprintf(fdc1,"%d",fdc[1]);
 rc=pipe(fds);
 if(rc==-1)return 1;
 sprintf(fds0,"%d",fds[0]);
 sprintf(fds1,"%d",fds[1]);
 inp=fdc[0];
 outp=fds[1];
 rc=ExecProg("sqlpipe",fds0,fdc1,Connect,(char*)0);
 if(rc!=0){
  if(rc=-2)
    return 2;  
  else
    return 1;
 }
   else{
  connected=1;
  return 0;
 }
}
 
int SQL::close(void)
{
 connected=0;
 WrBufHead(cEnd,0);
 RdBufHead();
 if(buf_head.code==cNop)
  return 0; 
 else
  return 1;
}

void  SQL::commit(void)
{
 WrBufHead(cCommit,0);
 RdBufHead();
 (*handler)(0);
}

void SQL::roll_back(void)
{
 WrBufHead(cRollBack,0);
 RdBufHead();
 (*handler)(0);
}

int SQL::exec(char* Stm,int ignore_error)
{short len=strlen(Stm)+1;
 WrBufHead(cExec,len,ignore_error);
 strcpy(buf,Stm);
 WrBuf();
 RdBufHead();
 (*handler)(0);
 return buf_head.len; 
}

void default_handler(char* s)
{if(!connected)return;
 if(buf_head.code!=cError)
  return;
 RdBuf();
 if(SQL::get_handler())(*SQL::get_handler())(buf);
  exit(1);
} /* default_handler */

SQLStream::SQLStream(char* Stm,short BufSize)
{if(!connected)return;
 int len=strlen(Stm)+1;
 WrBufHead(cOpenStream,len,BufSize);
 strcpy(buf,Stm);
 WrBuf();
 RdBufHead();
 (*handler)(0);
 ndx=buf_head.user;
}

SQLStream::~SQLStream()
{if(!connected)return; 
 WrBufHead(cCloseStream,0,ndx);
 RdBufHead();
 (*handler)(0);
}

int  SQLStream::eof(void)
{if(!connected)return 1;
 WrBufHead(cEof,0,ndx);
 RdBufHead();
 (*handler)(0);
 return buf_head.user; 
}

int SQLStream::is_null(void)
{if(!connected)return 0;
 WrBufHead(cIsNull,0,ndx);
 RdBufHead();
 (*handler)(0);
 return buf_head.user; 
}

void SQLStream::flush(void)
{if(!connected)return;
 WrBufHead(cFlush,0,ndx);
 RdBufHead();
 (*handler)(0);
}

void SQLStream::set_commit(int commit_when_flush)
{if(!connected)return;
 WrBufHead(cSetCommit,commit_when_flush,ndx);
 RdBufHead();
 (*handler)(0);
}


void SQLStream::commit(void)
{
 flush();
 SQL::commit();
}

void SQLStream::roll_back(void)
{
 flush();
 SQL::roll_back();
}


SQLStream& SQLStream::operator<<(char c)
{if(!connected)return *this;
 WrBufHead(cWrChar,1,ndx);
 buf[0]=c;
 WrBuf();
 RdBufHead();
 (*handler)(0);
 return *this; 
}

SQLStream& SQLStream::operator<<(unsigned char c)
{if(!connected)return *this;
 WrBufHead(cWrUChar,1,ndx);
 unsigned char* tmp=(unsigned char*)buf;
 *tmp=c;
 WrBuf();
 RdBufHead();
 (*handler)(0);
 return *this;  
}

SQLStream& SQLStream::operator<<(const char* s)
{if(!connected)return *this;
 int len=strlen(s)+1;
 WrBufHead(cWrStr,len,ndx);
 strcpy(buf,s);
 WrBuf();
 RdBufHead();
 (*handler)(0);
 return *this;  
}

SQLStream& SQLStream::operator<<(const unsigned char* s)
{if(!connected)return *this;
 int len=strlen((char*)s)+1;
 WrBufHead(cWrUStr,len,ndx);
 strcpy(buf,(char*)s);
 WrBuf();
 RdBufHead();
 (*handler)(0);
 return *this;  
}

SQLStream& SQLStream::operator<<(int n)
{if(!connected)return *this;
 WrBufHead(cWrInt,sizeof(int),ndx);
 int* tmp=(int*)buf;
 *tmp=n;
 WrBuf();
 RdBufHead();
 (*handler)(0);
 return *this;  
}

SQLStream& SQLStream::operator<<(unsigned u)
{if(!connected)return *this;
 WrBufHead(cWrUInt,sizeof(unsigned),ndx);
 unsigned* tmp=(unsigned*)buf;
 *tmp=u;
 WrBuf();
 RdBufHead();
 (*handler)(0);
 return *this;  
}

SQLStream& SQLStream::operator<<(short sh)
{if(!connected)return *this;
 WrBufHead(cWrShort,sizeof(short),ndx);
 short* tmp=(short*)buf;
 *tmp=sh;
 WrBuf();
 RdBufHead();
 (*handler)(0);
 return *this;  
}

SQLStream& SQLStream::operator<<(long int l)
{if(!connected)return *this;
 WrBufHead(cWrLongInt,sizeof(long),ndx);
 long* tmp=(long*)buf;
 *tmp=l;
 WrBuf();
 RdBufHead();
 (*handler)(0);
 return *this;  
}

SQLStream& SQLStream::operator<<(float f)
{if(!connected)return *this;
 WrBufHead(cWrFloat,sizeof(float),ndx);
 float* tmp=(float*)buf;
 *tmp=f;
 WrBuf();
 RdBufHead();
 (*handler)(0);
 return *this;  
}

SQLStream& SQLStream::operator<<(double d)
{if(!connected)return *this;
 WrBufHead(cWrDouble,sizeof(double),ndx);
 double* tmp=(double*)buf;
 *tmp=d;
 WrBuf();
 RdBufHead();
 (*handler)(0);
 return *this;  
}

SQLStream& SQLStream::operator<<(onull n)
{if(!connected)return *this;
 WrBufHead(cWrONull,0,ndx);
 RdBufHead();
 (*handler)(0);
 return *this;  
}

SQLStream& SQLStream::operator>>(char& c)
{if(!connected)return *this;
 WrBufHead(cRdChar,0,ndx);
 RdBufHead();
 (*handler)(0);
 RdBuf();
 c=buf[0];
 return *this;  
}

SQLStream& SQLStream::operator>>(unsigned char& c)
{if(!connected)return *this;
 WrBufHead(cRdUChar,0,ndx);
 RdBufHead();
 (*handler)(0);
 RdBuf();
 c=(unsigned char)buf[0];
 return *this;  
}

SQLStream& SQLStream::operator>>(char* s)
{if(!connected)return *this;
 WrBufHead(cRdStr,0,ndx);
 RdBufHead();
 (*handler)(0);
 RdBuf();
 strcpy(s,buf);
 return *this;  
}

SQLStream& SQLStream::operator>>(unsigned char* s)
{if(!connected)return *this;
 WrBufHead(cRdUStr,0,ndx);
 RdBufHead();
 (*handler)(0);
 RdBuf();
 strcpy((char*)s,buf);
 return *this;  
}

SQLStream& SQLStream::operator>>(int& n)
{if(!connected)return *this;
 WrBufHead(cRdInt,0,ndx);
 RdBufHead();
 (*handler)(0);
 RdBuf();
 int* tmp=(int*)buf;
 n=*tmp;
 return *this;  
}

SQLStream& SQLStream::operator>>(unsigned& u)
{if(!connected)return *this;
 WrBufHead(cRdUInt,0,ndx);
 RdBufHead();
 (*handler)(0);
 RdBuf();
 unsigned* tmp=(unsigned*)buf;
 u=*tmp;
 return *this;  
}

SQLStream& SQLStream::operator>>(short& sh)
{if(!connected)return *this;
 WrBufHead(cRdShort,0,ndx);
 RdBufHead();
 (*handler)(0);
 RdBuf();
 short* tmp=(short*)buf;
 sh=*tmp;
 return *this;  
}

SQLStream& SQLStream::operator>>(long int& l)
{if(!connected)return *this;
 WrBufHead(cRdLongInt,0,ndx);
 RdBufHead();
 (*handler)(0);
 RdBuf();
 long* tmp=(long*)buf;
 l=*tmp;
 return *this;  
}

SQLStream& SQLStream::operator>>(float& f)
{if(!connected)return *this;
 WrBufHead(cRdFloat,0,ndx);
 RdBufHead();
 (*handler)(0);
 RdBuf();
 float* tmp=(float*)buf;
 f=*tmp;
 return *this;  
}

SQLStream& SQLStream::operator>>(double& d)
{if(!connected)return *this;
 WrBufHead(cRdDouble,0,ndx);
 RdBufHead();
 (*handler)(0);
 RdBuf();
 double* tmp=(double*)buf;
 d=*tmp;
 return *this;  
}
