/* *******************************************************************

The Oracle SQL Class Library Version 1.0,
Author: Sergei Kuchin
Copyright (C) Mosakin Corp., 1995
This library is free software.  Permission to use, copy,
modify and redistribute the Oracle SQL class library for any
purpose is hereby granted without fee, provided that the
above copyright notice appear in all copies.


******************************************************************* */
extern "C"{
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
}

#include <oscl.h>
#include <sqlpipe.h>


DP(SQL*,db);
int inp,outp;
TBufHead buf_head;
TBuf buf;
int  connect_flag=0;

SQLStream* str_arr[MAX_CURSOR_NUM];

int GetFirstFree(void)
{
 for(int i=0;i<MAX_CURSOR_NUM;++i)
  if(str_arr[i]==0)
   return i;
 return -1;
}

int OpenStream(char* Stm,short BufSize)
{int rc=GetFirstFree();
 if(rc!=-1)
  str_arr[rc]=new SQLStream(db,Stm,BufSize);
 return rc;
}

void CloseStream(int ndx)
{
 delete str_arr[ndx];
 str_arr[ndx]=0;
}

int timeout_on=0;

void TimeOut(int p)
{
 if(timeout_on){
  DELETE(db);
  exit(1);
 }
} /* TimeOut */

void SetTimeOut(void)
{timeout_on=1;
 signal(SIGALRM,TimeOut);
 alarm(SQL_TIME_OUT);
} /* SetTimeOut */

int Read(int inp,void* buf,unsigned nbyte)
{int n=0;
 SetTimeOut();
 n=read(inp,buf,nbyte);
 timeout_on=0;
 return n;
} /* Read */

int Write(int inp,void* buf,unsigned nbyte)
{int n=0;
 SetTimeOut();
 n=write(inp,buf,nbyte);
 timeout_on=0;
 return n;
} /* Write */

void WrBufHead(short code,short len,short user=0)
{
 buf_head.code=code;
 buf_head.len=len;
 buf_head.user=user;
 Write(outp,&buf_head,sizeof(buf_head));
}

int RdBufHead(void)
{
 return Read(inp,&buf_head,sizeof(buf_head));
} /* RdBufHead */

int RdBuf(void)
{
 return Read(inp,buf,buf_head.len);
} /* RdBuf */

void WrBuf(void)
{
 Write(outp,buf,buf_head.len);
} /* WrBuf */

void Process(void)
{
 EX_DISABLE;
 for(;;){
  RdBufHead();
 switch(buf_head.code){
  case cNop:
   break;
  case cEnd:
    WrBufHead(cNop,0);
   return;
  case cCommit:
   db->commit();
   WrBufHead(cNop,0);
   break;
  case cRollBack:
   db->roll_back();
   WrBufHead(cNop,0);
   break;
  case cExec:
   RdBuf();
   db->exec(buf,buf_head.user);
   WrBufHead(cNop,0);   
   break;
  case cOpenStream:
   RdBuf();
   WrBufHead(cNop,0,OpenStream(buf,buf_head.user));
   break;
  case cCloseStream:
   CloseStream(buf_head.user);
   WrBufHead(cNop,0);
   break;
  case cEof:
   WrBufHead(cNop,0,str_arr[buf_head.user]->eof());
   break;
  case cIsNull:
   WrBufHead(cNop,0,str_arr[buf_head.user]->is_null());
   break;
  case cFlush:
   str_arr[buf_head.user]->flush();
   WrBufHead(cNop,0);
   break;
  case cSetCommit:
   str_arr[buf_head.user]->set_commit(buf_head.len);
   WrBufHead(cNop,0);
   break;
  case  cWrChar:
   {
    RdBuf();
    str_arr[buf_head.user]->operator<<(buf[0]);
    WrBufHead(cNop,0);
   }
   break;
  case  cWrUChar:
   {
    RdBuf();
    str_arr[buf_head.user]->operator<<((unsigned char)buf[0]);
    WrBufHead(cNop,0);
   }
   break;
  case  cWrStr:
   {
    RdBuf();
    str_arr[buf_head.user]->operator<<((char*)buf);
    WrBufHead(cNop,0);
   }
   break;
  case  cWrUStr:
   {
    RdBuf();
    str_arr[buf_head.user]->operator<<((unsigned char*)buf);
    WrBufHead(cNop,0);
   }
   break;
  case  cWrInt:
   {
    RdBuf();
    int* tmp=(int*)buf;
    str_arr[buf_head.user]->operator<<(*tmp);
    WrBufHead(cNop,0);
   }
   break;
  case  cWrUInt:
   {
    RdBuf();
    unsigned* tmp=(unsigned*)buf;
    str_arr[buf_head.user]->operator<<(*tmp);
    WrBufHead(cNop,0);
   }
   break;
  case  cWrShort:
   {
    RdBuf();
    short* tmp=(short*)buf;
    str_arr[buf_head.user]->operator<<(*tmp);
    WrBufHead(cNop,0);
   }
   break;
  case  cWrLongInt:
   {
    RdBuf();
    long* tmp=(long*)buf;
    str_arr[buf_head.user]->operator<<(*tmp);
    WrBufHead(cNop,0);
   }
   break;
  case  cWrFloat:
   {
    RdBuf();
    float* tmp=(float*)buf;
    str_arr[buf_head.user]->operator<<(*tmp);
    WrBufHead(cNop,0);
   }
   break;
  case  cWrDouble:
   {
    RdBuf();
    double* tmp=(double*)buf;
    str_arr[buf_head.user]->operator<<(*tmp);
    WrBufHead(cNop,0);
   }
   break;
  case  cWrONull:
   {
    str_arr[buf_head.user]->operator<<(onull());
    WrBufHead(cNop,0);
   }
   break;
  case  cRdChar:
   {
    char c;
    str_arr[buf_head.user]->operator>>(c);
    WrBufHead(cNop,1);
    buf[0]=c;
    WrBuf();
   }
   break;
  case  cRdUChar:
   {
    unsigned char c;
    str_arr[buf_head.user]->operator>>(c);
    WrBufHead(cNop,1);
    unsigned char* tmp=(unsigned char*)buf;
    *tmp=c;
    WrBuf();
   }
   break;
  case  cRdStr:
   {
    char* tmp=(char*)buf;
    str_arr[buf_head.user]->operator>>(tmp);
    WrBufHead(cNop,strlen(tmp)+1);
    WrBuf();
   }
   break;
  case  cRdUStr:
   {
    unsigned char* tmp=(unsigned char*)buf;
    str_arr[buf_head.user]->operator>>(tmp);
    WrBufHead(cNop,strlen((char*)tmp)+1);
    WrBuf();
   }
   break;
  case  cRdInt:
   {
    int* tmp=(int*)buf;
    str_arr[buf_head.user]->operator>>(*tmp);
    WrBufHead(cNop,sizeof(int));
    WrBuf();
   }
   break;
  case  cRdUInt:
   {
    unsigned* tmp=(unsigned*)buf;
    str_arr[buf_head.user]->operator>>(*tmp);
    WrBufHead(cNop,sizeof(unsigned));
    WrBuf();
   }
   break;
  case  cRdShort:
   {
    short* tmp=(short*)buf;
    str_arr[buf_head.user]->operator>>(*tmp);
    WrBufHead(cNop,sizeof(short));
    WrBuf();
   }
   break;
  case  cRdLongInt:
   {
    long* tmp=(long*)buf;
    str_arr[buf_head.user]->operator>>(*tmp);
    WrBufHead(cNop,sizeof(long));
    WrBuf();
   }
   break;
  case  cRdFloat:
   {
    float* tmp=(float*)buf;
    str_arr[buf_head.user]->operator>>(*tmp);
    WrBufHead(cNop,sizeof(float));
    WrBuf();
   }
   break;
  case  cRdDouble:
   {
    double* tmp=(double*)buf;
    str_arr[buf_head.user]->operator>>(*tmp);
    WrBufHead(cNop,sizeof(double));
    WrBuf();
   }
   break;
  }
  if(err::on()){
   EX_ENABLE;
   RAISE1;
  }
 }
} /* Process */

int main(int argc,char* argv[])
{
 inp=atoi(argv[1]);
 outp=atoi(argv[2]);

/* 
 fcntl(inp,O_NDELAY);
 fcntl(outp,O_NDELAY);
*/

EXCEPTION_ENABLE;
BEGIN_TRY
  NEW(db) SQL(argv[3]);
  connect_flag=1;
  WrBufHead(cNop,0);  
  Process();
  DELETE(db);
  return 0;
END_TRY
BEGIN_CATCH
  int len=strlen(SQL::err_msg())+1;
  WrBufHead(cError,len);
  strcpy(buf,SQL::err_msg());
  WrBuf();
EPILOG
  if(connect_flag){
   db->roll_back();
   DELETE(db);
  }
  return 1;
END_CATCH
} /* main */
