/* *******************************************************************

The Oracle SQL Class Library Version 1.0,
Author: Sergei Kuchin
Copyright (C) Mosakin Corp., 1995
This library is free software.  Permission to use, copy,
modify and redistribute the Oracle SQL class library for any
purpose is hereby granted without fee, provided that the
above copyright notice appear in all copies.


******************************************************************* */
// --------------------------- Internal Macros ---------------------------

#define DEFINE_NUM(Prefix,Name,HostVarType,ActualType)           \
  ActualType Name;                                               \
  HostVarType* _##Name;                                          \
  inline HostVarType* ___##Name##Init(void)                      \
   {return _##Name=new HostVarType(Prefix#Name,&Name);}

#define NUM_VECT(Prefix,Name,HostVarType,ActualType,VectSize)    \
  ActualType Name[VectSize];                                     \
  HostVarType* _##Name;                                          \
  inline HostVarType* ___##Name##Init(void)                      \
   {return _##Name=new HostVarType(Prefix#Name,VectSize,Name);}

#define TYPEDEF_NUM_VECT(TypeName,SVectSize,HostVarType,ActualType)\
  const sword ___##TypeName##VectSize=SVectSize;                   \
  typedef ActualType TypeName[___##TypeName##VectSize];            \
  typedef HostVarType _##TypeName;

#ifdef __TEMPLATE_ENABLED__

#define DEFINE_STRING(Prefix,Name,StrSize,CharType)               \
  CharType Name[StrSize];                                         \
  TCChar<StrSize,type_TCChar>* _##Name;                           \
  inline TCChar<StrSize,type_TCChar>* ___##Name##Init(void)       \
   {return _##Name=new TCChar<StrSize,type_TCChar>(Prefix#Name,Name);}


#define STRING_VECT(Prefix,Name,StrSize,VectSize,CharType)			\
  CharType Name[VectSize][StrSize];						\
  TCChar<StrSize,type_TCChar>* _##Name;						\
  inline TCChar<StrSize,type_TCChar>* ___##Name##Init(void)			\
   {return _##Name=new TCChar<StrSize,type_TCChar>(Prefix#Name,VectSize,Name);}

#define TYPEDEF_STR(TypeName,StrSize,CharType)              \
  const sword ___##TypeName##VectSize=1;                    \
  typedef CharType TypeName[StrSize];                       \
  typedef TCChar<StrSize,type_TCChar> _##TypeName;


#define TYPEDEF_STR_VECT(TypeName,StrSize,SVectSize,CharType)    \
  const sword ___##TypeName##VectSize=SVectSize;                 \
  typedef CharType TypeName[___##TypeName##VectSize][StrSize];  \
  typedef TCChar<StrSize,type_TCChar> _##TypeName;

#define  OBJ_OF_TYPE(Type,Prefix,Name)                         \
  Type     Name;                                               \
  _##Type* _##Name;                                            \
  inline _##Type* ___##Name##Init(void)                        \
   {return _##Name=new _##Type(Prefix#Name,___##Type##VectSize,Name);}

#else


#define DEFINE_STRING(Prefix,Name,StrSize,CharType)               \
  CharType Name[StrSize];                                         \
  TCChar* _##Name;                                                \
  inline TCChar* ___##Name##Init(void)                            \
   {return _##Name=new TCChar(Prefix#Name,StrSize,Name);}

#define STRING_VECT(Prefix,Name,StrSize,VectSize,CharType)           \
  CharType Name[VectSize][StrSize];                                  \
  TCChar* _##Name;                                                   \
  inline TCChar* ___##Name##Init(void)                               \
   {return _##Name=new TCChar(Prefix#Name,StrSize,VectSize,Name);}

#define TYPEDEF_STR(TypeName,StrSize,CharType)              \
  const sword ___##TypeName##VectSize=1;                    \
  typedef char TypeName[StrSize];                           \
  DEFINE_STATIC_TCCHAR(_##TypeName,StrSize);


#define TYPEDEF_STR_VECT(TypeName,StrSize,SVectSize,CharType)    \
  const sword ___##TypeName##VectSize=SVectSize;                 \
  typedef CharType TypeName[___##TypeName##VectSize][StrSize];   \
  DEFINE_STATIC_TCCHAR(_##TypeName,StrSize);

#define  OBJ_OF_TYPE(Type,Prefix,Name)                         \
  Type     Name;                                               \
  _##Type* _##Name;                                            \
  inline _##Type* ___##Name##Init(void)                        \
   {return _##Name=new _##Type(Prefix#Name,___##Type##VectSize,Name);}

#endif

#ifdef __BCPLUSPLUS__

#define DEFINE_LONG_STRING(Prefix,Name,StrSize,StrType,TypeCode)  \
  StrType<StrSize,TypeCode>* Name;                                \
  StrType<StrSize,TypeCode>* _##Name;                             \
  inline StrType<StrSize,TypeCode>* ___##Name##Init(void)         \
   {return _##Name=Name=new StrType<StrSize,TypeCode>(Prefix#Name);}

#define TYPEDEF_LONG_STR(TypeName,StrSize,StrType)           \
  const sword ___##TypeName##VectSize=1;                     \
  typedef StrType<StrSize> _##TypeName;                      \
  typedef _##TypeName* TypeName;

#else

#define DEFINE_LONG_STRING(Prefix,Name,StrSize,StrType,TypeCode)  \
  StrType* Name;                                                  \
  StrType* _##Name;                                               \
  inline StrType* ___##Name##Init(void)                           \
   {return _##Name=Name=new StrType(Prefix#Name,StrSize);}

#define TYPEDEF_LONG_STR(TypeName,StrSize,ByteType,type_Id,TypeCode)       \
  const sword ___##TypeName##VectSize=1;                                   \
  STATIC_LONG_STRING_CLASS(_##TypeName,StrSize,ByteType,type_Id,TypeCode); \
  typedef _##TypeName* TypeName;

#endif
