DEFINT A-Z

DECLARE SUB Screen13 ()
DECLARE SUB ScreenEnd ()

    CONST BPORT = &H220  'Base Port address
    CONST XPORT = &H226  'Reset port address
    CONST WPORT = &H22C  'Write port address
    CONST RPORT = &H22A  'Read port address
    CONST APORT = &H22E  'Data Available port address
    
    Screen13

    DIM xx(255), xx3(255)
    
    FOR r = 0 TO 63
            xx(r) = r
            xx(r + 64) = 63 - r
    NEXT

    FOR r = 0 TO 31
            xx3(r) = r * 2
            xx3(r + 32) = (31 - r) * 2
            xx3(r + 128) = r * 2
            xx3(r + 160) = (31 - r) * 2
    NEXT

    FOR r = 0 TO 255
        xx(r) = xx(r) + 20
        xx3(r) = xx3(r) + 20
    NEXT
    
    os1 = 0
    os3 = 0
    x1m = 1
    x3m = -1

    OUT &H3C8, 0
    FOR r = 0 TO 254
        OUT &H3C9, 0
        OUT &H3C9, 0
        OUT &H3C9, 0
    NEXT
    
    DEF SEG = &HA000

    x$ = SPACE$(16000)
    x2$ = SPACE$(16000)

    OUT XPORT, &H1
    FOR r = 1 TO 20: NEXT
    OUT XPORT, &H0
    FOR r = 1 TO 20: NEXT

    c = 1
    ltot = 0
    pa0 = 0     'previous above zero
    ca0 = 0     'current above zero
    lzc = 0
    top = 0
    gon = 0

    bc1 = 1
    bc2 = 32
    bc3 = 1

    
newimag:
    gon = gon + 1
    IF gon = 4 THEN gon = 1
    zc = 0
    at = 0
    tot = 0
    js = 1      'just switched
    rs = 0
    CALL fopen("osc.dat", hand)
    
    goin& = ((gon - 1) * 64000) + 5000
    CALL fseek(hand, goin&)

    CALL fget(hand, x$)
    CALL bcopy(SSEG(x$), SADD(x$), &HA000, 0, 16000, 0)

    CALL fget(hand, x$)
    toadd& = 16000
    CALL bcopy(SSEG(x$), SADD(x$), &HA000, toadd&, 16000, 0)

    CALL fget(hand, x2$)
    toadd& = 32000
    CALL bcopy(SSEG(x2$), SADD(x2$), &HA000, toadd&, 16000, 0)

    CALL fget(hand, x$)
    toadd& = 48000
    CALL bcopy(SSEG(x$), SADD(x$), &HA000, toadd&, 16000, 0)

    CALL fseek(hand, goin& + 16000)
    CALL fget(hand, x$)

    CALL fclose(hand)

    maxzc = 1       'maximum zero count for interactive freq. counter
    tbzc = 0        'times below zero counter - for adaption.

    DO
        OUT WPORT, &H20           'Tell SoundBlaster you wanna read a byte.
        gotit = INP(RPORT)
        IF gotit > 253 OR gotit < 2 THEN top = 63
        gg = (gotit - 128)
        IF gg > 5 THEN ca0 = 1 ELSE IF gg < -5 THEN ca0 = -1
        IF pa0 <> ca0 THEN
            zc = zc + 1
        END IF
        pa0 = ca0

        gg = ABS(gg)
        tot = tot + gg
        at = at + 1
        
        IF at = 320 THEN
            tot = tot \ 512

            tot = (tot + tot + ltot) \ 3
            zc = (zc + zc + lzc) \ 3
            IF zc > maxzc THEN
                maxzc = zc
                tbzc = 0
            ELSEIF zc < (maxzx - 5) THEN
                tbzc = tbzc + 1
                IF tbzc > 25 THEN
                    maxzc = maxzc - 1
                    IF maxzc = 0 THEN maxzc = 1
                    tbzc = 0
                END IF
            END IF
            
            IF zc THEN
                js = 0
                rs = 0
            END IF

            bc1 = bc1 + 1
            bc2 = bc2 + 2
            bc3 = bc3 + 3

            IF (zc = 0 AND js = 0) THEN rs = rs + 1
            IF rs >= 17 THEN GOTO newimag
            
            CALL bcopy(SSEG(x$), SADD(x$), &HA000, 16000, 16000, 0)
            CALL bcopy(SSEG(x2$), SADD(x2$), &HA000, 32000, 16000, 0)

            OUT &H3C8, 0
            top = top - 5
            IF top < 0 THEN top = 0
            OUT &H3C9, top
            OUT &H3C9, top
            OUT &H3C9, top
            FOR r = 1 TO 254
                rr1 = ABS((r + os1) MOD 255)
                rr3 = ABS((r + os3) MOD 255)
                c1 = (((xx(rr1) * zc + 2) \ maxzc) * tot) \ 30
                xx = (maxzc - zc)
                IF xx < 0 THEN xx = 0
                c3 = (((xx3(rr3) * xx + 2) \ maxzc) * tot) \ 30
                IF c1 > 63 THEN c1 = 63 ELSE IF c1 < 0 THEN c1 = 0
                IF c3 > 63 THEN c3 = 63 ELSE IF c3 < 0 THEN c3 = 0
                OUT &H3C9, c1
                OUT &H3C9, 0
                OUT &H3C9, c3
            NEXT
            OUT &H3C9, bc1
            OUT &H3C9, bc2
            OUT &H3C9, bc3
            
            os1 = os1 + x1m
            os3 = os3 + x3m

            zc = 0
            at = 0
            tot = 0
        END IF
        gotit = gotit + 150
        POKE ((gotit \ 3) * 320 + at), 255
    LOOP UNTIL INP(&H60) = 1    'esc pressed

    ScreenEnd
    END

