/* Compile (if needed) and run a Java application      */
/*                                                     */
/* use as:  RUN hello                                  */
/*                                                     */
/*   which will use JAVAC to compile hello.java        */
/*   then use JAVA to interpret HELLO.CLASS            */
/*                                                     */
/* Extra flags:                                        */
/*                                                     */
/*   -debug  = run debug version, under IPMD           */
/*   -debugc = run compiler debug version, under IPMD  */
/*   -noisy  = turn on -diag, -verbosegc, and -verbose */
/*   -nogc   = turn on -noasyncgc during run           */
/*                                                     */
parse arg args
w=wordpos('-debug', args)
if w>0 then do; debug=1;  args=delword(args,w,1); end; else debug=0;
w=wordpos('-debugc', args)
if w>0 then do; debugc=1; args=delword(args,w,1); end; else debugc=0;
w=wordpos('-noisy', args)
if w>0 then do; noisy=1;  args=delword(args,w,1); end; else noisy=0
w=wordpos('-nogc', args)
if w>0 then do; nogc=1;   args=delword(args,w,1); end; else nogc=0

parse var args file args

file=filespec('n', file)
parse var file fn '.' fe

fsource=fn'.java'
fclass =fn'.class'

numeric digits 20

/* ----- Compile step ----- */
if filedate(fclass)>filedate(fsource) then rc=0  /* no compile needed */
 else do
   if debugc then do; deb='_g'; start='ipmd'; end /* better run inline */
             else do; deb=''  ; start=''    ; end
   javacopts='-ms4m -verbosegc'
   if noisy then javacopts=javacopts '-diag -ms2m -verbose -verbosegc -noasyncgc'
   javacclass='java.tools.javac.Main'
   start 'java'deb javacopts javacclass fsource
   end

/* ----- Run step ----- */
if rc=0 then do
  if debug then do; deb='_g'; start='start ipmd'; end
           else do; deb=''  ; start=''          ; end
  opts=''
  if noisy then opts=opts '-diag -ms1m -verbosegc -verbose -noasyncgc'
   else if nogc  then opts='-noasyncgc'
  start 'java'deb opts fn args
  end

if rc<>0 then say '+++ RC='rc '+++'
exit rc


/* Filedate as all-digits */
filedate: procedure
  arg file
  if stream(file, 'c', 'query exists')='' then return 0
  '@dir' file '/n | rxqueue'
  do queued()
    pull date time . . name
    parse var date day'-'mon'-'year
    if year='' then iterate
    parse var time h':' +1 m +2 ampm
    select
      when ampm='P' then do
        if h<>12 then h=h+12
        end
      when ampm='A' then do
        if h=12 then h=0
        end
      otherwise say '*** Bad am/pm "'ampm'" ***'
      end
    day=right(day,2,0); h=right(h,2,0)
    value=year''mon''day''h''m
    end
  /* say 'FD of' file 'is' value */
  return value
