/*  Installation of OS/2-Commander v1.03  */

'@Echo Off'

/* REXXUTIL laden */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisieren */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say '   Installation of OS/2-Commander v1.03...'
Say ''


/* Which language */

Say 'Install (E)nglish or (G)erman language version?'
Pull YesNo
If YesNo = "G" Then
   Do
     Language = 'DEUTSCH'
   End
Else
   Do
     Language = 'OS2COM'
   End
Say ''

If Language = 'DEUTSCH' Then
  Do
    Say 'Mchten Sie ein Icon auf dem Desktop erstellen? (J/N)'
  End
Else
  Do
    Say 'Do you wish to create an icon on the desktop? (Y/N)'
  End

Pull YesNo
If YesNo = "Y" Then
  Do
    Icon = 1
    Say 'Object will be placed on the desktop.'
  End
Else If YesNo = "J" Then
  Do
    Icon = 1
    Say 'Das Icon wird auf dem Desktop erstellt.'
  End
Else
  Do
    Icon = 0
  End
Say ''


/* Check for the files */

Result = SysFileTree( 'OS2COM.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: OS2COM.EXE not found!'
  Signal DONE
  End

Result = SysFileTree( Language".MSG", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: 'Language'.MSG not found!'
  Signal DONE
  End

Result = SysFileTree( Language".INI", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: 'Language'.INI not found!'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Error: 'Language'.HLP not found!'
  Signal DONE
  End

/* Get target directory */

If Language = 'DEUTSCH' Then
  Do
    Say 'Bitte geben Sie den vollen Verzeichnisnamen ein, wohin der'
    Say '  OS/2-Commander installiert werden soll (Standard: C:\OS2COM): '
  End
Else
  Do
    Say 'Please enter the full name of the directory to which you want'
    Say '  to install The OS/2-Commander (default C:\OS2COM): '
  End

Pull Directory
If Directory = "" Then Directory = 'C:\OS2COM'
Say ''

/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEHLER: Kann das Zielverzeichnis nicht anlegen.'
    Say 'ERROR: Unable to create target directory.'
    Signal DONE
    End
  End
Say '';


/* Do the installation */

Say 'Installing The OS/2-Commander to ' Directory '...'
Copy OS2Com.EXE Directory		   '1>NUL'
Copy Language".MSG" Directory"\OS2Com.MSG" '1>NUL'
Copy Language".HLP" Directory"\OS2Com.HLP" '1>NUL'
Copy Language".INI" Directory"\OS2Com.INI" '1>NUL'
Copy Language".INF" Directory              '1>NUL'

Copy "OS2Com.MNU" Directory"\OS2Com.MNU" '1>NUL'
Copy "support.bbs" Directory"\support.bbs" '1>NUL'
Copy "register.*" Directory"\register.*" '1>NUL'
Copy "wcd.txt" Directory                 '1>NUL'

Result = SysFileTree( "OS2C.CMD", 'Files', 'F' )
If Files.0 > 0 Then
  Do
   Copy "OS2C.CMD" Directory"\OS2C.CMD"    '1>NUL'
  End

Result = SysFileTree( "OS2COM.ICO", 'Files', 'F' )
If Files.0 > 0 Then
  Do
   Copy "OS2COM.ICO" Directory"\OS2COM.ICO"  '1>NUL'
  End


If Icon = 1 Then
  Do
   Say 'creating icon...'
   Folder = '<WP_DESKTOP>'
   Type = 'WPProgram'
   Title = 'OS/2-Commander'
   Parms = 'MINWIN=DESKTOP;PROGTYPE=WP;EXENAME='Directory'\OS2Com.EXE;STARTUPDIR='Directory';OBJECTID=<OS/2-Commander>;NOPRINT=YES;'
   Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

   If Result = 1 Then
     Say 'Icon created!  Done.'
   Else
     Say 'Error: Icon not created!'
  End

Say ''

If Language = 'DEUTSCH' Then
  Do
    Say 'Sie knnen das Handbuch mit VIEW DEUTSCH.INF lesen.'
  End
Else
  Do
    Say 'You can read the manual with VIEW OS2COM.INF.'
  End

Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
