/* 


	provadlg.cpp (emx+gcc) 

	1995 Giovanni Iachello
	This is freeware software. You can use or modify it as you wish,
	provided that the part of code that I wrote remains freeware.
	Freeware means that the source code must be available on request 
	to anyone.
	You must also include this notice in all files derived from this
	file.


*/

#include <stdio.h>
#include <string.h>
#define INCL_WIN
#include "pmwin.h"
#include "pmdlg.h"
#include "pmgpi.h"
#include "pmhelp.h"
#include "pmstdres.h"
#include "provadlg.h"

PMApp* App;

PMHelpWin *helpwin;

/////////////////////////////////////////////////////////////////////////////

BOOL helpHook ( HAB habAnchor, SHORT sMode, USHORT usTopic, USHORT usSubTopic, PRECTL prclPos )
{
	if ( (sMode == HLPM_WINDOW ) && helpwin ) {
		helpwin->sendMsg(HM_DISPLAY_HELP, 
			MPFROMLONG (MAKELONG (usTopic, 0)), MPFROMSHORT( HM_RESOURCEID) );
		return TRUE;
	} 
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////

class NamesDialog : public PMModalDialog {
public:
	NamesDialog(HWND parent,HWND owner,ULONG id,PMControlMap* cm,void* obj) :
		PMModalDialog(parent,owner,id,cm,obj) {};
	BOOL initdlg() {
		char buf[64];
		PMListBox* lb=(PMListBox*)controlFromID(DNAME_LB_NAMELIST);
		lb->insertItem(LIT_END,"Mario");
		lb->insertItem(LIT_END,"Luca");
		lb->insertItem(LIT_END,"Piero");
		lb->insertItem(LIT_END,"Marco");
		lb->insertItem(LIT_END,"Giovanni");
		ab.loadString( STR_PAOLA, 64, buf);
		lb->insertItem( LIT_END, buf);
		ab.loadString( STR_CHIARA, 64, buf);
		lb->insertItem( LIT_END, buf);
		ab.loadString( STR_SILVIA, 64, buf);
		lb->insertItem( LIT_END, buf);
		return TRUE;
	}		
	BOOL control(SHORT id,SHORT ctrlmsg) {
		switch (id) {
		case DNAME_LB_NAMELIST:
			switch (ctrlmsg) {
				case LN_SELECT: 
					char buf[64];
					SHORT sIndex;

					PMListBox* ctl=(PMListBox*)controlFromID(DNAME_LB_NAMELIST);

					sIndex=ctl->querySelection();
					ctl->queryItemText(sIndex,buf,64);
					
					controlFromID(DNAME_EF_NAME)->setText(buf);
  	        		return TRUE;
				case LN_ENTER:                                              // @10
					postMsg(WM_COMMAND,MPFROMSHORT(DID_OK),0);
					return TRUE;
			} /* endswitch */
		} /* endswitch */
		return FALSE;
	}		 
};

class PMPrintThread : public PMWindowThread {
public:
	PMPrintThread() : PMWindowThread() {
	}
	void main(void* arg=NULL) {
		PMPrinterDC printer(hab);
		printer.open();
		printer.startDoc("docdiprova");

		PMPresSpace *ptr=new PMPresSpace(&printer,0,0,PU_LOMETRIC|PU_LOENGLISH|GPIF_DEFAULT|GPIT_NORMAL|GPIA_ASSOC,hab);
		PMPoint points[4]={ PMPoint(0,0), PMPoint(900,0), PMPoint(0,900), PMPoint(900,900) };
    	ptr->move(&points[0]);
    	ptr->line(&points[1]);
    	ptr->line(&points[2]);
    	ptr->line(&points[3]);
    	ptr->line(&points[0]);

		delete ptr;
		printer.endDoc("docdiprova");
	}
};

class Pippo : public PMMainWin {
	struct pluto {
		int lbsel;
		char nome[64];
	} temp;
public:
	Pippo(HAB ab,PMHelpWin* hw) : PMMainWin("pippo.child",ab,hw) {
		createArgs->flCreateFlags|=FCF_MENU|FCF_ICON|FCF_ACCELTABLE;
		createArgs->idResources=ID_PROVADLG;
		createArgs->pszTitle="Pippo";
		strcpy(temp.nome,"Collo");
		temp.lbsel=1;
	} ;
	BOOL paint(PMPresSpace& ps)
	{
		char buf[100];
		sprintf( buf, "ProvaDlg main window '%s'", temp.nome);
		PMRect rcl;
		rcl=this;
      	ps.setColor (CLR_DARKCYAN);
      	ps.drawText (-1, buf, &rcl, 0, 0, DT_TEXTATTRS | DT_CENTER | DT_VCENTER | DT_ERASERECT);
		return TRUE;
	}
	BOOL command(USHORT id,USHORT cmddev)
	{
		switch (id) {
	        case IDM_CRASH: {
/*				PMControlMap plutocm[] ={
					cmListBox(DNAME_LB_NAMELIST , pluto,lbsel)
					cmEntryField(DNAME_EF_NAME,pluto,nome)
					cmEnd(DNAME_EF_NAME)
				};
				NamesDialog mio(HWND_DESKTOP,hwnd,DLG_NAME,plutocm,&temp);*/

				PMControlMap esempio1cm[] ={
					cmEntryField(D1_NOME,pluto,nome)
					cmEnd(D1_NOME)
				};
				PMModalDialog mio(HWND_DESKTOP,hwnd,DLG_ESEMPIO1,esempio1cm,&temp);
				int ret=mio.createWin(); // run dialog
				if (ret) invalidate(TRUE);
				return TRUE;
			}
    	    case IDM_FONTS:	{
				FONTMETRICS fm;
				PMWindowPresSpace ps(this);
				ps.queryFontMetrics(&fm);
				PMFontDialog fd(HWND_DESKTOP,hwnd, &fm,0,"Titolo","Preview");
				int ret=fd.createWin();
				assert(ret);
				FONTDLG fi=fd;
				msgBox("Result","%d %s %ld %hd %hd %hd %hd",ret,fi.pszFamilyname,fi.fxPointSize,fi.usWeight,fi.usWidth,fi.x,fi.y);
				return TRUE;
			}
		}		
		return PMMainWin::command(id,cmddev);
	}
/*	BOOL kbd(PMEvent& event) {
		char buf[160];
		sprintf(buf,"fs: %u  repeat: %u   scan: %u  chr: %u  vkey: %u",
			event.charmsg->fs,event.charmsg->cRepeat,event.charmsg->scancode,
			event.charmsg->chr,event.charmsg->vkey);
		WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,buf,"KEYBOARDHIT",0,MB_OK);
		return TRUE;
	}*/
	BOOL fileOpen(PCSZ filename) {
		char buf[200];
		msgBox("Result","%s ",filename);
		
		return TRUE;
	}
	BOOL filePrint() {
		new PMPrintThread;
		return TRUE;
	}
	BOOL helpmsg(PMEvent &event)
	{
		if (event.msg==HM_QUERY_KEYS_HELP) {
			event.ret=MRFROMSHORT(HLP_PROVADLG_KEYS); 
			return TRUE;
		}
		return FALSE;
	}
	BOOL help(PMEvent &event)
	{
		return FALSE;
	}
	
};


int main (int argc,char* argv[])
{
	PMAnchorBlock ab;
	PMMessageQueue mq;
	ab.init();
	mq.create(ab);
	
	App=new PMApp(ab,mq,argc,argv);

	helpwin=new PMHelpWin("Prova Dlg Sample Help File","provadlg.hlp",ID_PROVADLG,ab);
	helpwin->createWin();

	Pippo * pip=new Pippo(ab,helpwin);
	pip->createWin();

	ab.setHook(mq,HK_HELP,(PFN)helpHook,NULLHANDLE);
	
	App->run();

	ab.releaseHook(mq,HK_HELP,(PFN)helpHook,NULLHANDLE);

	pip->destroyWin();

	delete helpwin;

	mq.destroy();
	ab.uninit();

	return (0);
}

/*
 * Local variables:
 * compile-command: "dmake provadlg.exe"
 * end:
 */
