/* 


	pmwin.cpp (emx+gcc) 

	1995 Giovanni Iachello
	This is freeware software. You can use or modify it as you wish,
	provided that the part of code that I wrote remains freeware.
	Freeware means that the source code must be available on request 
	to anyone.
	You must also include this notice in all files derived from this
	file.


*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "pmwin.h"
#include "pmgpi.h"
#include "pmdlg.h"
#include "pmhelp.h"
#include "pmstdres.h"


MRESULT PMWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
	PMWin* win=NULL;

	win = (PMWin*)WinQueryWindowPtr(hwnd, 0);

	if (win) {
		PMEvent event(msg,mp1,mp2,CHARMSG(&msg),MOUSEMSG(&msg));
		MRESULT ret=win->msgProc(event);
		if (msg==WM_DESTROY) delete win; // cancella l'oggetto se viene distrutta la finestra.
		return ret;
	}
	return WinDefWindowProc(hwnd,msg,mp1,mp2);
}


/////////////////////////////////////////////////////////////////////////////

PMWin::PMWin(HAB iab)
{
	ab.PMAnchorBlock(iab);
	createArgs=NULL;
	hwnd=(HWND)0;
	hwndFrame=(HWND)0;
	oldproc=WinDefWindowProc; // per sicurezza
}

PMWin::PMWin(PCSZ classname,HAB iab)
{
	ab.PMAnchorBlock(iab);
	createArgs=new WINCREATEARGS;
	hwnd=(HWND)0;
	hwndFrame=(HWND)0;
	oldproc=WinDefWindowProc; // per sicurezza
	
	createArgs->hwndParent=HWND_DESKTOP;
	createArgs->flStyle= WS_VISIBLE;
    createArgs->flCreateFlags=(FCF_TITLEBAR | FCF_SYSMENU |
                  FCF_SIZEBORDER | FCF_MINMAX |
                  FCF_SHELLPOSITION | FCF_TASKLIST);
    createArgs->pszClientClass=classname;
    createArgs->pszTitle=NULL;
    createArgs->styleClient=0L;
    createArgs->hmod=(HMODULE)0;
    createArgs->idResources=0;
    createArgs->phwndClient=&hwnd;

    createArgs->hab=iab;
    createArgs->pszClassName=classname;
    createArgs->pfnWndProc=PMWndProc;
    createArgs->flClassStyle=CS_SIZEREDRAW;
    createArgs->cbWindowData=sizeof(this);
}

PMWin::~PMWin()
{
	delete createArgs;
}

BOOL PMWin::createWin()
{
	HWND newhwnd;

	CLASSINFO temp;
	if (!WinQueryClassInfo(ab,createArgs->pszClassName,&temp)) {
		BOOL ret=WinRegisterClass (createArgs->hab, createArgs->pszClassName, 
			createArgs->pfnWndProc,createArgs->flClassStyle, createArgs->cbWindowData);
		assert(ret);
	}
	
	oldproc=WinDefWindowProc;
	
	newhwnd = WinCreateStdWindow (createArgs->hwndParent,createArgs->flStyle,
				&createArgs->flCreateFlags,createArgs->pszClientClass,
				createArgs->pszTitle,createArgs->styleClient,createArgs->hmod, 
				createArgs->idResources,createArgs->phwndClient);
	assert(newhwnd);
	hwndFrame=newhwnd;
	BOOL ret=WinSetWindowPtr(hwnd, 0, this);
	assert(ret);
	return hwnd;
}

MRESULT PMWin::msgProc(PMEvent &event)
{
	event.ret=MRFROMSHORT(FALSE);
	return dispachEvent(event) ? event.ret : (*oldproc)(hwnd,event.msg,event.mp1,event.mp2);
}

BOOL PMWin::dispachEvent(PMEvent & event)
{
	if ((event.msg>=WM_MOUSEFIRST && event.msg<=WM_MOUSELAST) ||
			(event.msg>=WM_EXTMOUSEFIRST && event.msg<=WM_EXTMOUSELAST) ) {
		return mouse(event);
	} else if (event.msg>=HM_MSG_BASE && event.msg<=HM_CONTROL) {
		return helpmsg(event);
	} else
		switch (event.msg) {
		case WM_CREATE:
			return create(event);
		case WM_CHAR: 
			return kbd(event);
		case WM_COMMAND:
			return command(SHORT1FROMMP (event.mp1),SHORT2FROMMP (event.mp2));
		case WM_PAINT:
			return paint();
		case WM_ENABLE:
			return enable();
		case WM_SHOW:
			return show();
		case WM_MOVE:
			return move();
		case WM_SIZE:
			return size(SHORT1FROMMP (event.mp2),SHORT2FROMMP (event.mp2));
		case WM_ACTIVATE:
			return activate();
		case WM_SETFOCUS:
			return setfocus();
		case WM_HELP:
			return help(event);
		case WM_TIMER:
			return timer();
		case WM_CLOSE:
			return closed();
		case WM_PRESPARAMCHANGED:
			invalidate(TRUE);
			return TRUE;
		case WM_INITMENU:
			PMMenu* menu=new PMMenu(HWNDFROMMP(event.mp2));
			return initmenu(SHORT1FROMMP(event.mp1),menu);
			delete menu;
		}		   	
	return other(event);
}

BOOL PMWin::create(PMEvent &event)
{
	return FALSE;
}

BOOL PMWin::command(USHORT id,USHORT cmddev)  // nothandled
{
	return FALSE;
}

BOOL PMWin::paint()
{
	return FALSE;
}

BOOL PMWin::kbd(PMEvent &event)
{
	return FALSE;
}

BOOL PMWin::mouse(PMEvent &event)
{
	return FALSE;
}

BOOL PMWin::enable()
{
	return FALSE;
}
BOOL PMWin::show()	
{
	return FALSE;
}
BOOL PMWin::move()
{
	return FALSE;
}
BOOL PMWin::size(SHORT,SHORT)
{
	return FALSE;
}
BOOL PMWin::activate()
{
	return FALSE;
}
BOOL PMWin::setfocus()
{
	return FALSE;
}
BOOL PMWin::help(PMEvent &)
{
	return FALSE;
}
BOOL PMWin::helpmsg(PMEvent &)
{
	return FALSE;
}

BOOL PMWin::timer()
{
	return FALSE;
}
BOOL PMWin::closed()
{
	return FALSE;
}

BOOL PMWin::other(PMEvent &event)
{
	return FALSE;
}

MRESULT PMWin::close() 
{ 
	return sendMsg(WM_CLOSE); 
}

BOOL PMWin::destroyWin()
{
	return WinDestroyWindow(hwndFrame);
}

BOOL PMWin::initmenu(SHORT id,PMMenu* menu)
{
	return FALSE;
}


/////////////////////////////////////////////////////////////////////////////

BOOL PMWin::ptInClient(PMPoint& pt)
{
	PMRect rcl;
	rcl=this;
	return WinPtInRect (ab, &rcl, &pt);
}

/////////////////////////////////////////////////////////////////////////////

PMMessageQueue::PMMessageQueue()
{
	hmq=0;
}

PMAnchorBlock::PMAnchorBlock()
{
	hab=0;
}

PMAnchorBlock::~PMAnchorBlock()
{
}

void PMAnchorBlock::init(int flags)
{
	hab = WinInitialize(flags);
}

void PMAnchorBlock::uninit(void)
{
	WinTerminate(hab);
}


PMApp::PMApp(PMAnchorBlock iab,PMMessageQueue imq,int iargc,char** iargv)
{
	ab=iab; 
	mq=imq;
	argc=iargc;
	argv=iargv;
}

void PMApp::quit(int ret)
{
}

void PMApp::run(void)
{
	QMSG qmsg;
	while ( ab.getMsg( &qmsg ) ) 
		ab.dispachMsg ( &qmsg );
}

/////////////////////////////////////////////////////////////////////////////

PMMainWin::PMMainWin(PCSZ classname,HAB ab,PMHelpWin *ihelpWin) : PMWin(classname,ab) 
{ 
	helpWin=ihelpWin;
	caption=NULL;
	modified=FALSE;
	filename[0]='\0';
	fileFlags=PMMWFF_NOTHING;
	fileNone="(none)"; fileUntitled="(untitled)";
	flCaption=fsCaption=fnFilter=NULL;
}

// supporto per help inline (usa tutto create della classe base, e aggiunge
// l'associazione automatica alla finestra di help!)

BOOL PMMainWin::createWin()
{
	BOOL ret;
	ret=PMWin::createWin();
	if (helpWin) ret&=associateHelpInstance(helpWin->getHwnd());
	return ret;
}

BOOL PMMainWin::destroyWin()
{
	BOOL ret;
	if (helpWin) {
		ret=associateHelpInstance(NULLHANDLE);
		ret&=PMWin::destroyWin();
	} else ret=PMWin::destroyWin();
	return ret;
}

BOOL PMMainWin::paint() 
{
	PMWindowPresSpace ps(this);
	return paint(ps);
}

BOOL PMMainWin::closed()
{
	if (queryEnd()) postMsg(WM_QUIT);
	return TRUE;
}

BOOL PMMainWin::fileKillConfirm()
{
	if (!modified) return TRUE;
	char buf[160];
	strcpy(buf,"Save Changes");
	if (fileFlags==PMMWFF_FILE) {
		strcat(buf," to ");
		strcat(buf,filename);
	}
	strcat(buf,"?");
	int ret=WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,(PCSZ)buf,(PCSZ)caption,0,MB_YESNOCANCEL|MB_ICONHAND|MB_APPLMODAL);
	if (ret==MBID_YES) command(PMIDM_FILESAVE,0);
	if (ret==MBID_CANCEL) return FALSE;
	return TRUE;		
}


void PMMainWin::setTitleCaption()
{
	char temp[256];
	if (caption==NULL) temp[0]='\0';
	else {
		switch (fileFlags) {
		case PMMWFF_NOTHING:
			sprintf(temp,"%s",caption);
			break;
		case PMMWFF_NONE:
			if (modified)
				sprintf(temp,"%s - *%s",caption,fileNone);
			else
				sprintf(temp,"%s - %s",caption,fileNone);
			break;
		case PMMWFF_UNTITLED:
			if (modified)
				sprintf(temp,"%s - *%s",caption,fileUntitled);
			else
				sprintf(temp,"%s - %s",caption,fileUntitled);
			break;
		case PMMWFF_FILE:
			if (modified)
				sprintf(temp,"%s - *%s",caption,filename);
			else
				sprintf(temp,"%s - %s",caption,filename);
			break;
		}
	}
	setFrameWindowText(temp);
}

BOOL PMMainWin::command(USHORT id,USHORT cmddev)
{
	switch(id) {
	case PMIDM_FILENEW:
		if (fileKillConfirm()) {
			if (fileNew()) { fileFlags=PMMWFF_UNTITLED; setModified(FALSE);	}
		}
		return TRUE;
	case PMIDM_FILEOPEN: {
		if (fileKillConfirm()) {
			PMFileDialog fd(HWND_DESKTOP, hwnd, fnFilter, flCaption, "Open", FDS_OPEN_DIALOG);
			int ret=fd.createWin();
			if (ret==1) {
				FILEDLG fi=fd;
				if (fileOpen(fi.szFullFile)) { // se caricato cambia il filename
	  	  			strcpy(filename,fi.szFullFile);
					fileFlags=PMMWFF_FILE;
				}
				setModified(FALSE);
			}
		}
		return TRUE;
		}	
	case PMIDM_FILESAVE: 
		if (filename[0]) { // se c'e' filename salva con quello
			fileSave(filename);
			setModified(FALSE);
			return TRUE;
		} // altrimenti ricadi in save as
	case PMIDM_FILESAVEAS: {
		PMFileDialog fd(HWND_DESKTOP, hwnd, fnFilter, fsCaption, "Save", FDS_SAVEAS_DIALOG);
		int ret=fd.createWin();
		if (ret==1) {
			FILEDLG fi=fd;
			if (fileSave(fi.szFullFile)) { // se caricato cambia il filename
				strcpy(filename,fi.szFullFile);
				fileFlags=PMMWFF_FILE;
			}
			setModified(FALSE);
		}
		return TRUE;
		}	
	case PMIDM_FILEPRINT :
		filePrint();
		return TRUE;
	case PMIDM_FILEEXIT :
		close();
		return TRUE;

	case PMIDM_EDITUNDO :
		editUndo();
		return TRUE;
	case PMIDM_EDITREDO :
		editRedo();
		return TRUE;
	case PMIDM_EDITCUT :
		editCut();
		return TRUE;
	case PMIDM_EDITCOPY :
		editCopy();
		return TRUE;
	case PMIDM_EDITPASTE:
		editPaste();
		return TRUE;
	case PMIDM_EDITCLEAR:
		editClear();
		return TRUE;
	case PMIDM_EDITDUPLICATE :
	case PMIDM_EDITSELECTALL :
		return FALSE;

	case PMIDM_HELPINDEX :
		helpWin->sendMsg(HM_HELP_INDEX);
		return TRUE;
	case PMIDM_HELPGENERAL :
		helpWin->sendMsg(HM_EXT_HELP);
		return TRUE;
	case PMIDM_HELPUSING :
		helpWin->sendMsg(HM_DISPLAY_HELP);
		return TRUE;
	case PMIDM_HELPKEYS :
		helpWin->sendMsg(HM_KEYS_HELP);
		return TRUE;

	case PMIDM_HELPABOUT :
        WinDlgBox(HWND_DESKTOP,hwnd,(PFNWP)PMDlgProc,NULLHANDLE,PMDLG_ABOUT,NULL);
		return TRUE;

	}
	return FALSE;
}


/////////////////////////////////////////////////////////////////////////////

static MRESULT PMSubclassWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
	PMWin* win=NULL;

	win = (PMWin*)WinQueryWindowPtr(hwnd, 0);

	if (win) {
		PMEvent event(msg,mp1,mp2,CHARMSG(&msg),MOUSEMSG(&msg));
		MRESULT ret=win->msgProc(event);
		if (msg==WM_DESTROY) delete win; // cancella l'oggetto se viene distrutta la finestra.
		return ret;
	}
	return WinDefWindowProc(hwnd,msg,mp1,mp2);
}

PMSubclassWin::PMSubclassWin(HWND hwndParent, PCSZ pszClass, PCSZ pszName,
    ULONG flStyle, LONG x, LONG y, LONG cx, LONG cy, HWND hwndOwner,
   	HWND hwndInsertBehind, ULONG id, PVOID pCtlData, PVOID pPresParams) : PMWin(NULLHANDLE)
{
	createArgs=new WINCREATEARGS;
	
	createArgs->hwndParent=hwndParent;
    createArgs->pszClientClass=pszClass;
    createArgs->pszTitle=pszName;
	createArgs->flStyle=flStyle;
    createArgs->x=x;
    createArgs->y=y;
    createArgs->cx=cx;
    createArgs->cy=cy;
	createArgs->hwndOwner=hwndOwner;
    createArgs->hwndInsertBehind=hwndInsertBehind;
    createArgs->id=id;
    createArgs->pCtlData=pCtlData;
    createArgs->pPresParams=pPresParams;
    
}

PMSubclassWin::~PMSubclassWin()
{
//	delete createArgs;
}

BOOL PMSubclassWin::createWin()
{
	hwnd=WinCreateWindow(createArgs->hwndParent,
						createArgs->pszClientClass,
						createArgs->pszTitle,
						createArgs->flStyle,
						createArgs->x, createArgs->y,
						createArgs->cx, createArgs->cy,
						createArgs->hwndParent,
						createArgs->hwndInsertBehind,
						createArgs->id,
						createArgs->pCtlData,
						createArgs->pPresParams);
	BOOL ret=WinSetWindowPtr(hwnd, 0, this);
	assert(ret);
	ab.PMAnchorBlock( WinQueryAnchorBlock(hwnd) );
	oldproc=WinSubclassWindow(hwnd,PMSubclassWndProc);
	return hwnd;
}


/////////////////////////////////////////////////////////////////////////////

PMThread::PMThread(void* iarg,int istacksize)
{
	arg=iarg;
	stacksize=istacksize;
	id=_beginthread(threadstart,NULL,stacksize,(void*)this);
}

PMThread::~PMThread()
{
}

void threadstart(void* arg)
{
	PMThread* pmt=(PMThread*)arg;
	pmt->threadStore(NULL);        // annulla il puntatore

	pmt->main(pmt->arg);

	delete pmt->threadStore();     // elimina la zona di memoria del thread
	delete pmt;
	_endthread();
}

void PMThread::threadStore(void *p)
{
	(*_threadstore())=p;	
}

void* PMThread::threadStore()
{
	return *_threadstore();
}

void PMThread::main(void* )
{
}

PMWindowThread::PMWindowThread(void* iarg,int istacksize,int iflags) : 
	PMThread(iarg,istacksize), PMAnchorBlock() 
{
	flags=iflags;
	init(flags);
}

PMWindowThread::~PMWindowThread()
{
}

void PMWindowThread::main(void* arg)
{
}

/////////////////////////////////////////////////////////////////////////////

void DoAssert(PCSZ msg,PCSZ file,unsigned line)
{
	char buf[160];
	sprintf(buf,"at line %u in file %s: \"%s\"",line,file,msg);
	if (WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,buf,"ASSERTION FAILURE",0,MB_OKCANCEL|MB_ICONHAND|MB_APPLMODAL)!=MBID_OK) exit(-1);
}

void ErrBox(PCSZ msg,...)
{
	char buf[256];

	va_list arg_ptr;
	va_start(arg_ptr,msg);
	vsprintf(buf,msg,arg_ptr);
	va_end(arg_ptr);

	WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,msg,"Error!",0,MB_CUACRITICAL|MB_APPLMODAL);
}

ULONG PMWin::msgBox(PCSZ title,PCSZ msg,...)
{
	char buf[256];

	va_list arg_ptr;
	va_start(arg_ptr,msg);
	vsprintf(buf,msg,arg_ptr);
	va_end(arg_ptr);
	
	return WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,buf,title,0,MB_OK);
}

/*
 * Local variables:
 * compile-command: "dmake pmwin.o"
 * end:
 */
