#include "xheaders.h"

#include XWindow_i
#include XString_i
#include XRect_i
#include XColor_i
#include XHandler_i
#include XPoint_i

#include <stdio.h>
#include <stdlib.h>

/*DOC
CLASS XWindow
FUNCTION DoControl
GROUP user input
REMARKS If the user has done some interaction with a window this function is called.
To get information about the event, override this function, the parameter holds
information of your interest.

Parameters:   XControlEvent * pointerOfEvent   a pointer to an instance of XControlEvent
*/
void XWindow :: DoControl (XControlEvent * e)
{
   XWindow * w = QueryWindow( QW_PARENT);
   if(w)
      w->DoControl( e );
}


/*DOC
CLASS XWindow
FUNCTION SetPointer
GROUP pointer
Set the actual pointer. You can receive a pointer-handle by calling QuerySystemPointer
or load a pointer from a resource with XResourceLibrary::LoadIcon.
*/
BOOL XWindow :: SetPointer( OOL_POINTERHANDLE thePointer)
{
   return WinSetPointer( HWND_DESKTOP, thePointer);
}


/*DOC
CLASS XWindow
FUNCTION QueryPointerHandle
GROUP pointer
returns the handle of the actual pointer.
*/
OOL_POINTERHANDLE XWindow :: QueryPointerHandle( void )
{
   return WinQueryPointer( HWND_DESKTOP);
}


/*DOC
CLASS XWindow
FUNCTION QuerySystemPointerHandle
GROUP pointer
returns the handle of the pointer identified by theID.
Parameters:       LONG theID             ID of the needed pointer. Valid values are:

                                               PTR_ARROW
                                               PTR_TEXT
                                               PTR_WAIT
                                               PTR_SIZE
                                               PTR_SIZENWSE
                                               PTR_SIZENESW
                                               PTR_SIZEWE
                                               PTR_SIZENS
                                               PTR_MOVE
                                               PTR_ILLEGAL

                  BOOL copy              If you need a copy of the pointer (to modify
                                         it) set copy TRUE, otherwise FALSE.
                                         Default is FALSE.
*/
OOL_POINTERHANDLE XWindow :: QuerySystemPointerHandle( LONG theID, BOOL copy )
{
   return WinQuerySysPointer( HWND_DESKTOP, theID, copy);
}


XWindow :: XWindow ()
{
   winhandle = 0;
   handlers = 0;
   regHandlers = NULL;
}


void XWindow :: QueryPointerPos( XPoint * p)
{
   WinQueryPointerPos( HWND_DESKTOP, &p->p);
}


void XWindow :: Activate( void )
{
   WinSetActiveWindow( HWND_DESKTOP, winhandle);
}

/*
void XWindow :: Close(void )
{
  WinDestroyWindow( winhandle );
}
*/

BOOL XWindow :: IsVisible( void )
{
   return WinIsWindowVisible( winhandle);
}


void XWindow :: GetSize( XRect * rect)
{
  SWP swp;
  WinQueryWindowPos( winhandle, &swp);
  rect->x = swp.x;
  rect->y = swp.y;
  rect->cx = swp.cx;
  rect->cy = swp.cy;
}


SHORT XWindow :: GetWindowID( void )
{
   return WinQueryWindowUShort( winhandle, QWS_ID);
}

/*
LONG XWindow :: GetClientHandle( void )
{
  return (LONG) winhandle;
}
*/

XWindow * XWindow :: QueryWindow( ULONG id )
{
   HWND hwnd = WinQueryWindow( winhandle, id);
   return (XWindow *) WinQueryWindowPtr( hwnd, 0);
}


XWindow * XWindow :: GetWindow( ULONG id )
{
   HWND hwnd = WinWindowFromID( winhandle, id);
   return (XWindow *) WinQueryWindowPtr( hwnd, 0);
}

void XWindow :: SetTop( void )
{
   WinSetWindowPos(winhandle, HWND_TOP, 0, 0, 0, 0, SWP_ZORDER);
}


void XWindow :: Enable( BOOL enable)
{
   WinEnableWindow(winhandle, enable);
}

void XWindow :: EnableWindowUpdate ( BOOL enable )
{
   WinEnableWindowUpdate(winhandle, enable);
}


LONG XWindow :: GetText( XString * buffer)
{
   SHORT r = WinQueryWindowTextLength( winhandle);
   WinQueryWindowText( winhandle, r+1, (PCH) buffer->GetBuffer( r));
   buffer->ReleaseBuffer();
   return buffer->GetLength();
}


void XWindow :: Hide(void)
{
   WinSetWindowPos( winhandle, 0,0,0,0,0, SWP_HIDE);
}


void XWindow :: SetSize( XRect * rect )
{
   WinSetWindowPos(winhandle, 0, rect->x, rect->y, rect->cx, rect->cy, SWP_SHOW|SWP_MOVE|SWP_SIZE);
}


void XWindow :: SetText(const char * text)
{
   WinSetWindowText( winhandle, (PSZ) text);
}


void XWindow :: Show(void)
{
   WinSetWindowPos( winhandle, HWND_TOP,0,0,0,0, SWP_SHOW|SWP_ZORDER|SWP_ACTIVATE|SWP_RESTORE);
}


BOOL XWindow :: SetFocus( void )
{
   return WinSetFocus(HWND_DESKTOP, winhandle);
}


LONG XWindow :: QueryTextLength( void)
{
   return WinQueryWindowTextLength( winhandle);
}


void XWindow :: Invalidate( BOOL invalidateChilds )
{
   WinInvalidateRegion( winhandle, NULLHANDLE, invalidateChilds);
}


void XWindow :: SetBottom( void )
{
   WinSetWindowPos(winhandle, HWND_BOTTOM, 0, 0, 0, 0, SWP_ZORDER);
}


void XWindow :: GetForegroundColor( XColor * rgb)
{
   WinQueryPresParam( winhandle, PP_FOREGROUNDCOLOR , 0, NULL, 4, rgb->color, QPF_PURERGBCOLOR);
}


void XWindow :: GetBackgroundColor( XColor * rgb)
{
   WinQueryPresParam( winhandle, PP_BACKGROUNDCOLOR , 0, NULL, 4, rgb->color, QPF_PURERGBCOLOR);
}


void XWindow :: SetForegroundColor( XColor * rgb)
{
   WinSetPresParam( winhandle, PP_FOREGROUNDCOLOR, 4, (PVOID) (ULONG) rgb->color);
}


void XWindow :: SetBackgroundColor( XColor * rgb)
{
   WinSetPresParam( winhandle, PP_BACKGROUNDCOLOR, 4, (PVOID) (ULONG) rgb->color);
}


void XWindow :: SetFont( const char * fontName, unsigned short fontSize)
{
   short l;
   char st[200];
   sprintf( st, "%i.%s", fontSize,fontName);
   l = strlen( st);

   WinSetPresParam( winhandle, PP_FONTNAMESIZE, l, (PVOID) st);
}


void XWindow :: SetFont( const char * fontNameSize)
{
   WinSetPresParam( winhandle, PP_FONTNAMESIZE, strlen(fontNameSize), (PVOID) fontNameSize);
}


XWindow :: ~XWindow()
{
   SHORT i;

   WinSetWindowPtr( winhandle, 0, NULL);
   WinDestroyWindow( winhandle );
   for(i=0; i < handlers; i++)
      {
         regHandlers[i]->handleFor = NULL;
         delete regHandlers[i];
      }
   handlers = 0;
   free (regHandlers);
}


void XWindow :: QueryFontName( XString * font)
{
   WinQueryPresParam( winhandle, PP_FONTNAMESIZE , 0, NULL, 100, font->GetBuffer(100), QPF_NOINHERIT);
   font->ReleaseBuffer();
}



