#include "xheaders.h"

#include XHelpInstance_i
#include XFrameWindow_i
#include XResourceLibrary_i
#include XProcess_i

#include "string.h"

#include "xmsgBox.h"
XHelpInstance :: XHelpInstance( char * path, LONG helpTable, XProcess * pro, char * title, XResourceLibrary * actionBarLib, XResourceLibrary * helpTableLib )
{
  HELPINIT helpinit;
  memset(&helpinit, 0, sizeof(helpinit));

  helpinit.cb = sizeof(HELPINIT);
  helpinit.ulReturnCode = 0;
  helpinit.pszTutorialName = NULL;
  helpinit.phtHelpTable =  (PHELPTABLE) MPFROM2SHORT( helpTable, 0xFFFF);

  helpinit.idAccelTable = 0;
  helpinit.idActionBar = 0;

  helpinit.pszHelpWindowTitle = (PSZ) title;
  helpinit.fShowPanelId = CMIC_HIDE_PANEL_ID;
  helpinit.fShowPanelId = 0;
  helpinit.pszHelpLibraryName = (PSZ) path;
  if( actionBarLib )
     helpinit.hmodAccelActionBarModule = actionBarLib->moduleHandle;
  if( helpTableLib )
     helpinit.hmodHelpTableModule = helpTableLib->moduleHandle;
  helpInstance = WinCreateHelpInstance( pro->hab, &helpinit);
}


void XHelpInstance :: ShowHelpForHelp( void )
{
  WinSendMsg( helpInstance, HM_DISPLAY_HELP, NULL, NULL);
}


void XHelpInstance :: ShowHelpIndex( void )
{
  WinSendMsg( helpInstance, HM_HELP_INDEX, NULL, NULL);
}


void XHelpInstance :: ShowHelpForId( LONG id )
{
  WinSendMsg( helpInstance, HM_DISPLAY_HELP, MPFROMSHORT( id) , MPFROMSHORT( HM_RESOURCEID));
}


XHelpInstance  :: ~XHelpInstance()
{
  if (helpInstance)
     WinDestroyHelpInstance(helpInstance);
}


void XHelpInstance :: AssociateWindow ( XFrameWindow * fWin)
{
  WinAssociateHelpInstance( helpInstance, fWin->frame);
}

