#include "xheaders.h"
#include XFileFind_i


/*DOC
CLASS XFileFind
FUNCTION XFileFind
GROUP constructors/destructors
REMARKS construct a XFileFind-instance
Parameters: char * fileMask              mask for the files to find(e.g. "*.EXE" )
            LONG options                 options to search, valid values are:
*/
XFileFind :: XFileFind( char * m, LONG o)
{
   init = TRUE;
   mask = m;
   options = o;
   dir = HDIR_SYSTEM;
}


char * XFileFind :: Find( void )
{
   LONG res;
   ULONG count = 1;

   if( init)
      {
         res = DosFindFirst( (PSZ) (char*) mask, &dir, options, &buffer, sizeof(buffer), &count, 1);
         init = FALSE;
      }
   else
     res = DosFindNext( dir, &buffer, sizeof(buffer), &count);
   if(res == 0)
      return buffer.achName;
   else
      return NULL;
}


XFileFind :: ~XFileFind()
{
   DosFindClose( dir );
}
