#include "xheaders.h"

#include XCheckBox_i
#include XPushButton_i
#include XRadioButton_i
#include XUserButton_i
#include XBitmap_i
#include XDefaultHandler_i

XButton :: XButton ( HWND hwnd ): XControl ( hwnd )
{;}


XButton :: XButton(  XWindow * owner, XRect * rec, USHORT id, ULONG style, const char * s , unsigned char *classStyle): XControl( rec, style, owner, (const char*) s, (PSZ) classStyle, id)
{ ;}


XPushButton :: XPushButton(HWND hwnd): XButton( hwnd )
{ ;}


XPushButton :: XPushButton(XWindow * owner, XRect * rec, USHORT id, ULONG style, const char * s):XButton( owner, rec, id, style|BS_PUSHBUTTON, (const char*) s, (unsigned char*) WC_BUTTON)
{;}


XSettingButton :: XSettingButton( XWindow * owner, XRect * rec, USHORT id, ULONG style, const char * s , unsigned char *classStyle):XButton( owner, rec, id, style, (const char*) s, (unsigned char*) classStyle)
{ ;}


XSettingButton :: XSettingButton(HWND hwnd): XButton( hwnd )
{ ;}


void XSettingButton :: Select( BOOL select)
{
   WinSendMsg( winhandle,  BM_SETCHECK, MPFROMSHORT(select), 0);
}


BOOL XSettingButton :: IsSelected( void )
{
   return SHORT1FROMMR(WinSendMsg( winhandle,  BM_QUERYCHECK, 0, 0));
}


XCheckBox :: XCheckBox(HWND hwnd): XSettingButton( hwnd )
{ ;}


XCheckBox :: XCheckBox(XWindow * owner, XRect * rec, USHORT id, ULONG style, const char * s):XSettingButton(owner, rec, id, style|BS_AUTOCHECKBOX, (const char*) s, (unsigned char*)WC_BUTTON)
{; }


XRadioButton :: XRadioButton(HWND hwnd): XSettingButton( hwnd )
{ ;}


XRadioButton :: XRadioButton(XWindow * owner, XRect * rec, USHORT id, ULONG style, const char * s):XSettingButton( owner, rec, id, style|BS_AUTORADIOBUTTON, (const char*) s, (unsigned char*)WC_BUTTON)
{ ;}


class userbtnhandler:public XDefaultHandler
{
   public:
      userbtnhandler(XWindow * w):XDefaultHandler( w ) {;}
      BOOL HandleEvent( ULONG, void *, void *);
};


XUserButton :: XUserButton( XWindow * w, XRect * r, LONG id):XSettingButton( w, r, id, WIN_VISIBLE|BS_PUSHBUTTON|BS_USERBUTTON, "", WC_BUTTON)
{
   isPressed = 0;
   userbtnhandler * u = new userbtnhandler(this);
}


void XUserButton :: Draw(void)
{
   HPS hps = WinBeginPaint(winhandle, 0, NULL);
   RECTL rc;
   POINTL p;

   WinQueryWindowRect(winhandle, &rc);
   rc.yBottom += 1;
   rc.xRight -= 1;

   GpiCreateLogColorTable(hps, LCOL_RESET, LCOLF_RGB, 0L, 0L, NULL);
   WinFillRect(hps, &rc, SYSCLR_BUTTONMIDDLE);
   WinDrawBorder(hps, &rc, 1, 1, 0, 0, DB_PATCOPY );

   p.x = (rc.xRight - rc.xLeft - bmp->cx + isPressed * 2) /2 ;
   p.y = 1+ (rc.yTop - rc.yBottom - bmp->cy - isPressed * 2) /2 ;

   if( bmp )
     {
        if(bmp->hbm)
           WinDrawBitmap( hps, bmp->hbm, NULL, &p, 0, 0, DBM_HALFTONE);
     }
   GpiSetLineWidth( hps, LINEWIDTH_THICK );
   GpiSetColor( hps, isPressed ? SYSCLR_BUTTONDARK : SYSCLR_BUTTONLIGHT);
   p.x = rc.xLeft + 2;
   p.y = rc.yBottom + 2;
   GpiMove( hps, &p);
   p.y = rc.yTop - rc.yBottom - 1;
   GpiLine( hps, &p);
   p.x = rc.xRight - rc.xLeft - 2;
   GpiLine( hps, &p);
   if(!isPressed)
      {
         p.y-=2;
         GpiMove(hps, &p );
         GpiSetColor( hps, SYSCLR_BUTTONDARK);
         p.y = rc.yBottom + 2;
         GpiLine( hps, &p);
         p.x = rc.xLeft + 4;
         GpiLine( hps, &p);
      }
   WinEndPaint(hps);
}


BOOL userbtnhandler :: HandleEvent( ULONG msg, void * mp1, void * mp2)
{
   switch(msg)
      {
         case BM_SETHILITE:
            {
               XUserButton * b = (XUserButton *) GetWindow();
               b->isPressed = SHORT1FROMMP(mp1);
               b->Invalidate();
            }
            return TRUE;
      }
}



