#ifndef __OOL_XWINDOW_H__
#define __OOL_XWINDOW_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XWindow                               */
/*                       derived from: XObject                               */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/



#include "xobject.h"

class XRect;
class XColor;
class XString;
class XHandler;
class XFrameWindow;
class XPoint;
class XControlEvent;

#define OOL_ADDCLIENT  WM_USER + 9987

#ifdef OOL_FOR_OS2_X86
   //styles
   #define WIN_VISIBLE  WS_VISIBLE
   #define WIN_BORDER   FS_BORDER

   //
   #define WIN_PARENT   QW_PARENT
   #define WIN_NEXT     QW_NEXT
   #define WIN_PREV     QW_PREV


   #define PTR_ARROW    SPTR_ARROW
   #define PTR_TEXT     SPTR_TEXT
   #define PTR_WAIT     SPTR_WAIT
   #define PTR_SIZE     SPTR_SIZE
   #define PTR_SIZENWSE SPTR_SIZENWSE
   #define PTR_SIZENESW SPTR_SIZENESW
   #define PTR_SIZEWE   SPTR_SIZEWE
   #define PTR_SIZENS   SPTR_SIZENS
   #define PTR_MOVE     SPTR_MOVE
   #define PTR_ILLEGAL  SPTR_ILLEGAL

#endif


class _export_ XWindow: public XObject
{
      friend MRESULT HandleDefault( XWindow * w, ULONG msg, MPARAM mp1, MPARAM mp2, BOOL& handled);
      friend MRESULT HandleFrameDefault( XFrameWindow * w, ULONG msg, MPARAM mp1, MPARAM mp2, BOOL& handled);
      friend class XHandler;
      friend class XFrameWindow;
      friend class XScrollWindow;
      friend class XFrame;
   private:
      XHandler ** regHandlers;
      USHORT handlers;
   protected:
      OOL_WINDOWHANDLE winhandle;
      XWindow();
   public:
      virtual ~XWindow();
      virtual void Activate( void );
      virtual void DoControl( XControlEvent *);
      virtual void DoMove( void ) { ;}
      virtual void DoSize( void ) { ;}
      virtual void Draw( void ) { ;}
      virtual void Enable( BOOL enable = TRUE);
      virtual void EnableWindowUpdate ( BOOL update = TRUE);
      virtual void FocusChanged( BOOL focusReceived) { ;}
      virtual void GetBackgroundColor( XColor * rgbColor);
      virtual LONG GetClientHandle( void ) { return winhandle; }
      void GetForegroundColor( XColor * rgbColor);
      virtual OOL_WINDOWHANDLE GetHandle(void) {return winhandle;}
      virtual void GetSize( XRect* rect);
      virtual LONG GetText( XString * buffer );
      virtual XWindow * XWindow :: GetWindow( ULONG id );
      virtual SHORT GetWindowID( void );
      virtual void Hide(void);
      virtual void Invalidate( BOOL invalidateChilds = FALSE );
      virtual BOOL IsVisible( void );
      void QueryFontName( XString *);
      static void QueryPointerPos( XPoint * p);
      static OOL_POINTERHANDLE QueryPointerHandle( void );
      static OOL_POINTERHANDLE QuerySystemPointerHandle( LONG theID, BOOL copy = FALSE );
      virtual LONG QueryTextLength( void);
      virtual XWindow * QueryWindow( ULONG id );
      static void * SendMsg( OOL_WINDOWHANDLE handle, ULONG msg, void * mp1, void * mp2) { return WinSendMsg( handle, msg, mp1, mp2); }
      void SetBackgroundColor( XColor * rgbColor);
      virtual void SetBottom( void );
      BOOL SetFocus( void );
      void SetForegroundColor( XColor * rgbColor);
      void SetFont(const char * fontName, unsigned short fontSize);
      void SetFont(const char * fontNameSize);
      static BOOL SetPointer( OOL_POINTERHANDLE thePointer);
      virtual void SetSize( XRect * rect);
      virtual void SetText(const char * text);
      virtual void SetTop( void );
      virtual void Show(void);
};

#endif
