#ifndef __OOL_XTOOLBAR_H__
#define __OOL_XTOOLBAR_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XToolBar                              */
/*                       derived from: XFrameControl                         */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xfrmcnt.h"


class XFrameWindow;
class XColor;
class XGraphicDevice;
class XLine;
class XControlEvent;

class _export_ XToolBar: public XFrameControl
{
      friend class XFrame;
   private:
      XWindow ** clientWin;
      USHORT clients;
      USHORT borderSize;
      LONG * yOffset, * xOffset;
      XFrameWindow * frame;
      SHORT spacing;
      void ReSize( void );
      XGraphicDevice * graph;
      XLine * line1, *line2, *line3, *line4;
   public:
      XToolBar ( XFrameWindow *, ULONG style = TB_TOP, USHORT ySize = 20, USHORT groupSpacing = 15);
      virtual ~XToolBar();
      void AddWindow ( XWindow * clientWindow, BOOL newGroup = FALSE, BOOL adjustSize = FALSE, XWindow * insertBehind = NULL, LONG x_offset = 0, LONG y_Offset = 0);
      void DoCommand( LONG);
      void DoSize( void );
      void Draw(void);
      void Hide( void );
      void GetBackgroundColor( XColor * rgb);
      BOOL RemoveWindow( XWindow *, BOOL redraw = FALSE);
      void SetBorderSize(USHORT siz);
      BOOL SetHight( USHORT cy);
      void Show( void );
};

#endif
