#ifndef __OOL_XPINBTN_H__
#define __OOL_XPINBTN_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XSpinButton                           */
/*                       derived from: XControl                              */
/*                        last update: 4/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xcontrol.h"

#define SP_LEFT     SPBS_JUSTLEFT
#define SP_RIGHT    SPBS_JUSTRIGHT
#define SP_CENTER   SPBS_JUSTCENTER
#define SP_NOBORDER SPBS_NOBORDER
#define SP_FAST     SPBS_FASTDSPIN
#define SP_MASTER   SPBS_MASTER
#define SP_SERVANT  SPBS_SERVANT
#define SP_READONLY SPBS_READONLY
#define SP_NUMERIC  SPBS_NUMERICONLY
#define SP_CHAR     SPBS_ALLCHARACTERS
#define SP_FILLZERO SPBS_PADWITHZEROS



class _export_ XSpinButton: public XControl{
      friend class XFrameWindow;
   private:
      XSpinButton( HWND hwnd);
   public:
      XSpinButton(XWindow * owner, XRect * rec, USHORT id = 0, ULONG style=SP_CHAR|SP_RIGHT, const char * string="");
      virtual ~XSpinButton() {;}
      LONG GetValue( void);
      void SetLimits( LONG lowerLimit, LONG upperLimit);
      void SetValue( LONG val);
};

#endif
