#ifndef __OOL_XLINE_H__
#define __OOL_XLINE_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XLine                                 */
/*                       derived from: XGraphicObject                        */
/*                        last update: 4/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/


#include "xgraphob.h"
#include "xpoint.h"

class XRect;

class _export_ XLine: public XGraphicObject
{
   protected:
      XPoint p2;
      char lineType;
      char lineWidth;
      char lineJoin;
      char lineEnd;
   public:
      XLine( XGraphicDevice *, XPoint *, XPoint *);
      virtual ~XLine() {;}
      void Draw( XRect * r = NULL);
      LONG GetWight( void ) { return p2.p.x - p.p.x; }
      LONG GetHight( void ) { return p2.p.y - p.p.y; }
      void SetLineEnd( char end ) { lineEnd = end; }
      void SetLineJoin( char join ) { lineJoin = join; }
      void SetLineWidth( char width ) { lineWidth = width; }
      void SetHight( LONG y) { p2.p.y = p.p.y + y; }
      void SetWight( LONG x) { p2.p.x = p.p.x + x; }
      void SetupDevice( void );
};


#endif
