#ifndef __OOL_XENTRYFIELD_H__
#define __OOL_XENTRYFIELD_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XEntryField                           */
/*                       derived from: XControl                              */
/*                        last update: 4/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/




#include "xcontrol.h"

#ifdef OOL_FOR_OS2_X86
   #define EN_LEFT       0x0000
   #define EN_CENTER     0x0001
   #define EN_RIGHT      0x0002
   #define EN_AUTOSCROLL 0x0004
   #define EN_MARGIN     0x0008
   #define EN_AUTOTAB    0x0010
   #define EN_READONLY   0x0020
   #define EN_UNREADABLE 0x0080
   #define EN_AUTOSIZE   0x0200
   #define EN_BORDER     FS_BORDER
#endif

class _export_ XEntryField: public XControl{
      friend class XFrameWindow;
   private:
      XEntryField( HWND hwnd);
   public:
      XEntryField(XWindow * owner, XRect * rec, USHORT id = 0, ULONG style = EN_BORDER | EN_LEFT, const char * string = "");
      virtual ~XEntryField() {;}
      void EnableOverWrite( BOOL overWrite = TRUE);
      BOOL HasChanged(void );
      void QuerySelectionBounds( SHORT& start, SHORT& end);
      void SelectText( USHORT start, USHORT end);
      void SetLimit( USHORT len);
      void ShowFirstChar( SHORT firstChar = 0);
};

#endif
