#ifndef __OOL_XDRAGITEM_H__
#define __OOL_XDRAGITEM_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XDragItem                             */
/*                       derived from: XObject                               */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xstring.h"
#include "xdragevn.h"


#ifdef OOL_FOR_OS2_X86

   //mechanism information
   #define DRG_M_FILE    "DRM_OS2FILE"
   #define DRG_M_OBJECT  "DRM_OBJECT"

   //format information
   #define DRG_F_TEXT    "DRF_TEXT"

#endif


class _export_ XDragItem: public XObject
{
      friend class XDragEvent;
      friend class XContainerDragEvent;
      friend class XWindowDrag;
   private:
   public:
      PDRAGITEM item;
      BOOL allocated;
   public:
      XDragItem() { allocated = FALSE;}
      XDragItem( XWindow * sourceWindow, SHORT operation = DRG_COPY, LONG id = 0, char * type = DRG_M_OBJECT , char * mechanism = DRG_F_TEXT);
      ~XDragItem();
      void Accept( BOOL accept = TRUE );
      void EndConversation( BOOL success = TRUE);
      OOL_WINDOWHANDLE GetSourceWindow(void) { return item->hwndItem; }
      void QueryContainerName( XString*);
      LONG QueryID(void);
      void QueryMechanism( XString *);
      void QueryName( XString * );
      void QueryTargetName( XString *);
      void QueryType( XString *);
      void SetContainerName( char *);
      void SetMechanism( char *);
      void SetName( char *);
      void SetTargetName( char *);
      BOOL VerifyItemType( char * mechanism, char * format = NULL);
};

#endif
