#ifndef __OOL_XCONTINFO_H__
#define __OOL_XCONTINFO_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XContainerInfo                        */
/*                       derived from: XObject                               */
/*                        last update: 4/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/



#include "xobject.h"

#define CO_TITLESEPARATOR CA_TITLESEPARATOR
#define CO_TITLEREADONLY  CA_TITLEREADONLY
#define CO_DETAILTITLES   CA_DETAILSVIEWTITLES
#define CO_TITLELEFT      CA_TITLELEFT
#define CO_TITLERIGHT     CA_TITLERIGHT
#define CO_TITLECENTER    CA_TITLECENTER
#define CO_TEXT    0x00000001
#define CO_NAME    0x00000002
#define CO_ICON    0x00000004
#define CO_DETAIL  0x00000008
#define CO_FLOW    0x00000010
#define CO_MINI    CV_MINI
#define CO_TREE    0x00000040
#define CO_OWNERPAINTBACKGROUND		0x00100000
#define CO_TREELINE			0x00400000

#define CO_DRAWBITMAP CA_DRAWBITMAP
#define CO_DRAWICON   CA_DRAWICON
#define CO_TITLE CA_CONTAINERTITLE

class XString;
class XContainerColumn;

/*DOC
CLASS XContainerInfo
DESCRIPTION The XConatinerInfo is used to set/query information about
the behavior of a XContainerControl.
*/
class _export_ XContainerInfo: public XObject
{
      friend class XContainerControl;
   private:
      CNRINFO cnrinfo;
      LONG changes;
   public:
      XContainerInfo( char * title = "", LONG attr = CO_ICON);
      virtual ~XContainerInfo() {;}
      void EnableSorting( BOOL enable = TRUE);
      LONG QueryAttributes( void );
      SHORT QueryBitmapSize( void );
      LONG QuerySplitbarPos( void );
      void QueryTitle( XString * s );
      void SetAttributes( LONG attribute );
      void SetBitmapSize( SHORT size);
      void SetSplitbarPos( LONG pos );
      void SetSplitbarColumn( XContainerColumn * col);
      void SetTitle( char * t );
};

#endif
