#ifndef __OOL_XCONTAINER_H__
#define __OOL_XCONTAINER_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XContainerControl                     */
/*                       derived from: XControl                              */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/


#include "xcontrol.h"

#ifdef OOL_FOR_OS2_X86
   #ifndef CRA_SOURCE
      #define CRA_SOURCE  0x00004000L
   #endif

   //container creation styles
   #define CON_AUTOPOSITION CCS_AUTOPOSITION
   #define CON_EXTENDSEL    CCS_EXTENDSEL
   #define CON_MULTIPLESEL  CCS_MULTIPLESEL
   #define CON_READONLY     CCS_READONLY
   #define CON_SINGLESEL    CCS_SINGLESEL

   //object-emphasis, can be or-ed
   #define CON_CURSORED   CRA_CURSORED
   #define CON_DISABLED   CRA_DISABLED
   #define CON_INUSE      CRA_INUSE
   #define CON_PICKED     CRA_PICKED
   #define CON_SELECTED   CRA_SELECTED
   #define CON_SOURCE     CRA_SOURCE

   //enumeration styles (FindObject)
   #define CON_FIRST      CMA_FIRST
   #define CON_FIRSTCHILD CMA_FIRSTCHILD
   #define CON_LAST       CMA_LAST
   #define CON_LASTCHILD  CMA_LASTCHILD
   #define CON_NEXT       CMA_NEXT
   #define CON_PARENT     CMA_PARENT
   #define CON_PREV       CMA_PREV

   //other
   #define CON_REPOSITION    CMA_REPOSITION
   #define CON_NOREPOSITION  CMA_NOREPOSITION
   #define CON_TEXTCHANGED   CMA_TEXTCHANGED
   #define CON_ERASE         CMA_ERASE

   #define CON_FREE       CMA_FREE
   #define CON_INVALIDATE CMA_INVALIDATE

#endif

class XContainerInfo;
class XContainerObject;
class XContainerColumn;


class _export_ XContainerControl: public XControl{
       friend class XFrameWindow;
     private:
       XContainerControl(HWND hwnd);
     public:
       XContainerControl( XWindow * owner, XRect * rec, USHORT id = 0, ULONG style=WIN_VISIBLE|WIN_BORDER);
       virtual ~XContainerControl() { ;}
       BOOL AddObject( XContainerObject * objectList, XContainerObject * parentObject=NULL);
       void Arrange(void);
       XContainerObject * FindObject( XContainerObject * startObject = NULL, SHORT select=CON_FIRST);
       void HScroll( LONG pix );
       BOOL InsertColumn( XContainerColumn * column, XContainerColumn * insertBehind = NULL, BOOL redraw = FALSE);
       void InvalidateObject( XContainerObject * obj = NULL, SHORT option = CMA_REPOSITION);
       XContainerColumn * QueryColumn( XContainerColumn * col, SHORT option);
       void QueryInfo( XContainerInfo*);
       XContainerObject * QueryObject( XContainerObject * startObject = NULL, SHORT filter= CON_SELECTED);
       void RemoveAll( BOOL destroyObjects = TRUE );
       BOOL RemoveColumn( XContainerColumn * column, SHORT option);
       BOOL RemoveObject( XContainerObject *, BOOL destroyObject = TRUE, BOOL redraw = FALSE);
       void SetInfo( XContainerInfo*);
       void SetObjectEmphasis( XContainerObject * obj, SHORT emph, BOOL enableEmph=TRUE);
//       BOOL Sort( PFN functionPointer);
       void UpdateColumns( void );
       void VScroll( LONG pix );
};


#endif
