#ifndef __OOL_XCONTROLEVENT_H__
#define __OOL_XCONTROLEVENT_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XControlEvent                         */
/*                       derived from: XEvent                                */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xevent.h"

//standard control events
#define WIN_CHANGED   1
#define WIN_DBLCLICK  2
#define WIN_PAINT     3
#define WIN_ENTER     4
#define WIN_VSCROLL   5
#define WIN_HSCROLL   6
#define WIN_SETFOCUS  7
#define WIN_KILLFOCUS 8
#define WIN_SELECTED  9
#define WIN_SHOWLIST  10
#define WIN_TRACK     11
#define WIN_UPARROW   12
#define WIN_DOWNARROW 13
#define WIN_ENDTRACK  14

//media control events
#define MEDIA_PLAYED   300
#define MEDIA_PAUSED   301
#define MEDIA_REWINDED 302




#define WIN_FONTCHANGED  15
#define WIN_BACKCOLCHANGED   16
#define WIN_FRONTCOLCHANGED  17


/*DOC
CLASS XControlEvent
The XControlEvent is send to a XFrameWindow when the user has performed
some interaction with a client window of the frame window. If you have caught the XControlEvent
by overriding XFrameWindow::DoControl you can get information about the sending window
and the type (ID) of the event. Valid event-IDs are:

   WIN_CHANGED          the content of the client has changed
   WIN_DBLCLICK         the user double-clicked on the window
   WIN_PAINT            the window will be redrawn
   WIN_ENTER            the user pressed ENTER
   WIN_SELECTED         an item of the window was selected
   WIN_VSCROLL          the window scrolls it contents
   WIN_HSCROLL          the window scrolls it contents
   WIN_SETFOCUS         the window recieves the focus
   WIN_KILLFOCUS        the window lost the focus
   WIN_SHOWLIST         the list of a XComboBox will be displayed
   WIN_TRACK            the user tracks the window (in XSlider)
   WIN_ENDTRACK         the user stopped tracking (in XSlider)
   WIN_UPARROW          the user pressed the arrow "up" (in XSpinButton)
   WIN_DOWNARROW        the user pressed the arrow "down" (in XSpinButton)

   MEDIA_PLAYED         a media-window has completed playing a file
   MEDIA_PAUSED         a media-window paused playing a file
   MEDIA_REWINDED       a media-window completed rewinding a file
*/
class XWindow;
class XFrameWindow;

class _export_ XControlEvent: public XEvent
{
      friend MRESULT HandleFrameDefault( XFrameWindow * w, ULONG msg, MPARAM mp1, MPARAM mp2, BOOL& handled);
      friend MRESULT userProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
   protected:
      XControlEvent( LONG event): XEvent(event) {;}
      XControlEvent( XWindow *, void*, void*);
      LONG windowID;
      XWindow * window;
   public:
      XWindow * GetWindow(void) { return window; }
      LONG GetWindowID( void ) { return windowID; }

};

#endif
