#ifndef __OOL_XBITMAP_H__
#define __OOL_XBITMAP_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XBitmap                               */
/*                       derived from: XGraphicObject                        */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/


#include "xgraphob.h"
#include "xpoint.h"

class XResource;
class XUserButton;
class XWindow;

class _export_  XBitmap: public XGraphicObject
{
      friend class XBitmapShadow;
      friend XUserButton;
      friend class XWindowDrag;
   private:
      BITMAPINFOHEADER2 * data;
      XWindow * owner;
      HBITMAP hbm;
      HDC hdc;
      HPS hps;
      ULONG cScans;
      LONG SetBitmap( HBITMAP b);
      LONG SetData( PBITMAPINFOHEADER2, LONG );
      BOOL HitTest( LONG x, LONG y);
      LONG cx, cy;
   public:
      XBitmap( XGraphicDevice*, XPoint * );
      XBitmap( XUserButton*);
      ~XBitmap();
      void Draw( XRect * );
      LONG LoadBitmap( XResource * r);
      LONG LoadBitmap( char*);
      void QueryDimensions( LONG& x, LONG& y);
};

#endif
