// Demo created by: Juan Miguel Sosso
//                  2:345/201.8@fidonet.org

#include "inkey.ch"
#include "box.ch"

// ----------------------------------------------------------------------------

Function Main()

   local oMouse := TMouse()
   local lFin := .F.
   local lBox := .F.
   local cArea
   local nTop, nLeft, nBottom, nRight
   local cOldColor := SetColor( "W+/B" )

   SET CURSOR OFF
   CLS

   // Init screen
   @ 0, 3 SAY "RUNsoft presents: TMouse class for CLIPPER 5.x demo, press ESC when finish"
   @ 1, 3 SAY "Make a box pressing left button, moving the mouse and releasing the button"
   @ MaxRow(), 0 SAY Space( MaxCol() + 1 ) COLOR "B/W"
   @ MaxRow(), 1 SAY "The Mouse has " + Transform( oMouse:nButtons, "9" ) + ;
     " buttons, and now is at row    and col" COLOR "B/W"
   @ MaxRow() - 3, 71, MaxRow() - 1, 78 BOX B_DOUBLE
   @ MaxRow() - 2, 73 SAY "Exit"

   // Init mouse
   oMouse:On()
   oMouse:SetArea( 2, 0, MaxRow() - 1, MaxCol() )
   oMouse:SetPos( MaxRow() / 2, MaxCol() / 2 )

   // Main loop
   do while !lFin

      oMouse:Update()
      if Inkey() = K_ESC
         lFin = .T.
      endif

      @ MaxRow(), 44 SAY Transform( oMouse:nRow, "99" ) COLOR( "B/W" )
      @ MaxRow(), 55 SAY Transform( oMouse:nCol, "99" ) COLOR( "B/W" )

      if oMouse:lLeft
         @ MaxRow(), 60 SAY "Left" COLOR "GR+/W"
      else
         @ MaxRow(), 60 SAY "    " COLOR "B/W"
      endif

      if oMouse:lCenter
         @ MaxRow(), 65 SAY "Center" COLOR "GR+/W"
      else
         @ MaxRow(), 65 SAY "      " COLOR "B/W"
      endif

      if oMouse:lRight
         @ MaxRow(), 72 SAY "Right" COLOR "GR+/W"
      else
         @ MaxRow(), 72 SAY "     " COLOR "B/W"
      endif

      // Exit button
      if oMouse:lLeft .and. !lBox
         if oMouse:lAt( MaxRow() - 3, 71, MaxRow() - 1, 78 )
            lFin = .T.
         endif
      endif

      // Draw boxes
      if oMouse:lLeft .and. !lFin
         if oMouse:nRow != nBottom .or. oMouse:nCol != nRight
            oMouse:Off()
            DispBegin()
            if !lBox
               lBox    = .T.
               nTop    = oMouse:nRow
               nLeft   = oMouse:nCol
               nBottom = nTop
               nRight  = nLeft
               cArea   = SaveScreen( nTop, nLeft, nBottom, nRight )
            else
               RestScreen( nTop, nLeft, nBottom, nRight, cArea )
               if oMouse:nRow >= nTop
                  nBottom = oMouse:nRow
               endif
               if oMouse:nCol >= nLeft
                  nRight = oMouse:nCol
               endif
               cArea = SaveScreen( nTop, nLeft, nBottom, nRight )
               @ nTop, nLeft, nBottom, nRight BOX B_SINGLE COLOR "G+/B"
            endif
            DispEnd()
            oMouse:On()
         endif
      else
         if lBox
            oMouse:Off()
            @ nTop, nLeft, nBottom, nRight BOX B_SINGLE + " " COLOR "W/R"
            oMouse:On()
         endif
         lBox = .F.
      endif

   enddo

   oMouse:Off()
   SetColor( cOldColor )
   CLS

   ?? "What do you think about it? see TEST.PRG to enjoy..."
   ? "Source code available to registered users only, pure C code"
   ?
   ? "Write to:"
   ?
   ? "          RUNsoft"
   ? "          Mlaga 40, 3"
   ? "          29600 Marbella (MA)"
   ? "          SPAIN"
   ?
   ? "Send $30 or 3.000 ptas plus $3 if out of spain"
   ?
   ? "Also: contact at 2:345/201@fidonet.org tel: +34-5-221-3374 up to 19.200 bps"
   ?

Return NIL

// ----------------------------------------------------------------------------
