;! " VOR Radar "
;? " Altitude: "=SML_Alt
;? " Scenery density required to show on (1-4): "=SML_Comp
; converted by A. Antonini (with permission )

; NOTE: Fixed Scale, Heading and Colors

MACRO VorRadar

Local ObjEnd, Pcall, Scall, ObjReturn, Dwg, LB01, LB02, LB03, LB04, LB05,
      LB06, LB07, LB08, LB09, LB10, LB11, J01

Area(  SML_Lat, SML_Lon, 22 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )        
    PerspectiveCall( Pcall )
    ShadowCall( Scall )
    Jump( ObjEnd )              

Pcall:
    Perspective

Scall:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    Rotate(  Dwg,  0, 0, 0 ) 

ObjReturn:
    Return

Dwg:
    Call( LB03 )
    Call( LB04 )
    Call( LB05 )
    Return

LB01:
    Call( LB05 )
    Call( LB04 )
    Call( LB03 )
    Return

LB03:
    Call( LB06 )
    Rotate( LB06,  0, 0,  60d )
    Rotate( LB06,  0, 0, 120d )
    Rotate( LB06,  0, 0, 180d )
    Rotate( LB06,  0, 0, 240d )
    Rotate( LB06,  0, 0, 300d )
    Return

LB04:
    Call( LB07 )
    Rotate( LB07,  0, 0,  60d )
    Rotate( LB07,  0, 0, 120d )
    Rotate( LB07,  0, 0, 180d )
    Rotate( LB07,  0, 0, 240d )
    Rotate( LB07,  0, 0, 300d )
    Return

LB06:
    Call( LB08 )
    Call( LB09 )
    Rotate( LB09,  0, 0,  7d )
    Rotate( LB09,  0, 0, 15d )
    Rotate( LB09,  0, 0, 22d )
    Rotate( LB09,  0, 0, 30d )
    Rotate( LB09,  0, 0, 37d )
    Rotate( LB09,  0, 0, 45d )
    Rotate( LB09,  0, 0, 52d )
    Return

LB08:
    PointsList(   0,  35 )
    Point(        0,  20,   0    ) ;0
    Point(        0,  40,   0    ) ;1
    Point(      -11,  40,  19    ) ;2
    Point(        0,  40,  21    ) ;3
    Point(       11,  40,  19    ) ;4
    Point(      -21,  40,  35    ) ;5
    Point(        0,  40,  41    ) ;6
    Point(       21,  40,  35    ) ;7
    Point(      -31,  40,  53    ) ;8
    Point(        0,  40,  61    ) ;9
    Point(       31,  40,  53    ) ;10
    Point(      -31,  40,  73    ) ;11
    Point(       31,  40,  73    ) ;12
    Point(       48,  40,  63    ) ;13
    Point(      -31,  40,  93    ) ;14
    Point(       31,  40,  93    ) ;15
    Point(       65,  40,  73    ) ;16
    Point(      -34,  40, 116    ) ;17
    Point(       34,  40, 116    ) ;18
    Point(       86,  40,  86    ) ;19
    Point(        0,  53,   0    ) ;20
    Point(      -31,  40,  53    ) ;21
    Point(        0,  40,  61    ) ;22
    Point(      -31,  40,  93    ) ;23
    Point(       31,  40,  93    ) ;24
    Point(        0,   0,   0    ) ;25
    Point(      -31,   0,  53    ) ;26
    Point(        0,   0,  61    ) ;27
    Point(      -31,   0,  93    ) ;28
    Point(       31,   0,  93    ) ;29
    Point(        0,   20,  0    ) ;30
    Point(      -31,   20, 53    ) ;31
    Point(        0,   20, 61    ) ;32
    Point(      -31,   20, 93    ) ;33
    Point(       31,   20, 93    ) ;34
               
    Db 0x52, 0x00, 0x05, 0x68    
    LineColor(   Red )
        MoveToPoint( 1 ) 
        LineToPoint( 2 ) 
        LineToPoint( 8 ) 
        LineToPoint( 17 )
        LineToPoint( 18 )
        LineToPoint( 19 )
        LineToPoint( 10 )
        LineToPoint( 1 ) 
        LineToPoint( 9 ) 
        MoveToPoint( 2 ) 
        LineToPoint( 3 ) 
        LineToPoint( 4 ) 
        MoveToPoint( 5 ) 
        LineToPoint( 6 ) 
        LineToPoint( 7 ) 
        MoveToPoint( 8 ) 
        LineToPoint( 9 ) 
        LineToPoint( 10 )
        MoveToPoint( 11 )
        LineToPoint( 12 )
        LineToPoint( 13 )
        MoveToPoint( 14 )
        LineToPoint( 15 )
        LineToPoint( 16 )
        MoveToPoint( 20 )
        LineToPoint( 30 )
        MoveToPoint( 21 )
        LineToPoint( 31 )
        MoveToPoint( 22 )
        LineToPoint( 32 )
        MoveToPoint( 23 )
        LineToPoint( 33 )
        MoveToPoint( 24 )
        LineToPoint( 34 )
        MoveToPoint( 10 )
        LineToPoint( 18 )

    LineColor( White )
        MoveToPoint( 30 ) 
        LineToPoint( 25 ) 
        MoveToPoint( 31 ) 
        LineToPoint( 26 ) 
        MoveToPoint( 32 ) 
        LineToPoint( 27 ) 
        MoveToPoint( 33 ) 
        LineToPoint( 28 ) 
        MoveToPoint( 34 ) 
        LineToPoint( 29 ) 

        Polygon_3( 1,  8, 10 )
        Polygon_4( 8, 10, 18, 17 )
        Polygon_3( 10, 18, 19 )
        Polygon_3( 1, 8, 10 )
        Polygon_4( 8, 10, 18, 17 )
        Polygon_3( 10, 18, 19 )
        Polygon_3( 10, 8, 1 )
        Polygon_4( 17, 18, 10, 8 )
        Polygon_3( 19, 18, 10 )
        Polygon_3( 10, 8, 1 )
        Polygon_4( 17, 18, 10, 8 )
        Polygon_3( 19, 18, 10 )
        Return

LB09:
    PointsList( 0, 2 )
    Point(    0,   40,   60  )  ; 0
    Point(    0,   45,   60  )  ; 1
    Point(    0,   50,   60  )  ; 2

    LineColor( Red )  ; supports antennes VOR
        MoveToPoint( 0 )
        LineToPoint( 1 )
    LineColor( Grey )
        MoveToPoint( 1 )
        LineToPoint( 2 )
    Return

LB07:
Call( LB10 )
    Rotate( LB10,   0, 0,   7 )
    Rotate( LB10,   0, 0,  15 )
    Rotate( LB10,   0, 0,  22 )
    Rotate( LB10,   0, 0,  30 )
    Rotate( LB10,   0, 0, 337 )
    Rotate( LB10,   0, 0, 345 )
    Rotate( LB10,   0, 0, 352 )
    Return

LB10:
    PointsList( 0, 25 )
    Point(        0,   54,   60  )        ;0 
    Point(        0,   53,   62  )        ;1 
    Point(        0,   53,   58  )        ;2 
    Point(        0,   51,   63  )        ;3 
    Point(        0,   51,   57  )        ;4 
    Point(        0,   50,   63  )        ;5 
    Point(        0,   50,   57  )        ;6 
    Point(       -2,   53,   60  )        ;7 
    Point(        2,   53,   60  )        ;8 
    Point(       -3,   51,   60  )        ;9 
    Point(        3,   51,   60  )        ;10
    Point(       -3,   50,   60  )        ;11
    Point(        3,   50,   60  )        ;12
    Point(       -1,   53,   61  )        ;13
    Point(        1,   53,   59  )        ;14
    Point(       -2,   51,   62  )        ;15
    Point(        2,   51,   58  )        ;16
    Point(       -2,   50,   62  )        ;17
    Point(        2,   50,   58  )        ;18
    Point(        1,   53,   61  )        ;19
    Point(       -1,   53,   59  )        ;20
    Point(        2,   51,   62  )        ;21
    Point(       -2,   51,   58  )        ;22
    Point(        2,   50,   62  )        ;23
    Point(       -2,   50,   58  )        ;24
                    
    SurfaceColor( 0x16 )   ; antennes VOR
    StartSurface
    MoveToPoint( 0 )
        LineToPoint( 1 )
        LineToPoint( 3 )
        LineToPoint( 5 )
        LineToPoint( 6 )
        LineToPoint( 4 )
        LineToPoint( 2 )
    CloseSurface

    StartSurface
        MoveToPoint( 0 )
        LineToPoint( 7 )
        LineToPoint( 9 )
        LineToPoint( 11 )
        LineToPoint( 12 )
        LineToPoint( 10 )
        LineToPoint( 8 )
    CloseSurface

    StartSurface
        MoveToPoint( 0 )
        LineToPoint( 13 )
        LineToPoint( 15 )
        LineToPoint( 17 )
        LineToPoint( 18 )
        LineToPoint( 16 )
        LineToPoint( 14 )
    CloseSurface
    
    StartSurface
        MoveToPoint( 0 )
        LineToPoint( 19 )
        LineToPoint( 21 )
        LineToPoint( 23 )
        LineToPoint( 24 )
        LineToPoint( 22 )
        LineToPoint( 20 )
    CloseSurface
    
    StartSurface
        MoveToPoint( 5 )
        LineToPoint( 17 )
        LineToPoint( 11 )
        LineToPoint( 24 )
        LineToPoint( 6 )
        LineToPoint( 18 )
        LineToPoint( 12 )
        LineToPoint( 23 )
    CloseSurface
    Return

LB05:
    PointsList( 0, 35 )
    Point(        0,   73,    0  )      ;0
    Point(        0,   70,    1  )      ;1
    Point(        0,   70,   -1  )      ;2
    Point(        0,   53,    1  )      ;3
    Point(        0,   53,   -1  )      ;4
    Point(        0,   51,    3  )      ;5
    Point(        0,   51,   -3  )      ;6
    Point(        0,   50,    3  )      ;7
    Point(        0,   50,   -3  )      ;8
    Point(       -1,   70,    0  )      ;9
    Point(        1,   70,    0  )      ;10
    Point(       -1,   53,    0  )      ;11
    Point(        1,   53,    0  )      ;12
    Point(       -3,   51,    0  )      ;13
    Point(        3,   51,    0  )      ;14
    Point(       -3,   50,    0  )      ;15
    Point(        3,   50,    0  )      ;16
    Point(       -1,   70,    1  )      ;17
    Point(        1,   70,   -1  )      ;18
    Point(       -1,   53,    1  )      ;19
    Point(        1,   53,   -1  )      ;20
    Point(       -2,   51,    2  )      ;21
    Point(        2,   51,   -2  )      ;22
    Point(       -2,   50,    2  )      ;23
    Point(        2,   50,   -2  )      ;24
    Point(        1,   70,    1  )      ;25
    Point(       -1,   70,   -1  )      ;26
    Point(        1,   53,    1  )      ;27
    Point(       -1,   53,   -1  )      ;28
    Point(        2,   51,    2  )      ;29
    Point(       -2,   51,   -2  )      ;30
    Point(        2,   50,    2  )      ;31
    Point(       -2,   50,   -2  )      ;32
    Point(        0,   70,    0  )      ;33
    Point(        0,   74,    0  )      ;34

    SurfaceColor( 0x16 )  ; antenne centrale
    LineColor( Red )
    StartSurface
        MoveToPoint( 1 )
        LineToPoint( 3 )
        LineToPoint( 5 )
        LineToPoint( 7 )
        LineToPoint( 8 )
        LineToPoint( 6 )
        LineToPoint( 4 )
        LineToPoint( 2 )
    CloseSurface
    StartSurface
        MoveToPoint( 9 )
        LineToPoint( 11 )
        LineToPoint( 13 )
        LineToPoint( 15 )
        LineToPoint( 16 )
        LineToPoint( 14 )
        LineToPoint( 12 )
        LineToPoint( 10 )
    CloseSurface
    StartSurface
        MoveToPoint( 17 )
        LineToPoint( 19 )
        LineToPoint( 21 )
        LineToPoint( 23 )
        LineToPoint( 24 )
        LineToPoint( 22 )
        LineToPoint( 20 )
        LineToPoint( 18 )
    CloseSurface
    StartSurface
        MoveToPoint( 25 )
        LineToPoint( 27 )
        LineToPoint( 29 )
        LineToPoint( 31 )
        LineToPoint( 32 )
        LineToPoint( 30 )
        LineToPoint( 28 )
        LineToPoint( 26 )
    CloseSurface
    StartSurface
        MoveToPoint( 7 )
        LineToPoint( 23 )
        LineToPoint( 15 )
        LineToPoint( 32 )
        LineToPoint( 8  )
        LineToPoint( 24 )
        LineToPoint( 16 )
        LineToPoint( 31 )
    CloseSurface
    StartSurface
        MoveToPoint( 25 )
        LineToPoint( 17 )
        LineToPoint( 26 )
        LineToPoint( 18 )
    CloseSurface
        MoveToPoint( 0  )
        LineToPoint( 33 )
  
    SurfaceColor( Black )
        Polygon_3( 0, 26, 17 )
        Polygon_3( 0, 17, 25 )
        Polygon_3( 0, 25, 18 )
        Polygon_3( 0, 18, 26 )

    LineColor(  0x0F )
        MoveToPoint( 0 )
        LineToPoint( 34 )
    Return

J01:
    Return

LB11:
    Return

ObjEnd:
    ENDMACRO

