;! " Tennis course "
;? " (1) Terrain, (2) Grass, (3) Concrete - Course type (1-3): "=SML_Course
;? " Lines colors: "=SML_Lines
;? " Net Grill around the course (0-1): "=SML_Grill
;? " Scale: "=SML_Scale
;? " Heading [HDG] "=SML_Heading
;? " Scenery density required to show on (1-4): "=SML_Comp
; auteur : michel manelphe PVF 264 
; Converted by A. Antonini with permission from Airport author

 
; terrain de tennis

; couleur 1 = couleur de terrain
;       ex  = 0C terre battue
;       ex  = 0D herbe
;       ex  = 02 ciment
; couleur 2 = lignes
; couleur 3 = 0  >>  pas de grillage autour du terrain
;           = 1  >>  grillage autour du terrain
; taille standard : longueur 34 m  (24+10)
;                   largeur 20 m  (11+9)
MACRO _Tennis      
Local Ttype, LType, Pcall, Scall, ObjEnd, ObjReturn, Dwg, Terrain, Lignes,
      Filet, Grillage
; setup defaults

Ttype = 0x0C

If ( SML_Course == 1 )
    Ttype = 0x0C
EndIf
If ( SML_Course == 2 )
    Ttype = 0x0D
EndIf
If ( SML_Course == 3 )
    Ttype = 0x02
EndIf

LType = 0x03

If ( SML_Lines == 0 )
    LType = 0x00
EndIf
If ( SML_Lines == 0 )
    LType = 0x00
EndIf
If ( SML_Lines == 0 )
    LType = 0x00
EndIf
If ( SML_Lines == 0 )
    LType = 0x00
EndIf
If ( SML_Lines == 1 )
    LType = 0x01
EndIf
If ( SML_Lines == 2 )
    LType = 0x02
EndIf
If ( SML_Lines == 3 )
    LType = 0x03
EndIf
If ( SML_Lines == 4 )
    LType = 0x04
EndIf
If ( SML_Lines == 5 )
    LType = 0x05
EndIf
If ( SML_Lines == 6 )
    LType = 0x06
EndIf
If ( SML_Lines == 7 )
    LType = 0x06
EndIf
If ( SML_Lines == 8 )
    LType = 0x06
EndIf
If ( SML_Lines == 9 )
    LType = 0x06
EndIf


Area(  SML_Lat, SML_Lon, 16 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
    Priority( Pcall, 0x18 )
    PerspectiveCall( Scall )
    Jump( ObjEnd )


Scall:
    Perspective

Pcall:
    CondRefPoint( ObjReturn, 6800, 100, 0, 1, SML_Lat, SML_Lon, 0 )
    _FS5SCALE = (SML_Scale * 100) / (Pow(SML_Scale,2)) / 100
    Rotate( Dwg, 0, 0, SML_Heading )
    Return

Dwg:
    PointsList(  1, 18 )
    Point(     90,   0,  180 ) ;1
    Point(     90,   0, -180 ) ;2
    Point(    -90,   0, -180 ) ;3
    Point(    -90,   0,  180 ) ;4
    Point(     55,   0,  120 ) ;5
    Point(     55,   0, -120 ) ;6
    Point(    -55,   0, -120 ) ;7
    Point(    -55,   0,  120 ) ;8
    Point(     45,   0,  120 ) ;9
    Point(     45,   0, -120 ) ;10
    Point(    -45,   0, -120 ) ;11
    Point(    -45,   0,  120 ) ;12 
    Point(     45,   0,   65 ) ;13
    Point(     45,   0,  -65 ) ;14
    Point(    -45,   0,  -65 ) ;15
    Point(    -45,   0,   65 ) ;16
    Point(      0,   0,   65 ) ;17 
    Point(      0,   0,  -65 ) ;18
    

    PointsListVect( 20, 8 )
    PointVect(   -63,   0,   0 ) ;20
    PointVect(   -63,   9,   0 ) ;21
    PointVect(    63,   9,   0 ) ;22
    PointVect(    63,   0,   0 ) ;23 
    PointVect(    64,   0,   0 ) ;24
    PointVect(    64,  10,   0 ) ;25 
    PointVect(   -64,  10,   0 ) ;26 
    PointVect(   -64,   0,   0 ) ;27
    Call( Terrain )
    Call( Lignes )
    Call( Filet )
    
    If ( SML_Grill == 1 )
        Call( Grillage )        
    EndIf
     
    Return

Terrain:
    SurfaceColor( Ttype )
    LineColor( Ttype )
        Polygon_4( 1, 2, 3, 4 )
    Return

Lignes: 
    LineColor( LType )
        MoveToPoint( 5 )
        LineToPoint( 6 )
        LineToPoint( 7 )
        LineToPoint( 8 )
        LineToPoint( 5 )
        MoveToPoint( 9 )
        LineToPoint( 10 )
        MoveToPoint( 12 )
        LineToPoint( 11 )
        MoveToPoint( 13 )
        LineToPoint( 16 )
        MoveToPoint( 14 )
        LineToPoint( 15 )
        MoveToPoint( 17 )
        LineToPoint( 18 )
    Return

Filet:
    Db 0x52, 0x00, 0x03, 0x68
        Polygon_4( 20,  21,  22,  23 )
        Polygon_4( 23,  22,  21,  20 )
 
    GradColor( 0x04 )
        GradPolygon_4(  20, 21, 26, 27 )
        GradPolygon_4(  27, 26, 21, 20 )
        GradPolygon_4(  22, 23, 24, 25 )
        GradPolygon_4(  25, 24, 23, 22 )
        GradPolygon_4(  21, 22, 25, 26 )
        GradPolygon_4(  26, 25, 21, 22 )
        Return

Grillage:
    PointsList( 0, 12 )
    Point(    90,   0,  180 );0
    Point(    90,  40,  180 );1
    Point(    90,   0,    0 );2
    Point(    90,  40,    0 );3
    Point(    90,   0, -180 );4
    Point(    90,  40, -180 );5 
    Point(   -90,   0, -180 );6
    Point(   -90,  40, -180 );7 
    Point(   -90,   0,    0 );8
    Point(   -90,  40,    0 );9
    Point(   -90,   0,  180 );10
    Point(   -90,  40,  180 );11 
        
    Texture( "airpt006", "oav" )
    TransparentOn
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  0,  56,  198 )
        TexturePt(  1,  56,  238 )
        TexturePt( 11, 240,  238 )
        TexturePt( 10, 240,  198 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 10, 240,  198 )
        TexturePt( 11, 240,  238 )
        TexturePt(  1,  56,  238 )
        TexturePt(  0,  56,  198 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  4,  56,  198 )
        TexturePt(  5,  56,  238 )
        TexturePt(  7, 240,  238 )
        TexturePt(  6, 240,  198 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  6, 240,  198 )
        TexturePt(  7, 240,  238 )
        TexturePt(  5,  56,  238 )
        TexturePt(  4,  56,  198 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  0,  56,  198 )
        TexturePt(  1,  56,  238 )
        TexturePt(  3, 240,  238 )
        TexturePt(  2, 240,  198 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  2, 240,  198 )
        TexturePt(  3, 240,  238 )
        TexturePt(  1,  56,  238 )
        TexturePt(  0,  56,  198 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  2,  56,  198 )
        TexturePt(  3,  56,  238 )
        TexturePt(  5, 240,  238 )
        TexturePt(  4, 240,  198 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  4, 240,  198 )
        TexturePt(  5, 240,  238 )
        TexturePt(  3,  56,  238 )
        TexturePt(  2,  56,  198 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 10,  56,  198 )
        TexturePt( 11,  56,  238 )
        TexturePt(  9, 240,  238 )
        TexturePt(  8, 240,  198 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  8, 240,  198 )
        TexturePt(  9, 240,  238 )
        TexturePt( 11,  56,  238 )
        TexturePt( 10,  56,  198 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  8,  56,  198 )
        TexturePt(  9,  56,  238 )
        TexturePt(  7, 240,  238 )
        TexturePt(  6, 240,  198 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  6, 240,  198 )
        TexturePt(  7, 240,  238 )
        TexturePt(  9,  56,  238 )
        TexturePt(  8,  56,  198 )
    TransparentOff

    Db 0x52, 0x00, 0x04, 0x68
        Polygon_4(   0,  1, 11, 10 )
        Polygon_4(  10, 11,  1,  0 )
        Polygon_4(   4,  5,  7,  6 )
        Polygon_4(   6,  7,  5,  4 )
        Polygon_4(   0,  1,  3,  2 )
        Polygon_4(   2,  3,  1,  0 )
        Polygon_4(   2,  3,  5,  4 )
        Polygon_4(   4,  5,  3,  2 )
        Polygon_4(  10, 11,  9,  8 )
        Polygon_4(   8,  9, 11, 10 )
        Polygon_4(   8,  9,  7,  6 )
        Polygon_4(   6,  7,  9,  8 )
    Return

ObjReturn:
    Return

ObjEnd:
    ENDMACRO
