;! " 40 mts. wide taxiway hold point, shows when Scenery is Dense or above "
;? " Heading [HDG]: "=SML_Heading
; by Alessandro Antonini

MACRO _TaxiStop

Local ObjEnd, Pcall, ObjReturn, Dwg

Area( SML_Lat, SML_Lon, 6 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, 3, 4 )
    Priority( Pcall, 0x18 )
    Goto( ObjEnd )

Pcall:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    SurfaceColor( 0x09 )
    StartSurface
        MoveTo(    -20,      0,      0 )
        LineTo(    -20,      0,      1 )
        LineTo(     20,      0,      1 )
        LineTo(     20,      0,      0 )
    CloseSurface
    StartSurface
        MoveTo(    -20,      0,     -2 )
        LineTo(    -20,      0,     -1 )
        LineTo(    -16,      0,     -1 )
        LineTo(    -16,      0,     -2 )
    CloseSurface
    StartSurface
        MoveTo(    -14,      0,     -2 )
        LineTo(    -14,      0,     -1 )
        LineTo(    -10,      0,     -1 )
        LineTo(    -10,      0,     -2 )
    CloseSurface
    StartSurface
        MoveTo(     -8,      0,     -2 )
        LineTo(     -8,      0,     -1 )
        LineTo(     -4,      0,     -1 )
        LineTo(     -4,      0,     -2 )
    CloseSurface
    StartSurface
        MoveTo(     -2,      0,     -2 )
        LineTo(     -2,      0,     -1 )
        LineTo(      2,      0,     -1 )
        LineTo(      2,      0,     -2 )
    CloseSurface
    StartSurface
        MoveTo(      4,      0,     -2 )
        LineTo(      4,      0,     -1 )
        LineTo(      8,      0,     -1 )
        LineTo(      8,      0,     -2 )
    CloseSurface
    StartSurface
        MoveTo(     10,      0,     -2 )
        LineTo(     10,      0,     -1 )
        LineTo(     14,      0,     -1 )
        LineTo(     14,      0,     -2 )
    CloseSurface
    StartSurface
        MoveTo(     16,      0,     -2 )
        LineTo(     16,      0,     -1 )
        LineTo(     20,      0,     -1 )
        LineTo(     20,      0,     -2 )
    CloseSurface
    Return

ObjEnd:
    ENDMACRO
